/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.owl;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.LabelFunctionalDocumentFormat;
import org.semanticweb.owlapi.functional.renderer.FunctionalSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.StringComparator;

public class LabelFunctionalSyntaxStorer
extends AbstractOWLStorer {
    @Override
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof LabelFunctionalDocumentFormat;
    }

    @Override
    protected void storeOntology(OWLOntology ontology, PrintWriter writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        try {
            FunctionalSyntaxObjectRenderer renderer = new FunctionalSyntaxObjectRenderer(ontology, format, writer);
            renderer.setPrefixManager(new LabelPrefixManager(ontology));
            ontology.accept(renderer);
            writer.flush();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    static class LabelPrefixManager
    implements PrefixManager {
        private final OWLOntology ontology;
        private final PrefixManager delegate;
        private final OWLAnnotationProperty rdfsLabel;

        LabelPrefixManager(OWLOntology ontology) {
            this.ontology = ontology;
            OWLDocumentFormat ontologyFormat = ontology.getFormat();
            this.delegate = ontologyFormat instanceof PrefixManager ? (PrefixManager)((Object)ontologyFormat) : new DefaultPrefixManager();
            this.rdfsLabel = ontology.getOWLOntologyManager().getOWLDataFactory().getRDFSLabel();
        }

        @Override
        @Nullable
        public String getPrefixIRI(IRI iri) {
            for (OWLAnnotationAssertionAxiom annotation : OWLAPIStreamUtils.asList(this.ontology.annotationAssertionAxioms(iri))) {
                OWLAnnotationValue value;
                if (!((OWLAnnotationProperty)annotation.getProperty()).isLabel() || !((value = annotation.getValue()) instanceof OWLLiteral)) continue;
                return '<' + ((OWLLiteral)value).getLiteral() + '>';
            }
            return this.delegate.getPrefixIRI(iri);
        }

        @Override
        @Nullable
        public String getDefaultPrefix() {
            return this.delegate.getDefaultPrefix();
        }

        @Override
        public void setDefaultPrefix(@Nullable String defaultPrefix) {
        }

        @Override
        public String getPrefixIRIIgnoreQName(IRI iri) {
            Optional<OWLAnnotationValue> lit = this.labels(iri).map(OWLAnnotation::getValue).filter(OWLAnnotationValue::isLiteral).findFirst();
            return lit.map(x -> "<" + x.asLiteral().get().getLiteral() + ">").orElse(this.delegate.getPrefixIRIIgnoreQName(iri));
        }

        protected Stream<OWLAnnotation> labels(IRI iri) {
            return Searcher.annotationObjects(this.ontology.annotationAssertionAxioms(iri), this.rdfsLabel);
        }

        @Override
        public boolean containsPrefixMapping(String prefixName) {
            return this.delegate.containsPrefixMapping(prefixName);
        }

        @Override
        @Nullable
        public String getPrefix(String prefixName) {
            return this.delegate.getPrefix(prefixName);
        }

        @Override
        public Map<String, String> getPrefixName2PrefixMap() {
            return this.delegate.getPrefixName2PrefixMap();
        }

        @Override
        public IRI getIRI(String prefixIRI) {
            return this.delegate.getIRI(prefixIRI);
        }

        @Override
        public Stream<String> prefixNames() {
            return this.delegate.prefixNames();
        }

        @Override
        public StringComparator getPrefixComparator() {
            return this.delegate.getPrefixComparator();
        }

        @Override
        public void setPrefixComparator(StringComparator comparator) {
            this.delegate.setPrefixComparator(comparator);
        }

        @Override
        public void setPrefix(String prefixName, String prefix) {
        }

        @Override
        public void copyPrefixesFrom(PrefixManager from) {
        }

        @Override
        public void copyPrefixesFrom(Map<String, String> from) {
        }

        @Override
        public void unregisterNamespace(String namespace) {
        }

        @Override
        public void clear() {
        }
    }
}

