/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.parser;

import java.io.IOException;
import java.io.Reader;
import org.semanticweb.owlapi.formats.KRSS2DocumentFormat;
import org.semanticweb.owlapi.formats.KRSS2DocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.krss2.parser.KRSS2OWLParserException;
import org.semanticweb.owlapi.krss2.parser.KRSS2Parser;
import org.semanticweb.owlapi.krss2.parser.ParseException;
import org.semanticweb.owlapi.krss2.parser.StreamProvider;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class KRSS2OWLParser
extends AbstractOWLParser {
    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new KRSS2DocumentFormatFactory();
    }

    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource source, OWLOntology ontology, OWLOntologyLoaderConfiguration config) {
        KRSS2DocumentFormat kRSS2DocumentFormat;
        block8: {
            Reader r = DocumentSources.wrapInputAsReader(source, config);
            try {
                KRSS2DocumentFormat format = new KRSS2DocumentFormat();
                KRSS2Parser parser = new KRSS2Parser(new StreamProvider(r));
                parser.setOntology(ontology);
                parser.parse();
                kRSS2DocumentFormat = format;
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | OWLOntologyInputSourceException | ParseException e) {
                    throw new KRSS2OWLParserException(e);
                }
            }
            r.close();
        }
        return kRSS2DocumentFormat;
    }
}

