/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserException;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserImpl;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OntologyConfigurator;

public class ManchesterOWLSyntaxOntologyParser
extends AbstractOWLParser {
    private static final String COMMENT_START_CHAR = "#";

    private static boolean startsWithMagicNumber(String line) {
        return line.indexOf(ManchesterOWLSyntax.PREFIX.toString()) != -1 || line.indexOf(ManchesterOWLSyntax.ONTOLOGY.toString()) != -1;
    }

    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new ManchesterSyntaxDocumentFormatFactory();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource source, OWLOntology ontology, OWLOntologyLoaderConfiguration config) {
        try (Reader r = DocumentSources.wrapInputAsReader(source, config);){
            ManchesterSyntaxDocumentFormat manchesterSyntaxDocumentFormat;
            try (BufferedReader reader = new BufferedReader(r);){
                String line;
                StringBuilder sb = new StringBuilder();
                int lineCount = 1;
                boolean foundMagicNumber = false;
                while ((line = reader.readLine()) != null) {
                    String trimmedLine;
                    sb.append(line);
                    sb.append('\n');
                    if (!(foundMagicNumber || (trimmedLine = line.trim()).isEmpty() || trimmedLine.startsWith(COMMENT_START_CHAR))) {
                        if (ManchesterOWLSyntaxOntologyParser.startsWithMagicNumber(line)) {
                            foundMagicNumber = true;
                        } else {
                            int startCol = line.indexOf(trimmedLine) + 1;
                            String msg = String.format("Encountered '%s' at line %s column %s.  Expected either 'Ontology:' or 'Prefix:'", trimmedLine, lineCount, startCol);
                            throw new ManchesterOWLSyntaxParserException(msg, lineCount, startCol);
                        }
                    }
                    ++lineCount;
                }
                String s = sb.toString();
                ManchesterOWLSyntaxParserImpl parser = new ManchesterOWLSyntaxParserImpl(new OntologyConfigurator(), ontology.getOWLOntologyManager().getOWLDataFactory());
                parser.setOntologyLoaderConfiguration(config);
                parser.setStringToParse(s);
                manchesterSyntaxDocumentFormat = parser.parseOntology(ontology);
            }
            return manchesterSyntaxDocumentFormat;
        }
        catch (ParserException e) {
            throw new ManchesterOWLSyntaxParserException(e.getMessage(), (Throwable)e, e.getLineNumber(), e.getColumnNumber());
        }
        catch (IOException | OWLOntologyInputSourceException e) {
            throw new ManchesterOWLSyntaxParserException(e.getMessage(), (Throwable)e, 1, 1);
        }
    }
}

