/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.metrics.OWLMetric;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLMetricManager {
    private final List<OWLMetric<?>> metrics;

    public OWLMetricManager(List<OWLMetric<?>> metrics) {
        this.metrics = new ArrayList((Collection)OWLAPIPreconditions.checkNotNull(metrics, "metrics cannot be null"));
    }

    public void setOntology(OWLOntology ontology) {
        this.metrics.forEach(m -> m.setOntology(ontology));
    }

    public List<OWLMetric<?>> getMetrics() {
        return new ArrayList(this.metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (OWLMetric<?> m : this.metrics) {
            sb.append(m);
            sb.append('\n');
        }
        return sb.toString();
    }
}

