/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public abstract class DefaultNode<E extends OWLObject>
implements Node<E> {
    private final Set<E> entities = new HashSet(4);

    public DefaultNode(E entity) {
        this.entities.add((OWLObject)OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null"));
    }

    public DefaultNode(Collection<E> entities) {
        this.entities.addAll(OWLAPIPreconditions.checkNotNull(entities, "entities cannot be null"));
    }

    public DefaultNode(Stream<E> entities) {
        OWLAPIStreamUtils.add(this.entities, OWLAPIPreconditions.checkNotNull(entities, "entities cannot be null"));
    }

    protected DefaultNode() {
    }

    protected abstract Optional<E> getTopEntity();

    protected abstract Optional<E> getBottomEntity();

    public void add(E entity) {
        this.entities.add(entity);
    }

    @Override
    public boolean isTopNode() {
        if (!this.getTopEntity().isPresent()) {
            return false;
        }
        return this.entities.contains(this.getTopEntity().get());
    }

    @Override
    public boolean isBottomNode() {
        if (!this.getBottomEntity().isPresent()) {
            return false;
        }
        return this.entities.contains(this.getBottomEntity().get());
    }

    @Override
    public Stream<E> entities() {
        return this.entities.stream();
    }

    @Override
    public int getSize() {
        return this.entities.size();
    }

    @Override
    public boolean contains(E entity) {
        return this.entities.contains(entity);
    }

    @Override
    public Set<E> getEntitiesMinus(E e) {
        return OWLAPIStreamUtils.asUnorderedSet(this.entities.stream().filter(i -> !i.equals(e)));
    }

    @Override
    public Set<E> getEntitiesMinusTop() {
        Optional<E> topEntity = this.getTopEntity();
        if (topEntity.isPresent()) {
            return this.getEntitiesMinus((OWLObject)topEntity.get());
        }
        return OWLAPIStreamUtils.asUnorderedSet(this.entities.stream());
    }

    @Override
    public Set<E> getEntitiesMinusBottom() {
        Optional<E> bottomEntity = this.getBottomEntity();
        if (bottomEntity.isPresent()) {
            return this.getEntitiesMinus((OWLObject)bottomEntity.get());
        }
        return OWLAPIStreamUtils.asUnorderedSet(this.entities.stream());
    }

    @Override
    public boolean isSingleton() {
        return this.entities.size() == 1;
    }

    @Override
    public E getRepresentativeElement() {
        return (E)((OWLObject)this.entities.iterator().next());
    }

    @Override
    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node( ");
        for (OWLObject entity : this.entities) {
            sb.append(entity);
            sb.append(' ');
        }
        sb.append(')');
        return OWLAPIPreconditions.verifyNotNull(sb.toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return this.entities.equals(OWLAPIStreamUtils.asUnorderedSet(other.entities()));
    }

    public int hashCode() {
        return this.entities.hashCode();
    }
}

