/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.annotations.HasPriority;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SAXParsers;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@HasPriority(value=1.0)
public class ZipIRIMapper
extends DefaultHandler
implements OWLOntologyIRIMapper,
Serializable {
    static final Pattern pattern = Pattern.compile("Ontology\\(<([^>]+)>");
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipIRIMapper.class);
    private final Set<String> fileExtensions = new HashSet<String>(Arrays.asList(".owl", ".xml", ".rdf", ".omn", ".ofn", ".obo"));
    private final Map<String, OntologyRootElementHandler> handlerMap = CollectionFactory.createMap();
    private final Map<IRI, IRI> ontologyIRI2PhysicalURIMap = CollectionFactory.createMap();
    private final Map<String, IRI> oboFileMap = CollectionFactory.createMap();
    @Nullable
    private IRI currentFile;

    public ZipIRIMapper(File zip, String baseIRI) throws IOException {
        this(new ZipFile(zip), baseIRI);
    }

    public ZipIRIMapper(ZipFile zip, String baseIRI) throws IOException {
        this.handlerMap.put((Object)((Object)Namespaces.RDF) + "RDF", this::baseIRI);
        this.handlerMap.put(OWLXMLVocabulary.ONTOLOGY.toString(), this::ontologyIRI);
        this.processFile(zip, baseIRI);
    }

    @Nullable
    protected IRI ontologyIRI(Attributes attributes) {
        String ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
        if (ontURI == null) {
            ontURI = attributes.getValue("ontologyIRI");
        }
        if (ontURI == null) {
            return null;
        }
        return IRI.create(ontURI);
    }

    @Nullable
    protected IRI baseIRI(Attributes attributes) {
        String baseValue = attributes.getValue(Namespaces.XML.toString(), "base");
        if (baseValue == null) {
            return null;
        }
        return IRI.create(baseValue);
    }

    static IRI unquote(String tok) {
        String substring = tok.substring(1, tok.length() - 1);
        assert (substring != null);
        return IRI.create(substring);
    }

    public Set<String> getFileExtensions() {
        return new HashSet<String>(this.fileExtensions);
    }

    public void setFileExtensions(Collection<String> extensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(extensions);
    }

    public Stream<Map.Entry<IRI, IRI>> mappedEntries() {
        return this.ontologyIRI2PhysicalURIMap.entrySet().stream();
    }

    @Override
    @Nullable
    public IRI getDocumentIRI(IRI ontologyIRI) {
        int lastSepIndex;
        String name;
        IRI documentIRI;
        String path;
        if (ontologyIRI.toString().endsWith(".obo") && (path = ontologyIRI.toURI().getPath()) != null && (documentIRI = this.oboFileMap.get(name = path.substring((lastSepIndex = path.lastIndexOf(47)) + 1, path.length()))) != null) {
            return documentIRI;
        }
        return this.ontologyIRI2PhysicalURIMap.get(ontologyIRI);
    }

    public Stream<Map.Entry<String, IRI>> oboMappings() {
        return this.oboFileMap.entrySet().stream();
    }

    public Stream<Map.Entry<IRI, IRI>> iriMappings() {
        return this.ontologyIRI2PhysicalURIMap.entrySet().stream();
    }

    private void processFile(ZipFile archive, String baseIRI) throws IOException {
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            this.parseIfExtensionSupported(archive, entries.nextElement(), baseIRI);
        }
    }

    protected void parseIfExtensionSupported(ZipFile file, ZipEntry e, String baseIRI) throws IOException {
        String name = e.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf < 0) {
            return;
        }
        IRI physicalIRI = IRI.create(baseIRI + name);
        String extension = name.substring(lastIndexOf);
        if (".obo".equals(extension)) {
            this.oboFileMap.put(name, physicalIRI);
        } else {
            try (InputStream in = file.getInputStream(e);){
                IRI logical;
                if (".ofn".equals(extension)) {
                    IRI logical2 = ZipIRIMapper.parseFSSFile(in);
                    if (logical2 != null) {
                        this.ontologyIRI2PhysicalURIMap.put(logical2, physicalIRI);
                    }
                } else if (".omn".equals(extension)) {
                    IRI logical3 = ZipIRIMapper.parseManchesterSyntaxFile(in);
                    if (logical3 != null) {
                        this.ontologyIRI2PhysicalURIMap.put(logical3, physicalIRI);
                    }
                } else if (this.fileExtensions.contains(extension) && (logical = this.parseFile(in)) != null) {
                    this.ontologyIRI2PhysicalURIMap.put(logical, physicalIRI);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IRI parseFSSFile(InputStream input) {
        try (InputStreamReader reader = new InputStreamReader(input, "UTF-8");
             BufferedReader br = new BufferedReader(reader);){
            String line = "";
            Matcher m = pattern.matcher(line);
            int n = 0;
            do {
                if ((line = br.readLine()) == null) return null;
                if (n++ >= 100) return null;
                m.reset(line);
            } while (!m.matches());
            String group = m.group(1);
            assert (group != null);
            IRI iRI = IRI.create(group);
            return iRI;
        }
        catch (IOException e) {
            LOGGER.debug("Exception reading file", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private IRI parseFile(InputStream file) {
        try {
            this.currentFile = null;
            SAXParsers.initParserWithOWLAPIStandards(null, "64000").parse(file, (DefaultHandler)this);
        }
        catch (IOException | SAXException e) {
            LOGGER.debug("Exception reading file", (Throwable)e);
        }
        return this.currentFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static IRI parseManchesterSyntaxFile(InputStream input) {
        try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line = br.readLine();
            while (line != null) {
                IRI iri = ZipIRIMapper.parseManLine(line);
                if (iri != null) {
                    IRI iRI = iri;
                    return iRI;
                }
                line = br.readLine();
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.debug("Exception reading file", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private static IRI parseManLine(String line) {
        for (String tok : line.split(" ")) {
            if (!tok.startsWith("<") || !tok.endsWith(">")) continue;
            return ZipIRIMapper.unquote(tok);
        }
        return null;
    }

    @Override
    public void startElement(@Nullable String uri, @Nullable String localName, @Nullable String qName, @Nullable Attributes attributes) throws SAXException {
        OntologyRootElementHandler handler = this.handlerMap.get(uri + localName);
        if (handler != null) {
            IRI ontologyIRI = handler.handle(OWLAPIPreconditions.checkNotNull(attributes));
            if (ontologyIRI != null && this.currentFile == null) {
                this.currentFile = ontologyIRI;
            }
            throw new SAXException();
        }
    }

    protected void addMapping(IRI ontologyIRI, File file) {
        this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(file));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AutoIRIMapper: (");
        sb.append(this.ontologyIRI2PhysicalURIMap.size()).append(" ontologies)\n");
        this.ontologyIRI2PhysicalURIMap.forEach((k, v) -> sb.append("    ").append(k.toQuotedString()).append(" -> ").append((CharSequence)v).append('\n'));
        return sb.toString();
    }

    @FunctionalInterface
    private static interface OntologyRootElementHandler
    extends Serializable {
        @Nullable
        public IRI handle(Attributes var1);
    }
}

