/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.obo2owl.OWLAPIOwl2Obo;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OboInOwlCardinalityTools {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OboInOwlCardinalityTools.class);
    public static final AnnotationCardinalityConfictHandler DEFAULT_HANDLER = new AnnotationCardinalityConfictHandler(){

        @Override
        public List<OWLAnnotationAssertionAxiom> handleConflict(OWLEntity entity, OWLAnnotationProperty property, Collection<OWLAnnotationAssertionAxiom> axioms) {
            if (axioms.size() > 1) {
                String tag = OWLAPIOwl2Obo.owlObjectToTag(property);
                if (tag == null) {
                    tag = property.getIRI().toString();
                }
                LOGGER.info("Fixing multiple {} tags for entity: {}", (Object)tag, (Object)entity.getIRI());
                return OboInOwlCardinalityTools.listOfFirst(axioms);
            }
            throw new AnnotationCardinalityException("Could not resolve conflict for property: " + String.valueOf(property));
        }

        @Override
        public List<OWLAnnotation> handleConflict(OWLAnnotationProperty property, Collection<OWLAnnotation> ontologyAnnotations) {
            if (ontologyAnnotations.size() > 1) {
                String tag = OWLAPIOwl2Obo.owlObjectToTag(property);
                if (tag == null) {
                    tag = property.getIRI().toString();
                }
                LOGGER.info("Fixing multiple ontolgy annotations with, tag: {}", (Object)tag);
                return OboInOwlCardinalityTools.listOfFirst(ontologyAnnotations);
            }
            throw new AnnotationCardinalityException("Could not resolve conflict for property: " + String.valueOf(property));
        }
    };

    private OboInOwlCardinalityTools() {
    }

    public static void checkAnnotationCardinality(OWLOntology ontology, @Nullable AnnotationCardinalityReporter reporter, @Nullable AnnotationCardinalityConfictHandler handler) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        Set<OWLAnnotationProperty> headerProperties = OboInOwlCardinalityTools.getProperties(factory, OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION, OBOFormatConstants.OboFormatTag.TAG_DATE, OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, OBOFormatConstants.OboFormatTag.TAG_SAVED_BY, OBOFormatConstants.OboFormatTag.TAG_AUTO_GENERATED_BY);
        OboInOwlCardinalityTools.checkOntologyAnnotations(headerProperties, ontology, reporter, handler, manager);
        Set<OWLAnnotationProperty> properties = OboInOwlCardinalityTools.getProperties(factory, OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS, OBOFormatConstants.OboFormatTag.TAG_NAME, OBOFormatConstants.OboFormatTag.TAG_NAMESPACE, OBOFormatConstants.OboFormatTag.TAG_DEF, OBOFormatConstants.OboFormatTag.TAG_COMMENT, OBOFormatConstants.OboFormatTag.TAG_DOMAIN, OBOFormatConstants.OboFormatTag.TAG_RANGE, OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_CYCLIC, OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE, OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC, OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE, OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL, OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE, OBOFormatConstants.OboFormatTag.TAG_CREATED_BY, OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE);
        ontology.classesInSignature(Imports.INCLUDED).forEach(c -> OboInOwlCardinalityTools.checkOwlEntity(c, properties, ontology, reporter, handler));
        ontology.objectPropertiesInSignature(Imports.INCLUDED).forEach(p -> OboInOwlCardinalityTools.checkOwlEntity(p, properties, ontology, reporter, handler));
    }

    private static Set<OWLAnnotationProperty> getProperties(OWLDataFactory factory, OBOFormatConstants.OboFormatTag ... tags) {
        HashSet<OWLAnnotationProperty> set = new HashSet<OWLAnnotationProperty>();
        for (OBOFormatConstants.OboFormatTag tag : tags) {
            set.add(factory.getOWLAnnotationProperty(OWLAPIObo2Owl.trTagToIRI(tag.getTag())));
        }
        return set;
    }

    private static void checkOntologyAnnotations(Set<OWLAnnotationProperty> properties, OWLOntology ontology, @Nullable AnnotationCardinalityReporter reporter, @Nullable AnnotationCardinalityConfictHandler handler, OWLOntologyManager manager) {
        Set<OWLAnnotation> annotations = OWLAPIStreamUtils.asUnorderedSet(ontology.annotations());
        HashMap<OWLAnnotationProperty, Set<OWLAnnotation>> groupedAnnotations = new HashMap<OWLAnnotationProperty, Set<OWLAnnotation>>();
        for (OWLAnnotation oWLAnnotation : annotations) {
            OWLAnnotationProperty current = oWLAnnotation.getProperty();
            if (!properties.contains(current)) continue;
            HashSet<OWLAnnotation> set = (HashSet<OWLAnnotation>)groupedAnnotations.get(current);
            if (set == null) {
                groupedAnnotations.put(current, Collections.singleton(oWLAnnotation));
                continue;
            }
            if (set.size() == 1) {
                set = new HashSet<OWLAnnotation>(set);
                set.add(oWLAnnotation);
                groupedAnnotations.put(current, set);
                continue;
            }
            set.add(oWLAnnotation);
        }
        for (Map.Entry entry : groupedAnnotations.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            if (reporter != null) {
                reporter.reportConflict((OWLAnnotationProperty)entry.getKey(), (Collection)entry.getValue());
            }
            if (handler == null) continue;
            List<OWLAnnotation> changed = handler.handleConflict((OWLAnnotationProperty)entry.getKey(), (Collection)entry.getValue());
            ((Set)entry.getValue()).forEach(a -> manager.applyChange(new RemoveOntologyAnnotation(ontology, (OWLAnnotation)a)));
            changed.forEach(a -> manager.applyChange(new AddOntologyAnnotation(ontology, (OWLAnnotation)a)));
        }
    }

    private static void checkOwlEntity(OWLEntity owlClass, Set<OWLAnnotationProperty> properties, OWLOntology ontology, @Nullable AnnotationCardinalityReporter reporter, @Nullable AnnotationCardinalityConfictHandler handler) {
        HashMap<OWLAnnotationProperty, Set<OWLAnnotationAssertionAxiom>> groupedAxioms = new HashMap<OWLAnnotationProperty, Set<OWLAnnotationAssertionAxiom>>();
        for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : OWLAPIStreamUtils.asUnorderedSet(ontology.annotationAssertionAxioms(owlClass.getIRI()))) {
            OWLAnnotationProperty current = (OWLAnnotationProperty)oWLAnnotationAssertionAxiom.getProperty();
            if (!properties.contains(current)) continue;
            HashSet<OWLAnnotationAssertionAxiom> set = (HashSet<OWLAnnotationAssertionAxiom>)groupedAxioms.get(current);
            if (set == null) {
                groupedAxioms.put(current, Collections.singleton(oWLAnnotationAssertionAxiom));
                continue;
            }
            if (set.size() == 1) {
                set = new HashSet<OWLAnnotationAssertionAxiom>(set);
                set.add(oWLAnnotationAssertionAxiom);
                groupedAxioms.put(current, set);
                continue;
            }
            set.add(oWLAnnotationAssertionAxiom);
        }
        for (Map.Entry entry : groupedAxioms.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            if (reporter != null) {
                reporter.reportConflict(owlClass, (OWLAnnotationProperty)entry.getKey(), (Collection)entry.getValue());
            }
            if (handler == null) continue;
            List<OWLAnnotationAssertionAxiom> changed = handler.handleConflict(owlClass, (OWLAnnotationProperty)entry.getKey(), (Collection)entry.getValue());
            ontology.remove((Collection)entry.getValue());
            ontology.add(changed);
        }
    }

    public static void checkAnnotationCardinality(OWLOntology ontology) {
        OboInOwlCardinalityTools.checkAnnotationCardinality(ontology, null, DEFAULT_HANDLER);
    }

    public static void checkAnnotationCardinality(OWLOntology ontology, AnnotationCardinalityReporter reporter) {
        try {
            OboInOwlCardinalityTools.checkAnnotationCardinality(ontology, reporter, null);
        }
        catch (AnnotationCardinalityException e) {
            LOGGER.error("Cardinality exception during report: This isn't supposed to happen.", (Throwable)e);
        }
    }

    static <T> List<T> listOfFirst(Collection<T> t) {
        return Collections.singletonList(t.iterator().next());
    }

    public static interface AnnotationCardinalityReporter {
        public void reportConflict(OWLEntity var1, OWLAnnotationProperty var2, Collection<OWLAnnotationAssertionAxiom> var3);

        public void reportConflict(OWLAnnotationProperty var1, Collection<OWLAnnotation> var2);
    }

    public static interface AnnotationCardinalityConfictHandler {
        public List<OWLAnnotationAssertionAxiom> handleConflict(OWLEntity var1, OWLAnnotationProperty var2, Collection<OWLAnnotationAssertionAxiom> var3);

        public List<OWLAnnotation> handleConflict(OWLAnnotationProperty var1, Collection<OWLAnnotation> var2);
    }

    public static class AnnotationCardinalityException
    extends OWLRuntimeException {
        public AnnotationCardinalityException(String message, Throwable cause) {
            super(message, cause);
        }

        public AnnotationCardinalityException(String message) {
            super(message);
        }
    }
}

