/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity.locality;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.modularity.locality.LocalityEvaluator;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public enum SyntacticLocalityEvaluator implements LocalityEvaluator
{
    BOTTOM{

        @Override
        protected LocalityAxiomVisitor createLocalityAxiomVisitor(OWLAxiom axiom, Collection<OWLEntity> signature) {
            return new BottomLocalityAxiomVisitor(axiom, signature);
        }
    }
    ,
    TOP{

        @Override
        protected LocalityAxiomVisitor createLocalityAxiomVisitor(OWLAxiom axiom, Collection<OWLEntity> signature) {
            return new TopLocalityAxiomVisitor(axiom, signature);
        }
    };


    protected static boolean isTopOrBuiltInDatatype(OWLDataRange dataRange) {
        if (dataRange.isOWLDatatype()) {
            OWLDatatype dataType = dataRange.asOWLDatatype();
            return dataType.isTopDatatype() || dataType.isBuiltIn();
        }
        return false;
    }

    static boolean isTopOrBuiltInInfiniteDatatype(OWLDataRange dataRange) {
        if (dataRange.isOWLDatatype()) {
            OWLDatatype dataType = dataRange.asOWLDatatype();
            return dataType.isTopDatatype() || dataType.isBuiltIn() && !dataType.getBuiltInDatatype().isFinite();
        }
        return false;
    }

    protected abstract LocalityAxiomVisitor createLocalityAxiomVisitor(OWLAxiom var1, Collection<OWLEntity> var2);

    @Override
    public final boolean isLocal(OWLAxiom axiom, Collection<OWLEntity> signature) {
        return !axiom.isLogicalAxiom() || this.createLocalityAxiomVisitor(Objects.requireNonNull(axiom, "The given axiom may not be null"), Objects.requireNonNull(signature, "The given signature may not be null")).isLocal();
    }

    protected abstract class LocalityAxiomVisitor
    implements OWLAxiomVisitor {
        @Nonnull
        private final AbstractBottomEquivalenceEvaluator bottomEquivalenceEvaluator;
        protected boolean isLocal;
        @Nonnull
        protected final Collection<OWLEntity> signature;
        @Nonnull
        private final AbstractTopEquivalenceEvaluator topEquivalenceEvaluator;

        protected LocalityAxiomVisitor(OWLAxiom axiom, Collection<OWLEntity> signature) {
            this.signature = signature;
            this.isLocal = false;
            this.bottomEquivalenceEvaluator = this.createBottomEquivalenceEvaluator();
            this.topEquivalenceEvaluator = this.createTopEquivalenceEvaluator();
            axiom.accept(this);
        }

        protected abstract AbstractBottomEquivalenceEvaluator createBottomEquivalenceEvaluator();

        protected abstract AbstractTopEquivalenceEvaluator createTopEquivalenceEvaluator();

        @Nonnull
        protected final AbstractEquivalenceEvaluator getBottomEquivalenceEvaluator() {
            return this.bottomEquivalenceEvaluator;
        }

        @Nonnull
        protected final AbstractEquivalenceEvaluator getTopEquivalenceEvaluator() {
            return this.topEquivalenceEvaluator;
        }

        protected final boolean isLocal() {
            return this.isLocal;
        }

        private boolean isLocal(OWLEquivalentClassesAxiom axiom) {
            Iterator eqs = axiom.classExpressions().iterator();
            OWLClassExpression first = (OWLClassExpression)eqs.next();
            if (!eqs.hasNext()) {
                return true;
            }
            boolean isBottom = this.getBottomEquivalenceEvaluator().isEquivalent(first);
            if (!isBottom && !this.getTopEquivalenceEvaluator().isEquivalent(first)) {
                return false;
            }
            while (eqs.hasNext()) {
                if (!(isBottom ? !this.getBottomEquivalenceEvaluator().isEquivalent((OWLClassExpression)eqs.next()) : !this.getTopEquivalenceEvaluator().isEquivalent((OWLClassExpression)eqs.next()))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            this.isLocal = this.getTopEquivalenceEvaluator().isEquivalent(axiom.getClassExpression());
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public final void visit(OWLDifferentIndividualsAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            List<OWLClassExpression> disjs = OWLAPIStreamUtils.asList(axiom.classExpressions());
            boolean nonBottomEquivDescFound = false;
            for (OWLClassExpression desc : disjs) {
                if (this.getBottomEquivalenceEvaluator().isEquivalent(desc)) continue;
                if (nonBottomEquivDescFound) {
                    this.isLocal = false;
                    return;
                }
                nonBottomEquivDescFound = true;
            }
            this.isLocal = true;
        }

        @Override
        public final void visit(OWLEquivalentClassesAxiom axiom) {
            this.isLocal = this.isLocal(axiom);
        }

        @Override
        public final void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            if (axiom.properties().count() < 2L) {
                this.isLocal = true;
                return;
            }
            if (axiom.properties().anyMatch(property -> this.signature.contains(property.asOWLDataProperty()))) {
                this.isLocal = false;
                return;
            }
            this.isLocal = true;
        }

        @Override
        public final void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            if (axiom.properties().count() < 2L) {
                this.isLocal = true;
                return;
            }
            if (axiom.properties().anyMatch(property -> this.signature.contains(property.getNamedProperty()))) {
                this.isLocal = false;
                return;
            }
            this.isLocal = true;
        }

        @Override
        public final void visit(OWLHasKeyAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public final void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.isLocal = !this.signature.contains(axiom.getFirstProperty().getNamedProperty()) && !this.signature.contains(axiom.getSecondProperty().getNamedProperty());
        }

        @Override
        public final void visit(OWLSameIndividualAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public final void visit(OWLSubClassOfAxiom axiom) {
            this.isLocal = this.getBottomEquivalenceEvaluator().isEquivalent(axiom.getSubClass()) || this.getTopEquivalenceEvaluator().isEquivalent(axiom.getSuperClass());
        }

        @Override
        public final void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public final void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public final void visit(SWRLRule rule) {
            this.isLocal = false;
        }

        protected abstract class AbstractBottomEquivalenceEvaluator
        extends AbstractEquivalenceEvaluator {
            protected AbstractBottomEquivalenceEvaluator() {
            }

            @Override
            public final void visit(OWLObjectComplementOf ce) {
                this.isEquivalent = LocalityAxiomVisitor.this.getTopEquivalenceEvaluator().isEquivalent(ce.getOperand());
            }

            @Override
            public final void visit(OWLObjectOneOf ce) {
                this.isEquivalent = ce.individuals().count() == 0L;
            }
        }

        protected abstract class AbstractTopEquivalenceEvaluator
        extends AbstractEquivalenceEvaluator {
            protected AbstractTopEquivalenceEvaluator() {
            }

            @Override
            public final void visit(OWLObjectComplementOf ce) {
                this.isEquivalent = LocalityAxiomVisitor.this.getBottomEquivalenceEvaluator().isEquivalent(ce.getOperand());
            }

            @Override
            public final void visit(OWLObjectOneOf ce) {
                this.isEquivalent = false;
            }
        }

        protected abstract class AbstractEquivalenceEvaluator
        implements OWLClassExpressionVisitor {
            protected boolean isEquivalent;

            protected AbstractEquivalenceEvaluator() {
            }

            protected final synchronized boolean isEquivalent(OWLClassExpression classExpression) {
                Objects.requireNonNull(classExpression, "The given class expression may not be null").accept(this);
                return this.isEquivalent;
            }

            @Override
            public final void visit(OWLObjectIntersectionOf ce) {
                this.isEquivalent = !ce.operands().anyMatch(this::isEquivalent);
            }

            @Override
            public final void visit(OWLObjectUnionOf ce) {
                this.isEquivalent = ce.operands().anyMatch(this::isEquivalent);
            }
        }
    }

    private final class TopLocalityAxiomVisitor
    extends LocalityAxiomVisitor {
        TopLocalityAxiomVisitor(OWLAxiom axiom, Collection<OWLEntity> signature) {
            super(axiom, signature);
        }

        @Override
        protected TopLocalityBottomEquivalenceEvaluator createBottomEquivalenceEvaluator() {
            return new TopLocalityBottomEquivalenceEvaluator();
        }

        @Override
        protected TopLocalityTopEquivalenceEvaluator createTopEquivalenceEvaluator() {
            return new TopLocalityTopEquivalenceEvaluator();
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.isLocal = this.getTopEquivalenceEvaluator().isEquivalent((OWLClassExpression)axiom.getDomain());
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.isLocal = this.getTopEquivalenceEvaluator().isEquivalent((OWLClassExpression)axiom.getRange());
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getSuperProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.isLocal = !this.signature.contains(axiom.getSuperProperty().getNamedProperty());
        }

        final class TopLocalityBottomEquivalenceEvaluator
        extends LocalityAxiomVisitor.AbstractBottomEquivalenceEvaluator {
            TopLocalityBottomEquivalenceEvaluator() {
            }

            @Override
            public void visit(OWLClass ce) {
                this.isEquivalent = ce.isOWLNothing();
            }

            @Override
            public void visit(OWLDataAllValuesFrom ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && !((OWLDataRange)ce.getFiller()).isTopDatatype();
            }

            @Override
            public void visit(OWLDataExactCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0 && !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller()) || ce.getCardinality() > 0 && !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)ce.getFiller());
            }

            @Override
            public void visit(OWLDataHasValue ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLDataMaxCardinality ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && ce.getCardinality() <= 1 && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller());
            }

            @Override
            public void visit(OWLDataMinCardinality ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLDataSomeValuesFrom ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectAllValuesFrom ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) && this.isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectExactCardinality ce) {
                this.isEquivalent = ce.getCardinality() > 0 && (this.isEquivalent((OWLClassExpression)ce.getFiller()) || !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) && TopLocalityAxiomVisitor.this.getTopEquivalenceEvaluator().isEquivalent((OWLClassExpression)ce.getFiller()));
            }

            @Override
            public void visit(OWLObjectHasSelf ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectHasValue ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectMaxCardinality ce) {
                this.isEquivalent = ce.getCardinality() > 0 && !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) && TopLocalityAxiomVisitor.this.getTopEquivalenceEvaluator().isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectMinCardinality ce) {
                this.isEquivalent = ce.getCardinality() > 0 && this.isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectSomeValuesFrom ce) {
                this.isEquivalent = this.isEquivalent((OWLClassExpression)ce.getFiller());
            }
        }

        final class TopLocalityTopEquivalenceEvaluator
        extends LocalityAxiomVisitor.AbstractTopEquivalenceEvaluator {
            TopLocalityTopEquivalenceEvaluator() {
            }

            @Override
            public void visit(OWLClass ce) {
                this.isEquivalent = ce.isOWLThing() || !ce.isOWLNothing() && !TopLocalityAxiomVisitor.this.signature.contains(ce);
            }

            @Override
            public void visit(OWLDataAllValuesFrom ce) {
                this.isEquivalent = ((OWLDataRange)ce.getFiller()).isTopDatatype();
            }

            @Override
            public void visit(OWLDataExactCardinality ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLDataHasValue ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty());
            }

            @Override
            public void visit(OWLDataMaxCardinality ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLDataMinCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0 || ce.getCardinality() == 1 && !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller()) || ce.getCardinality() > 1 && !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)ce.getFiller());
            }

            @Override
            public void visit(OWLDataSomeValuesFrom ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectAllValuesFrom ce) {
                this.isEquivalent = this.isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectExactCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0 && TopLocalityAxiomVisitor.this.getBottomEquivalenceEvaluator().isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectHasSelf ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty());
            }

            @Override
            public void visit(OWLObjectHasValue ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty());
            }

            @Override
            public void visit(OWLObjectMaxCardinality ce) {
                this.isEquivalent = TopLocalityAxiomVisitor.this.getBottomEquivalenceEvaluator().isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectMinCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0 || !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) && this.isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectSomeValuesFrom ce) {
                this.isEquivalent = !TopLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) && this.isEquivalent((OWLClassExpression)ce.getFiller());
            }
        }
    }

    private final class BottomLocalityAxiomVisitor
    extends LocalityAxiomVisitor {
        BottomLocalityAxiomVisitor(OWLAxiom axiom, Collection<OWLEntity> signature) {
            super(axiom, signature);
        }

        protected boolean checkIfLocalProperties(OWLNaryPropertyAxiom<? extends OWLPropertyExpression> axiom) {
            List<? extends OWLPropertyExpression> disjs = OWLAPIStreamUtils.asList(axiom.properties());
            int size = disjs.size();
            if (size > 1) {
                boolean nonBottomEquivPropFound = false;
                for (OWLPropertyExpression oWLPropertyExpression : disjs) {
                    if ((!oWLPropertyExpression.isOWLDataProperty() || !this.signature.contains(oWLPropertyExpression.asOWLDataProperty())) && (!oWLPropertyExpression.isOWLObjectProperty() || !this.signature.contains(oWLPropertyExpression.asOWLObjectProperty()))) continue;
                    if (nonBottomEquivPropFound) {
                        return false;
                    }
                    nonBottomEquivPropFound = true;
                }
            }
            return true;
        }

        @Override
        protected BottomLocalityBottomEquivalenceEvaluator createBottomEquivalenceEvaluator() {
            return new BottomLocalityBottomEquivalenceEvaluator();
        }

        @Override
        protected BottomLocalityTopEquivalenceEvaluator createTopEquivalenceEvaluator() {
            return new BottomLocalityTopEquivalenceEvaluator();
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.isLocal = this.checkIfLocalProperties(axiom);
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.isLocal = this.checkIfLocalProperties(axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.getTopEquivalenceEvaluator().isEquivalent((OWLClassExpression)axiom.getDomain());
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.getTopEquivalenceEvaluator().isEquivalent((OWLClassExpression)axiom.getRange());
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.isLocal = !this.signature.contains(((OWLObjectPropertyExpression)axiom.getSubProperty()).getNamedProperty());
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.isLocal = axiom.getPropertyChain().stream().anyMatch(ope -> !this.signature.contains(ope.getNamedProperty()));
        }

        final class BottomLocalityBottomEquivalenceEvaluator
        extends LocalityAxiomVisitor.AbstractBottomEquivalenceEvaluator {
            BottomLocalityBottomEquivalenceEvaluator() {
            }

            @Override
            public void visit(OWLClass ce) {
                this.isEquivalent = ce.isOWLNothing() || !ce.isOWLThing() && !BottomLocalityAxiomVisitor.this.signature.contains(ce);
            }

            @Override
            public void visit(OWLDataAllValuesFrom ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLDataExactCardinality ce) {
                this.isEquivalent = ce.getCardinality() > 0 && !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty());
            }

            @Override
            public void visit(OWLDataHasValue ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty());
            }

            @Override
            public void visit(OWLDataMaxCardinality ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLDataMinCardinality ce) {
                this.isEquivalent = ce.getCardinality() > 0 && !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty());
            }

            @Override
            public void visit(OWLDataSomeValuesFrom ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectAllValuesFrom ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectExactCardinality ce) {
                this.isEquivalent = ce.getCardinality() > 0 && (!BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) || this.isEquivalent((OWLClassExpression)ce.getFiller()));
            }

            @Override
            public void visit(OWLObjectHasSelf ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty());
            }

            @Override
            public void visit(OWLObjectHasValue ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty());
            }

            @Override
            public void visit(OWLObjectMaxCardinality ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectMinCardinality ce) {
                this.isEquivalent = ce.getCardinality() > 0 && (!BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) || this.isEquivalent((OWLClassExpression)ce.getFiller()));
            }

            @Override
            public void visit(OWLObjectSomeValuesFrom ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) || this.isEquivalent((OWLClassExpression)ce.getFiller());
            }
        }

        final class BottomLocalityTopEquivalenceEvaluator
        extends LocalityAxiomVisitor.AbstractTopEquivalenceEvaluator {
            BottomLocalityTopEquivalenceEvaluator() {
            }

            @Override
            public void visit(OWLClass ce) {
                this.isEquivalent = ce.isOWLThing();
            }

            @Override
            public void visit(OWLDataAllValuesFrom ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) || ((OWLDataRange)ce.getFiller()).isTopDatatype();
            }

            @Override
            public void visit(OWLDataExactCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0 && !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty());
            }

            @Override
            public void visit(OWLDataHasValue ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLDataMaxCardinality ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty());
            }

            @Override
            public void visit(OWLDataMinCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0 || ce.getCardinality() == 1 && !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller()) || ce.getCardinality() > 1 && !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)ce.getFiller());
            }

            @Override
            public void visit(OWLDataSomeValuesFrom ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectAllValuesFrom ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) || this.isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectExactCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0 && (!BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) || BottomLocalityAxiomVisitor.this.getBottomEquivalenceEvaluator().isEquivalent((OWLClassExpression)ce.getFiller()));
            }

            @Override
            public void visit(OWLObjectHasSelf ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectHasValue ce) {
                this.isEquivalent = false;
            }

            @Override
            public void visit(OWLObjectMaxCardinality ce) {
                this.isEquivalent = !BottomLocalityAxiomVisitor.this.signature.contains(ce.getProperty().getNamedProperty()) || BottomLocalityAxiomVisitor.this.getBottomEquivalenceEvaluator().isEquivalent((OWLClassExpression)ce.getFiller());
            }

            @Override
            public void visit(OWLObjectMinCardinality ce) {
                this.isEquivalent = ce.getCardinality() == 0;
            }

            @Override
            public void visit(OWLObjectSomeValuesFrom ce) {
                this.isEquivalent = false;
            }
        }
    }
}

