/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;

public class AbsoluteIRIHelper {
    public static IRI verifyAbsolute(IRI iri, @Nullable OWLDocumentFormat f, OWLOntology o) {
        if (iri.isAbsolute()) {
            return iri;
        }
        if (f == null || f.supportsRelativeIRIs()) {
            return iri;
        }
        String defaultPrefix = null;
        if (f.isPrefixOWLDocumentFormat()) {
            defaultPrefix = f.asPrefixOWLDocumentFormat().getDefaultPrefix();
        }
        if (defaultPrefix == null) {
            defaultPrefix = o.getOntologyID().getOntologyIRI().map(IRI::toString).orElse(null);
        }
        if (defaultPrefix == null) {
            defaultPrefix = o.getOntologyID().getDefaultDocumentIRI().map(IRI::toString).orElse(null);
        }
        if (defaultPrefix == null) {
            return IRI.create("urn:absoluteiri:defaultvalue#" + String.valueOf(iri));
        }
        return IRI.create(defaultPrefix + String.valueOf(iri));
    }
}

