/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ReificationManager;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ReifiedStatementBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

abstract class AbstractState {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractState.class);
    static final String DATATYPE_RESOURCE = "rdf:datatype specified on a node with resource value.";
    static final String TEXT_SEEN = "Text was seen and new node is started.";
    static final String RDF_RDF = "Expecting rdf:RDF element.";
    static final String OP_EXPECTED = "Cannot answer characters when object properties are expected.";
    static final String CHARACTERS_NOT_EXPECTED = "Characters were not expected.";
    static final String INCORRECT_START = "incorrect element start encountered.";
    static final String EXPECTING_OBJECT = "Expecting an object element instead of character content.";
    static final String RDF_RDF_EXPECTED = "Expecting rdf:rdf element instead of character content.";
    static final String NODE_EXPECTED = "Cannot answer characters when node is expected.";
    static final String NO_RDF_NODE_ID_ID_ABOUT = "Element cannot specify both rdf:nodeID and rdf:ID or rdf:about attributes.";
    static final String NO_RDF_ID_AND_ABOUT = "Element cannot specify both rdf:ID and rdf:about attributes.";
    static final String ABOUT_EACH_PREFIX_UNSUPPORTED = "rdf:aboutEachPrefix attribute is not supported.";
    static final String ABOUT_EACH_UNSUPPORTED = "rdf:aboutEach attribute is not supported.";
    protected final RDFParser parser;

    AbstractState(RDFParser parser) {
        this.parser = parser;
    }

    ReificationManager getReificationManager(Attributes atts) {
        String bagIDAttr = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "bagID");
        if (bagIDAttr == null) {
            return ReificationManager.INSTANCE;
        }
        String bagID = this.parser.resolveIRI("#" + bagIDAttr);
        return new ReifiedStatementBag(bagID, this.parser);
    }

    void propertyAttributes(String subjectIRI, Attributes atts, ReificationManager reificationManager) {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String nsIRI = atts.getURI(i);
            String localName = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (!("http://www.w3.org/XML/1998/namespace".equals(nsIRI) || "xml:lang".equals(localName) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(nsIRI) && ("ID".equals(localName) || "nodeID".equals(localName) || "about".equals(localName) || "type".equals(localName) || "resource".equals(localName) || "parseType".equals(localName) || "aboutEach".equals(localName) || "aboutEachPrefix".equals(localName) || "bagID".equals(localName)))) {
                String reificationID = reificationManager.getReificationID(null, this.parser);
                this.parser.statementWithLiteralValue(subjectIRI, nsIRI + localName, value, null, reificationID);
                continue;
            }
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(nsIRI) || !"type".equals(localName)) continue;
            String resolvedValue = this.parser.resolveIRI(value);
            String reificationID = reificationManager.getReificationID(null, this.parser);
            this.parser.statementWithResourceValue(subjectIRI, nsIRI + localName, resolvedValue, reificationID);
        }
    }

    @Nullable
    protected String getNodeIDResourceResourceIRI(Attributes atts) {
        String value = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        if (value != null) {
            return this.parser.resolveIRI(value);
        }
        value = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (value != null) {
            return NodeID.getIRIFromNodeID(value);
        }
        return null;
    }

    boolean notBlank(char[] data, int start, int length) {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            if (!this.notSpace(data[i])) continue;
            return true;
        }
        return false;
    }

    boolean notSpace(char c) {
        return c != ' ' && c != '\n' && c != '\r' && c != '\t';
    }

    boolean notBlank(StringBuilder buffer) {
        for (int i = 0; i < buffer.length(); ++i) {
            if (!this.notSpace(buffer.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

