/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleLogger.class);
    private final AtomicInteger count = new AtomicInteger();
    @Nullable
    private PrefixManager prefixManager;

    public static void logOntologyID(OWLOntologyID id) {
        LOGGER.debug("Loaded {}", (Object)id);
    }

    public void setPrefixManager(@Nullable PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
    }

    public int count() {
        return this.count.get();
    }

    public void logTriple(Object s, Object p, Object o) {
        this.justLog(s, p, o);
        this.incrementTripleCount();
    }

    public void logTriple(Object s, Object p, Object o, @Nullable Object lang, @Nullable Object datatype) {
        this.justLog(s, p, o, lang, datatype);
        this.incrementTripleCount();
    }

    public void justLog(Object s, Object p, Object o, @Nullable Object lang, @Nullable Object datatype) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("s={} p={} o={} l={} dt={}", new Object[]{this.shorten(s), this.shorten(p), this.shorten(o), lang, this.shorten(datatype)});
        }
    }

    public void justLog(Object s, Object p, Object o) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("s={} p={} o={}", new Object[]{this.shorten(s), this.shorten(p), this.shorten(o)});
        }
    }

    private Object shorten(@Nullable Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String && (((String)o).startsWith("http:") || ((String)o).startsWith("urn:"))) {
            return this.shorten(IRI.create((String)o));
        }
        if (this.prefixManager == null || !(o instanceof IRI)) {
            return "\"" + String.valueOf(o) + "\"";
        }
        IRI i = (IRI)o;
        String result = OWLAPIPreconditions.verifyNotNull(this.prefixManager).getPrefixIRI(i);
        if (result == null) {
            result = i.toQuotedString();
        }
        return result;
    }

    private void incrementTripleCount() {
        if (this.count.incrementAndGet() % 10000 == 0) {
            LOGGER.debug("Parsed: {} triples", (Object)this.count);
        }
    }

    public void logNumberOfTriples() {
        LOGGER.debug("Total number of triples: {}", (Object)this.count);
    }
}

