/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.util.Namespaces;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RioMemoryTripleSource
implements OWLOntologyDocumentSource {
    private final Map<String, String> namespaces = new LinkedHashMap<String, String>();
    private final Iterator<Statement> statementIterator;
    private final IRI documentIRI = IRI.getNextDocumentIRI("rio-memory-triples:");

    public RioMemoryTripleSource(Iterator<Statement> statements) {
        this.statementIterator = OWLAPIPreconditions.checkNotNull(statements, "statements cannot be null");
    }

    public RioMemoryTripleSource(Iterator<Statement> statements, Map<String, String> namespaces) {
        this(statements);
        this.namespaces.putAll(namespaces);
    }

    public RioMemoryTripleSource(Iterable<Statement> statements) {
        this.statementIterator = statements.iterator();
        if (statements instanceof Model) {
            this.namespaces.putAll(Namespaces.asMap((Set)((Model)statements).getNamespaces()));
        }
    }

    public RioMemoryTripleSource(CloseableIteration<Statement> statements) {
        this.statementIterator = new StatementIterator(statements);
    }

    public RioMemoryTripleSource(CloseableIteration<Statement> statements, Map<String, String> namespaces) {
        this(statements);
        this.namespaces.putAll(namespaces);
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public boolean hasAlredyFailedOnStreams() {
        return false;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> nextNamespaces) {
        this.namespaces.clear();
        this.namespaces.putAll(nextNamespaces);
    }

    public Iterator<Statement> getStatementIterator() {
        return this.statementIterator;
    }

    public void setNamespaces(Set<Namespace> nextNamespaces) {
        this.namespaces.clear();
        this.namespaces.putAll(Namespaces.asMap(nextNamespaces));
    }

    @Override
    public boolean hasAlredyFailedOnIRIResolution() {
        return false;
    }

    @Override
    public void setIRIResolutionFailed(boolean value) {
    }

    static final class StatementIterator
    implements Iterator<Statement> {
        private final CloseableIteration<Statement> statements;

        StatementIterator(CloseableIteration<Statement> statements) {
            this.statements = statements;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove statements using this iterator");
        }

        @Override
        public Statement next() {
            return (Statement)this.statements.next();
        }

        @Override
        public boolean hasNext() {
            return this.statements.hasNext();
        }
    }
}

