/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum SWRLVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    IMP("Imp"),
    INDIVIDUAL_PROPERTY_ATOM("IndividualPropertyAtom"),
    DATAVALUED_PROPERTY_ATOM("DatavaluedPropertyAtom"),
    CLASS_ATOM("ClassAtom"),
    DATA_RANGE_ATOM("DataRangeAtom"),
    VARIABLE("Variable"),
    ATOM_LIST("AtomList"),
    SAME_INDIVIDUAL_ATOM("SameIndividualAtom"),
    DIFFERENT_INDIVIDUALS_ATOM("DifferentIndividualsAtom"),
    BUILT_IN_ATOM("BuiltinAtom"),
    HEAD("head"),
    BODY("body"),
    CLASS_PREDICATE("classPredicate"),
    DATA_RANGE("dataRange"),
    PROPERTY_PREDICATE("propertyPredicate"),
    BUILT_IN("builtin"),
    BUILT_IN_CLASS("Builtin"),
    ARGUMENTS("arguments"),
    ARGUMENT_1("argument1"),
    ARGUMENT_2("argument2");

    private final String shortName;
    private final IRI iri;
    private final String prefixedName;

    private SWRLVocabulary(String name) {
        this.shortName = name;
        this.prefixedName = Namespaces.SWRL.getPrefixName() + ":" + name;
        this.iri = IRI.create(Namespaces.SWRL.toString(), name);
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }
}

