/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.owl.owlapi.InternalizedEntities;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplNoCompression
extends OWLObjectImpl
implements OWLLiteral {
    private final String literal;
    private final OWLDatatype datatype;
    private final String language;

    public OWLLiteralImplNoCompression(String literal, @Nullable String lang, @Nullable OWLDatatype datatype) {
        this.literal = literal;
        if (lang == null || lang.isEmpty()) {
            this.language = "";
            this.datatype = datatype == null ? InternalizedEntities.XSDSTRING : datatype;
        } else {
            if (datatype != null && !datatype.equals(InternalizedEntities.LANGSTRING) && !datatype.equals(InternalizedEntities.PLAIN)) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + String.valueOf(datatype.getIRI()) + " and language: " + lang);
            }
            this.language = lang;
            this.datatype = InternalizedEntities.LANGSTRING;
        }
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public boolean hasLang() {
        return !this.language.isEmpty();
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.getDatatype().isRDFPlainLiteral();
    }

    @Override
    public boolean isInteger() {
        return this.getDatatype().isInteger();
    }

    @Override
    public boolean isBoolean() {
        return this.getDatatype().isBoolean();
    }

    @Override
    public boolean isDouble() {
        return this.getDatatype().isDouble();
    }

    @Override
    public boolean isFloat() {
        return this.getDatatype().isFloat();
    }

    @Override
    public int parseInteger() {
        return Integer.parseInt(this.getLiteral());
    }

    @Override
    public boolean parseBoolean() {
        return OWLLiteralImpl.asBoolean(this.literal);
    }

    @Override
    public double parseDouble() {
        return Double.parseDouble(this.literal);
    }

    @Override
    public float parseFloat() {
        if ("inf".equalsIgnoreCase(this.literal)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(this.literal)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(this.literal);
    }

    @Override
    public String getLang() {
        return this.language;
    }

    @Override
    public boolean hasLang(@Nullable String lang) {
        if (lang == null) {
            return this.language.isEmpty();
        }
        return this.language.equalsIgnoreCase(lang.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int initHashCode() {
        int hash = this.hashIndex();
        hash = OWLObject.hashIteration(hash, this.getDatatype().hashCode());
        hash = OWLObject.hashIteration(hash, this.specificHash() * 65536);
        return OWLObject.hashIteration(hash, this.getLang().hashCode());
    }

    private int specificHash() {
        try {
            if (this.isInteger()) {
                return this.parseInteger();
            }
            if (this.isDouble()) {
                return (int)this.parseDouble();
            }
            if (this.isFloat()) {
                return (int)this.parseFloat();
            }
            if (this.isBoolean()) {
                return this.parseBoolean() ? 1 : 0;
            }
            if (this.datatype.equals(InternalizedEntities.XSDLONG)) {
                return (int)Long.parseLong(this.getLiteral());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getLiteral().hashCode();
    }
}

