/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.concurrent;

import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasAxiomsByType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.HasTrimToSize;

public class ConcurrentOWLOntologyImpl
implements OWLMutableOntology,
HasTrimToSize {
    private final OWLOntology delegate;
    private ReadWriteLock lock;

    @Inject
    public ConcurrentOWLOntologyImpl(OWLOntology delegate, ReadWriteLock readWriteLock) {
        this.delegate = OWLAPIPreconditions.verifyNotNull(delegate);
        this.lock = OWLAPIPreconditions.verifyNotNull(readWriteLock);
    }

    @Override
    public int typeIndex() {
        return this.delegate.typeIndex();
    }

    @Override
    public void setLock(ReadWriteLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withWriteLock(Supplier<T> t) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            T t2 = t.get();
            return t2;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void callWriteLock(Runnable t) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            t.run();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withReadLock(Supplier<T> t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            T t2 = t.get();
            return t2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean withBooleanReadLock(BooleanSupplier t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = t.getAsBoolean();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int withIntReadLock(IntSupplier t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int n = t.getAsInt();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    private void callReadLock(Store t) throws OWLOntologyStorageException {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            t.store();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void trimToSize() {
        this.callWriteLock(this::trimToSizeInternal);
    }

    protected void trimToSizeInternal() {
        if (this.delegate instanceof HasTrimToSize) {
            ((HasTrimToSize)((Object)this.delegate)).trimToSize();
        }
    }

    @Override
    public void accept(OWLNamedObjectVisitor owlNamedObjectVisitor) {
        this.delegate.accept(owlNamedObjectVisitor);
    }

    @Override
    public <O> O accept(OWLNamedObjectVisitorEx<O> owlNamedObjectVisitorEx) {
        return this.delegate.accept(owlNamedObjectVisitorEx);
    }

    public int hashCode() {
        return this.withIntReadLock((IntSupplier)LambdaMetafactory.metafactory(null, null, null, ()I, hashCode(), ()I)((OWLOntology)this.delegate));
    }

    public boolean equals(@Nullable Object obj) {
        return this.withBooleanReadLock(() -> this.delegate.equals(obj));
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        return this.withReadLock(this.delegate::getOWLOntologyManager);
    }

    @Override
    public void setOWLOntologyManager(@Nullable OWLOntologyManager owlOntologyManager) {
        this.callWriteLock(() -> this.delegate.setOWLOntologyManager(owlOntologyManager));
    }

    @Override
    public OWLOntologyID getOntologyID() {
        return this.withReadLock(this.delegate::getOntologyID);
    }

    @Override
    public boolean isAnonymous() {
        return this.withBooleanReadLock(this.delegate::isAnonymous);
    }

    @Override
    public Set<OWLAnnotation> getAnnotations() {
        return this.withReadLock(this.delegate::getAnnotations);
    }

    @Override
    public Set<IRI> getDirectImportsDocuments() {
        return this.withReadLock(this.delegate::getDirectImportsDocuments);
    }

    @Override
    public Stream<IRI> directImportsDocuments() {
        return this.withReadLock(this.delegate::directImportsDocuments);
    }

    @Override
    public Set<OWLOntology> getDirectImports() {
        return this.withReadLock(this.delegate::getDirectImports);
    }

    @Override
    public Stream<OWLOntology> directImports() {
        return this.withReadLock(this.delegate::directImports);
    }

    @Override
    public Set<OWLOntology> getImports() {
        return this.withReadLock(this.delegate::getImports);
    }

    @Override
    public Stream<OWLOntology> imports() {
        return this.withReadLock(this.delegate::imports);
    }

    @Override
    public Set<OWLOntology> getImportsClosure() {
        return this.withReadLock(this.delegate::getImportsClosure);
    }

    @Override
    public Stream<OWLOntology> importsClosure() {
        return this.withReadLock(this.delegate::importsClosure);
    }

    @Override
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.withReadLock(this.delegate::getImportsDeclarations);
    }

    @Override
    public boolean isEmpty() {
        return this.withBooleanReadLock(this.delegate::isEmpty);
    }

    @Override
    public Set<OWLAxiom> getTBoxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getTBoxAxioms(imports));
    }

    @Override
    public Set<OWLAxiom> getABoxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getABoxAxioms(imports));
    }

    @Override
    public Set<OWLAxiom> getRBoxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getRBoxAxioms(imports));
    }

    @Override
    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.tboxAxioms(imports));
    }

    @Override
    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.aboxAxioms(imports));
    }

    @Override
    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.rboxAxioms(imports));
    }

    @Override
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.withReadLock(this.delegate::getGeneralClassAxioms);
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return this.withReadLock(this.delegate::getSignature);
    }

    @Override
    public Set<OWLEntity> getSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getSignature(imports));
    }

    @Override
    public Stream<OWLClassAxiom> generalClassAxioms() {
        return this.withReadLock(this.delegate::generalClassAxioms);
    }

    @Override
    public Stream<OWLEntity> signature() {
        return this.withReadLock(this.delegate::signature);
    }

    @Override
    public Stream<OWLEntity> signature(Imports imports) {
        return this.withReadLock(() -> this.delegate.signature(imports));
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.isDeclared(owlEntity));
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.isDeclared(owlEntity, imports));
    }

    @Override
    public void saveOntology() throws OWLOntologyStorageException {
        this.callReadLock(this.delegate::saveOntology);
    }

    @Override
    public void saveOntology(IRI iri) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(iri));
    }

    @Override
    public void saveOntology(OutputStream outputStream) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(outputStream));
    }

    @Override
    public void saveOntology(OWLDocumentFormat owlDocumentFormat) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat));
    }

    @Override
    public void saveOntology(OWLDocumentFormat owlDocumentFormat, IRI iri) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, iri));
    }

    @Override
    public void saveOntology(OWLDocumentFormat owlDocumentFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, outputStream));
    }

    @Override
    public void saveOntology(OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlOntologyDocumentTarget));
    }

    @Override
    public void saveOntology(OWLDocumentFormat owlDocumentFormat, OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, owlOntologyDocumentTarget));
    }

    @Override
    public Set<OWLClassExpression> getNestedClassExpressions() {
        return this.withReadLock(this.delegate::getNestedClassExpressions);
    }

    @Override
    public void accept(OWLObjectVisitor owlObjectVisitor) {
        this.delegate.accept(owlObjectVisitor);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> owlObjectVisitorEx) {
        return this.delegate.accept(owlObjectVisitorEx);
    }

    @Override
    public boolean isTopEntity() {
        return this.withBooleanReadLock(this.delegate::isTopEntity);
    }

    @Override
    public boolean isBottomEntity() {
        return this.withBooleanReadLock(this.delegate::isBottomEntity);
    }

    public String toString() {
        return this.withReadLock((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((OWLOntology)this.delegate));
    }

    @Override
    public int compareTo(@Nullable OWLObject o) {
        return this.withIntReadLock(() -> this.delegate.compareTo(o));
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity));
    }

    @Override
    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntitiesOfTypeInSignature(type));
    }

    @Override
    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type, Imports includeImportsClosure) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntitiesOfTypeInSignature(type, includeImportsClosure));
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return this.withReadLock(this.delegate::getAnonymousIndividuals);
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return this.withReadLock(this.delegate::getClassesInSignature);
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return this.withReadLock(this.delegate::getObjectPropertiesInSignature);
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return this.withReadLock(this.delegate::getDataPropertiesInSignature);
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return this.withReadLock(this.delegate::getIndividualsInSignature);
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return this.withReadLock(this.delegate::getDatatypesInSignature);
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return this.withReadLock(this.delegate::getAnnotationPropertiesInSignature);
    }

    @Override
    public Set<OWLAxiom> getAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(imports));
    }

    @Override
    public int getAxiomCount(Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(imports));
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getLogicalAxioms(imports));
    }

    @Override
    public int getLogicalAxiomCount(Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getLogicalAxiomCount(imports));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType, imports));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(axiomType, imports));
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType, imports));
    }

    @Override
    public boolean containsAxiom(OWLAxiom owlAxiom, Imports imports, AxiomAnnotations axiomAnnotations) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom, imports, axiomAnnotations));
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, imports));
    }

    @Override
    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom owlAxiom, Imports imports) {
        return this.withReadLock(() -> this.delegate.axiomsIgnoreAnnotations(owlAxiom, imports));
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive, Imports imports) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive, imports));
    }

    @Override
    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlPrimitive, Imports imports) {
        return this.withReadLock(() -> this.delegate.referencingAxioms(owlPrimitive, imports));
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass, imports));
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression, imports));
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty, imports));
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual, imports));
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty, imports));
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype, imports));
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return this.withReadLock(this.delegate::getAxioms);
    }

    @Override
    public Stream<OWLAxiom> axioms() {
        return this.withReadLock(this.delegate::axioms);
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return this.withReadLock(this.delegate::getLogicalAxioms);
    }

    @Override
    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.withReadLock(this.delegate::logicalAxioms);
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType) {
        return this.withReadLock(() -> this.delegate.axioms(axiomType));
    }

    @Override
    public boolean equalAxioms(HasAxiomsByType o) {
        return this.withBooleanReadLock(() -> this.delegate.equalAxioms(o));
    }

    @Override
    public boolean containsAxiom(OWLAxiom owlAxiom) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom));
    }

    @Override
    public Set<OWLAxiom> getAxioms(boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(b));
    }

    @Override
    public int getAxiomCount(boolean b) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(b));
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean b) {
        return this.withReadLock(() -> this.delegate.getLogicalAxioms(b));
    }

    @Override
    public int getLogicalAxiomCount(boolean b) {
        return this.withIntReadLock(() -> this.delegate.getLogicalAxiomCount(b));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType, b));
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean b) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType, b));
    }

    @Override
    public boolean containsAxiom(OWLAxiom owlAxiom, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom, b));
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom owlAxiom, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiomIgnoreAnnotations(owlAxiom, b));
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, b));
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive, boolean b) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive, b));
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass, b));
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression, b));
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty, b));
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual, b));
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty, b));
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype, b));
    }

    @Override
    public int getAxiomCount() {
        return this.withIntReadLock(this.delegate::getAxiomCount);
    }

    @Override
    public int getLogicalAxiomCount() {
        return this.withIntReadLock(this.delegate::getLogicalAxiomCount);
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType));
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom owlAxiom) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiomIgnoreAnnotations(owlAxiom));
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom));
    }

    @Override
    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom owlAxiom) {
        return this.withReadLock(() -> this.delegate.axiomsIgnoreAnnotations(owlAxiom));
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive));
    }

    @Override
    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlPrimitive) {
        return this.withReadLock(() -> this.delegate.referencingAxioms(owlPrimitive));
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass));
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty));
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual));
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty));
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype));
    }

    @Override
    public Stream<OWLClassAxiom> axioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.axioms(owlClass));
    }

    @Override
    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.axioms(owlObjectPropertyExpression));
    }

    @Override
    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.axioms(owlDataProperty));
    }

    @Override
    public Stream<OWLIndividualAxiom> axioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.axioms(owlIndividual));
    }

    @Override
    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.axioms(owlAnnotationProperty));
    }

    @Override
    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.axioms(owlDatatype));
    }

    @Override
    public Set<OWLClass> getClassesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getClassesInSignature(imports));
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getObjectPropertiesInSignature(imports));
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getDataPropertiesInSignature(imports));
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getIndividualsInSignature(imports));
    }

    @Override
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports imports) {
        return this.withReadLock(() -> this.delegate.getReferencedAnonymousIndividuals(imports));
    }

    @Override
    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals(Imports imports) {
        return this.withReadLock(() -> this.delegate.referencedAnonymousIndividuals(imports));
    }

    @Override
    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.withReadLock(this.delegate::referencedAnonymousIndividuals);
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getDatatypesInSignature(imports));
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertiesInSignature(imports));
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity, imports));
    }

    @Override
    public boolean containsEntityInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri, imports));
    }

    @Override
    public boolean containsClassInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri, imports));
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri, imports));
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri, imports));
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri, imports));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri, imports));
    }

    @Override
    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri, imports));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri));
    }

    @Override
    public boolean containsEntityInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri));
    }

    @Override
    public boolean containsClassInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri));
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri));
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri));
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri));
    }

    @Override
    public boolean containsIndividualInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri));
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports imports) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri, imports));
    }

    @Override
    public Set<IRI> getPunnedIRIs(Imports imports) {
        return this.withReadLock(() -> this.delegate.getPunnedIRIs(imports));
    }

    @Override
    public boolean containsReference(OWLEntity owlEntity, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity, imports));
    }

    @Override
    public boolean containsReference(OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity));
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri));
    }

    @Override
    public Stream<OWLEntity> entitiesInSignature(IRI iri) {
        return this.withReadLock(() -> this.delegate.entitiesInSignature(iri));
    }

    @Override
    public Set<OWLClass> getClassesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getClassesInSignature(b));
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getObjectPropertiesInSignature(b));
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getDataPropertiesInSignature(b));
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getIndividualsInSignature(b));
    }

    @Override
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean b) {
        return this.withReadLock(() -> this.delegate.getReferencedAnonymousIndividuals(b));
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getDatatypesInSignature(b));
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertiesInSignature(b));
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity, b));
    }

    @Override
    public boolean containsEntityInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri, b));
    }

    @Override
    public boolean containsClassInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri, b));
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri, b));
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri, b));
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri, b));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri, b));
    }

    @Override
    public boolean containsIndividualInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri, b));
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean b) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri, b));
    }

    @Override
    public boolean containsReference(OWLEntity owlEntity, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity, b));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> aClass, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.getAxioms(aClass, owlObject, imports, navigation));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> aClass, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.axioms(aClass, owlObject, imports, navigation));
    }

    @Override
    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o, Imports imports) {
        return this.withReadLock(() -> this.delegate.filterAxioms(owlAxiomSearchFilter, o, imports));
    }

    @Override
    public boolean contains(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.contains(owlAxiomSearchFilter, o, imports));
    }

    @Override
    public boolean contains(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o) {
        return this.withBooleanReadLock(() -> this.delegate.contains(owlAxiomSearchFilter, o));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> aClass, Class<? extends OWLObject> aClass1, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.getAxioms(aClass, aClass1, owlObject, imports, navigation));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> aClass, Class<? extends OWLObject> aClass1, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.axioms(aClass, aClass1, owlObject, imports, navigation));
    }

    @Override
    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getSubAnnotationPropertyOfAxioms(owlAnnotationProperty));
    }

    @Override
    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertyDomainAxioms(owlAnnotationProperty));
    }

    @Override
    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertyRangeAxioms(owlAnnotationProperty));
    }

    @Override
    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.annotationPropertyDomainAxioms(owlAnnotationProperty));
    }

    @Override
    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.annotationPropertyRangeAxioms(owlAnnotationProperty));
    }

    @Override
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity owlEntity) {
        return this.withReadLock(() -> this.delegate.getDeclarationAxioms(owlEntity));
    }

    @Override
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject owlAnnotationSubject) {
        return this.withReadLock(() -> this.delegate.getAnnotationAssertionAxioms(owlAnnotationSubject));
    }

    @Override
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getSubClassAxiomsForSubClass(owlClass));
    }

    @Override
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getSubClassAxiomsForSuperClass(owlClass));
    }

    @Override
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getEquivalentClassesAxioms(owlClass));
    }

    @Override
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getDisjointClassesAxioms(owlClass));
    }

    @Override
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getDisjointUnionAxioms(owlClass));
    }

    @Override
    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getHasKeyAxioms(owlClass));
    }

    @Override
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectSubPropertyAxiomsForSubProperty(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectSubPropertyAxiomsForSuperProperty(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyDomainAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyRangeAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getInverseObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getEquivalentObjectPropertiesAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getDisjointObjectPropertiesAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getFunctionalObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getInverseFunctionalObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getSymmetricObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getAsymmetricObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getReflexiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getIrreflexiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getTransitiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Override
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataSubPropertyAxiomsForSubProperty(owlDataProperty));
    }

    @Override
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression owlDataPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getDataSubPropertyAxiomsForSuperProperty(owlDataPropertyExpression));
    }

    @Override
    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataPropertyDomainAxioms(owlDataProperty));
    }

    @Override
    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataPropertyRangeAxioms(owlDataProperty));
    }

    @Override
    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getEquivalentDataPropertiesAxioms(owlDataProperty));
    }

    @Override
    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDisjointDataPropertiesAxioms(owlDataProperty));
    }

    @Override
    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression owlDataPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getFunctionalDataPropertyAxioms(owlDataPropertyExpression));
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getClassAssertionAxioms(owlIndividual));
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression owlClassExpression) {
        return this.withReadLock(() -> this.delegate.getClassAssertionAxioms(owlClassExpression));
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getDataPropertyAssertionAxioms(owlIndividual));
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyAssertionAxioms(owlIndividual));
    }

    @Override
    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getNegativeObjectPropertyAssertionAxioms(owlIndividual));
    }

    @Override
    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getNegativeDataPropertyAssertionAxioms(owlIndividual));
    }

    @Override
    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getSameIndividualAxioms(owlIndividual));
    }

    @Override
    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getDifferentIndividualAxioms(owlIndividual));
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.getDatatypeDefinitions(owlDatatype));
    }

    @Override
    public ChangeApplied applyChange(OWLOntologyChange owlOntologyChange) {
        return this.withWriteLock(() -> this.getMutableOntology().applyChange(owlOntologyChange));
    }

    @Override
    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> list) {
        return this.withWriteLock(() -> this.getMutableOntology().applyChangesAndGetDetails(list));
    }

    @Override
    public ChangeApplied addAxiom(OWLAxiom owlAxiom) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxiom(owlAxiom));
    }

    @Override
    public ChangeApplied addAxioms(Collection<? extends OWLAxiom> set) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxioms(set));
    }

    @Override
    public ChangeApplied addAxioms(OWLAxiom ... set) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxioms(set));
    }

    @Override
    public ChangeApplied add(OWLAxiom owlAxiom) {
        return this.withWriteLock(() -> this.getMutableOntology().add(owlAxiom));
    }

    @Override
    public ChangeApplied add(Collection<? extends OWLAxiom> set) {
        return this.withWriteLock(() -> this.getMutableOntology().add(set));
    }

    @Override
    public ChangeApplied add(OWLAxiom ... set) {
        return this.withWriteLock(() -> this.getMutableOntology().add(set));
    }

    private OWLMutableOntology getMutableOntology() {
        return (OWLMutableOntology)this.delegate;
    }

    @Override
    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.withReadLock(this.delegate::importsDeclarations);
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports includeImportsClosure) {
        return this.withReadLock(() -> this.delegate.axioms(filter, key, includeImportsClosure));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key) {
        return this.withReadLock(() -> this.delegate.axioms(filter, key));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.axioms(type, explicitClass, entity, forSubPosition));
    }

    @Override
    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        return this.withReadLock(() -> this.delegate.subAnnotationPropertyOfAxioms(subProperty));
    }

    @Override
    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype datatype) {
        return this.withReadLock(() -> this.delegate.datatypeDefinitions(datatype));
    }

    @Override
    public ChangeApplied removeAxiom(OWLAxiom axiom) {
        return this.withWriteLock(() -> this.delegate.removeAxiom(axiom));
    }

    @Override
    public ChangeApplied removeAxioms(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLock(() -> this.delegate.removeAxioms(axioms));
    }

    @Override
    public ChangeApplied removeAxioms(OWLAxiom ... axioms) {
        return this.withWriteLock(() -> this.delegate.removeAxioms(axioms));
    }

    @Override
    public ChangeApplied remove(OWLAxiom axiom) {
        return this.withWriteLock(() -> this.delegate.remove(axiom));
    }

    @Override
    public ChangeApplied remove(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLock(() -> this.delegate.remove(axioms));
    }

    @Override
    public ChangeApplied remove(OWLAxiom ... axioms) {
        return this.withWriteLock(() -> this.delegate.remove(axioms));
    }

    @Override
    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        return this.withWriteLock(() -> this.delegate.applyDirectChange(change));
    }

    @Override
    public Stream<OWLDisjointObjectPropertiesAxiom> disjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.disjointObjectPropertiesAxioms(property));
    }

    @Override
    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.withReadLock(this.delegate::objectPropertiesInSignature);
    }

    @Override
    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity) {
        return this.withReadLock(() -> this.delegate.annotationAssertionAxioms(entity));
    }

    @Override
    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        return this.withReadLock(() -> this.delegate.annotationAssertionAxioms(entity, imports));
    }

    @Override
    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.withReadLock(this.delegate::annotationPropertiesInSignature);
    }

    @Override
    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.annotationPropertiesInSignature(imports));
    }

    @Override
    public Stream<OWLAnnotation> annotations() {
        return this.withReadLock(this.delegate::annotations);
    }

    @Override
    public List<OWLAnnotation> annotationsAsList() {
        return this.withReadLock(this.delegate::annotationsAsList);
    }

    @Override
    public Stream<OWLAnnotation> annotations(OWLAnnotationProperty p) {
        return this.withReadLock(() -> this.delegate.annotations(p));
    }

    @Override
    public Stream<OWLAnnotation> annotations(Predicate<OWLAnnotation> p) {
        return this.withReadLock(() -> this.delegate.annotations(p));
    }

    @Override
    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.withReadLock(this.delegate::anonymousIndividuals);
    }

    @Override
    public Stream<OWLAsymmetricObjectPropertyAxiom> asymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.asymmetricObjectPropertyAxioms(property));
    }

    @Override
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.axioms(type, entity, forSubPosition));
    }

    @Override
    public Stream<OWLAxiom> axioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(imports));
    }

    @Override
    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(property, imports));
    }

    @Override
    public Stream<OWLClassAxiom> axioms(OWLClass cls, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(cls, imports));
    }

    @Override
    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(property, imports));
    }

    @Override
    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(datatype, imports));
    }

    @Override
    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(individual, imports));
    }

    @Override
    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(property, imports));
    }

    @Override
    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression ce) {
        return this.withReadLock(() -> this.delegate.classAssertionAxioms(ce));
    }

    @Override
    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.classAssertionAxioms(individual));
    }

    @Override
    public Stream<OWLClass> classesInSignature() {
        return this.withReadLock(this.delegate::classesInSignature);
    }

    @Override
    public Stream<OWLClass> classesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.classesInSignature(imports));
    }

    @Override
    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.withReadLock(this.delegate::dataPropertiesInSignature);
    }

    @Override
    public Stream<OWLDataProperty> dataPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.dataPropertiesInSignature(imports));
    }

    @Override
    public Stream<OWLDataPropertyAssertionAxiom> dataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.dataPropertyAssertionAxioms(individual));
    }

    @Override
    public Stream<OWLDataPropertyDomainAxiom> dataPropertyDomainAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.dataPropertyDomainAxioms(property));
    }

    @Override
    public Stream<OWLDataPropertyRangeAxiom> dataPropertyRangeAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.dataPropertyRangeAxioms(property));
    }

    @Override
    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSubProperty(OWLDataProperty subProperty) {
        return this.withReadLock(() -> this.delegate.dataSubPropertyAxiomsForSubProperty(subProperty));
    }

    @Override
    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression superProperty) {
        return this.withReadLock(() -> this.delegate.dataSubPropertyAxiomsForSuperProperty(superProperty));
    }

    @Override
    public Stream<OWLDatatype> datatypesInSignature() {
        return this.withReadLock(this.delegate::datatypesInSignature);
    }

    @Override
    public Stream<OWLDatatype> datatypesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.datatypesInSignature(imports));
    }

    @Override
    public Stream<OWLDeclarationAxiom> declarationAxioms(OWLEntity subject) {
        return this.withReadLock(() -> this.delegate.declarationAxioms(subject));
    }

    @Override
    public Stream<OWLDifferentIndividualsAxiom> differentIndividualAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.differentIndividualAxioms(individual));
    }

    @Override
    public Stream<OWLDisjointClassesAxiom> disjointClassesAxioms(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.disjointClassesAxioms(cls));
    }

    @Override
    public Stream<OWLDisjointDataPropertiesAxiom> disjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.disjointDataPropertiesAxioms(property));
    }

    @Override
    public Stream<OWLDisjointUnionAxiom> disjointUnionAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.disjointUnionAxioms(owlClass));
    }

    @Override
    public Stream<OWLEntity> entitiesInSignature(IRI iri, Imports imports) {
        return this.withReadLock(() -> this.delegate.entitiesInSignature(iri, imports));
    }

    @Override
    public Stream<OWLEquivalentClassesAxiom> equivalentClassesAxioms(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.equivalentClassesAxioms(cls));
    }

    @Override
    public Stream<OWLEquivalentDataPropertiesAxiom> equivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.equivalentDataPropertiesAxioms(property));
    }

    @Override
    public Stream<OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.equivalentObjectPropertiesAxioms(property));
    }

    @Override
    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter filter, Object key) {
        return this.withReadLock(() -> this.delegate.filterAxioms(filter, key));
    }

    @Override
    public Stream<OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.functionalDataPropertyAxioms(property));
    }

    @Override
    public Stream<OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.functionalObjectPropertyAxioms(property));
    }

    @Override
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAnnotationAssertionAxioms(entity, imports));
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty annotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotations(annotationProperty));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.getAxioms(type, explicitClass, entity, forSubPosition));
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.getAxioms(type, entity, forSubPosition));
    }

    @Override
    @Nullable
    public OWLDocumentFormat getFormat() {
        return this.withReadLock(this.delegate::getFormat);
    }

    @Override
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        return this.withReadLock(this.delegate::getReferencedAnonymousIndividuals);
    }

    @Override
    public Stream<OWLHasKeyAxiom> hasKeyAxioms(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.hasKeyAxioms(cls));
    }

    @Override
    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.withReadLock(this.delegate::individualsInSignature);
    }

    @Override
    public Stream<OWLNamedIndividual> individualsInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.individualsInSignature(imports));
    }

    @Override
    public Stream<OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.inverseFunctionalObjectPropertyAxioms(property));
    }

    @Override
    public Stream<OWLInverseObjectPropertiesAxiom> inverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.inverseObjectPropertyAxioms(property));
    }

    @Override
    public Stream<OWLIrreflexiveObjectPropertyAxiom> irreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.irreflexiveObjectPropertyAxioms(property));
    }

    @Override
    public Stream<OWLLogicalAxiom> logicalAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.logicalAxioms(imports));
    }

    @Override
    public Stream<OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.negativeDataPropertyAssertionAxioms(individual));
    }

    @Override
    public Stream<OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.negativeObjectPropertyAssertionAxioms(individual));
    }

    @Override
    public Stream<OWLClassExpression> nestedClassExpressions() {
        return this.withReadLock(this.delegate::nestedClassExpressions);
    }

    @Override
    public Stream<OWLObjectProperty> objectPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.objectPropertiesInSignature(imports));
    }

    @Override
    public Stream<OWLObjectPropertyAssertionAxiom> objectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.objectPropertyAssertionAxioms(individual));
    }

    @Override
    public Stream<OWLObjectPropertyDomainAxiom> objectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.objectPropertyDomainAxioms(property));
    }

    @Override
    public Stream<OWLObjectPropertyRangeAxiom> objectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.objectPropertyRangeAxioms(property));
    }

    @Override
    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression subProperty) {
        return this.withReadLock(() -> this.delegate.objectSubPropertyAxiomsForSubProperty(subProperty));
    }

    @Override
    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression superProperty) {
        return this.withReadLock(() -> this.delegate.objectSubPropertyAxiomsForSuperProperty(superProperty));
    }

    @Override
    public Stream<OWLReflexiveObjectPropertyAxiom> reflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.reflexiveObjectPropertyAxioms(property));
    }

    @Override
    public Stream<OWLSameIndividualAxiom> sameIndividualAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.sameIndividualAxioms(individual));
    }

    @Override
    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSubClass(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.subClassAxiomsForSubClass(cls));
    }

    @Override
    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSuperClass(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.subClassAxiomsForSuperClass(cls));
    }

    @Override
    public Stream<OWLSymmetricObjectPropertyAxiom> symmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.symmetricObjectPropertyAxioms(property));
    }

    @Override
    public Stream<OWLTransitiveObjectPropertyAxiom> transitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.transitiveObjectPropertyAxioms(property));
    }

    private static interface Store {
        public void store() throws OWLOntologyStorageException;
    }
}

