/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderSWRLClassAtom
extends BaseBuilder<SWRLClassAtom, BuilderSWRLClassAtom> {
    @Nullable
    private SWRLIArgument argument = null;
    @Nullable
    private OWLClassExpression predicate = null;

    public BuilderSWRLClassAtom(@Nonnull SWRLClassAtom expected, OWLDataFactory df) {
        this(df);
        this.with(expected.getPredicate()).with((SWRLIArgument)expected.getArgument());
    }

    @Inject
    public BuilderSWRLClassAtom(OWLDataFactory df) {
        super(df);
    }

    @Nonnull
    public BuilderSWRLClassAtom with(SWRLIArgument arg) {
        this.argument = arg;
        return this;
    }

    @Nonnull
    public BuilderSWRLClassAtom with(OWLClassExpression arg) {
        this.predicate = arg;
        return this;
    }

    @Override
    public SWRLClassAtom buildObject() {
        return this.df.getSWRLClassAtom(this.getPredicate(), this.getArgument());
    }

    @Nonnull
    public OWLClassExpression getPredicate() {
        return (OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.predicate);
    }

    @Nonnull
    public SWRLIArgument getArgument() {
        return (SWRLIArgument)OWLAPIPreconditions.verifyNotNull((Object)this.argument);
    }
}

