/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderFacetRestriction
extends BaseBuilder<OWLFacetRestriction, BuilderFacetRestriction> {
    @Nullable
    private OWLLiteral literal = null;
    @Nullable
    private OWLFacet facet = null;

    public BuilderFacetRestriction(@Nonnull OWLFacetRestriction expected, OWLDataFactory df) {
        this(df);
        this.withFacet(expected.getFacet()).withLiteral(expected.getFacetValue());
    }

    @Inject
    public BuilderFacetRestriction(OWLDataFactory df) {
        super(df);
    }

    @Nonnull
    public BuilderFacetRestriction withLiteral(int arg) {
        this.literal = this.df.getOWLLiteral(arg);
        return this;
    }

    @Nonnull
    public BuilderFacetRestriction withLiteral(OWLLiteral arg) {
        this.literal = arg;
        return this;
    }

    @Nonnull
    public BuilderFacetRestriction withLiteral(double arg) {
        this.literal = this.df.getOWLLiteral(arg);
        return this;
    }

    @Nonnull
    public BuilderFacetRestriction withLiteral(float arg) {
        this.literal = this.df.getOWLLiteral(arg);
        return this;
    }

    @Nonnull
    public BuilderFacetRestriction withFacet(OWLFacet arg) {
        this.facet = arg;
        return this;
    }

    @Override
    public OWLFacetRestriction buildObject() {
        return this.df.getOWLFacetRestriction(this.getFacet(), this.getLiteral());
    }

    @Nonnull
    public OWLFacet getFacet() {
        return (OWLFacet)OWLAPIPreconditions.verifyNotNull((Object)this.facet);
    }

    @Nonnull
    public OWLLiteral getLiteral() {
        return (OWLLiteral)OWLAPIPreconditions.verifyNotNull((Object)this.literal);
    }
}

