/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationObjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLAnnotationImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLAnnotation {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLAnnotationProperty property;
    @Nonnull
    private final OWLAnnotationValue value;
    @Nonnull
    private final List<OWLAnnotation> anns;

    @Override
    protected int index() {
        return 5001;
    }

    public OWLAnnotationImpl(@Nonnull OWLAnnotationProperty property, @Nonnull OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        this.property = (OWLAnnotationProperty)OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        this.value = (OWLAnnotationValue)OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
        OWLAPIPreconditions.checkNotNull(annotations, (String)"annotations cannot be null");
        this.anns = CollectionFactory.sortOptionally(annotations);
    }

    public Set<OWLAnnotation> getAnnotations() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.anns);
    }

    public OWLAnnotationProperty getProperty() {
        return this.property;
    }

    public OWLAnnotationValue getValue() {
        return this.value;
    }

    public OWLAnnotation getAnnotatedAnnotation(@Nonnull Set<OWLAnnotation> annotations) {
        if (annotations.isEmpty()) {
            return this;
        }
        HashSet<OWLAnnotation> merged = new HashSet<OWLAnnotation>(this.anns);
        merged.addAll(annotations);
        return new OWLAnnotationImpl(this.property, this.value, merged);
    }

    public boolean isDeprecatedIRIAnnotation() {
        return this.property.isDeprecated() && this.value instanceof OWLLiteral && ((OWLLiteral)this.value).isBoolean() && ((OWLLiteral)this.value).parseBoolean();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OWLAnnotationImpl) {
            OWLAnnotationImpl other = (OWLAnnotationImpl)obj;
            return other.getProperty().equals(this.property) && other.getValue().equals(this.value) && other.anns.equals(this.anns);
        }
        if (obj instanceof OWLAnnotation) {
            OWLAnnotation other = (OWLAnnotation)obj;
            return other.getProperty().equals(this.property) && other.getValue().equals(this.value) && other.getAnnotations().equals(this.getAnnotations());
        }
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLAnnotation other = (OWLAnnotation)object;
        int diff = this.getProperty().compareTo((Object)other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return this.getValue().compareTo((Object)other.getValue());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLAnnotation)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotation)this);
    }

    public void accept(OWLAnnotationObjectVisitor visitor) {
        visitor.visit((OWLAnnotation)this);
    }

    public <O> O accept(OWLAnnotationObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotation)this);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.property);
        OWLAnnotationImpl.addEntitiesFromAnnotationsToSet(this.anns, entities);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        OWLAnnotationImpl.addAnonymousIndividualsFromAnnotationsToSet(this.anns, anons);
        if (this.value instanceof OWLAnonymousIndividual) {
            OWLAnonymousIndividual anonymousIndividual = (OWLAnonymousIndividual)this.value;
            anons.add(anonymousIndividual);
        }
    }
}

