/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.OWLAPIConfigProvider;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyStorageIOException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.OntologyIRIMappingNotFoundException;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.DefaultChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.DefaultImpendingChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImmutableOWLOntologyChangeException;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVetoException;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactoryNotFoundException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.OWLStorerNotFoundException;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAnnotationPropertyTransformer;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.HasTrimToSize;
import uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentPriorityCollection;

public class OWLOntologyManagerImpl
implements OWLOntologyManager,
OWLOntologyFactory.OWLOntologyCreationHandler,
Serializable {
    private static final long serialVersionUID = 40000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLOntologyManagerImpl.class);
    @Nonnull
    protected final Map<OWLOntologyID, OWLOntology> ontologiesByID = CollectionFactory.createSyncMap();
    @Nonnull
    protected final Map<OWLOntologyID, IRI> documentIRIsByID = CollectionFactory.createSyncMap();
    @Nonnull
    protected final Map<OWLOntologyID, OWLOntologyLoaderConfiguration> ontologyConfigurationsByOntologyID = new HashMap<OWLOntologyID, OWLOntologyLoaderConfiguration>();
    @Nonnull
    protected final Map<OWLOntologyID, OWLDocumentFormat> ontologyFormatsByOntology = CollectionFactory.createSyncMap();
    @Nonnull
    protected final Map<OWLImportsDeclaration, OWLOntologyID> ontologyIDsByImportsDeclaration = CollectionFactory.createSyncMap();
    protected final AtomicInteger loadCount = new AtomicInteger(0);
    protected final AtomicInteger importsLoadCount = new AtomicInteger(0);
    @Nonnull
    protected final Map<IRI, Object> importedIRIs = CollectionFactory.createSyncMap();
    @Nonnull
    protected final OWLDataFactory dataFactory;
    @Nonnull
    protected final Map<OWLOntologyID, Set<OWLOntology>> importsClosureCache = CollectionFactory.createSyncMap();
    @Nonnull
    protected final List<MissingImportListener> missingImportsListeners = CollectionFactory.createSyncList();
    @Nonnull
    protected final List<OWLOntologyLoaderListener> loaderListeners = CollectionFactory.createSyncList();
    @Nonnull
    protected final List<OWLOntologyChangeProgressListener> progressListeners = CollectionFactory.createSyncList();
    @Nonnull
    protected final AtomicLong autoGeneratedURICounter = new AtomicLong();
    private final AtomicBoolean broadcastChanges = new AtomicBoolean(true);
    @Nonnull
    protected OWLOntologyChangeBroadcastStrategy defaultChangeBroadcastStrategy = new DefaultChangeBroadcastStrategy();
    @Nonnull
    protected ImpendingOWLOntologyChangeBroadcastStrategy defaultImpendingChangeBroadcastStrategy = new DefaultImpendingChangeBroadcastStrategy();
    private transient Map<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy> listenerMap = CollectionFactory.createSyncMap();
    private transient Map<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy> impendingChangeListenerMap = CollectionFactory.createSyncMap();
    private transient List<OWLOntologyChangesVetoedListener> vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
    @Nonnull
    private Supplier<OWLOntologyLoaderConfiguration> configProvider = new OWLAPIConfigProvider();
    @Nonnull
    private Optional<OWLOntologyLoaderConfiguration> config = Optional.absent();
    @Nonnull
    protected final PriorityCollection<OWLOntologyIRIMapper> documentMappers;
    @Nonnull
    protected final PriorityCollection<OWLOntologyFactory> ontologyFactories;
    @Nonnull
    protected final PriorityCollection<OWLParserFactory> parserFactories;
    @Nonnull
    protected final PriorityCollection<OWLStorerFactory> ontologyStorers;
    private final Lock readLock;
    private final Lock writeLock;
    private final ReadWriteLock lock;

    @Inject
    public OWLOntologyManagerImpl(@Nonnull OWLDataFactory dataFactory, ReadWriteLock readWriteLock) {
        this(dataFactory, readWriteLock, PriorityCollectionSorting.ON_SET_INJECTION_ONLY);
    }

    public OWLOntologyManagerImpl(@Nonnull OWLDataFactory dataFactory, ReadWriteLock readWriteLock, PriorityCollectionSorting sorting) {
        this.dataFactory = (OWLDataFactory)OWLAPIPreconditions.checkNotNull((Object)dataFactory, (String)"dataFactory cannot be null");
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.lock = readWriteLock;
        this.documentMappers = new ConcurrentPriorityCollection<OWLOntologyIRIMapper>(readWriteLock, sorting);
        this.ontologyFactories = new ConcurrentPriorityCollection<OWLOntologyFactory>(readWriteLock, sorting);
        this.parserFactories = new ConcurrentPriorityCollection<OWLParserFactory>(readWriteLock, sorting);
        this.ontologyStorers = new ConcurrentPriorityCollection<OWLStorerFactory>(readWriteLock, sorting);
        this.installDefaultURIMappers();
        this.installDefaultOntologyFactories();
    }

    private static boolean matchingIDs(OWLOntologyID first, OWLOntologyID second) {
        if (first.isAnonymous() || second.isAnonymous()) {
            return first.equals((Object)second);
        }
        return first.getOntologyIRI().equals((Object)second.getOntologyIRI());
    }

    @Nonnull
    protected static IRI getNextAutoGeneratedIRI() {
        return OWLOntologyDocumentSourceBase.getNextDocumentIRI((String)"urn:unnamed:ontology#ont");
    }

    public void setOntologyLoaderConfigurationProvider(Supplier<OWLOntologyLoaderConfiguration> provider) {
        this.writeLock.lock();
        try {
            this.configProvider = provider;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration getOntologyLoaderConfiguration() {
        this.readLock.lock();
        try {
            if (this.config.isPresent()) {
                OWLOntologyLoaderConfiguration oWLOntologyLoaderConfiguration = (OWLOntologyLoaderConfiguration)this.config.get();
                return oWLOntologyLoaderConfiguration;
            }
            this.config = Optional.of((Object)this.configProvider.get());
            OWLOntologyLoaderConfiguration oWLOntologyLoaderConfiguration = (OWLOntologyLoaderConfiguration)this.config.get();
            return oWLOntologyLoaderConfiguration;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOntologyLoaderConfiguration(OWLOntologyLoaderConfiguration newConfig) {
        this.writeLock.lock();
        try {
            this.config = Optional.fromNullable((Object)newConfig);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    public Set<OWLOntology> getOntologies() {
        this.readLock.lock();
        try {
            HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>(this.ontologiesByID.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getOntologies(OWLAxiom axiom) {
        this.readLock.lock();
        try {
            HashSet<OWLOntology> result = new HashSet<OWLOntology>(this.ontologiesByID.size());
            for (OWLOntology ont : this.getOntologies()) {
                if (!ont.containsAxiom(axiom)) continue;
                result.add(ont);
            }
            HashSet<OWLOntology> hashSet = result;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(OWLOntology ontology) {
        this.readLock.lock();
        try {
            boolean bl = this.ontologiesByID.containsValue(ontology);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IRI ontologyIRI) {
        OWLAPIPreconditions.checkNotNull((Object)ontologyIRI, (String)"Ontology IRI cannot be null");
        this.readLock.lock();
        try {
            Set<OWLOntologyID> owlOntologyIDs = this.ontologiesByID.keySet();
            for (OWLOntologyID nextOntologyID : owlOntologyIDs) {
                if (!ontologyIRI.equals(nextOntologyID.getOntologyIRI().orNull())) continue;
                boolean bl = true;
                return bl;
            }
            for (OWLOntologyID ont : owlOntologyIDs) {
                if (!ontologyIRI.equals(ont.getVersionIRI().orNull())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(OWLOntologyID id) {
        this.readLock.lock();
        try {
            if (this.ontologiesByID.containsKey(id)) {
                boolean bl = true;
                return bl;
            }
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (id.isAnonymous() || !id.getOntologyIRI().equals((Object)nextOntologyID.getOntologyIRI())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsVersion(IRI ontologyVersionIRI) {
        this.readLock.lock();
        try {
            for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
                if (!ontologyVersionIRI.equals(ont.getVersionIRI().orNull())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntologyID> getOntologyIDsByVersion(IRI ontologyVersionIRI) {
        this.readLock.lock();
        try {
            TreeSet<OWLOntologyID> result = new TreeSet<OWLOntologyID>();
            for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
                if (!ontologyVersionIRI.equals(ont.getVersionIRI().orNull())) continue;
                result.add(ont);
            }
            TreeSet<OWLOntologyID> treeSet = result;
            return treeSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology getOntology(IRI ontologyIRI) {
        this.readLock.lock();
        try {
            OWLOntologyID ontologyID = new OWLOntologyID(this.of(ontologyIRI), this.of(null));
            OWLOntology result = this.ontologiesByID.get(ontologyID);
            if (result == null) {
                for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                    if (!ontologyIRI.equals(nextOntologyID.getVersionIRI().orNull()) && !ontologyIRI.equals(nextOntologyID.getOntologyIRI().orNull()) && !ontologyIRI.equals(nextOntologyID.getDefaultDocumentIRI().orNull())) continue;
                    result = this.ontologiesByID.get(nextOntologyID);
                }
            }
            OWLOntology oWLOntology = result;
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology getOntology(OWLOntologyID ontologyID) {
        this.readLock.lock();
        try {
            OWLOntology result = this.ontologiesByID.get(ontologyID);
            if (result == null && !ontologyID.isAnonymous()) {
                for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                    if (!OWLOntologyManagerImpl.matchingIDs(ontologyID, nextOntologyID)) continue;
                    result = this.ontologiesByID.get(nextOntologyID);
                }
            }
            if (result == null) {
                IRI documentIRI = this.getDocumentIRIFromMappers(ontologyID);
                if (documentIRI == null) {
                    documentIRI = !ontologyID.isAnonymous() ? (IRI)ontologyID.getDefaultDocumentIRI().orNull() : IRI.generateDocumentIRI();
                    Collection<IRI> existingDocumentIRIs = this.documentIRIsByID.values();
                    while (existingDocumentIRIs.contains(documentIRI)) {
                        documentIRI = IRI.generateDocumentIRI();
                    }
                }
                if (this.documentIRIsByID.values().contains(documentIRI)) {
                    throw new OWLRuntimeException((Throwable)new OWLOntologyDocumentAlreadyExistsException(documentIRI));
                }
            }
            OWLOntology oWLOntology = result;
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getVersions(IRI ontologyIRI) {
        this.readLock.lock();
        try {
            HashSet<OWLOntology> result = new HashSet<OWLOntology>();
            for (OWLOntology ont : this.getOntologies()) {
                OWLOntologyID ontId = ont.getOntologyID();
                Optional ontIRI = ontId.getOntologyIRI();
                if (!ontIRI.isPresent() || !((IRI)ontIRI.get()).equals((Object)ontologyIRI)) continue;
                result.add(ont);
            }
            HashSet<OWLOntology> hashSet = result;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OWLOntology getImportedOntology(OWLImportsDeclaration declaration) {
        this.readLock.lock();
        try {
            OWLOntologyID ontologyID = this.ontologyIDsByImportsDeclaration.get(declaration);
            if (ontologyID == null) {
                OWLOntology ontology = this.getOntology(declaration.getIRI());
                if (ontology == null) {
                    ontology = this.getOntologyByDocumentIRI(declaration.getIRI());
                }
                OWLOntology oWLOntology = ontology;
                return oWLOntology;
            }
            OWLOntology oWLOntology = this.getOntology(ontologyID);
            return oWLOntology;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getDirectImports(OWLOntology ontology) {
        this.readLock.lock();
        try {
            if (!this.contains(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            HashSet<OWLOntology> imports = new HashSet<OWLOntology>();
            for (OWLImportsDeclaration axiom : ontology.getImportsDeclarations()) {
                assert (axiom != null);
                OWLOntology importedOntology = this.getImportedOntology(axiom);
                if (importedOntology == null) continue;
                imports.add(importedOntology);
            }
            HashSet<OWLOntology> hashSet = imports;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getImports(OWLOntology ontology) {
        this.readLock.lock();
        try {
            if (!this.contains(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            TreeSet<OWLOntology> result = new TreeSet<OWLOntology>();
            this.getImports(ontology, result);
            TreeSet<OWLOntology> treeSet = result;
            return treeSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImports(@Nonnull OWLOntology ont, @Nonnull Set<OWLOntology> result) {
        this.readLock.lock();
        try {
            for (OWLOntology directImport : this.getDirectImports(ont)) {
                assert (directImport != null);
                if (!result.add(directImport)) continue;
                this.getImports(directImport, result);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLOntology> getImportsClosure(OWLOntology ontology) {
        this.readLock.lock();
        try {
            Set<OWLOntology> ontologies = this.importsClosureCache.get(ontology.getOntologyID());
            if (ontologies == null) {
                ontologies = new TreeSet<OWLOntology>();
                this.getImportsClosure(ontology, ontologies);
                this.importsClosureCache.put(ontology.getOntologyID(), ontologies);
            }
            Set set = CollectionFactory.getCopyOnRequestSetFromMutableCollection(ontologies);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImportsClosure(@Nonnull OWLOntology ontology, @Nonnull Set<OWLOntology> ontologies) {
        this.readLock.lock();
        try {
            ontologies.add(ontology);
            for (OWLOntology ont : this.getDirectImports(ontology)) {
                assert (ont != null);
                if (ontologies.contains(ont)) continue;
                this.getImportsClosure(ont, ontologies);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<OWLOntology> getSortedImportsClosure(OWLOntology ontology) {
        this.readLock.lock();
        try {
            ArrayList<OWLOntology> arrayList = new ArrayList<OWLOntology>(ontology.getImportsClosure());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isChangeApplicable(OWLOntologyChange change) {
        OWLOntologyLoaderConfiguration ontologyConfig = this.ontologyConfigurationsByOntologyID.get(change.getOntology().getOntologyID());
        return ontologyConfig == null || ontologyConfig.isLoadAnnotationAxioms() || !change.isAddAxiom() || !(change.getAxiom() instanceof OWLAnnotationAxiom);
    }

    private ChangeApplied enactChangeApplication(OWLOntologyChange change) {
        if (!this.isChangeApplicable(change)) {
            return ChangeApplied.UNSUCCESSFULLY;
        }
        OWLOntology ont = change.getOntology();
        if (!(ont instanceof OWLMutableOntology)) {
            throw new ImmutableOWLOntologyChangeException(change.getChangeData(), ont.toString());
        }
        this.checkForOntologyIDChange(change);
        ChangeApplied appliedChange = ((OWLMutableOntology)ont).applyChange(change);
        this.checkForImportsChange(change);
        return appliedChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeApplied applyChanges(List<? extends OWLOntologyChange> changes) {
        this.writeLock.lock();
        try {
            Iterator<Object> iterator;
            ChangeApplied enactChangeApplication;
            try {
                this.broadcastImpendingChanges(changes);
            }
            catch (OWLOntologyChangeVetoException e) {
                this.broadcastOntologyChangesVetoed(changes, e);
                ChangeApplied changeApplied = ChangeApplied.UNSUCCESSFULLY;
                this.writeLock.unlock();
                return changeApplied;
            }
            boolean rollbackRequested = false;
            boolean allNoOps = true;
            ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
            this.fireBeginChanges(changes.size());
            for (OWLOntologyChange oWLOntologyChange : changes) {
                if (rollbackRequested) continue;
                assert (oWLOntologyChange != null);
                enactChangeApplication = this.enactChangeApplication(oWLOntologyChange);
                if (enactChangeApplication == ChangeApplied.UNSUCCESSFULLY) {
                    rollbackRequested = true;
                }
                if (enactChangeApplication == ChangeApplied.SUCCESSFULLY) {
                    allNoOps = false;
                    appliedChanges.add(oWLOntologyChange);
                }
                this.fireChangeApplied(oWLOntologyChange);
            }
            if (rollbackRequested) {
                for (OWLOntologyChange oWLOntologyChange : appliedChanges) {
                    enactChangeApplication = this.enactChangeApplication(oWLOntologyChange.reverseChange());
                    if (enactChangeApplication != ChangeApplied.UNSUCCESSFULLY) continue;
                    throw new OWLRuntimeException("Rollback of changes unsuccessful: Change " + oWLOntologyChange + " could not be rolled back");
                }
                appliedChanges.clear();
            }
            this.fireEndChanges();
            this.broadcastChanges(appliedChanges);
            if (rollbackRequested) {
                iterator = ChangeApplied.UNSUCCESSFULLY;
                return iterator;
            }
            if (allNoOps) {
                iterator = ChangeApplied.NO_OPERATION;
                return iterator;
            }
            iterator = ChangeApplied.SUCCESSFULLY;
            return iterator;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> changes) {
        this.writeLock.lock();
        try {
            Iterator<Object> iterator;
            ChangeApplied enactChangeApplication;
            this.broadcastImpendingChanges(changes);
            boolean rollbackRequested = false;
            boolean allNoOps = true;
            ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
            this.fireBeginChanges(changes.size());
            for (OWLOntologyChange oWLOntologyChange : changes) {
                if (rollbackRequested) continue;
                assert (oWLOntologyChange != null);
                enactChangeApplication = this.enactChangeApplication(oWLOntologyChange);
                if (enactChangeApplication == ChangeApplied.UNSUCCESSFULLY) {
                    rollbackRequested = true;
                }
                if (enactChangeApplication == ChangeApplied.SUCCESSFULLY) {
                    allNoOps = false;
                    appliedChanges.add(oWLOntologyChange);
                }
                this.fireChangeApplied(oWLOntologyChange);
            }
            if (rollbackRequested) {
                for (OWLOntologyChange oWLOntologyChange : appliedChanges) {
                    enactChangeApplication = this.enactChangeApplication(oWLOntologyChange.reverseChange());
                    if (enactChangeApplication != ChangeApplied.UNSUCCESSFULLY) continue;
                    throw new OWLRuntimeException("Rollback of changes unsuccessful: Change " + oWLOntologyChange + " could not be rolled back");
                }
                appliedChanges.clear();
            }
            this.fireEndChanges();
            this.broadcastChanges(appliedChanges);
            if (rollbackRequested) {
                iterator = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, appliedChanges);
                return iterator;
            }
            if (allNoOps) {
                iterator = new ChangeDetails(ChangeApplied.NO_OPERATION, appliedChanges);
                return iterator;
            }
            iterator = new ChangeDetails(ChangeApplied.SUCCESSFULLY, appliedChanges);
            return iterator;
        }
        catch (OWLOntologyChangeVetoException e) {
            this.broadcastOntologyChangesVetoed(changes, e);
            ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, Collections.emptyList());
            return changeDetails;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeApplied addAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.addAxioms(ont, CollectionFactory.createSet((Object)axiom));
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeApplied addAxioms(@Nonnull OWLOntology ont, @Nonnull Set<? extends OWLAxiom> axioms) {
        this.writeLock.lock();
        try {
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>(axioms.size() + 2);
            for (OWLAxiom oWLAxiom : axioms) {
                assert (oWLAxiom != null);
                changes.add(new AddAxiom(ont, oWLAxiom));
            }
            ChangeApplied changeApplied = this.applyChanges(changes);
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeApplied removeAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.removeAxioms(ont, CollectionFactory.createSet((Object)axiom));
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ChangeApplied removeAxioms(@Nonnull OWLOntology ont, @Nonnull Set<? extends OWLAxiom> axioms) {
        ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>(axioms.size() + 2);
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            changes.add(new RemoveAxiom(ont, oWLAxiom));
        }
        return this.applyChanges(changes);
    }

    public ChangeApplied applyChange(@Nonnull OWLOntologyChange change) {
        this.writeLock.lock();
        try {
            ChangeApplied changeApplied = this.applyChanges(CollectionFactory.list((Object)change));
            return changeApplied;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void checkForImportsChange(OWLOntologyChange change) {
        if (change.isImportChange()) {
            this.resetImportsClosureCache();
            if (change instanceof AddImport) {
                OWLImportsDeclaration addImportDeclaration = ((AddImport)change).getImportDeclaration();
                boolean found = false;
                IRI iri = addImportDeclaration.getIRI();
                for (OWLOntologyID oWLOntologyID : this.ontologiesByID.keySet()) {
                    if (!iri.equals(oWLOntologyID.getDefaultDocumentIRI().orNull()) && !iri.equals(oWLOntologyID.getOntologyIRI().orNull()) && !iri.equals(oWLOntologyID.getVersionIRI().orNull())) continue;
                    found = true;
                    this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, oWLOntologyID);
                }
                if (!found) {
                    for (Map.Entry entry : this.documentIRIsByID.entrySet()) {
                        if (!((IRI)entry.getValue()).equals((Object)iri)) continue;
                        this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, (OWLOntologyID)entry.getKey());
                    }
                }
            } else {
                OWLImportsDeclaration importDeclaration = ((RemoveImport)change).getImportDeclaration();
                this.ontologyIDsByImportsDeclaration.remove(importDeclaration);
                this.importedIRIs.remove(importDeclaration.getIRI());
            }
        }
    }

    private void checkForOntologyIDChange(OWLOntologyChange change) {
        if (change instanceof SetOntologyID) {
            SetOntologyID setID = (SetOntologyID)change;
            OWLOntology existingOntology = this.ontologiesByID.get(((SetOntologyID)change).getNewOntologyID());
            if (existingOntology != null && !change.getOntology().equals(existingOntology) && !change.getOntology().getAxioms().equals(existingOntology.getAxioms())) {
                LOGGER.error("OWLOntologyManagerImpl.checkForOntologyIDChange() existing:{}", (Object)existingOntology);
                LOGGER.error("OWLOntologyManagerImpl.checkForOntologyIDChange() new:{}", (Object)change.getOntology());
                throw new OWLOntologyRenameException(change.getChangeData(), ((SetOntologyID)change).getNewOntologyID());
            }
            this.renameOntology(setID.getOriginalOntologyID(), setID.getNewOntologyID());
            this.resetImportsClosureCache();
        }
    }

    public void ontologyCreated(OWLOntology ontology) {
        this.addOntology(ontology);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOntologyFormat(OWLOntology ontology, OWLDocumentFormat ontologyFormat) {
        this.writeLock.lock();
        try {
            OWLOntologyID ontologyID = ontology.getOntologyID();
            this.ontologyFormatsByOntology.put(ontologyID, ontologyFormat);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLDocumentFormat getOntologyFormat(@Nonnull OWLOntology ontology) {
        this.readLock.lock();
        try {
            OWLOntologyID ontologyID = ontology.getOntologyID();
            OWLDocumentFormat oWLDocumentFormat = this.ontologyFormatsByOntology.get(ontologyID);
            return oWLDocumentFormat;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public OWLOntology createOntology() throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID());
    }

    public OWLOntology createOntology(@Nonnull IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID(this.of(ontologyIRI), this.absent()));
    }

    public OWLOntology createOntology(@Nonnull OWLOntologyID ontologyID) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLOntology ontology = this.ontologiesByID.get(ontologyID);
            if (ontology != null) {
                throw new OWLOntologyAlreadyExistsException(ontologyID);
            }
            IRI documentIRI = this.getDocumentIRIFromMappers(ontologyID);
            if (documentIRI == null) {
                documentIRI = !ontologyID.isAnonymous() ? (IRI)ontologyID.getDefaultDocumentIRI().orNull() : IRI.generateDocumentIRI();
                Collection<IRI> existingDocumentIRIs = this.documentIRIsByID.values();
                while (existingDocumentIRIs.contains(documentIRI)) {
                    documentIRI = IRI.generateDocumentIRI();
                }
            }
            assert (documentIRI != null);
            if (this.documentIRIsByID.values().contains(documentIRI)) {
                throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
            }
            for (OWLOntologyFactory factory : this.ontologyFactories) {
                if (!factory.canCreateFromDocumentIRI(documentIRI)) continue;
                this.documentIRIsByID.put(ontologyID, documentIRI);
                factory.setLock(this.lock);
                OWLOntology oWLOntology = factory.createOWLOntology((OWLOntologyManager)this, ontologyID, documentIRI, (OWLOntologyFactory.OWLOntologyCreationHandler)this);
                return oWLOntology;
            }
            throw new OWLOntologyFactoryNotFoundException(documentIRI);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLOntology createOntology(IRI ontologyIRI, Set<OWLOntology> ontologies) throws OWLOntologyCreationException {
        return this.createOntology(ontologyIRI, ontologies, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology createOntology(IRI ontologyIRI, Set<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            if (this.contains(ontologyIRI)) {
                throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(this.of(ontologyIRI), this.absent()));
            }
            OWLOntology ont = this.createOntology(ontologyIRI);
            HashSet axioms = new HashSet();
            for (OWLOntology ontology : ontologies) {
                if (copyLogicalAxiomsOnly) {
                    axioms.addAll(ontology.getLogicalAxioms());
                    continue;
                }
                axioms.addAll(ontology.getAxioms());
            }
            this.addAxioms(ont, axioms);
            OWLOntology oWLOntology = ont;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology createOntology(Set<OWLAxiom> axioms, IRI ontologyIRI) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            if (this.contains(ontologyIRI)) {
                throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(this.of(ontologyIRI), this.absent()));
            }
            OWLOntology ont = this.createOntology(ontologyIRI);
            this.addAxioms(ont, axioms);
            OWLOntology oWLOntology = ont;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLOntology createOntology(Set<OWLAxiom> axioms) throws OWLOntologyCreationException {
        return this.createOntology(axioms, OWLOntologyManagerImpl.getNextAutoGeneratedIRI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology copyOntology(OWLOntology toCopy, OntologyCopy settings) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLAPIPreconditions.checkNotNull((Object)toCopy);
            OWLAPIPreconditions.checkNotNull((Object)settings);
            OWLOntology toReturn = null;
            if (settings == OntologyCopy.MOVE) {
                toReturn = toCopy;
                this.ontologiesByID.put(toReturn.getOntologyID(), toReturn);
            } else if (settings == OntologyCopy.SHALLOW || settings == OntologyCopy.DEEP) {
                toReturn = this.createOntology(toCopy.getOntologyID());
                for (AxiomType type : AxiomType.AXIOM_TYPES) {
                    assert (type != null);
                    this.addAxioms(toReturn, toCopy.getAxioms(type));
                }
                for (OWLAnnotation a : toCopy.getAnnotations()) {
                    assert (a != null);
                    this.applyChange((OWLOntologyChange)new AddOntologyAnnotation(toReturn, a));
                }
                for (OWLAnnotation a : toCopy.getImportsDeclarations()) {
                    assert (a != null);
                    this.applyChange((OWLOntologyChange)new AddImport(toReturn, (OWLImportsDeclaration)a));
                }
            }
            assert (toReturn != null);
            OWLOntologyManager m = toCopy.getOWLOntologyManager();
            if (settings == OntologyCopy.MOVE || settings == OntologyCopy.DEEP) {
                this.setOntologyDocumentIRI(toReturn, m.getOntologyDocumentIRI(toCopy));
                OWLDocumentFormat f = m.getOntologyFormat(toCopy);
                if (f != null) {
                    this.setOntologyFormat(toReturn, f);
                }
            }
            if (settings == OntologyCopy.MOVE) {
                m.removeOntology(toCopy);
                toReturn.setOWLOntologyManager((OWLOntologyManager)this);
                if (toReturn instanceof OWLMutableOntology) {
                    ((OWLMutableOntology)toReturn).setLock(this.lock);
                }
            }
            OWLOntology oWLOntology = toReturn;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OWLOntology loadOntology(IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.loadOntology(ontologyIRI, false, this.getOntologyLoaderConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected OWLOntology loadOntology(@Nonnull IRI ontologyIRI, boolean allowExists, @Nonnull OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLOntology ontByID = null;
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (!ontologyIRI.equals(nextOntologyID.getOntologyIRI().orNull())) continue;
                ontByID = this.ontologiesByID.get(nextOntologyID);
            }
            if (ontByID == null) {
                for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                    if (!ontologyIRI.equals(nextOntologyID.getVersionIRI().orNull())) continue;
                    ontByID = this.ontologiesByID.get(nextOntologyID);
                }
            }
            if (ontByID != null) {
                Iterator<OWLOntologyID> iterator = ontByID;
                return iterator;
            }
            OWLOntologyID id = new OWLOntologyID(this.of(ontologyIRI), this.absent());
            IRI documentIRI = this.getDocumentIRIFromMappers(id);
            if (documentIRI != null) {
                if (this.documentIRIsByID.values().contains(documentIRI) && !allowExists) {
                    throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
                }
                OWLOntology ontByDocumentIRI = this.loadOntologyByDocumentIRI(documentIRI);
                if (ontByDocumentIRI != null) {
                    OWLOntology oWLOntology = ontByDocumentIRI;
                    return oWLOntology;
                }
            } else {
                throw new OntologyIRIMappingNotFoundException(ontologyIRI);
            }
            OWLOntology oWLOntology = this.loadOntology(ontologyIRI, (OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI, null, null), configuration);
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OWLOntology loadOntologyByDocumentIRI(IRI documentIRI) {
        this.readLock.lock();
        try {
            for (OWLOntologyID ontID : this.documentIRIsByID.keySet()) {
                assert (ontID != null);
                IRI docIRI = this.documentIRIsByID.get(ontID);
                if (docIRI == null || !docIRI.equals((Object)documentIRI)) continue;
                OWLOntology oWLOntology = this.getOntology(ontID);
                return oWLOntology;
            }
            Iterator<OWLOntologyID> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OWLOntology getOntologyByDocumentIRI(IRI documentIRI) {
        this.readLock.lock();
        try {
            for (OWLOntologyID ontID : this.documentIRIsByID.keySet()) {
                assert (ontID != null);
                IRI docIRI = this.documentIRIsByID.get(ontID);
                if (!documentIRI.equals((Object)docIRI)) continue;
                OWLOntology oWLOntology = this.ontologiesByID.get(ontID);
                return oWLOntology;
            }
            Iterator<OWLOntologyID> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public OWLOntology loadOntologyFromOntologyDocument(IRI documentIRI) throws OWLOntologyCreationException {
        return this.loadOntology(null, (OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI, null, null), this.getOntologyLoaderConfiguration());
    }

    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, this.getOntologyLoaderConfiguration());
    }

    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, conf);
    }

    public OWLOntology loadOntologyFromOntologyDocument(File file) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new FileDocumentSource(file));
    }

    public OWLOntology loadOntologyFromOntologyDocument(InputStream inputStream) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new StreamDocumentSource(inputStream));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected OWLOntology loadOntology(@Nullable IRI ontologyIRI, @Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            OWLOntologyID idOfLoadedOntology;
            Throwable ex;
            block15: {
                OWLOntology oWLOntology;
                if (this.loadCount.get() != this.importsLoadCount.get()) {
                    LOGGER.warn("Runtime Warning: Parsers should load imported ontologies using the makeImportLoadRequest method.");
                }
                this.fireStartedLoadingEvent(new OWLOntologyID(this.of(ontologyIRI), this.absent()), documentSource.getDocumentIRI(), this.loadCount.get() > 0);
                this.loadCount.incrementAndGet();
                this.broadcastChanges.set(false);
                ex = null;
                idOfLoadedOntology = new OWLOntologyID();
                try {
                    OWLOntology ontology = this.actualParse(documentSource, configuration);
                    if (ontology == null) break block15;
                    idOfLoadedOntology = ontology.getOntologyID();
                    oWLOntology = ontology;
                    this.loadCount.decrementAndGet();
                }
                catch (OWLOntologyRenameException e) {
                    try {
                        ex = e;
                        throw new OWLOntologyAlreadyExistsException(e.getOntologyID(), (Throwable)e);
                        catch (UnloadableImportException e2) {
                            ex = e2;
                            throw e2;
                        }
                        catch (OWLRuntimeException e3) {
                            if (!(e3.getCause() instanceof OWLOntologyCreationException)) throw e3;
                            ex = (OWLOntologyCreationException)e3.getCause();
                            throw (OWLOntologyCreationException)e3.getCause();
                        }
                        catch (OWLOntologyCreationException e4) {
                            ex = e4;
                            throw e4;
                        }
                    }
                    catch (Throwable throwable) {
                        this.loadCount.decrementAndGet();
                        if (this.loadCount.get() == 0) {
                            this.broadcastChanges.set(true);
                        }
                        this.fireFinishedLoadingEvent(idOfLoadedOntology, documentSource.getDocumentIRI(), this.loadCount.get() > 0, (Exception)ex);
                        throw throwable;
                    }
                }
                if (this.loadCount.get() == 0) {
                    this.broadcastChanges.set(true);
                }
                this.fireFinishedLoadingEvent(idOfLoadedOntology, documentSource.getDocumentIRI(), this.loadCount.get() > 0, (Exception)ex);
                return oWLOntology;
            }
            this.loadCount.decrementAndGet();
            if (this.loadCount.get() == 0) {
                this.broadcastChanges.set(true);
            }
            this.fireFinishedLoadingEvent(idOfLoadedOntology, documentSource.getDocumentIRI(), this.loadCount.get() > 0, (Exception)ex);
            throw new OWLOntologyFactoryNotFoundException(documentSource.getDocumentIRI());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected OWLOntology actualParse(OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        for (OWLOntologyFactory factory : this.ontologyFactories) {
            if (!factory.canLoad(documentSource)) continue;
            factory.setLock(this.lock);
            OWLOntology ontology = factory.loadOWLOntology((OWLOntologyManager)this, documentSource, (OWLOntologyFactory.OWLOntologyCreationHandler)this, configuration);
            if (configuration.shouldRepairIllegalPunnings()) {
                this.fixIllegalPunnings(ontology);
            }
            this.documentIRIsByID.put(ontology.getOntologyID(), documentSource.getDocumentIRI());
            this.ontologyConfigurationsByOntologyID.put(ontology.getOntologyID(), configuration);
            if (ontology instanceof HasTrimToSize && configuration.shouldTrimToSize()) {
                ((HasTrimToSize)ontology).trimToSize();
            }
            return ontology;
        }
        return null;
    }

    protected void fixIllegalPunnings(OWLOntology o) {
        Collection illegals = OWLDocumentFormatImpl.determineIllegalPunnings((boolean)true, (Collection)o.getSignature(Imports.INCLUDED), (Collection)o.getPunnedIRIs(Imports.INCLUDED));
        HashMultimap illegalDeclarations = HashMultimap.create();
        Set declarations = o.getAxioms(AxiomType.DECLARATION, Imports.INCLUDED);
        for (OWLDeclarationAxiom d : declarations) {
            if (!illegals.contains(d.getEntity().getIRI())) continue;
            illegalDeclarations.put((Object)d.getEntity().getIRI(), (Object)d);
        }
        HashMap<OWLAnnotationProperty, OWLEntity> replacementMap = new HashMap<OWLAnnotationProperty, OWLEntity>();
        for (Map.Entry e : illegalDeclarations.asMap().entrySet()) {
            if (((Collection)e.getValue()).size() == 1) {
                OWLDeclarationAxiom correctDeclaration = (OWLDeclarationAxiom)((Collection)e.getValue()).iterator().next();
                OWLEntity entity = correctDeclaration.getEntity();
                if (!entity.isOWLDataProperty() && !entity.isOWLObjectProperty()) continue;
                OWLAnnotationProperty wrongProperty = this.dataFactory.getOWLAnnotationProperty(entity.getIRI());
                replacementMap.put(wrongProperty, entity);
                continue;
            }
            String errorMessage = "Illegal redeclarations of entities: reuse of entity {} in punning not allowed {}";
            LOGGER.warn(errorMessage, e.getKey(), e.getValue());
        }
        for (OWLOntology ont : o.getImportsClosure()) {
            for (OWLEntity e : replacementMap.keySet()) {
                if (!ont.containsEntityInSignature(e)) continue;
                ArrayList<Object> list = new ArrayList<Object>();
                for (OWLAxiom ax : ont.getAxioms()) {
                    if (!ax.getSignature().contains(e)) continue;
                    list.add(new RemoveAxiom(ont, ax));
                    OWLAnnotationPropertyTransformer changer = new OWLAnnotationPropertyTransformer(replacementMap, this.dataFactory);
                    list.add(new AddAxiom(ont, (OWLAxiom)changer.transformObject((OWLObject)ax)));
                }
                o.getOWLOntologyManager().applyChanges(list);
            }
        }
    }

    public void removeOntology(OWLOntology ontology) {
        this.writeLock.lock();
        try {
            this.removeOntology(ontology.getOntologyID());
            ontology.setOWLOntologyManager(null);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntology(OWLOntologyID ontologyID) {
        this.writeLock.lock();
        try {
            OWLOntology o = this.ontologiesByID.remove(ontologyID);
            this.ontologyFormatsByOntology.remove(ontologyID);
            this.documentIRIsByID.remove(ontologyID);
            this.removeValue(this.ontologyIDsByImportsDeclaration, ontologyID);
            this.removeValue(this.importedIRIs, ontologyID);
            if (o != null) {
                o.setOWLOntologyManager(null);
                this.resetImportsClosureCache();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected <Q, S> void removeValue(Map<Q, S> map, S id) {
        ArrayList<Q> keys = new ArrayList<Q>();
        for (Map.Entry<Q, S> e : map.entrySet()) {
            if (!e.getValue().equals(id)) continue;
            keys.add(e.getKey());
        }
        for (Map.Entry<Object, Object> k : keys) {
            map.remove(k);
        }
    }

    private void addOntology(OWLOntology ont) {
        this.writeLock.lock();
        try {
            this.ontologiesByID.put(ont.getOntologyID(), ont);
            this.resetImportsClosureCache();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public IRI getOntologyDocumentIRI(OWLOntology ontology) {
        this.readLock.lock();
        try {
            if (!this.contains(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            IRI iRI = (IRI)OWLAPIPreconditions.verifyNotNull((Object)this.documentIRIsByID.get(ontology.getOntologyID()));
            return iRI;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setOntologyDocumentIRI(OWLOntology ontology, IRI documentIRI) {
        this.writeLock.lock();
        try {
            if (!this.ontologiesByID.containsKey(ontology.getOntologyID())) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            this.documentIRIsByID.put(ontology.getOntologyID(), documentIRI);
            this.resetImportsClosureCache();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void renameOntology(OWLOntologyID oldID, OWLOntologyID newID) {
        IRI documentIRI;
        OWLOntology ont = this.ontologiesByID.get(oldID);
        if (ont == null) {
            return;
        }
        this.ontologiesByID.remove(oldID);
        this.ontologiesByID.put(newID, ont);
        if (this.ontologyFormatsByOntology.containsKey(oldID)) {
            this.ontologyFormatsByOntology.put(newID, this.ontologyFormatsByOntology.remove(oldID));
        }
        if ((documentIRI = this.documentIRIsByID.remove(oldID)) != null) {
            this.documentIRIsByID.put(newID, documentIRI);
        }
        this.resetImportsClosureCache();
    }

    protected void resetImportsClosureCache() {
        this.writeLock.lock();
        try {
            this.importsClosureCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void saveOntology(OWLOntology ontology) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            OWLDocumentFormat format = this.getOntologyFormat(ontology);
            this.saveOntology(ontology, format);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(@Nonnull OWLOntology ontology, OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.saveOntology(ontology, ontologyFormat, this.getOntologyDocumentIRI(ontology));
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOntology(OWLOntology ontology, IRI documentIRI) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            OWLDocumentFormat format = this.getOntologyFormat(ontology);
            this.saveOntology(ontology, format, documentIRI);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, IRI documentIRI) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            Iterator iterator = this.ontologyStorers.iterator();
            while (iterator.hasNext()) {
                OWLStorerFactory storerFactory = (OWLStorerFactory)iterator.next();
                OWLStorer storer = storerFactory.createStorer();
                if (storer.canStoreOntology(ontologyFormat)) {
                    storer.storeOntology(ontology, documentIRI, ontologyFormat);
                    return;
                }
            }
            throw new OWLStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveOntology(OWLOntology ontology, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, (OWLOntologyDocumentTarget)new StreamDocumentTarget(outputStream));
    }

    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, ontologyFormat, (OWLOntologyDocumentTarget)new StreamDocumentTarget(outputStream));
    }

    public void saveOntology(OWLOntology ontology, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            this.saveOntology(ontology, this.getOntologyFormat(ontology), documentTarget);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveOntology(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.readLock.lock();
        try {
            Iterator iterator = this.ontologyStorers.iterator();
            while (iterator.hasNext()) {
                OWLStorerFactory storerFactory = (OWLStorerFactory)iterator.next();
                OWLStorer storer = storerFactory.createStorer();
                if (storer.canStoreOntology(ontologyFormat)) {
                    storer.storeOntology(ontology, documentTarget, ontologyFormat);
                    return;
                }
            }
            throw new OWLStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public PriorityCollection<OWLStorerFactory> getOntologyStorers() {
        return this.ontologyStorers;
    }

    @Inject
    public void setOntologyStorers(Set<OWLStorerFactory> storers) {
        this.ontologyStorers.set(storers);
    }

    public PriorityCollection<OWLOntologyIRIMapper> getIRIMappers() {
        return this.documentMappers;
    }

    @Inject
    public void setIRIMappers(Set<OWLOntologyIRIMapper> mappers) {
        this.documentMappers.set(mappers);
    }

    public void addIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.add((Serializable)mapper);
    }

    public void removeIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.remove((Serializable)mapper);
    }

    public void clearIRIMappers() {
        this.documentMappers.clear();
    }

    public void addOntologyStorer(OWLStorerFactory storer) {
        this.ontologyStorers.add((Serializable)storer);
    }

    public void removeOntologyStorer(OWLStorerFactory storer) {
        this.ontologyStorers.remove((Serializable)storer);
    }

    public void clearOntologyStorers() {
        this.ontologyStorers.clear();
    }

    public PriorityCollection<OWLParserFactory> getOntologyParsers() {
        return this.parserFactories;
    }

    @Inject
    public void setOntologyParsers(Set<OWLParserFactory> parsers) {
        this.parserFactories.set(parsers);
    }

    public PriorityCollection<OWLOntologyFactory> getOntologyFactories() {
        return this.ontologyFactories;
    }

    @Inject
    public void setOntologyFactories(Set<OWLOntologyFactory> factories) {
        this.ontologyFactories.set(factories);
    }

    @Nullable
    private IRI getDocumentIRIFromMappers(OWLOntologyID ontologyID) {
        Optional defIRI = ontologyID.getDefaultDocumentIRI();
        if (!defIRI.isPresent()) {
            return null;
        }
        IRI iri = (IRI)defIRI.get();
        assert (iri != null);
        for (OWLOntologyIRIMapper mapper : this.documentMappers) {
            IRI documentIRI = mapper.getDocumentIRI(iri);
            if (documentIRI == null) continue;
            return documentIRI;
        }
        return iri;
    }

    protected final void installDefaultURIMappers() {
    }

    protected final void installDefaultOntologyFactories() {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerMap = new ConcurrentHashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
        this.impendingChangeListenerMap = new ConcurrentHashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
        this.vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
    }

    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.listenerMap.put(listener, this.defaultChangeBroadcastStrategy);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeListener listener : new ArrayList<OWLOntologyChangeListener>(this.listenerMap.keySet())) {
                assert (listener != null);
                OWLOntologyChangeBroadcastStrategy strategy = this.listenerMap.get(listener);
                if (strategy == null) continue;
                try {
                    strategy.broadcastChanges(listener, changes);
                }
                catch (Exception e) {
                    LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                    this.listenerMap.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastImpendingChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (ImpendingOWLOntologyChangeListener listener : new ArrayList<ImpendingOWLOntologyChangeListener>(this.impendingChangeListenerMap.keySet())) {
                assert (listener != null);
                ImpendingOWLOntologyChangeBroadcastStrategy strategy = this.impendingChangeListenerMap.get(listener);
                if (strategy == null) continue;
                strategy.broadcastChanges(listener, changes);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setDefaultChangeBroadcastStrategy(OWLOntologyChangeBroadcastStrategy strategy) {
        this.writeLock.lock();
        try {
            this.defaultChangeBroadcastStrategy = strategy;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyChangeListener(OWLOntologyChangeListener listener, OWLOntologyChangeBroadcastStrategy strategy) {
        this.writeLock.lock();
        try {
            this.listenerMap.put(listener, strategy);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.impendingChangeListenerMap.put(listener, this.defaultImpendingChangeBroadcastStrategy);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.impendingChangeListenerMap.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.writeLock.lock();
        try {
            this.listenerMap.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.writeLock.lock();
        try {
            this.vetoListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.writeLock.lock();
        try {
            this.vetoListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastOntologyChangesVetoed(@Nonnull List<? extends OWLOntologyChange> changes, @Nonnull OWLOntologyChangeVetoException veto) {
        this.writeLock.lock();
        try {
            for (OWLOntologyChangesVetoedListener listener : new ArrayList<OWLOntologyChangesVetoedListener>(this.vetoListeners)) {
                listener.ontologyChangesVetoed(changes, veto);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OWLOntology loadImports(OWLImportsDeclaration declaration, @Nonnull OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        this.writeLock.lock();
        try {
            this.importsLoadCount.incrementAndGet();
            OWLOntology ont = null;
            try {
                ont = this.loadOntology(declaration.getIRI(), true, configuration);
            }
            catch (OWLOntologyCreationException e) {
                if (configuration.getMissingImportHandlingStrategy() == MissingImportHandlingStrategy.THROW_EXCEPTION) {
                    throw e;
                }
                MissingImportEvent evt = new MissingImportEvent(declaration.getIRI(), e);
                this.fireMissingImportEvent(evt);
            }
            finally {
                this.importsLoadCount.decrementAndGet();
            }
            OWLOntology oWLOntology = ont;
            return oWLOntology;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void makeLoadImportRequest(OWLImportsDeclaration declaration) {
        this.writeLock.lock();
        try {
            this.makeLoadImportRequest(declaration, this.getOntologyLoaderConfiguration());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeLoadImportRequest(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration configuration) {
        block6: {
            this.writeLock.lock();
            try {
                IRI iri = declaration.getIRI();
                if (configuration.isIgnoredImport(iri) || this.importedIRIs.containsKey(iri)) break block6;
                this.importedIRIs.put(iri, new Object());
                try {
                    OWLOntology ont = this.loadImports(declaration, configuration);
                    if (ont != null) {
                        this.ontologyIDsByImportsDeclaration.put(declaration, ont.getOntologyID());
                        this.importedIRIs.put(iri, ont.getOntologyID());
                    }
                }
                catch (OWLOntologyCreationException e) {
                    throw new UnloadableImportException(e, declaration);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public void addMissingImportListener(MissingImportListener listener) {
        this.writeLock.lock();
        try {
            this.missingImportsListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeMissingImportListener(@Nonnull MissingImportListener listener) {
        this.writeLock.lock();
        try {
            this.missingImportsListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMissingImportEvent(@Nonnull MissingImportEvent evt) {
        this.writeLock.lock();
        try {
            for (MissingImportListener listener : new ArrayList<MissingImportListener>(this.missingImportsListeners)) {
                listener.importMissing(evt);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.writeLock.lock();
        try {
            this.loaderListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.writeLock.lock();
        try {
            this.loaderListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStartedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported) {
        this.writeLock.lock();
        try {
            for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
                listener.startedLoadingOntology(new OWLOntologyLoaderListener.LoadingStartedEvent(ontologyID, documentIRI, imported));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFinishedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported, Exception ex) {
        this.writeLock.lock();
        try {
            for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
                listener.finishedLoadingOntology(new OWLOntologyLoaderListener.LoadingFinishedEvent(ontologyID, documentIRI, imported, ex));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.writeLock.lock();
        try {
            this.progressListeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.writeLock.lock();
        try {
            this.progressListeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginChanges(int size) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.begin(size);
                }
                catch (Exception e) {
                    LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndChanges() {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.end();
                }
                catch (Exception e) {
                    LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeApplied(@Nonnull OWLOntologyChange change) {
        this.writeLock.lock();
        try {
            if (!this.broadcastChanges.get()) {
                return;
            }
            if (this.progressListeners.isEmpty()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.appliedChange(change);
                }
                catch (Exception e) {
                    LOGGER.warn("BADLY BEHAVING LISTENER: {} has been removed", (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Nonnull
    protected <T> Optional<T> of(T t) {
        return Optional.fromNullable(t);
    }

    @Nonnull
    protected Optional<IRI> absent() {
        return Optional.absent();
    }
}

