/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiomShortCut;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SatisfiabilityReducer
implements OWLAxiomVisitorEx<Optional<OWLClassExpression>> {
    @Nonnull
    private final OWLDataFactory df;

    public SatisfiabilityReducer(OWLDataFactory dataFactory) {
        this.df = (OWLDataFactory)OWLAPIPreconditions.checkNotNull((Object)dataFactory, (String)"dataFactory cannot be null");
    }

    public Optional<OWLClassExpression> doDefault(Object o) {
        if (o instanceof OWLSubClassOfAxiomShortCut) {
            return (Optional)((OWLSubClassOfAxiomShortCut)o).asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }
        return OWLAPIPreconditions.emptyOptional();
    }

    public Optional<OWLClassExpression> visit(OWLSubClassOfAxiom axiom) {
        return Optional.of(this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{axiom.getSubClass(), this.df.getOWLObjectComplementOf(axiom.getSuperClass())}));
    }
}

