/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.WeakIndexCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.CompressionEnabled;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImplNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends OWLDataFactoryInternalsImplNoCache {
    private static Logger logger = LoggerFactory.getLogger(OWLDataFactoryInternalsImpl.class);
    private final AtomicInteger annotationsCount = new AtomicInteger(0);
    @Nonnull
    private final BuildableWeakIndexCache<OWLClass> classesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLObjectProperty> objectPropertiesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLDataProperty> dataPropertiesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLDatatype> datatypesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLNamedIndividual> individualsByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLAnnotationProperty> annotationPropertiesByURI = this.buildCache();
    private final transient LoadingCache<OWLAnnotation, OWLAnnotation> annotationsCache;

    @Inject
    public OWLDataFactoryInternalsImpl(@CompressionEnabled boolean useCompression) {
        super(useCompression);
        Caffeine annotationsCacheBuilder = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(2L, TimeUnit.MINUTES);
        if (logger.isDebugEnabled()) {
            annotationsCacheBuilder.recordStats();
        }
        this.annotationsCache = annotationsCacheBuilder.build(key -> key);
    }

    protected final <V extends OWLEntity> BuildableWeakIndexCache<V> buildCache() {
        return new BuildableWeakIndexCache();
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return this.classesByURI.cache(iri, Buildable.OWLCLASS);
    }

    @Override
    public void purge() {
        this.classesByURI.clear();
        this.objectPropertiesByURI.clear();
        this.dataPropertiesByURI.clear();
        this.datatypesByURI.clear();
        this.individualsByURI.clear();
        this.annotationPropertiesByURI.clear();
        this.annotationsCache.invalidateAll();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.objectPropertiesByURI.cache(iri, Buildable.OWLOBJECTPROPERTY);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.dataPropertiesByURI.cache(iri, Buildable.OWLDATAPROPERTY);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return this.individualsByURI.cache(iri, Buildable.OWLNAMEDINDIVIDUAL);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return this.datatypesByURI.cache(iri, Buildable.OWLDATATYPE);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return this.annotationPropertiesByURI.cache(iri, Buildable.OWLANNOTATIONPROPERTY);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        return super.getOWLLiteral(literal, OWLDataFactoryInternalsImpl.lang(lang));
    }

    private static String lang(@Nullable String l) {
        if (l == null || l.isEmpty()) {
            return "";
        }
        return l.trim().toLowerCase().intern();
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> annotations) {
        int n;
        OWLAnnotationImpl key = new OWLAnnotationImpl(property, value, annotations);
        OWLAnnotation annotation = (OWLAnnotation)this.annotationsCache.get((Object)key);
        if (logger.isDebugEnabled() && (n = this.annotationsCount.incrementAndGet()) % 1000 == 0) {
            logger.debug("{}: Annotations Cache stats: {}", (Object)n, (Object)this.annotationsCache.stats());
        }
        return annotation;
    }

    protected static enum Buildable {
        OWLCLASS{

            OWLClass build(IRI iri) {
                return new OWLClassImpl(iri);
            }
        }
        ,
        OWLOBJECTPROPERTY{

            OWLObjectProperty build(IRI iri) {
                return new OWLObjectPropertyImpl(iri);
            }
        }
        ,
        OWLDATAPROPERTY{

            OWLDataProperty build(IRI iri) {
                return new OWLDataPropertyImpl(iri);
            }
        }
        ,
        OWLNAMEDINDIVIDUAL{

            OWLNamedIndividual build(IRI iri) {
                return new OWLNamedIndividualImpl(iri);
            }
        }
        ,
        OWLDATATYPE{

            OWLDatatype build(IRI iri) {
                return new OWLDatatypeImpl(iri);
            }
        }
        ,
        OWLANNOTATIONPROPERTY{

            OWLAnnotationProperty build(IRI iri) {
                return new OWLAnnotationPropertyImpl(iri);
            }
        };


        abstract <K extends OWLEntity> K build(IRI var1);
    }

    protected class BuildableWeakIndexCache<V extends OWLEntity>
    extends WeakIndexCache<IRI, V> {
        protected BuildableWeakIndexCache() {
        }

        public V cache(IRI s, Buildable v) {
            OWLEntity toReturn;
            WeakReference w = (WeakReference)this.prefixCache.get(s);
            if (w != null && (toReturn = (OWLEntity)w.get()) != null) {
                return (V)toReturn;
            }
            Object value = v.build(s);
            this.prefixCache.put(s, new WeakReference(value));
            return (V)value;
        }
    }
}

