/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

public class OWLSubClassOfAxiomImpl
extends OWLClassAxiomImpl
implements OWLSubClassOfAxiom {
    @Nonnull
    private final OWLClassExpression subClass;
    @Nonnull
    private final OWLClassExpression superClass;

    public OWLSubClassOfAxiomImpl(OWLClassExpression subClass, OWLClassExpression superClass, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.subClass = (OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)subClass, (String)"subClass cannot be null");
        this.superClass = (OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)superClass, (String)"superClass cannot be null");
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, this.mergeAnnos(anns));
    }

    public OWLSubClassOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, NO_ANNOTATIONS);
    }

    public OWLClassExpression getSubClass() {
        return this.subClass;
    }

    public OWLClassExpression getSuperClass() {
        return this.superClass;
    }

    public boolean isGCI() {
        return this.subClass.isAnonymous();
    }
}

