/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class SWRLRuleImpl
extends OWLLogicalAxiomImpl
implements SWRLRule {
    private final LinkedHashSet<SWRLAtom> head;
    private final LinkedHashSet<SWRLAtom> body;
    private final boolean containsAnonymousClassExpressions;
    @Nonnull
    protected static final AtomSimplifier ATOM_SIMPLIFIER = new AtomSimplifier();

    public SWRLRuleImpl(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.head = new LinkedHashSet((Collection)OWLAPIPreconditions.checkNotNull(head, (String)"head cannot be null"));
        this.body = new LinkedHashSet((Collection)OWLAPIPreconditions.checkNotNull(body, (String)"body cannot be null"));
        this.containsAnonymousClassExpressions = this.hasAnon();
    }

    public SWRLRuleImpl(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head) {
        this(body, head, NO_ANNOTATIONS);
    }

    public SWRLRule getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new SWRLRuleImpl(this.body, this.head, NO_ANNOTATIONS);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new SWRLRuleImpl(this.body, this.head, this.mergeAnnos(anns));
    }

    public Stream<SWRLVariable> variables() {
        return ((Collection)this.accept((SWRLObjectVisitorEx)new SWRLVariableExtractor())).stream();
    }

    private boolean hasAnon() {
        return this.classAtomPredicates().anyMatch(IsAnonymous::isAnonymous);
    }

    public boolean containsAnonymousClassExpressions() {
        return this.containsAnonymousClassExpressions;
    }

    public Stream<OWLClassExpression> classAtomPredicates() {
        return Stream.concat(this.head.stream(), this.body.stream()).filter(c -> c instanceof SWRLClassAtom).map(c -> ((SWRLClassAtom)c).getPredicate());
    }

    public Stream<SWRLAtom> body() {
        return this.body.stream();
    }

    public Stream<SWRLAtom> head() {
        return this.head.stream();
    }

    public SWRLRule getSimplified() {
        return (SWRLRule)this.accept(ATOM_SIMPLIFIER);
    }

    protected static class AtomSimplifier
    implements SWRLObjectVisitorEx<SWRLObject> {
        protected AtomSimplifier() {
        }

        public SWRLObject doDefault(Object o) {
            return (SWRLObject)o;
        }

        public SWRLRule visit(SWRLRule node) {
            List nodebody = OWLAPIStreamUtils.asList(node.body().map(a -> (SWRLAtom)a.accept((SWRLObjectVisitorEx)this)));
            List nodehead = OWLAPIStreamUtils.asList(node.head().map(a -> (SWRLAtom)a.accept((SWRLObjectVisitorEx)this)));
            return new SWRLRuleImpl(nodebody, nodehead, OWLObjectImpl.NO_ANNOTATIONS);
        }

        public SWRLObjectPropertyAtom visit(SWRLObjectPropertyAtom node) {
            return node.getSimplified();
        }
    }
}

