/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;

public class OWLDisjointUnionAxiomImpl
extends OWLClassAxiomImpl
implements OWLDisjointUnionAxiom {
    private final OWLClass owlClass;
    private final List<OWLClassExpression> classExpressions;

    public OWLDisjointUnionAxiomImpl(OWLClass owlClass, List<OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.owlClass = (OWLClass)OWLAPIPreconditions.checkNotNull((Object)owlClass, (String)"owlClass cannot be null");
        this.classExpressions = Collections.unmodifiableList((List)OWLAPIPreconditions.checkValidForNAryExpressions(classExpressions, (String)"classExpressions cannot be null or empty"));
    }

    public Stream<OWLClassExpression> classExpressions() {
        return OWLAPIStreamUtils.streamFromSorted(this.classExpressions);
    }

    public Stream<OWLClassExpression> operands() {
        return this.classExpressions();
    }

    public List<OWLClassExpression> getOperandsAsList() {
        return this.classExpressions;
    }

    public OWLDisjointUnionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.classExpressions, NO_ANNOTATIONS);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.classExpressions, this.mergeAnnos(anns));
    }

    public OWLClass getOWLClass() {
        return this.owlClass;
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom() {
        return new OWLEquivalentClassesAxiomImpl(OWLAPIStreamUtils.sorted(OWLClassExpression.class, (Object[])new OWLClassExpression[]{this.owlClass, new OWLObjectUnionOfImpl(this.classExpressions)}), NO_ANNOTATIONS);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom() {
        return new OWLDisjointClassesAxiomImpl(this.classExpressions, NO_ANNOTATIONS);
    }
}

