/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.structural;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.Version;

public class StructuralReasoner
extends OWLReasonerBase {
    private static final Version VERSION = new Version(1, 0, 0, 0);
    protected final ReasonerProgressMonitor pm;
    private final ClassHierarchyInfo classHierarchyInfo = new ClassHierarchyInfo();
    private final ObjectPropertyHierarchyInfo objectPropertyHierarchyInfo = new ObjectPropertyHierarchyInfo();
    private final DataPropertyHierarchyInfo dataPropertyHierarchyInfo = new DataPropertyHierarchyInfo();
    private boolean interrupted = false;
    private boolean prepared = false;

    public StructuralReasoner(OWLOntology rootOntology, OWLReasonerConfiguration configuration, BufferingMode bufferingMode) {
        super(rootOntology, configuration, bufferingMode);
        OWLAPIPreconditions.checkNotNull((Object)configuration, (String)"configuration cannot be null");
        this.pm = configuration.getProgressMonitor();
        this.prepareReasoner();
    }

    private static <T extends OWLObject> void handleChanges(Set<OWLAxiom> added, Set<OWLAxiom> removed, AbstractHierarchyInfo<T> hierarchyInfo) {
        Set<T> sig = hierarchyInfo.getEntitiesInSignature(added);
        sig.addAll(hierarchyInfo.getEntitiesInSignature(removed));
        hierarchyInfo.processChanges(sig, added, removed);
    }

    private static void printIndent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
    }

    public String getReasonerName() {
        return "Structural Reasoner";
    }

    @Override
    public FreshEntityPolicy getFreshEntityPolicy() {
        return FreshEntityPolicy.ALLOW;
    }

    @Override
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return IndividualNodeSetPolicy.BY_NAME;
    }

    public Version getReasonerVersion() {
        return VERSION;
    }

    @Override
    protected void handleChanges(Set<OWLAxiom> addAxioms, Set<OWLAxiom> removeAxioms) {
        StructuralReasoner.handleChanges(addAxioms, removeAxioms, this.classHierarchyInfo);
        StructuralReasoner.handleChanges(addAxioms, removeAxioms, this.objectPropertyHierarchyInfo);
        StructuralReasoner.handleChanges(addAxioms, removeAxioms, this.dataPropertyHierarchyInfo);
    }

    public void interrupt() {
        this.interrupted = true;
    }

    private void ensurePrepared() {
        if (!this.prepared) {
            this.prepareReasoner();
        }
    }

    public final void prepareReasoner() {
        this.classHierarchyInfo.computeHierarchy();
        this.objectPropertyHierarchyInfo.computeHierarchy();
        this.dataPropertyHierarchyInfo.computeHierarchy();
        this.prepared = true;
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) {
        this.prepareReasoner();
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        return true;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return CollectionFactory.createSet((Object[])new InferenceType[]{InferenceType.CLASS_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY});
    }

    protected void throwExceptionIfInterrupted() {
        if (this.interrupted) {
            this.interrupted = false;
            throw new ReasonerInterruptedException();
        }
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) {
        return !classExpression.isAnonymous() && !this.getEquivalentClasses((OWLClassExpression)classExpression.asOWLClass()).contains((OWLObject)this.getDataFactory().getOWLNothing());
    }

    public Node<OWLClass> getUnsatisfiableClasses() {
        return OWLClassNode.getBottomNode();
    }

    public boolean isEntailed(OWLAxiom axiom) {
        return this.getRootOntology().containsAxiom(axiom, Imports.INCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS);
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.getRootOntology().containsAxiom(oWLAxiom, Imports.INCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return false;
    }

    public Node<OWLClass> getTopClassNode() {
        this.ensurePrepared();
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLThing());
    }

    public Node<OWLClass> getBottomClassNode() {
        this.ensurePrepared();
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLNothing());
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            this.ensurePrepared();
            return this.classHierarchyInfo.getNodeHierarchyChildren(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            this.ensurePrepared();
            return this.classHierarchyInfo.getNodeHierarchyParents(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) {
        this.ensurePrepared();
        if (!ce.isAnonymous()) {
            return this.classHierarchyInfo.getEquivalents(ce.asOWLClass());
        }
        return new OWLClassNode();
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        this.ensurePrepared();
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        if (ce.isAnonymous()) {
            return nodeSet;
        }
        this.getRootOntology().importsClosure().flatMap(o -> o.disjointClassesAxioms(ce.asOWLClass())).flatMap(ax -> ax.classExpressions()).filter(op -> !op.isAnonymous()).forEach(op -> nodeSet.addNode(this.getEquivalentClasses((OWLClassExpression)op)));
        return nodeSet;
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopObjectProperty());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomObjectProperty());
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getNodeHierarchyChildren(pe, direct, ns);
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getNodeHierarchyParents(pe, direct, ns);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(pe);
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) {
        return new OWLObjectPropertyNodeSet();
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) {
        this.ensurePrepared();
        OWLObjectPropertyExpression inv = pe.getInverseProperty();
        return this.getEquivalentObjectProperties(inv);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        Consumer<OWLObjectPropertyDomainAxiom> domains = axiom -> {
            result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getDomain()));
            if (!direct) {
                result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getDomain(), false).nodes());
            }
        };
        Consumer<OWLObjectPropertyRangeAxiom> inverseRanges = ax -> {
            result.addNode(this.getEquivalentClasses((OWLClassExpression)ax.getRange()));
            if (!direct) {
                result.addAllNodes(this.getSuperClasses((OWLClassExpression)ax.getRange(), false).nodes());
            }
        };
        this.getRootOntology().importsClosure().flatMap(o -> o.objectPropertyDomainAxioms(pe)).forEach(domains);
        this.getRootOntology().importsClosure().forEach(o -> this.getInverseObjectProperties(pe).entities().forEach(invPe -> o.objectPropertyRangeAxioms(invPe).forEach(inverseRanges)));
        return result;
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        this.getRootOntology().importsClosure().forEach(ontology -> {
            ontology.objectPropertyRangeAxioms(pe).forEach(axiom -> {
                result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getRange()));
                if (!direct) {
                    result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getRange(), false).nodes());
                }
            });
            this.getInverseObjectProperties(pe).entities().flatMap(arg_0 -> ((OWLOntology)ontology).objectPropertyDomainAxioms(arg_0)).forEach(axiom -> {
                result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getDomain()));
                if (!direct) {
                    result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getDomain(), false).nodes());
                }
            });
        });
        return result;
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopDataProperty());
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomDataProperty());
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) {
        this.ensurePrepared();
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyChildren(pe, direct, ns);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) {
        this.ensurePrepared();
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyParents(pe, direct, ns);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(pe);
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) {
        this.ensurePrepared();
        OWLDataPropertyNodeSet result = new OWLDataPropertyNodeSet();
        this.getRootOntology().importsClosure().flatMap(o -> o.disjointDataPropertiesAxioms(pe.asOWLDataProperty())).forEach(axiom -> {
            for (OWLDataPropertyExpression dpe : axiom.getPropertiesMinus((OWLPropertyExpression)pe)) {
                if (dpe.isAnonymous()) continue;
                result.addNode(this.dataPropertyHierarchyInfo.getEquivalents(dpe.asOWLDataProperty()));
                result.addAllNodes(this.getSubDataProperties(dpe.asOWLDataProperty(), false).nodes());
            }
        });
        return result;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        this.getRootOntology().importsClosure().flatMap(o -> o.dataPropertyDomainAxioms(pe)).forEach(ax -> this.addClasses(direct, result, (OWLClassExpression)ax.getDomain()));
        return result;
    }

    protected void addClasses(boolean direct, DefaultNodeSet<OWLClass> result, OWLClassExpression domain) {
        result.addNode(this.getEquivalentClasses(domain));
        if (!direct) {
            result.addAllNodes(this.getSuperClasses(domain, false).nodes());
        }
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        this.getRootOntology().importsClosure().flatMap(o -> o.classAssertionAxioms((OWLIndividual)ind)).forEach(ax -> this.addClasses(direct, result, ax.getClassExpression()));
        return result;
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) {
        this.ensurePrepared();
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        if (ce.isAnonymous()) {
            return result;
        }
        OWLClass cls = ce.asOWLClass();
        HashSet<OWLClass> clses = new HashSet<OWLClass>();
        clses.add(cls);
        if (!direct) {
            clses.addAll(OWLAPIStreamUtils.asList((Stream)this.getSubClasses((OWLClassExpression)cls, false).entities()));
        }
        for (OWLClass curCls : clses) {
            this.getRootOntology().importsClosure().flatMap(o -> o.classAssertionAxioms((OWLClassExpression)curCls)).map(ax -> ax.getIndividual()).filter(i -> !i.isAnonymous()).map(i -> i.asOWLNamedIndividual()).forEach(i -> {
                if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                    result.addNode(this.getSameIndividuals((OWLNamedIndividual)i));
                } else {
                    result.addNode(new OWLNamedIndividualNode((OWLNamedIndividual)i));
                }
            });
        }
        return result;
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) {
        this.ensurePrepared();
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        Node<OWLObjectPropertyExpression> inverses = this.getInverseObjectProperties(pe);
        this.getRootOntology().importsClosure().flatMap(o -> o.objectPropertyAssertionAxioms((OWLIndividual)ind)).forEach(axiom -> {
            OWLObjectPropertyExpression invPe;
            if (!((OWLIndividual)axiom.getObject()).isAnonymous() && ((OWLObjectPropertyExpression)axiom.getProperty()).equals(pe)) {
                if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                    result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                } else {
                    result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                }
            }
            if (((OWLIndividual)axiom.getObject()).equals(ind) && !axiom.getSubject().isAnonymous() && !(invPe = ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty()).isAnonymous() && inverses.contains((OWLObject)invPe.asOWLObjectProperty())) {
                if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                    result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                } else {
                    result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                }
            }
        });
        return result;
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) {
        this.ensurePrepared();
        HashSet<OWLLiteral> literals = new HashSet<OWLLiteral>();
        Set superProperties = OWLAPIStreamUtils.asUnorderedSet(Stream.concat(this.getSuperDataProperties(pe, false).entities(), this.getEquivalentDataProperties(pe).entities()));
        this.getRootOntology().importsClosure().flatMap(o -> o.dataPropertyAssertionAxioms((OWLIndividual)ind)).forEach(ax -> {
            if (superProperties.contains(((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty())) {
                literals.add((OWLLiteral)ax.getObject());
            }
        });
        return literals;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) {
        this.ensurePrepared();
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        HashSet processed = new HashSet();
        LinkedList<OWLNamedIndividual> stack = new LinkedList<OWLNamedIndividual>();
        stack.add(ind);
        while (!stack.isEmpty()) {
            OWLNamedIndividual currentInd = (OWLNamedIndividual)stack.remove(0);
            Stream<OWLSameIndividualAxiom> axioms = this.getRootOntology().importsClosure().flatMap(o -> o.sameIndividualAxioms((OWLIndividual)currentInd)).filter(processed::add);
            axioms.forEach(ax -> ax.individuals().filter(i -> i.isNamed()).filter(i -> inds.add(i.asOWLNamedIndividual())).forEach(i -> stack.add(i.asOWLNamedIndividual())));
        }
        if (inds.isEmpty()) {
            inds.add(ind);
        }
        return new OWLNamedIndividualNode((Collection<OWLNamedIndividual>)inds);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) {
        this.ensurePrepared();
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        HashSet processed = new HashSet();
        LinkedList<OWLNamedIndividual> stack = new LinkedList<OWLNamedIndividual>();
        stack.add(ind);
        while (!stack.isEmpty()) {
            OWLNamedIndividual currentInd = (OWLNamedIndividual)stack.remove(0);
            Stream<OWLDifferentIndividualsAxiom> axioms = Imports.INCLUDED.stream((HasImportsClosure)this.getRootOntology()).flatMap(o -> o.differentIndividualAxioms((OWLIndividual)currentInd)).filter(processed::add);
            axioms.forEach(ax -> ax.individuals().filter(i -> i.isOWLNamedIndividual()).map(i -> i.asOWLNamedIndividual()).forEach(i -> {
                if (inds.add((OWLNamedIndividual)i)) {
                    stack.add((OWLNamedIndividual)i);
                }
            }));
        }
        if (inds.isEmpty()) {
            inds.add(ind);
        }
        return new OWLNamedIndividualNodeSet(OWLAPIStreamUtils.asUnorderedSet(inds.stream().map(this::getSameIndividuals)));
    }

    protected OWLDataFactory getDataFactory() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
    }

    public void dumpClassHierarchy(boolean showBottomNode) {
        this.dumpClassHierarchy(OWLClassNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpClassHierarchy(Node<OWLClass> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        StructuralReasoner.printIndent(level);
        OWLClass representative = (OWLClass)cls.getRepresentativeElement();
        System.out.println(this.getEquivalentClasses((OWLClassExpression)representative));
        for (Node subCls : this.getSubClasses((OWLClassExpression)representative, true)) {
            this.dumpClassHierarchy((Node<OWLClass>)subCls, level + 1, showBottomNode);
        }
    }

    public void dumpObjectPropertyHierarchy(boolean showBottomNode) {
        this.dumpObjectPropertyHierarchy(OWLObjectPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpObjectPropertyHierarchy(Node<OWLObjectPropertyExpression> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        StructuralReasoner.printIndent(level);
        OWLObjectPropertyExpression representative = (OWLObjectPropertyExpression)cls.getRepresentativeElement();
        System.out.println(this.getEquivalentObjectProperties(representative));
        for (Node subProp : this.getSubObjectProperties(representative, true)) {
            this.dumpObjectPropertyHierarchy((Node<OWLObjectPropertyExpression>)subProp, level + 1, showBottomNode);
        }
    }

    public void dumpDataPropertyHierarchy(boolean showBottomNode) {
        this.dumpDataPropertyHierarchy(OWLDataPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpDataPropertyHierarchy(Node<OWLDataProperty> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        StructuralReasoner.printIndent(level);
        OWLDataProperty representative = (OWLDataProperty)cls.getRepresentativeElement();
        System.out.println(this.getEquivalentDataProperties(representative));
        for (Node subProp : this.getSubDataProperties(representative, true)) {
            this.dumpDataPropertyHierarchy((Node<OWLDataProperty>)subProp, level + 1, showBottomNode);
        }
    }

    private class ClassHierarchyInfo
    extends AbstractHierarchyInfo<OWLClass> {
        ClassHierarchyInfo() {
            super(StructuralReasoner.this, "class", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLThing(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLNothing(), (RawHierarchyProvider)new RawClassHierarchyProvider());
        }

        @Override
        protected Stream<OWLClass> getEntitiesInSignature(OWLAxiom ax) {
            return ax.classesInSignature();
        }

        @Override
        protected DefaultNode<OWLClass> createNode(Set<OWLClass> cycle) {
            return new OWLClassNode((Collection<OWLClass>)cycle);
        }

        @Override
        protected Stream<OWLClass> getEntities(OWLOntology ont) {
            return ont.classesInSignature();
        }

        @Override
        protected DefaultNode<OWLClass> createNode() {
            return new OWLClassNode();
        }
    }

    private class ObjectPropertyHierarchyInfo
    extends AbstractHierarchyInfo<OWLObjectPropertyExpression> {
        ObjectPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "object property", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLTopObjectProperty(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLBottomObjectProperty(), (RawHierarchyProvider)new RawObjectPropertyHierarchyProvider());
        }

        @Override
        protected Stream<OWLObjectPropertyExpression> getEntitiesInSignature(OWLAxiom ax) {
            HashSet result = new HashSet();
            ax.objectPropertiesInSignature().forEach(p -> {
                result.add(p);
                result.add(p.getInverseProperty());
            });
            return result.stream();
        }

        @Override
        protected Stream<OWLObjectPropertyExpression> getEntities(OWLOntology ont) {
            HashSet result = new HashSet();
            ont.objectPropertiesInSignature().forEach(p -> {
                result.add(p);
                result.add(p.getInverseProperty());
            });
            return result.stream();
        }

        @Override
        protected DefaultNode<OWLObjectPropertyExpression> createNode(Set<OWLObjectPropertyExpression> cycle) {
            return new OWLObjectPropertyNode((Collection<OWLObjectPropertyExpression>)cycle);
        }

        @Override
        protected DefaultNode<OWLObjectPropertyExpression> createNode() {
            return new OWLObjectPropertyNode();
        }

        @Override
        public void processChanges(Set<OWLObjectPropertyExpression> signature, Set<OWLAxiom> added, Set<OWLAxiom> removed) {
            boolean rebuild = false;
            for (OWLAxiom ax : added) {
                if (!(ax instanceof OWLObjectPropertyAxiom)) continue;
                rebuild = true;
                break;
            }
            if (!rebuild) {
                for (OWLAxiom ax : removed) {
                    if (!(ax instanceof OWLObjectPropertyAxiom)) continue;
                    rebuild = true;
                    break;
                }
            }
            if (rebuild) {
                ((RawObjectPropertyHierarchyProvider)this.getRawParentChildProvider()).rebuild();
            }
            super.processChanges(signature, added, removed);
        }
    }

    private class DataPropertyHierarchyInfo
    extends AbstractHierarchyInfo<OWLDataProperty> {
        DataPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "data property", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLTopDataProperty(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLBottomDataProperty(), (RawHierarchyProvider)new RawDataPropertyHierarchyProvider());
        }

        @Override
        protected Stream<OWLDataProperty> getEntitiesInSignature(OWLAxiom ax) {
            return ax.dataPropertiesInSignature();
        }

        @Override
        protected Stream<OWLDataProperty> getEntities(OWLOntology ont) {
            return ont.dataPropertiesInSignature();
        }

        @Override
        protected DefaultNode<OWLDataProperty> createNode(Set<OWLDataProperty> cycle) {
            return new OWLDataPropertyNode((Collection<OWLDataProperty>)cycle);
        }

        @Override
        protected DefaultNode<OWLDataProperty> createNode() {
            return new OWLDataPropertyNode();
        }
    }

    private static abstract class AbstractHierarchyInfo<T extends OWLObject> {
        private final RawHierarchyProvider<T> rawParentChildProvider;
        private final Set<T> directChildrenOfTopNode = new HashSet<T>();
        private final Set<T> directParentsOfBottomNode = new HashSet<T>();
        private final NodeCache<T> nodeCache;
        private final String name;
        protected T topEntity;
        protected T bottomEntity;
        private int classificationSize;
        final /* synthetic */ StructuralReasoner this$0;

        AbstractHierarchyInfo(String name, T topEntity, T bottomEntity, RawHierarchyProvider<T> rawParentChildProvider) {
            this.this$0 = var1_1;
            this.topEntity = topEntity;
            this.bottomEntity = bottomEntity;
            this.nodeCache = new NodeCache(this);
            this.rawParentChildProvider = rawParentChildProvider;
            this.name = name;
        }

        public RawHierarchyProvider<T> getRawParentChildProvider() {
            return this.rawParentChildProvider;
        }

        protected abstract Stream<T> getEntities(OWLOntology var1);

        protected abstract DefaultNode<T> createNode(Set<T> var1);

        protected abstract DefaultNode<T> createNode();

        protected abstract Stream<? extends T> getEntitiesInSignature(OWLAxiom var1);

        Set<T> getEntitiesInSignature(Set<OWLAxiom> axioms) {
            return OWLAPIStreamUtils.asUnorderedSet(axioms.stream().flatMap(this::getEntitiesInSignature));
        }

        public void computeHierarchy() {
            this.this$0.pm.reasonerTaskStarted("Computing " + this.name + " hierarchy");
            this.this$0.pm.reasonerTaskBusy();
            this.nodeCache.clear();
            HashMap cache = new HashMap();
            Set entities = OWLAPIStreamUtils.asUnorderedSet(this.this$0.getRootOntology().importsClosure().flatMap(this::getEntities));
            this.classificationSize = entities.size();
            this.this$0.pm.reasonerTaskProgressChanged(0, this.classificationSize);
            this.updateForSignature(entities, cache);
            this.this$0.pm.reasonerTaskStopped();
        }

        private void updateForSignature(Set<T> signature, @Nullable Map<T, Collection<T>> cache) {
            HashSet<Set<T>> cyclesResult = new HashSet<Set<T>>();
            HashSet processed = new HashSet();
            this.nodeCache.clearTopNode();
            this.nodeCache.clearBottomNode();
            this.nodeCache.clearNodes(signature);
            this.directChildrenOfTopNode.removeAll(signature);
            HashSet equivTopOrChildrenOfTop = new HashSet();
            HashSet equivBottomOrParentsOfBottom = new HashSet();
            for (OWLObject oWLObject : signature) {
                if (processed.contains(oWLObject)) continue;
                this.this$0.pm.reasonerTaskProgressChanged(processed.size(), signature.size());
                this.tarjan(oWLObject, 0, new LinkedList(), new HashMap(), new HashMap(), cyclesResult, processed, new HashSet(), cache, equivTopOrChildrenOfTop, equivBottomOrParentsOfBottom);
                this.this$0.throwExceptionIfInterrupted();
            }
            for (Set set : cyclesResult) {
                this.nodeCache.addNode(set);
            }
            this.directChildrenOfTopNode.addAll(equivTopOrChildrenOfTop);
            this.nodeCache.getTopNode().entities().forEach(this.directChildrenOfTopNode::remove);
            this.directParentsOfBottomNode.addAll(equivBottomOrParentsOfBottom);
            this.nodeCache.getBottomNode().entities().forEach(this.directParentsOfBottomNode::remove);
            for (Set set : cyclesResult) {
                if (set.contains(this.topEntity) || set.contains(this.bottomEntity)) continue;
                boolean childOfTop = true;
                for (OWLObject element : set) {
                    Collection<OWLObject> parents = this.rawParentChildProvider.getParents(element);
                    parents.removeAll(set);
                    this.nodeCache.getTopNode().entities().forEach(parents::remove);
                    if (parents.isEmpty()) continue;
                    childOfTop = false;
                    break;
                }
                if (childOfTop) {
                    this.directChildrenOfTopNode.addAll(set);
                }
                boolean parentOfBottom = true;
                for (OWLObject element : set) {
                    Collection<OWLObject> children = this.rawParentChildProvider.getChildren(element);
                    children.removeAll(set);
                    this.nodeCache.getBottomNode().entities().forEach(children::remove);
                    if (children.isEmpty()) continue;
                    parentOfBottom = false;
                    break;
                }
                if (!parentOfBottom) continue;
                this.directParentsOfBottomNode.addAll(set);
            }
        }

        public void processChanges(Set<T> signature, Set<OWLAxiom> added, Set<OWLAxiom> removed) {
            this.updateForSignature(signature, null);
        }

        public void tarjan(T entity, int inputIndex, Deque<T> stack, Map<T, Integer> indexMap, Map<T, Integer> lowlinkMap, Set<Set<T>> result, Set<T> processed, Set<T> stackEntities, @Nullable Map<T, Collection<T>> cache, Set<T> childrenOfTop, Set<T> parentsOfBottom) {
            Collection<T> rawChildren;
            int index = inputIndex;
            this.this$0.throwExceptionIfInterrupted();
            if (processed.add(entity) && ((rawChildren = this.rawParentChildProvider.getChildren(entity)).isEmpty() || rawChildren.contains(this.bottomEntity))) {
                parentsOfBottom.add(entity);
            }
            this.this$0.pm.reasonerTaskProgressChanged(processed.size(), this.classificationSize);
            indexMap.put(entity, index);
            lowlinkMap.put(entity, index);
            ++index;
            stack.push(entity);
            stackEntities.add(entity);
            Collection rawParents = cache != null ? cache.computeIfAbsent(entity, e -> this.computeParents(e, childrenOfTop)) : this.computeParents(entity, childrenOfTop);
            for (OWLObject superEntity : rawParents) {
                if (!indexMap.containsKey(superEntity)) {
                    this.tarjan(superEntity, index, stack, indexMap, lowlinkMap, result, processed, stackEntities, cache, childrenOfTop, parentsOfBottom);
                    lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), lowlinkMap.get(superEntity)));
                    continue;
                }
                if (!stackEntities.contains(superEntity)) continue;
                lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), indexMap.get(superEntity)));
            }
            if (lowlinkMap.get(entity).equals(indexMap.get(entity))) {
                OWLObject clsPrime;
                HashSet<OWLObject> scc = new HashSet<OWLObject>();
                do {
                    clsPrime = (OWLObject)stack.pop();
                    stackEntities.remove(clsPrime);
                    scc.add(clsPrime);
                } while (!clsPrime.equals(entity));
                if (scc.size() > 1) {
                    result.add(scc);
                }
            }
        }

        protected Collection<T> computeParents(T entity, Set<T> childrenOfTop) {
            Collection<T> rawParents = this.rawParentChildProvider.getParents(entity);
            if (rawParents.isEmpty() || rawParents.contains(this.topEntity)) {
                childrenOfTop.add(entity);
            }
            return rawParents;
        }

        public NodeSet<T> getNodeHierarchyChildren(T parent, boolean direct, DefaultNodeSet<T> ns) {
            Node<T> node = this.nodeCache.getNode(parent);
            if (node.isBottomNode()) {
                return ns;
            }
            HashSet<Object> directChildren = new HashSet<Object>();
            for (OWLObject equiv : node) {
                directChildren.addAll(this.rawParentChildProvider.getChildren(equiv));
                if (!this.directParentsOfBottomNode.contains(equiv)) continue;
                ns.addNode(this.nodeCache.getBottomNode());
            }
            node.entities().forEach(directChildren::remove);
            if (node.isTopNode()) {
                directChildren.addAll(this.directChildrenOfTopNode);
            }
            for (Node<T> childNode : this.nodeCache.getNodes(directChildren)) {
                ns.addNode(childNode);
            }
            if (!direct) {
                for (OWLObject child : directChildren) {
                    this.getNodeHierarchyChildren(child, direct, ns);
                }
            }
            return ns;
        }

        public NodeSet<T> getNodeHierarchyParents(T child, boolean direct, DefaultNodeSet<T> ns) {
            Node<T> node = this.nodeCache.getNode(child);
            if (node.isTopNode()) {
                return ns;
            }
            HashSet<Object> directParents = new HashSet<Object>();
            for (OWLObject equiv : node) {
                directParents.addAll(this.rawParentChildProvider.getParents(equiv));
                if (!this.directChildrenOfTopNode.contains(equiv)) continue;
                ns.addNode(this.nodeCache.getTopNode());
            }
            node.entities().forEach(directParents::remove);
            if (node.isBottomNode()) {
                directParents.addAll(this.directParentsOfBottomNode);
            }
            for (Node<T> parentNode : this.nodeCache.getNodes(directParents)) {
                ns.addNode(parentNode);
            }
            if (!direct) {
                for (OWLObject parent : directParents) {
                    this.getNodeHierarchyParents(parent, direct, ns);
                }
            }
            return ns;
        }

        public Node<T> getEquivalents(T element) {
            return this.nodeCache.getNode(element);
        }
    }

    private class RawDataPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLDataProperty> {
        RawDataPropertyHierarchyProvider() {
        }

        @Override
        public Collection<OWLDataProperty> getParents(OWLDataProperty child) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            Stream axioms = StructuralReasoner.this.getRootOntology().axioms(Filters.subDataPropertyWithSub, (Object)child, Imports.INCLUDED);
            Searcher.sup((Stream)axioms, OWLDataPropertyExpression.class).forEach(p -> properties.add(p.asOWLDataProperty()));
            return properties;
        }

        @Override
        public Collection<OWLDataProperty> getChildren(OWLDataProperty parent) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            Stream axioms = StructuralReasoner.this.getRootOntology().axioms(Filters.subDataPropertyWithSuper, (Object)parent, Imports.INCLUDED);
            Searcher.sub((Stream)axioms, OWLDataPropertyExpression.class).forEach(p -> properties.add(p.asOWLDataProperty()));
            return properties;
        }
    }

    private class RawObjectPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLObjectPropertyExpression> {
        private OWLObjectPropertyManager propertyManager;
        private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> sub2Super;
        private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> super2Sub;

        RawObjectPropertyHierarchyProvider() {
            this.rebuild();
        }

        public final void rebuild() {
            this.propertyManager = new OWLObjectPropertyManager(StructuralReasoner.this.getRootOntology());
            this.sub2Super = this.propertyManager.getPropertyHierarchy();
            this.super2Sub = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
            for (Map.Entry<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> e : this.sub2Super.entrySet()) {
                e.getValue().forEach(a -> this.super2Sub.computeIfAbsent((OWLObjectPropertyExpression)a, x -> new HashSet()).add((OWLObjectPropertyExpression)e.getKey()));
            }
        }

        @Override
        public Collection<OWLObjectPropertyExpression> getParents(OWLObjectPropertyExpression child) {
            if (child.isBottomEntity()) {
                return Collections.emptySet();
            }
            Set<OWLObjectPropertyExpression> propertyExpressions = this.sub2Super.get(child);
            if (propertyExpressions == null) {
                return Collections.emptySet();
            }
            return new HashSet<OWLObjectPropertyExpression>(propertyExpressions);
        }

        @Override
        public Collection<OWLObjectPropertyExpression> getChildren(OWLObjectPropertyExpression parent) {
            if (parent.isTopEntity()) {
                return Collections.emptySet();
            }
            Set<OWLObjectPropertyExpression> propertyExpressions = this.super2Sub.get(parent);
            if (propertyExpressions == null) {
                return Collections.emptySet();
            }
            return new HashSet<OWLObjectPropertyExpression>(propertyExpressions);
        }
    }

    private class RawClassHierarchyProvider
    implements RawHierarchyProvider<OWLClass> {
        RawClassHierarchyProvider() {
        }

        @Override
        public Collection<OWLClass> getParents(OWLClass child) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLOntology ont : OWLAPIStreamUtils.asList((Stream)StructuralReasoner.this.getRootOntology().importsClosure())) {
                for (OWLSubClassOfAxiom ax : OWLAPIStreamUtils.asList((Stream)ont.subClassAxiomsForSubClass(child))) {
                    OWLClassExpression superCls = ax.getSuperClass();
                    if (!superCls.isAnonymous()) {
                        result.add(superCls.asOWLClass());
                        continue;
                    }
                    if (!(superCls instanceof OWLObjectIntersectionOf)) continue;
                    OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)superCls;
                    for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                        if (conjunct.isAnonymous()) continue;
                        result.add(conjunct.asOWLClass());
                    }
                }
                for (OWLSubClassOfAxiom ax : OWLAPIStreamUtils.asList((Stream)ont.equivalentClassesAxioms(child))) {
                    for (OWLClassExpression ce : ax.getClassExpressionsMinus(new OWLClassExpression[]{child})) {
                        if (!ce.isAnonymous()) {
                            result.add(ce.asOWLClass());
                            continue;
                        }
                        if (!(ce instanceof OWLObjectIntersectionOf)) continue;
                        OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)ce;
                        for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                            if (conjunct.isAnonymous()) continue;
                            result.add(conjunct.asOWLClass());
                        }
                    }
                }
            }
            return result;
        }

        @Override
        public Collection<OWLClass> getChildren(OWLClass parent) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLAxiom ax : OWLAPIStreamUtils.asUnorderedSet((Stream)StructuralReasoner.this.getRootOntology().referencingAxioms((OWLPrimitive)parent, Imports.INCLUDED))) {
                if (ax instanceof OWLSubClassOfAxiom) {
                    Set conjuncts;
                    OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                    if (sca.getSubClass().isAnonymous() || !(conjuncts = sca.getSuperClass().asConjunctSet()).contains(parent)) continue;
                    result.add(sca.getSubClass().asOWLClass());
                    continue;
                }
                if (!(ax instanceof OWLEquivalentClassesAxiom)) continue;
                OWLEquivalentClassesAxiom eca = (OWLEquivalentClassesAxiom)ax;
                eca.classExpressions().filter(ce -> ce.containsConjunct((OWLClassExpression)parent)).forEach(ce -> eca.classExpressions().forEach(sub -> {
                    if (!sub.isAnonymous() && !sub.equals(ce)) {
                        result.add(sub.asOWLClass());
                    }
                }));
            }
            return result;
        }
    }

    private static class NodeCache<T extends OWLObject> {
        private final AbstractHierarchyInfo<T> hierarchyInfo;
        private final Map<T, Node<T>> map = new HashMap<T, Node<T>>();
        @Nullable
        private Node<T> topNode;
        @Nullable
        private Node<T> bottomNode;

        protected NodeCache(AbstractHierarchyInfo<T> hierarchyInfo) {
            this.hierarchyInfo = hierarchyInfo;
            this.clearTopNode();
            this.clearBottomNode();
        }

        public void addNode(Node<T> node) {
            node.entities().forEach(e -> {
                this.map.put(e, node);
                if (e.isTopEntity()) {
                    this.topNode = node;
                } else if (e.isBottomEntity()) {
                    this.bottomNode = node;
                }
            });
        }

        public Set<Node<T>> getNodes(Set<T> elements) {
            HashSet<Node<T>> result = new HashSet<Node<T>>();
            for (OWLObject element : elements) {
                result.add(this.getNode(element));
            }
            return result;
        }

        public Node<T> getNode(T containing) {
            Node<T> parentNode = this.map.get(containing);
            if (parentNode != null) {
                return parentNode;
            }
            return this.hierarchyInfo.createNode(CollectionFactory.createSet(containing));
        }

        public void addNode(Set<T> elements) {
            this.addNode(this.hierarchyInfo.createNode(elements));
        }

        public Node<T> getTopNode() {
            return (Node)OWLAPIPreconditions.verifyNotNull(this.topNode);
        }

        public Node<T> getBottomNode() {
            return (Node)OWLAPIPreconditions.verifyNotNull(this.bottomNode);
        }

        public final void clearTopNode() {
            this.removeNode(this.hierarchyInfo.topEntity);
            this.topNode = this.hierarchyInfo.createNode(CollectionFactory.createSet(this.hierarchyInfo.topEntity));
            this.addNode(this.getTopNode());
        }

        public final void clearBottomNode() {
            this.removeNode(this.hierarchyInfo.bottomEntity);
            this.bottomNode = this.hierarchyInfo.createNode(CollectionFactory.createSet(this.hierarchyInfo.bottomEntity));
            this.addNode(this.getBottomNode());
        }

        public void clearNodes(Set<T> containing) {
            for (OWLObject entity : containing) {
                this.removeNode(entity);
            }
        }

        public void clear() {
            this.map.clear();
            this.clearTopNode();
            this.clearBottomNode();
        }

        public void removeNode(T containing) {
            Node<T> node = this.map.remove(containing);
            if (node != null) {
                node.entities().forEach(this.map::remove);
            }
        }
    }

    private static interface RawHierarchyProvider<T> {
        public Collection<T> getParents(T var1);

        public Collection<T> getChildren(T var1);
    }
}

