/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.owlxml.parser.AbstractClassExpressionElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractIRIElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLAxiomElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLDataRangeHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLObjectPropertyElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnnotationElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnnotationPropertyElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnonymousIndividualElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLDataPropertyElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLDatatypeFacetRestrictionElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLIndividualElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLLiteralElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLSubObjectPropertyChainElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserAttributeNotFoundException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserElementNotFoundException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;
import org.semanticweb.owlapi.owlxml.parser.SWRLAtomElementHandler;
import org.semanticweb.owlapi.owlxml.parser.SWRLAtomListElementHandler;
import org.semanticweb.owlapi.owlxml.parser.SWRLVariableElementHandler;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

abstract class OWLElementHandler<O> {
    @Nonnull
    final OWLXMLParserHandler handler;
    OWLElementHandler<?> parentHandler;
    @Nonnull
    final StringBuilder sb = new StringBuilder();
    String elementName;
    @Nonnull
    final OWLDataFactory df;

    @Nonnull
    abstract O getOWLObject();

    abstract void endElement();

    OWLElementHandler(@Nonnull OWLXMLParserHandler handler) {
        this.handler = handler;
        this.df = handler.getDataFactory();
    }

    @Nonnull
    IRI getIRIFromAttribute(@Nonnull String localName, @Nonnull String value) {
        if (localName.equals(OWLXMLVocabulary.IRI_ATTRIBUTE.getShortForm())) {
            return this.handler.getIRI(value);
        }
        if (localName.equals(OWLXMLVocabulary.ABBREVIATED_IRI_ATTRIBUTE.getShortForm())) {
            return this.handler.getAbbreviatedIRI(value);
        }
        if (localName.equals("URI")) {
            return this.handler.getIRI(value);
        }
        this.ensureAttributeNotNull(null, OWLXMLVocabulary.IRI_ATTRIBUTE.getShortForm());
        return IRI.create((String)"");
    }

    IRI getIRIFromElement(@Nonnull String elementLocalName, @Nonnull String textContent) {
        if (elementLocalName.equals(OWLXMLVocabulary.IRI_ELEMENT.getShortForm())) {
            return this.handler.getIRI(textContent.trim());
        }
        if (elementLocalName.equals(OWLXMLVocabulary.ABBREVIATED_IRI_ELEMENT.getShortForm())) {
            return this.handler.getAbbreviatedIRI(textContent.trim());
        }
        throw new OWLXMLParserException(this.handler, elementLocalName + " is not an IRI element");
    }

    void setParentHandler(@Nonnull OWLElementHandler<?> handler) {
        this.parentHandler = handler;
    }

    @Nonnull
    OWLElementHandler<?> getParentHandler() {
        return (OWLElementHandler)OWLAPIPreconditions.verifyNotNull(this.parentHandler, (String)"parentHandler cannot be null at this point");
    }

    void attribute(@Nonnull String localName, @Nonnull String value) {
    }

    void startElement(@Nonnull String name) {
        this.elementName = name;
    }

    String getElementName() {
        return this.elementName;
    }

    void handleChild(@Nonnull AbstractOWLAxiomElementHandler h) {
    }

    void handleChild(@Nonnull AbstractClassExpressionElementHandler h) {
    }

    void handleChild(@Nonnull AbstractOWLDataRangeHandler h) {
    }

    void handleChild(@Nonnull AbstractOWLObjectPropertyElementHandler h) {
    }

    void handleChild(@Nonnull OWLDataPropertyElementHandler h) {
    }

    void handleChild(@Nonnull OWLIndividualElementHandler h) {
    }

    void handleChild(@Nonnull OWLLiteralElementHandler h) {
    }

    void handleChild(@Nonnull OWLAnnotationElementHandler h) {
    }

    void handleChild(@Nonnull OWLSubObjectPropertyChainElementHandler h) {
    }

    void handleChild(@Nonnull OWLDatatypeFacetRestrictionElementHandler h) {
    }

    void handleChild(@Nonnull OWLAnnotationPropertyElementHandler h) {
    }

    void handleChild(@Nonnull OWLAnonymousIndividualElementHandler h) {
    }

    void handleChild(@Nonnull AbstractIRIElementHandler h) {
    }

    void handleChild(@Nonnull SWRLVariableElementHandler h) {
    }

    void handleChild(@Nonnull SWRLAtomElementHandler h) {
    }

    void handleChild(@Nonnull SWRLAtomListElementHandler h) {
    }

    void ensureNotNull(@Nullable Object element, String message) {
        if (element == null) {
            throw new OWLXMLParserElementNotFoundException(this.handler, message);
        }
    }

    void ensureAttributeNotNull(@Nullable Object element, String message) {
        if (element == null) {
            throw new OWLXMLParserAttributeNotFoundException(this.handler, message);
        }
    }

    void handleChars(char[] chars, int start, int length) {
        if (this.isTextContentPossible()) {
            this.sb.append(chars, start, length);
        }
    }

    @Nonnull
    String getText() {
        return this.sb.toString();
    }

    boolean isTextContentPossible() {
        return false;
    }
}

