/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.SAXParser;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.IllegalElementNameException;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriter;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterNamespaceManager;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterPreferences;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SAXParsers;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLWriterImpl
implements XMLWriter {
    @Nonnull
    private final Deque<XMLElement> elementStack;
    @Nonnull
    protected final Writer writer;
    private String encoding = "";
    @Nonnull
    private final String xmlBase;
    @Nonnull
    private final XMLWriterNamespaceManager xmlWriterNamespaceManager;
    private Map<String, String> entities;
    private static final int TEXT_CONTENT_WRAP_LIMIT = Integer.MAX_VALUE;
    private boolean preambleWritten;
    private static final String PERCENT_ENTITY = "&#37;";
    protected final XMLWriterPreferences xmlPreferences;

    public XMLWriterImpl(@Nonnull Writer writer, @Nonnull XMLWriterNamespaceManager xmlWriterNamespaceManager, @Nonnull String xmlBase, @Nonnull XMLWriterPreferences preferences) {
        this.writer = (Writer)OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null");
        this.xmlWriterNamespaceManager = (XMLWriterNamespaceManager)OWLAPIPreconditions.checkNotNull((Object)xmlWriterNamespaceManager, (String)"xmlWriterNamespaceManager cannot be null");
        this.xmlBase = (String)OWLAPIPreconditions.checkNotNull((Object)xmlBase, (String)"xmlBase cannot be null");
        this.xmlPreferences = (XMLWriterPreferences)OWLAPIPreconditions.checkNotNull((Object)preferences, (String)"preferences cannot be null");
        this.elementStack = new LinkedList<XMLElement>();
        this.setupEntities();
    }

    private void setupEntities() {
        this.entities = new LinkedHashMap<String, String>();
        for (String curNamespace : this.xmlWriterNamespaceManager.getNamespaces()) {
            assert (curNamespace != null);
            String curPrefix = "";
            curPrefix = this.xmlWriterNamespaceManager.getDefaultNamespace().equals(curNamespace) ? this.xmlWriterNamespaceManager.getDefaultPrefix() : this.xmlWriterNamespaceManager.getPrefixForNamespace(curNamespace);
            assert (curPrefix != null);
            if (curPrefix.isEmpty()) continue;
            this.entities.put(curNamespace, '&' + curPrefix + ';');
        }
    }

    protected String swapForEntity(String value) {
        for (String curEntity : this.entities.keySet()) {
            String repVal;
            String entityVal = this.entities.get(curEntity);
            if (value.length() <= curEntity.length() || (repVal = value.replace(curEntity, entityVal)).length() >= value.length()) continue;
            return repVal;
        }
        return value;
    }

    public String getDefaultNamespace() {
        return this.xmlWriterNamespaceManager.getDefaultNamespace();
    }

    @Override
    public String getXMLBase() {
        return this.xmlBase;
    }

    @Override
    public XMLWriterNamespaceManager getNamespacePrefixes() {
        return this.xmlWriterNamespaceManager;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setWrapAttributes(boolean b) {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.peek();
            element.setWrapAttributes(b);
        }
    }

    @Override
    public void writeStartElement(IRI name) throws IOException {
        XMLElement topElement;
        String qName = this.xmlWriterNamespaceManager.getQName(name);
        if (!XMLUtils.isQName((CharSequence)qName)) {
            throw new IllegalElementNameException(name.toString());
        }
        XMLElement element = new XMLElement(qName, this.elementStack.size());
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        this.elementStack.push(element);
    }

    @Override
    public void writeEndElement() throws IOException {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.pop();
            element.writeElementEnd();
        }
    }

    @Override
    public void writeAttribute(String attr, String val) {
        XMLElement element = this.elementStack.peek();
        String qName = this.xmlWriterNamespaceManager.getQName(attr);
        if (qName != null) {
            element.setAttribute(qName, val);
        }
    }

    @Override
    public void writeAttribute(@Nonnull IRI attr, String val) {
        XMLElement element = this.elementStack.peek();
        String qName = this.xmlWriterNamespaceManager.getQName(attr);
        if (!qName.isEmpty()) {
            element.setAttribute(qName, val);
        }
    }

    @Override
    public void writeTextContent(String text) {
        XMLElement element = this.elementStack.peek();
        element.setText(text);
    }

    @Override
    public void writeComment(String commentText) throws IOException {
        XMLElement topElement;
        XMLElement element = new XMLElement(null, this.elementStack.size());
        element.setText("<!-- " + commentText.replace("--", "&#45;&#45;") + " -->");
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        if (this.preambleWritten) {
            element.writeElementStart(true);
        } else {
            this.elementStack.push(element);
        }
    }

    private void writeEntities(@Nonnull IRI rootName) throws IOException {
        String qName = this.xmlWriterNamespaceManager.getQName(rootName);
        if (qName.isEmpty()) {
            throw new IOException("Cannot create valid XML: qname for " + rootName + " is null or empty");
        }
        this.writer.write("\n\n<!DOCTYPE " + qName + " [\n");
        for (String entityVal : this.entities.keySet()) {
            String entity = this.entities.get(entityVal);
            entity = entity.substring(1, entity.length() - 1);
            this.writer.write("    <!ENTITY ");
            this.writer.write(entity);
            this.writer.write(" \"");
            entityVal = XMLUtils.escapeXML((CharSequence)entityVal);
            entityVal = entityVal.replace("%", PERCENT_ENTITY);
            this.writer.write(entityVal);
            this.writer.write("\" >\n");
        }
        this.writer.write("]>\n\n\n");
    }

    @Override
    public void startDocument(@Nonnull IRI rootElement) throws IOException {
        String encodingString = "";
        if (!this.encoding.isEmpty()) {
            encodingString = " encoding=\"" + this.encoding + '\"';
        }
        this.writer.write("<?xml version=\"1.0\"" + encodingString + "?>\n");
        if (this.xmlPreferences.isUseNamespaceEntities()) {
            this.writeEntities(rootElement);
        }
        this.preambleWritten = true;
        while (!this.elementStack.isEmpty()) {
            this.elementStack.pop().writeElementStart(true);
        }
        this.writeStartElement(rootElement);
        this.setWrapAttributes(true);
        this.writeAttribute("xmlns", this.xmlWriterNamespaceManager.getDefaultNamespace());
        if (!this.xmlBase.isEmpty()) {
            this.writeAttribute("xml:base", this.xmlBase);
        }
        for (String curPrefix : this.xmlWriterNamespaceManager.getPrefixes()) {
            if (curPrefix.isEmpty()) continue;
            this.writeAttribute("xmlns:" + curPrefix, (String)OWLAPIPreconditions.verifyNotNull((Object)this.xmlWriterNamespaceManager.getNamespaceForPrefix(curPrefix)));
        }
    }

    @Override
    public void endDocument() throws IOException {
        while (!this.elementStack.isEmpty()) {
            this.writeEndElement();
        }
        this.writer.flush();
    }

    public class XMLElement {
        private final String name;
        private final Map<String, String> attributes;
        @Nullable
        String textContent;
        private boolean startWritten;
        private int indentation;
        private boolean wrapAttributes;

        public XMLElement(String name, int indentation) {
            this.name = name;
            this.attributes = new LinkedHashMap<String, String>();
            this.indentation = indentation;
            this.textContent = null;
            this.startWritten = false;
        }

        public void setWrapAttributes(boolean b) {
            this.wrapAttributes = b;
        }

        public void setAttribute(String attribute, String value) {
            this.attributes.put(attribute, value);
        }

        public void setText(String content) {
            this.textContent = content;
        }

        public void writeElementStart(boolean close) throws IOException {
            if (!this.startWritten) {
                this.startWritten = true;
                this.insertIndentation();
                if (this.name != null) {
                    XMLWriterImpl.this.writer.write(60);
                    XMLWriterImpl.this.writer.write(this.name);
                    this.writeAttributes();
                    if (this.textContent != null) {
                        boolean wrap;
                        boolean bl = wrap = this.textContent.length() > Integer.MAX_VALUE;
                        if (wrap) {
                            this.writeNewLine();
                            ++this.indentation;
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(62);
                        this.writeTextContent();
                        if (wrap) {
                            --this.indentation;
                        }
                    }
                    if (close) {
                        if (this.textContent != null) {
                            this.writeElementEnd();
                        } else {
                            XMLWriterImpl.this.writer.write("/>");
                            this.writeNewLine();
                        }
                    } else if (this.textContent == null) {
                        XMLWriterImpl.this.writer.write(62);
                        this.writeNewLine();
                    }
                } else if (this.textContent != null) {
                    XMLWriterImpl.this.writer.write("\n\n\n");
                    StringTokenizer tokenizer = new StringTokenizer(this.textContent, "\n", true);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (!token.equals("\n")) {
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(token);
                    }
                    XMLWriterImpl.this.writer.write("\n\n");
                }
            }
        }

        public void writeElementEnd() throws IOException {
            if (this.name != null) {
                if (!this.startWritten) {
                    this.writeElementStart(true);
                } else {
                    if (this.textContent == null) {
                        this.insertIndentation();
                    }
                    XMLWriterImpl.this.writer.write("</");
                    XMLWriterImpl.this.writer.write(this.name);
                    XMLWriterImpl.this.writer.write(">");
                    this.writeNewLine();
                }
            }
        }

        private void writeAttribute(String attr, String val) throws IOException {
            XMLWriterImpl.this.writer.write(attr);
            XMLWriterImpl.this.writer.write(61);
            XMLWriterImpl.this.writer.write(34);
            if (XMLWriterImpl.this.xmlPreferences.isUseNamespaceEntities()) {
                XMLWriterImpl.this.writer.write(XMLWriterImpl.this.swapForEntity(XMLUtils.escapeXML((CharSequence)val)));
            } else {
                XMLWriterImpl.this.writer.write(XMLUtils.escapeXML((CharSequence)val));
            }
            XMLWriterImpl.this.writer.write(34);
        }

        private void writeAttributes() throws IOException {
            Iterator<String> it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String attr = it.next();
                String val = this.attributes.get(attr);
                XMLWriterImpl.this.writer.write(32);
                this.writeAttribute(attr, val);
                if (!it.hasNext() || !this.wrapAttributes) continue;
                XMLWriterImpl.this.writer.write("\n");
                ++this.indentation;
                this.insertIndentation();
                --this.indentation;
            }
        }

        private void writeTextContent() throws IOException {
            if (this.textContent != null) {
                if (this.isRDFXMLLiteral()) {
                    this.checkProperXMLLiteral(this.textContent);
                    XMLWriterImpl.this.writer.write(this.textContent);
                } else {
                    XMLWriterImpl.this.writer.write(XMLUtils.escapeXML((CharSequence)this.textContent));
                }
            }
        }

        private boolean isRDFXMLLiteral() {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(this.attributes.get("rdf:datatype")) || "Literal".equals(this.attributes.get("rdf:parseType"));
        }

        private void checkProperXMLLiteral(String text) throws IOException {
            try {
                String expansions = (String)ConfigurationOptions.ENTITY_EXPANSION_LIMIT.getValue(String.class, Collections.emptyMap());
                SAXParser parser = SAXParsers.initParserWithOWLAPIStandards(null, (String)expansions);
                parser.parse(new InputSource(new StringReader(text)), new DefaultHandler());
            }
            catch (SAXException e) {
                throw new IOException("XML literal is not self contained: \"" + text + "\"", e);
            }
        }

        private void insertIndentation() throws IOException {
            if (XMLWriterImpl.this.xmlPreferences.isIndenting()) {
                for (int i = 0; i < this.indentation * XMLWriterImpl.this.xmlPreferences.getIndentSize(); ++i) {
                    XMLWriterImpl.this.writer.write(32);
                }
            }
        }

        private void writeNewLine() throws IOException {
            XMLWriterImpl.this.writer.write(10);
        }
    }
}

