/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.AbstractRDFPrefixDocumentFormat;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.rdf.rdfxml.parser.BuiltInTypeHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.DeprecatedVocabulary;
import org.semanticweb.owlapi.rdf.rdfxml.parser.LiteralTripleHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OptimisedListTranslator;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ResourceTripleHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.Translators;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TypeMatcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleHandlers {
    static final Logger LOGGER = LoggerFactory.getLogger(TripleHandlers.class);

    private TripleHandlers() {
    }

    static class TypeTransitivePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeTransitivePropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.handlerAccessor.handle(subject, predicate, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
            return !this.isAnonymous(subject);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.addAxiom((OWLAxiom)this.df.getOWLTransitiveObjectPropertyAxiom(this.translateObjectProperty(subject), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSymmetricPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeSymmetricPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            if (!this.isAnonymous(subject)) {
                this.consumer.handlerAccessor.handle(subject, predicate, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
            }
            this.consumer.addObjectProperty(subject, false);
            return !this.isAnonymous(subject);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(subject)) {
                this.addAxiom((OWLAxiom)this.df.getOWLSymmetricObjectPropertyAxiom(this.translateObjectProperty(subject), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TypeSelfRestrictionHandler
    extends AbstractBuiltInTypeHandler {
        TypeSelfRestrictionHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, DeprecatedVocabulary.OWL_SELF_RESTRICTION);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.consumer.addOWLRestriction(subject, false);
            this.consumer.addTriple(subject, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), this.df.getOWLLiteral(true));
        }
    }

    static class TypeSWRLVariableHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLVariableHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.VARIABLE.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addSWRLVariable(subject);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSWRLSameIndividualAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLSameIndividualAtomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addSWRLSameAsAtom(subject);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSWRLIndividualPropertyAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLIndividualPropertyAtomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.consumer.addSWRLIndividualPropertyAtom(subject);
        }
    }

    static class TypeSWRLImpHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLImpHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.IMP.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            IRI remapIRI = this.consumer.remapIRI(subject);
            this.consumeTriple(remapIRI, predicate, object);
            this.consumer.addSWRLRule(remapIRI);
        }
    }

    static class TypeSWRLDifferentIndividualsAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLDifferentIndividualsAtomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addSWRLDifferentFromAtom(subject);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSWRLDataValuedPropertyAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLDataValuedPropertyAtomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.consumer.addSWRLDataPropertyAtom(subject);
        }
    }

    static class TypeSWRLDataRangeAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLDataRangeAtomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.DATA_RANGE_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addSWRLDataRangeAtom(subject);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSWRLClassAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLClassAtomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.CLASS_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addSWRLClassAtom(subject);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSWRLBuiltInHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLBuiltInHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.BUILT_IN_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSWRLBuiltInAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLBuiltInAtomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.BUILT_IN_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addSWRLBuiltInAtom(subject);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeSWRLAtomListHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLAtomListHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.ATOM_LIST.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeRestrictionHandler
    extends AbstractBuiltInTypeHandler {
        TypeRestrictionHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.consumer.addOWLRestriction(subject, true);
            this.consumer.addClassExpression(subject, false);
        }
    }

    static class TypeReflexivePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeReflexivePropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addObjectProperty(subject, false);
            return !this.isAnonymous(subject);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(subject)) {
                this.addAxiom((OWLAxiom)this.df.getOWLReflexiveObjectPropertyAxiom(this.translateObjectProperty(subject), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TypeRDFSClassHandler
    extends AbstractBuiltInTypeHandler {
        TypeRDFSClassHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(subject, false);
            this.consumeTriple(subject, predicate, object);
            if (!this.isStrict()) {
                this.consumer.handlerAccessor.handle(subject, predicate, OWLRDFVocabulary.OWL_CLASS.getIRI());
            }
        }
    }

    static class TypePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypePropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            LOGGER.info("Usage of rdf vocabulary: {} -> {} -> {}", new Object[]{subject, predicate, object});
        }
    }

    static class TypeOntologyPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeOntologyPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, DeprecatedVocabulary.OWL_ONTOLOGY_PROPERTY);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.consumer.handlerAccessor.handle(subject, predicate, OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        }
    }

    static class TypeOntologyHandler
    extends AbstractBuiltInTypeHandler {
        TypeOntologyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.consumer.addOntology(subject);
        }
    }

    static class TypeObjectPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeObjectPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.isAnonymous(subject)) {
                OWLObjectProperty owlObjectProperty = this.df.getOWLObjectProperty(subject);
                Set<OWLAnnotation> annos = this.getPendingAnnotations();
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)owlObjectProperty, annos));
            }
            this.consumer.addObjectProperty(subject, true);
        }
    }

    static class TypeNegativePropertyAssertionHandler
    extends AbstractBuiltInTypeHandler {
        TypeNegativePropertyAssertionHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            IRI source = this.source(subject);
            IRI property = this.property(subject);
            Object target = this.target(subject);
            this.anns(subject);
            if (target instanceof OWLLiteral && (!this.isStrict() || this.consumer.isDataProperty(property))) {
                this.translateNegativeDataPropertyAssertion(subject, predicate, object, source, property, (OWLLiteral)target, this.getPendingAnnotations());
            } else if (target instanceof IRI && (!this.isStrict() || this.consumer.isObjectProperty(property))) {
                this.translateNegativeObjectPropertyAssertion(subject, predicate, object, source, property, (IRI)target, this.getPendingAnnotations());
            }
        }

        @Nonnull
        Object target(IRI subject) {
            IRI target = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getIRI(), true);
            if (target == null) {
                target = this.consumer.getLiteralObject(subject, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), true);
            }
            if (target == null) {
                target = this.consumer.getResourceObject(subject, DeprecatedVocabulary.RDF_OBJECT, true);
            }
            if (target == null) {
                target = this.consumer.getLiteralObject(subject, DeprecatedVocabulary.RDF_OBJECT, true);
            }
            return OWLAPIPreconditions.verifyNotNull((Object)target);
        }

        @Nonnull
        IRI property(IRI subject) {
            IRI property = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), true);
            if (property == null) {
                property = this.consumer.getResourceObject(subject, DeprecatedVocabulary.RDF_PREDICATE, true);
            }
            return (IRI)OWLAPIPreconditions.verifyNotNull((Object)property);
        }

        @Nonnull
        IRI source(IRI subject) {
            IRI source = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), true);
            if (source == null) {
                source = this.consumer.getResourceObject(subject, DeprecatedVocabulary.RDF_SUBJECT, true);
            }
            return (IRI)OWLAPIPreconditions.verifyNotNull((Object)source);
        }

        private void translateNegativeObjectPropertyAssertion(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object, @Nonnull IRI source, @Nonnull IRI property, @Nonnull IRI target, @Nonnull Set<OWLAnnotation> annos) {
            OWLIndividual sourceInd = this.consumer.getOWLIndividual(source);
            OWLObjectPropertyExpression prop = this.consumer.translateObjectPropertyExpression(property);
            OWLIndividual targetInd = this.consumer.getOWLIndividual(target);
            this.consumeTriple(subject, predicate, object);
            this.addAxiom((OWLAxiom)this.df.getOWLNegativeObjectPropertyAssertionAxiom(prop, sourceInd, targetInd, annos));
        }

        private void translateNegativeDataPropertyAssertion(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object, @Nonnull IRI source, @Nonnull IRI property, @Nonnull OWLLiteral target, @Nonnull Set<OWLAnnotation> annos) {
            OWLIndividual sourceInd = this.consumer.getOWLIndividual(source);
            OWLDataPropertyExpression prop = this.consumer.translateDataPropertyExpression(property);
            this.consumeTriple(subject, predicate, object);
            this.addAxiom((OWLAxiom)this.df.getOWLNegativeDataPropertyAssertionAxiom(prop, sourceInd, target, annos));
        }
    }

    static class TypeNegativeDataPropertyAssertionHandler
    extends AbstractBuiltInTypeHandler {
        TypeNegativeDataPropertyAssertionHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, DeprecatedVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            IRI source = this.source(subject);
            IRI property = this.property(subject);
            OWLLiteral target = this.target(subject);
            OWLIndividual sourceInd = this.consumer.getOWLIndividual(source);
            OWLDataPropertyExpression prop = this.consumer.translateDataPropertyExpression(property);
            this.consumeTriple(subject, predicate, object);
            this.anns(subject);
            Set<OWLAnnotation> annos = this.consumer.getPendingAnnotations();
            this.addAxiom((OWLAxiom)this.df.getOWLNegativeDataPropertyAssertionAxiom(prop, sourceInd, target, annos));
        }

        @Nonnull
        OWLLiteral target(IRI subject) {
            OWLLiteral target = this.consumer.getLiteralObject(subject, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), true);
            if (target == null) {
                target = this.consumer.getLiteralObject(subject, DeprecatedVocabulary.OWL_OBJECT, true);
            }
            if (target == null) {
                target = this.consumer.getLiteralObject(subject, DeprecatedVocabulary.RDF_OBJECT, true);
            }
            return (OWLLiteral)OWLAPIPreconditions.verifyNotNull((Object)target);
        }

        @Nonnull
        IRI property(IRI subject) {
            IRI property = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), true);
            if (property == null) {
                property = this.consumer.getResourceObject(subject, DeprecatedVocabulary.OWL_PREDICATE, true);
            }
            if (property == null) {
                property = this.consumer.getResourceObject(subject, DeprecatedVocabulary.RDF_PREDICATE, true);
            }
            return (IRI)OWLAPIPreconditions.verifyNotNull((Object)property);
        }

        @Nonnull
        IRI source(IRI subject) {
            IRI source = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), true);
            if (source == null) {
                source = this.consumer.getResourceObject(subject, DeprecatedVocabulary.OWL_SUBJECT, true);
            }
            if (source == null) {
                source = this.consumer.getResourceObject(subject, DeprecatedVocabulary.RDF_SUBJECT, true);
            }
            return (IRI)OWLAPIPreconditions.verifyNotNull((Object)source);
        }
    }

    static class TypeNamedIndividualHandler
    extends AbstractBuiltInTypeHandler {
        TypeNamedIndividualHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.isAnonymous(subject)) {
                Set<OWLAnnotation> annos = this.consumer.getPendingAnnotations();
                OWLNamedIndividual individual = this.df.getOWLNamedIndividual(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)individual, annos));
            }
            this.consumer.addOWLNamedIndividual(subject, true);
        }
    }

    static class TypeListHandler
    extends AbstractBuiltInTypeHandler {
        TypeListHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_LIST.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TypeIrreflexivePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeIrreflexivePropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addObjectProperty(subject, false);
            return !this.isAnonymous(subject);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(subject)) {
                this.addAxiom((OWLAxiom)this.df.getOWLIrreflexiveObjectPropertyAxiom(this.translateObjectProperty(subject), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TypeInverseFunctionalPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeInverseFunctionalPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.handlerAccessor.handle(subject, predicate, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
            return !this.isAnonymous(subject);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(subject)) {
                OWLObjectPropertyExpression property = this.translateObjectProperty(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLInverseFunctionalObjectPropertyAxiom(property, this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TypeFunctionalPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeFunctionalPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(subject)) {
                this.addAxiom((OWLAxiom)this.df.getOWLFunctionalObjectPropertyAxiom(this.translateObjectProperty(subject), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
            if (this.consumer.isDataProperty(subject)) {
                this.addAxiom((OWLAxiom)this.df.getOWLFunctionalDataPropertyAxiom(this.translateDataProperty(subject), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TypeDeprecatedPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeDeprecatedPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DEPRECATED_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.addAxiom((OWLAxiom)this.df.getDeprecatedOWLAnnotationAssertionAxiom(subject));
        }
    }

    static class TypeDeprecatedClassHandler
    extends AbstractBuiltInTypeHandler {
        TypeDeprecatedClassHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DEPRECATED_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(subject, false);
            this.consumeTriple(subject, predicate, object);
            this.addAxiom((OWLAxiom)this.df.getDeprecatedOWLAnnotationAssertionAxiom(subject));
        }
    }

    static class TypeDatatypeHandler
    extends AbstractBuiltInTypeHandler {
        TypeDatatypeHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.consumer.isAnonymousNode(subject)) {
                OWLDatatype dt = this.df.getOWLDatatype(subject);
                Set<OWLAnnotation> annos = this.consumer.getPendingAnnotations();
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)dt, annos));
            }
            this.consumer.addDataRange(subject, true);
        }
    }

    static class TypeDataRangeHandler
    extends AbstractBuiltInTypeHandler {
        TypeDataRangeHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DATA_RANGE.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.isAnonymous(subject)) {
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TypeDataPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeDataPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.isAnonymous(subject)) {
                Set<OWLAnnotation> annos = this.consumer.getPendingAnnotations();
                OWLDataProperty owlDataProperty = this.df.getOWLDataProperty(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)owlDataProperty, annos));
            }
            this.consumer.addDataProperty(subject, true);
        }
    }

    static class TypeClassHandler
    extends AbstractBuiltInTypeHandler {
        TypeClassHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.isAnonymous(subject)) {
                Set<OWLAnnotation> annos = this.consumer.getPendingAnnotations();
                OWLClass owlClass = this.df.getOWLClass(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)owlClass, annos));
            }
            this.consumer.addClassExpression(subject, true);
        }
    }

    static class TypeAxiomHandler
    extends AbstractBuiltInTypeHandler {
        TypeAxiomHandler(@Nonnull OWLRDFConsumer consumer) {
            this(consumer, OWLRDFVocabulary.OWL_AXIOM.getIRI());
        }

        TypeAxiomHandler(@Nonnull OWLRDFConsumer consumer, IRI typeIRI) {
            super(consumer, typeIRI);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addAxiom(subject);
            return false;
        }

        protected static OWLRDFVocabulary getTargetTriplePredicate() {
            return OWLRDFVocabulary.OWL_ANNOTATED_TARGET;
        }

        protected static OWLRDFVocabulary getPropertyTriplePredicate() {
            return OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY;
        }

        protected static OWLRDFVocabulary getSourceTriplePredicate() {
            return OWLRDFVocabulary.OWL_ANNOTATED_SOURCE;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            IRI annotatedSource = this.getObjectOfSourceTriple(subject);
            IRI annotatedProperty = this.getObjectOfPropertyTriple(subject);
            IRI annotatedTarget = this.getObjectOfTargetTriple(subject);
            OWLLiteral annotatedTargetLiteral = null;
            if (annotatedTarget == null) {
                annotatedTargetLiteral = this.getTargetLiteral(subject);
            }
            if (annotatedSource != null && annotatedProperty != null) {
                Set<OWLAnnotation> annotations = this.consumer.translateAnnotations(subject);
                this.consumer.addPendingAnnotations(annotations);
                if (annotatedTarget != null) {
                    this.consumer.handlerAccessor.handle(annotatedSource, annotatedProperty, annotatedTarget);
                } else if (annotatedTargetLiteral != null) {
                    this.consumer.handlerAccessor.handle(annotatedSource, annotatedProperty, annotatedTargetLiteral);
                }
                if (!annotations.isEmpty()) {
                    OWLAxiom ax = this.consumer.getLastAddedAxiom();
                    this.consumer.removeAxiom(ax.getAxiomWithoutAnnotations());
                }
            }
            this.consumeTriple(subject, predicate, object);
        }

        protected OWLAxiom handleAxiomTriples(IRI subjectTriple, IRI predicateTriple, IRI objectTriple, Set<OWLAnnotation> annotations) {
            return this.consumer.getLastAddedAxiom();
        }

        protected OWLAxiom handleAxiomTriples(@Nonnull IRI subjectTripleObject, @Nonnull IRI predicateTripleObject, @Nonnull OWLLiteral con, Set<OWLAnnotation> annotations) {
            this.consumer.handlerAccessor.handle(subjectTripleObject, predicateTripleObject, con);
            return this.consumer.getLastAddedAxiom();
        }

        @Nonnull
        private OWLLiteral getTargetLiteral(IRI subject) {
            OWLLiteral con = this.consumer.getLiteralObject(subject, TypeAxiomHandler.getTargetTriplePredicate(), true);
            if (con == null) {
                con = this.consumer.getLiteralObject(subject, DeprecatedVocabulary.RDF_OBJECT, true);
            }
            return (OWLLiteral)OWLAPIPreconditions.verifyNotNull((Object)con);
        }

        @Nullable
        private IRI getObjectOfTargetTriple(IRI mainNode) {
            IRI objectTripleObject = this.consumer.getResourceObject(mainNode, TypeAxiomHandler.getTargetTriplePredicate(), true);
            if (objectTripleObject == null) {
                objectTripleObject = this.consumer.getResourceObject(mainNode, DeprecatedVocabulary.RDF_OBJECT, true);
            }
            if (objectTripleObject == null) {
                objectTripleObject = this.consumer.getResourceObject(mainNode, DeprecatedVocabulary.OWL_PROPERTY_CHAIN, true);
            }
            return objectTripleObject;
        }

        @Nullable
        private IRI getObjectOfPropertyTriple(IRI subject) {
            IRI predicateTripleObject = this.consumer.getResourceObject(subject, TypeAxiomHandler.getPropertyTriplePredicate(), true);
            if (predicateTripleObject == null) {
                predicateTripleObject = this.consumer.getResourceObject(subject, DeprecatedVocabulary.RDF_PREDICATE, true);
            }
            return predicateTripleObject;
        }

        @Nullable
        private IRI getObjectOfSourceTriple(IRI mainNode) {
            IRI subjectTripleObject = this.consumer.getResourceObject(mainNode, TypeAxiomHandler.getSourceTriplePredicate(), true);
            if (subjectTripleObject == null) {
                subjectTripleObject = this.consumer.getResourceObject(mainNode, DeprecatedVocabulary.RDF_SUBJECT, true);
            }
            return subjectTripleObject;
        }
    }

    static class TypeAsymmetricPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeAsymmetricPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addObjectProperty(subject, false);
            return !this.isAnonymous(subject);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(subject)) {
                this.addAxiom((OWLAxiom)this.df.getOWLAsymmetricObjectPropertyAxiom(this.translateObjectProperty(subject), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TypeAnnotationPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeAnnotationPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.isAnonymous(subject)) {
                Set<OWLAnnotation> annos = this.consumer.getPendingAnnotations();
                OWLAnnotationProperty property = this.df.getOWLAnnotationProperty(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)property, annos));
                this.consumeTriple(subject, predicate, object);
            }
            this.consumer.addAnnotationProperty(subject, true);
        }
    }

    static class TypeAnnotationHandler
    extends AbstractBuiltInTypeHandler {
        TypeAnnotationHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addAnnotationIRI(subject);
        }
    }

    static class TypeAllDisjointPropertiesHandler
    extends AbstractBuiltInTypeHandler {
        TypeAllDisjointPropertiesHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            IRI listNode = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), true);
            assert (listNode != null);
            if (this.consumer.isObjectProperty(this.consumer.getFirstResource(listNode, false))) {
                this.anns(subject);
                List<OWLObjectPropertyExpression> props = this.consumer.translatorAccessor.translateToObjectPropertyList(listNode);
                this.consumer.addAxiom((OWLAxiom)this.df.getOWLDisjointObjectPropertiesAxiom(new HashSet<OWLObjectPropertyExpression>(props), this.getPendingAnnotations()));
            } else {
                this.anns(subject);
                List<OWLDataPropertyExpression> props = this.consumer.translatorAccessor.translateToDataPropertyList(listNode);
                this.consumer.addAxiom((OWLAxiom)this.df.getOWLDisjointDataPropertiesAxiom(new HashSet<OWLDataPropertyExpression>(props), this.getPendingAnnotations()));
            }
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }
    }

    static class TypeAllDisjointClassesHandler
    extends AbstractBuiltInTypeHandler {
        TypeAllDisjointClassesHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            return super.canHandle(subject, predicate, object) && this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS, false) != null;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            IRI listNode = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), true);
            if (listNode != null) {
                Set<OWLClassExpression> desc = this.consumer.translatorAccessor.translateToClassExpressionSet(listNode);
                this.anns(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLDisjointClassesAxiom(desc, this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }
    }

    static class TypeAllDifferentHandler
    extends AbstractBuiltInTypeHandler {
        TypeAllDifferentHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_DIFFERENT.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            return super.canHandle(subject, predicate, object) && (this.isResourcePresent(subject, OWLRDFVocabulary.OWL_MEMBERS) || this.isResourcePresent(subject, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS));
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            IRI listNode = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), true);
            if (listNode != null) {
                Set<OWLIndividual> inds = this.consumer.translatorAccessor.translateToIndividualSet(listNode);
                this.anns(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLDifferentIndividualsAxiom(inds, this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            } else {
                listNode = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS.getIRI(), true);
                if (listNode != null) {
                    Set<OWLIndividual> inds = this.consumer.translatorAccessor.translateToIndividualSet(listNode);
                    this.anns(subject);
                    this.addAxiom((OWLAxiom)this.df.getOWLDifferentIndividualsAxiom(inds, this.getPendingAnnotations()));
                    this.consumeTriple(subject, predicate, object);
                }
            }
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }
    }

    static abstract class AbstractTriplePredicateHandler
    extends AbstractResourceTripleHandler
    implements TriplePredicateHandler {
        private final IRI predicateIRI;

        AbstractTriplePredicateHandler(@Nonnull OWLRDFConsumer consumer, IRI predicateIRI) {
            super(consumer);
            this.predicateIRI = predicateIRI;
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            this.inferTypes(subject, object);
            return predicate.equals((Object)this.predicateIRI);
        }

        @Override
        public IRI getPredicateIRI() {
            return this.predicateIRI;
        }
    }

    static class TPVersionIRIHandler
    extends AbstractTriplePredicateHandler {
        TPVersionIRIHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_VERSION_IRI.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addVersionIRI(subject, object);
            this.consumeTriple(subject, predicate, object);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            return predicate.equals((Object)OWLRDFVocabulary.OWL_VERSION_IRI.getIRI());
        }
    }

    static class TPUnionOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPUnionOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_UNION_OF.getIRI());
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(IRI mainNode) {
            return this.df.getOWLObjectUnionOf(this.consumer.translatorAccessor.translateToClassExpressionSet(mainNode));
        }
    }

    static class TPTypeHandler
    extends AbstractTriplePredicateHandler {
        TPTypeHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_TYPE.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, @Nonnull IRI object) {
            this.consumer.addClassExpression(object, false);
            if (this.isAnonymous(object)) {
                return false;
            }
            if (object.isReservedVocabulary()) {
                return object.equals((Object)OWLRDFVocabulary.OWL_THING.getIRI());
            }
            return true;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, IRI predicate, @Nonnull IRI object) {
            if (OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(object) && !object.equals((Object)OWLRDFVocabulary.OWL_THING.getIRI())) {
                LOGGER.info("Individual of builtin type {}", (Object)object);
            }
            this.addAxiom((OWLAxiom)this.df.getOWLClassAssertionAxiom(this.translateClassExpression(object), this.translateIndividual(subject), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPSubPropertyOfHandler
    extends AbstractTriplePredicateHandler {
        TPSubPropertyOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(object)) {
                this.consumer.addObjectProperty(subject, false);
            } else if (this.consumer.isDataProperty(object)) {
                this.consumer.addDataProperty(object, false);
            } else if (this.consumer.isAnnotationProperty(object)) {
                this.consumer.addAnnotationProperty(subject, false);
            } else if (this.consumer.isObjectProperty(subject)) {
                this.consumer.addObjectProperty(object, false);
            } else if (this.consumer.isDataProperty(subject)) {
                this.consumer.addDataProperty(object, false);
            } else if (this.consumer.isAnnotationProperty(subject)) {
                this.consumer.addAnnotationProperty(object, false);
            }
            return false;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            if (!this.isStrict() && this.consumer.hasPredicate(subject, DeprecatedVocabulary.OWL_PROPERTY_CHAIN)) {
                IRI chainList = this.consumer.getResourceObject(subject, DeprecatedVocabulary.OWL_PROPERTY_CHAIN, true);
                assert (chainList != null);
                List<OWLObjectPropertyExpression> properties = this.consumer.translatorAccessor.translateToObjectPropertyList(chainList);
                this.addAxiom((OWLAxiom)this.df.getOWLSubPropertyChainOfAxiom(properties, this.translateObjectProperty(object), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            } else if (!this.isStrict() && this.consumer.hasPredicate(subject, OWLRDFVocabulary.RDF_FIRST.getIRI())) {
                List<OWLObjectPropertyExpression> properties = this.consumer.translatorAccessor.translateToObjectPropertyList(subject);
                this.addAxiom((OWLAxiom)this.df.getOWLSubPropertyChainOfAxiom(properties, this.translateObjectProperty(object), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            } else if (this.consumer.isObjectProperty(subject) && this.consumer.isObjectProperty(object)) {
                this.translateSubObjectProperty(subject, predicate, object);
            } else if (this.consumer.isDataProperty(subject) && this.consumer.isDataProperty(object)) {
                this.translateSubDataProperty(subject, predicate, object);
            } else if (!this.isStrict()) {
                if (this.consumer.isObjectProperty(object)) {
                    this.translateSubObjectProperty(subject, predicate, object);
                } else if (this.consumer.isDataProperty(object)) {
                    this.translateSubDataProperty(subject, predicate, object);
                } else {
                    OWLAnnotationProperty subAnnoProp = this.df.getOWLAnnotationProperty(subject);
                    OWLAnnotationProperty superAnnoProp = this.df.getOWLAnnotationProperty(object);
                    this.addAxiom((OWLAxiom)this.df.getOWLSubAnnotationPropertyOfAxiom(subAnnoProp, superAnnoProp, this.getPendingAnnotations()));
                }
                this.consumeTriple(subject, predicate, object);
            }
        }

        private void translateSubObjectProperty(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            this.addAxiom((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom(this.translateObjectProperty(subject), this.translateObjectProperty(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }

        private void translateSubDataProperty(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            this.addAxiom((OWLAxiom)this.df.getOWLSubDataPropertyOfAxiom(this.translateDataProperty(subject), this.translateDataProperty(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPSubClassOfHandler
    extends AbstractTriplePredicateHandler {
        TPSubClassOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            return super.canHandle(subject, predicate, object) && this.isTyped(subject, object);
        }

        private boolean isTyped(IRI subject, IRI object) {
            return this.consumer.isClassExpression(subject) && this.consumer.isClassExpression(object);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(subject, false);
            this.consumer.addClassExpression(object, false);
            return !this.isStrict() && !this.isSubjectOrObjectAnonymous(subject, object);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.isStrict()) {
                if (this.isClassExpressionStrict(subject) && this.isClassExpressionStrict(object)) {
                    this.translate(subject, predicate, object);
                }
            } else if (this.isClassExpressionLax(subject) && this.isClassExpressionLax(object)) {
                this.translate(subject, predicate, object);
            }
        }

        private void translate(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            OWLClassExpression subClass = this.translateClassExpression(subject);
            OWLClassExpression supClass = this.translateClassExpression(object);
            Set<OWLAnnotation> pendingAnnotations = this.consumer.getPendingAnnotations();
            OWLSubClassOfAxiom ax = this.df.getOWLSubClassOfAxiom(subClass, supClass, pendingAnnotations);
            this.addAxiom((OWLAxiom)ax);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPSomeValuesFromHandler
    extends AbstractTriplePredicateHandler {
        TPSomeValuesFromHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.handleTriple(subject, predicate, object);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            IRI property;
            this.consumer.addOWLRestriction(subject, false);
            if (this.consumer.isDataRange(object) && (property = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), false)) != null) {
                this.consumer.addDataProperty(property, false);
            }
        }
    }

    static class TPSameAsHandler
    extends AbstractTriplePredicateHandler {
        TPSameAsHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_SAME_AS.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, IRI predicate, @Nonnull IRI object) {
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(this.translateIndividual(subject));
            inds.add(this.translateIndividual(object));
            this.addAxiom((OWLAxiom)this.df.getOWLSameIndividualAxiom(inds, this.consumer.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPRestHandler
    extends AbstractTriplePredicateHandler {
        TPRestHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_REST.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, @Nonnull IRI object) {
            if (!object.equals((Object)OWLRDFVocabulary.RDF_NIL.getIRI())) {
                this.consumer.addRest(subject, object);
            }
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPPropertyRangeHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyRangeHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_RANGE.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.inferTypes(subject, object);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.isStrict()) {
                if (this.isObjectPropertyStrict(subject) && this.isClassExpressionStrict(object)) {
                    this.translateAsObjectPropertyRange(subject, predicate, object);
                } else if (this.isDataPropertyStrict(subject) && this.isDataRangeStrict(object)) {
                    this.translateAsDataPropertyRange(subject, predicate, object);
                } else if (this.consumer.isAnnotationProperty(subject) && !this.consumer.isAnonymousNode(object)) {
                    this.translateAsAnnotationPropertyRange(subject, predicate, object);
                }
            } else if (this.isObjectPropertyStrict(subject) && this.consumer.isClassExpression(object)) {
                this.translateAsObjectPropertyRange(subject, predicate, object);
            } else if (this.isDataPropertyStrict(subject) && this.consumer.isDataRange(object)) {
                this.translateAsDataPropertyRange(subject, predicate, object);
            } else if (this.consumer.isAnnotationProperty(subject) && !this.consumer.isAnonymousNode(object)) {
                this.translateAsAnnotationPropertyRange(subject, predicate, object);
            } else if (this.isAnnotationPropertyOnly(subject) && !this.isAnonymous(object)) {
                this.translateAsAnnotationPropertyRange(subject, predicate, object);
            } else if (this.isClassExpressionLax(object)) {
                this.consumer.addObjectProperty(subject, false);
                this.translateAsObjectPropertyRange(subject, predicate, object);
            } else if (this.isDataRangeLax(object)) {
                this.consumer.addDataProperty(subject, false);
                this.translateAsDataPropertyRange(subject, predicate, object);
            } else if (this.isObjectPropertyLax(subject)) {
                this.consumer.addObjectProperty(subject, false);
                this.translateAsObjectPropertyRange(subject, predicate, object);
            } else if (this.isDataPropertyLax(subject)) {
                this.consumer.addDataProperty(subject, false);
                this.translateAsDataPropertyRange(subject, predicate, object);
            } else {
                this.consumer.addAnnotationProperty(subject, false);
                this.translateAsAnnotationPropertyRange(subject, predicate, object);
            }
        }

        private void translateAsAnnotationPropertyRange(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(subject);
            this.addAxiom((OWLAxiom)this.df.getOWLAnnotationPropertyRangeAxiom(prop, object, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }

        private void translateAsDataPropertyRange(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            OWLDataPropertyExpression property = this.translateDataProperty(subject);
            OWLDataRange dataRange = this.translateDataRange(object);
            this.addAxiom((OWLAxiom)this.df.getOWLDataPropertyRangeAxiom(property, dataRange, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }

        private void translateAsObjectPropertyRange(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            OWLObjectPropertyExpression property = this.translateObjectProperty(subject);
            OWLClassExpression range = this.translateClassExpression(object);
            this.addAxiom((OWLAxiom)this.df.getOWLObjectPropertyRangeAxiom(property, range, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPPropertyDomainHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyDomainHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isObjectProperty(subject)) {
                this.translateObjectPropertyDomain(subject, predicate, object);
            } else if (this.consumer.isDataProperty(subject)) {
                this.translateDataPropertyDomain(subject, predicate, object);
            } else if (this.consumer.isAnnotationProperty(subject) && !this.consumer.isAnonymousNode(object)) {
                this.translateAnnotationPropertyDomain(subject, predicate, object);
            } else if (!this.isStrict()) {
                this.consumer.addAnnotationProperty(subject, false);
                this.translateAnnotationPropertyDomain(subject, predicate, object);
            }
        }

        private void translateAnnotationPropertyDomain(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(subject);
            this.addAxiom((OWLAxiom)this.df.getOWLAnnotationPropertyDomainAxiom(prop, object, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }

        private void translateDataPropertyDomain(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            this.addAxiom((OWLAxiom)this.df.getOWLDataPropertyDomainAxiom(this.translateDataProperty(subject), this.translateClassExpression(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }

        private void translateObjectPropertyDomain(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            this.addAxiom((OWLAxiom)this.df.getOWLObjectPropertyDomainAxiom(this.translateObjectProperty(subject), this.translateClassExpression(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPPropertyDisjointWithHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyDisjointWithHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            this.inferTypes(subject, object);
            return super.canHandle(subject, predicate, object) && (this.consumer.isObjectProperty(subject) && this.consumer.isObjectProperty(object) || this.consumer.isDataProperty(subject) && this.consumer.isDataProperty(object));
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isDataProperty(subject) && this.consumer.isDataProperty(object)) {
                this.addAxiom((OWLAxiom)this.df.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLDataPropertyExpression[]{this.translateDataProperty(subject), this.translateDataProperty(object)}), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
            if (this.consumer.isObjectProperty(subject) && this.consumer.isObjectProperty(object)) {
                this.addAxiom((OWLAxiom)this.df.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLObjectPropertyExpression[]{this.translateObjectProperty(subject), this.translateObjectProperty(object)}), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.inferTypes(subject, object);
            return false;
        }
    }

    static class TPPropertyChainAxiomHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyChainAxiomHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addObjectProperty(object, false);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            OWLObjectPropertyExpression superProp = this.consumer.translateObjectPropertyExpression(subject);
            List<OWLObjectPropertyExpression> chain = this.consumer.translatorAccessor.translateToObjectPropertyList(object);
            this.consumeTriple(subject, predicate, object);
            Set<OWLAnnotation> annos = this.getPendingAnnotations();
            this.addAxiom((OWLAxiom)this.df.getOWLSubPropertyChainOfAxiom(chain, superProp, annos));
        }
    }

    static class TPOneOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPOneOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ONE_OF.getIRI());
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(IRI mainNode) {
            return this.df.getOWLObjectOneOf(this.consumer.translatorAccessor.translateToIndividualSet(mainNode));
        }
    }

    static class TPOnPropertyHandler
    extends AbstractTriplePredicateHandler {
        TPOnPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addOWLRestriction(subject, false);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }
    }

    static class TPOnDataRangeHandler
    extends AbstractTriplePredicateHandler {
        TPOnDataRangeHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addDataRange(object, true);
            return false;
        }
    }

    static class TPOnClassHandler
    extends AbstractTriplePredicateHandler {
        TPOnClassHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(object, false);
            return false;
        }
    }

    static class TPInverseOfHandler
    extends AbstractTriplePredicateHandler {
        private boolean axiomParsingMode = false;

        TPInverseOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI());
        }

        public boolean isAxiomParsingMode() {
            return this.axiomParsingMode;
        }

        public void setAxiomParsingMode(boolean axiomParsingMode) {
            this.axiomParsingMode = axiomParsingMode;
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addObjectProperty(subject, false);
            this.consumer.addObjectProperty(object, false);
            return false;
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            return super.canHandle(subject, predicate, object) && this.consumer.isObjectProperty(subject) && this.consumer.isObjectProperty(object);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.axiomParsingMode && this.consumer.isObjectProperty(subject) && this.consumer.isObjectProperty(object)) {
                this.addAxiom((OWLAxiom)this.df.getOWLInverseObjectPropertiesAxiom(this.translateObjectProperty(subject), this.translateObjectProperty(object), this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TPIntersectionOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPIntersectionOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI());
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(IRI mainNode) {
            return this.df.getOWLObjectIntersectionOf(this.consumer.translatorAccessor.translateToClassExpressionSet(mainNode));
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isClassExpression(subject)) {
                this.consumer.addClassExpression(object, false);
            } else if (this.consumer.isClassExpression(object)) {
                this.consumer.addClassExpression(subject, false);
            } else if (this.consumer.isDataRange(subject)) {
                this.consumer.addDataRange(object, false);
            } else if (this.consumer.isDataRange(object)) {
                this.consumer.addDataRange(subject, false);
            }
            return super.canHandleStreaming(subject, predicate, object);
        }
    }

    static class TPImportsHandler
    extends AbstractTriplePredicateHandler {
        TPImportsHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_IMPORTS.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            this.consumer.addOntology(subject);
            this.consumer.addOntology(object);
            OWLImportsDeclaration importsDeclaration = this.df.getOWLImportsDeclaration(object);
            this.consumer.addImport(importsDeclaration);
            if (!this.consumer.getConfiguration().isIgnoredImport(object)) {
                OWLDocumentFormat importedOntologyFormat;
                OWLOntologyManager man = this.consumer.getOWLOntologyManager();
                man.makeLoadImportRequest(importsDeclaration, this.consumer.getConfiguration());
                OWLOntology importedOntology = man.getImportedOntology(importsDeclaration);
                if (importedOntology != null && (importedOntologyFormat = man.getOntologyFormat(importedOntology)) instanceof AbstractRDFPrefixDocumentFormat && importedOntology.isAnonymous() && this.consumer.getConfiguration().getMissingOntologyHeaderStrategy() == OWLOntologyLoaderConfiguration.MissingOntologyHeaderStrategy.INCLUDE_GRAPH) {
                    man.applyChange((OWLOntologyChange)new RemoveImport(this.consumer.getOntology(), importsDeclaration));
                    for (OWLImportsDeclaration decl : importedOntology.getImportsDeclarations()) {
                        assert (decl != null);
                        man.applyChange((OWLOntologyChange)new AddImport(this.consumer.getOntology(), decl));
                    }
                    for (OWLAnnotation anno : importedOntology.getAnnotations()) {
                        assert (anno != null);
                        man.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.consumer.getOntology(), anno));
                    }
                    for (OWLAxiom ax : importedOntology.getAxioms()) {
                        this.consumer.addAxiom(ax);
                    }
                    man.removeOntology(importedOntology);
                }
                this.consumer.importsClosureChanged();
            }
        }
    }

    static class TPHasValueHandler
    extends AbstractTriplePredicateHandler {
        TPHasValueHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addOWLRestriction(subject, false);
            return false;
        }
    }

    static class TPHasKeyHandler
    extends AbstractTriplePredicateHandler {
        private final OptimisedListTranslator<OWLPropertyExpression> listTranslator;

        TPHasKeyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_HAS_KEY.getIRI());
            this.listTranslator = Translators.getListTranslator(consumer);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(subject, false);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.consumer.isClassExpression(subject)) {
                this.consumeTriple(subject, predicate, object);
                OWLClassExpression ce = this.translateClassExpression(subject);
                Set<OWLPropertyExpression> props = this.listTranslator.translateToSet(object);
                this.addAxiom((OWLAxiom)this.df.getOWLHasKeyAxiom(ce, props, this.getPendingAnnotations()));
            }
        }
    }

    static class TPFirstResourceHandler
    extends AbstractTriplePredicateHandler {
        TPFirstResourceHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_FIRST.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.addFirst(subject, object);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPFirstLiteralHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        TPFirstLiteralHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandle(IRI subject, @Nullable IRI predicate, OWLLiteral object) {
            return predicate != null && predicate.equals((Object)OWLRDFVocabulary.RDF_FIRST.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, @Nullable IRI predicate, OWLLiteral object) {
            return predicate != null && predicate.equals((Object)OWLRDFVocabulary.RDF_FIRST.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, OWLLiteral object) {
            this.consumer.addFirst(subject, object);
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPEquivalentPropertyHandler
    extends AbstractTriplePredicateHandler {
        TPEquivalentPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            HashSet<Object> props;
            Set<OWLAnnotation> pendingAnnotations = this.getPendingAnnotations();
            if (this.consumer.isObjectProperty(subject) && this.consumer.isObjectProperty(object)) {
                props = new HashSet<Object>();
                props.add(this.translateObjectProperty(subject));
                props.add(this.translateObjectProperty(object));
                this.addAxiom((OWLAxiom)this.df.getOWLEquivalentObjectPropertiesAxiom(props, pendingAnnotations));
                this.consumeTriple(subject, predicate, object);
            }
            if (this.consumer.isDataProperty(subject) && this.consumer.isDataProperty(object)) {
                props = new HashSet();
                props.add(this.translateDataProperty(subject));
                props.add(this.translateDataProperty(object));
                this.addAxiom((OWLAxiom)this.df.getOWLEquivalentDataPropertiesAxiom(props, pendingAnnotations));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TPEquivalentClassHandler
    extends AbstractTriplePredicateHandler {
        TPEquivalentClassHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            this.inferTypes(subject, object);
            return super.canHandle(subject, predicate, object) && this.isSubjectAndObjectMatchingClassExpressionOrMatchingDataRange(subject, object);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.inferTypes(subject, object);
            return !this.isStrict() && !this.isSubjectOrObjectAnonymous(subject, object) && this.isSubjectAndObjectMatchingClassExpressionOrMatchingDataRange(subject, object);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (this.isStrict()) {
                if (this.isClassExpressionStrict(subject) && this.isClassExpressionStrict(object)) {
                    this.translateEquivalentClasses(subject, predicate, object);
                } else if (this.isDataRangeStrict(subject) && this.isDataRangeStrict(object)) {
                    this.translateEquivalentDataRanges(subject, predicate, object);
                }
            } else if (this.isClassExpressionLax(subject) && this.isClassExpressionLax(object)) {
                this.translateEquivalentClasses(subject, predicate, object);
            } else if (this.isDataRangeLax(subject) || this.isDataRangeLax(object)) {
                this.translateEquivalentDataRanges(subject, predicate, object);
            }
        }

        private void translateEquivalentDataRanges(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            OWLDatatype datatype = this.df.getOWLDatatype(subject);
            OWLDataRange dataRange = this.consumer.translateDataRange(object);
            OWLDatatypeDefinitionAxiom def = this.df.getOWLDatatypeDefinitionAxiom(datatype, dataRange, this.getPendingAnnotations());
            this.addAxiom((OWLAxiom)def);
            this.consumeTriple(subject, predicate, object);
        }

        private void translateEquivalentClasses(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
            operands.add(this.translateClassExpression(subject));
            operands.add(this.translateClassExpression(object));
            this.addAxiom((OWLAxiom)this.df.getOWLEquivalentClassesAxiom(operands, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPDisjointWithHandler
    extends AbstractTriplePredicateHandler {
        TPDisjointWithHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(subject, false);
            this.consumer.addClassExpression(object, false);
            return !this.isSubjectOrObjectAnonymous(subject, object) && this.isSubjectAndObjectClassExpression(subject, object);
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            return super.canHandle(subject, predicate, object) && this.isSubjectAndObjectClassExpression(subject, object);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
            operands.add(this.translateClassExpression(subject));
            operands.add(this.translateClassExpression(object));
            this.addAxiom((OWLAxiom)this.df.getOWLDisjointClassesAxiom(operands, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class TPDisjointUnionHandler
    extends AbstractTriplePredicateHandler {
        TPDisjointUnionHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            return super.canHandle(subject, predicate, object) && !this.consumer.isAnonymousNode(subject) && this.consumer.isClassExpression(subject);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(subject, false);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            if (!this.consumer.isAnonymousNode(subject)) {
                OWLClass cls = (OWLClass)this.translateClassExpression(subject);
                Set<OWLClassExpression> classExpressions = this.consumer.translatorAccessor.translateToClassExpressionSet(object);
                this.addAxiom((OWLAxiom)this.df.getOWLDisjointUnionAxiom(cls, classExpressions, this.getPendingAnnotations()));
                this.consumeTriple(subject, predicate, object);
            }
        }
    }

    static class TPDifferentFromHandler
    extends AbstractTriplePredicateHandler {
        TPDifferentFromHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DIFFERENT_FROM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, IRI predicate, @Nonnull IRI object) {
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(this.translateIndividual(subject));
            inds.add(this.translateIndividual(object));
            this.addAxiom((OWLAxiom)this.df.getOWLDifferentIndividualsAxiom(inds, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    @Deprecated
    static class TPDeclaredAsHandler
    extends AbstractTriplePredicateHandler {
        TPDeclaredAsHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, DeprecatedVocabulary.OWL_DECLARED_AS);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, @Nonnull IRI object) {
            if (object.equals((Object)OWLRDFVocabulary.OWL_CLASS.getIRI())) {
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)this.df.getOWLClass(subject), this.getPendingAnnotations()));
            } else if (object.equals((Object)OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI())) {
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)this.df.getOWLObjectProperty(subject), this.getPendingAnnotations()));
            } else if (object.equals((Object)OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI())) {
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)this.df.getOWLDataProperty(subject), this.getPendingAnnotations()));
            } else if (object.equals((Object)OWLRDFVocabulary.OWL_DATATYPE.getIRI())) {
                this.addAxiom((OWLAxiom)this.df.getOWLDeclarationAxiom((OWLEntity)this.df.getOWLDatatype(subject), this.getPendingAnnotations()));
            }
        }
    }

    static class TPDatatypeComplementOfHandler
    extends AbstractTriplePredicateHandler {
        TPDatatypeComplementOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF.getIRI());
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addDataRange(subject, false);
            this.consumer.addDataRange(object, false);
            return false;
        }
    }

    static class TPComplementOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPComplementOfHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addClassExpression(subject, false);
            this.consumer.addClassExpression(object, false);
            return super.canHandleStreaming(subject, predicate, object);
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(@Nonnull IRI mainNode) {
            return this.df.getOWLObjectComplementOf(this.consumer.translatorAccessor.translateClassExpression(mainNode));
        }
    }

    static class TPAnnotatedTargetHandler
    extends AbstractTriplePredicateHandler {
        TPAnnotatedTargetHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addAnnotatedSource(object, subject);
            this.consumer.checkForAndProcessAnnotatedDeclaration(subject);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }
    }

    static class TPAnnotatedSourceHandler
    extends AbstractTriplePredicateHandler {
        TPAnnotatedSourceHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addAnnotatedSource(object, subject);
            this.consumer.checkForAndProcessAnnotatedDeclaration(subject);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }
    }

    static class TPAnnotatedPropertyHandler
    extends AbstractTriplePredicateHandler {
        TPAnnotatedPropertyHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addAnnotatedSource(object, subject);
            this.consumer.checkForAndProcessAnnotatedDeclaration(subject);
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }
    }

    static class TPAllValuesFromHandler
    extends AbstractTriplePredicateHandler {
        TPAllValuesFromHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            this.consumer.addOWLRestriction(subject, false);
            IRI propIRI = this.consumer.getResourceObject(subject, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), false);
            if (!(propIRI == null || this.consumer.isAnonymousNode(object) && this.consumer.translatorAccessor.getClassExpressionIfTranslated(object) == null)) {
                if (this.consumer.isObjectPropertyOnly(propIRI)) {
                    this.consumer.addClassExpression(object, false);
                    this.consumer.addTriple(subject, predicate, object);
                    this.consumer.translatorAccessor.translateClassExpression(subject);
                    return true;
                }
                if (this.consumer.isDataPropertyOnly(propIRI)) {
                    // empty if block
                }
            }
            return false;
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }
    }

    static class SKOSClassTripleHandler
    extends AbstractBuiltInTypeHandler {
        SKOSClassTripleHandler(@Nonnull OWLRDFConsumer consumer, @Nonnull SKOSVocabulary v) {
            super(consumer, v.getIRI());
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            OWLNamedIndividual ind = this.df.getOWLNamedIndividual(subject);
            OWLClass skosConcept = this.df.getOWLClass(object);
            this.addAxiom((OWLAxiom)this.df.getOWLClassAssertionAxiom((OWLClassExpression)skosConcept, (OWLIndividual)ind));
        }
    }

    static class GTPResourceTripleHandler
    extends AbstractResourceTripleHandler {
        GTPResourceTripleHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, IRI object) {
            return false;
        }
    }

    static class GTPObjectPropertyAssertionHandler
    extends AbstractResourceTripleHandler {
        GTPObjectPropertyAssertionHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, IRI object) {
            if (this.isStrict()) {
                return this.isObjectPropertyStrict(predicate);
            }
            return this.isObjectPropertyLax(predicate) && !this.isAnnotationPropertyOnly(predicate);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, IRI predicate, @Nonnull IRI object) {
            if (this.consumer.isObjectProperty(predicate)) {
                this.consumeTriple(subject, predicate, object);
                this.addAxiom((OWLAxiom)this.df.getOWLObjectPropertyAssertionAxiom(this.translateObjectProperty(predicate), this.translateIndividual(subject), this.translateIndividual(object), this.getPendingAnnotations()));
            }
        }
    }

    static class GTPLiteralTripleHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        GTPLiteralTripleHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, OWLLiteral object) {
            if (this.isStrict() || this.isAnnotationPropertyLax(predicate)) {
                // empty if block
            }
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, OWLLiteral object) {
            if (this.isStrict()) {
                return false;
            }
            return this.isAnnotationPropertyLax(predicate);
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, OWLLiteral object) {
            return this.isAnnotationPropertyStrict(predicate) || this.isDataPropertyStrict(predicate);
        }
    }

    static class GTPDataPropertyAssertionHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        GTPDataPropertyAssertionHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, OWLLiteral object) {
            if (this.isStrict()) {
                return this.isDataPropertyStrict(predicate);
            }
            return this.isDataPropertyLax(predicate) && !this.consumer.isAnnotationProperty(predicate);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, OWLLiteral object) {
            return false;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, IRI predicate, OWLLiteral object) {
            this.addAxiom((OWLAxiom)this.df.getOWLDataPropertyAssertionAxiom(this.translateDataProperty(predicate), this.translateIndividual(subject), object, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class GTPAnnotationResourceTripleHandler
    extends AbstractResourceTripleHandler {
        GTPAnnotationResourceTripleHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            boolean builtInAnnotationProperty = OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS.contains(predicate);
            return !this.consumer.isAxiom(subject) && !this.consumer.isAnnotation(subject) && (builtInAnnotationProperty || !predicate.isReservedVocabulary());
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, IRI predicate, @Nonnull IRI object) {
            Object value = this.isAnonymous(object) ? this.consumer.getOWLAnonymousIndividual(object.toString()) : object;
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(predicate);
            OWLAnnotation anno = this.df.getOWLAnnotation(prop, (OWLAnnotationValue)value);
            Object annoSubject = this.isAnonymous(subject) ? this.consumer.getOWLAnonymousIndividual(subject.toString()) : subject;
            if (this.consumer.isOntology(subject)) {
                this.consumer.addOntologyAnnotation(anno);
            } else {
                OWLAnnotationAssertionAxiom decAx = this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)annoSubject, anno, this.getPendingAnnotations());
                this.addAxiom((OWLAxiom)decAx);
            }
            this.consumeTriple(subject, predicate, object);
        }
    }

    static class GTPAnnotationLiteralHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        GTPAnnotationLiteralHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, OWLLiteral object) {
            return false;
        }

        @Override
        public boolean canHandle(IRI subject, IRI predicate, OWLLiteral object) {
            if (this.isStrict()) {
                return this.isAnnotationPropertyOnly(predicate);
            }
            boolean axiom = this.consumer.isAxiom(subject);
            if (axiom) {
                return false;
            }
            boolean annotation = this.consumer.isAnnotation(subject);
            if (annotation) {
                return false;
            }
            if (this.consumer.isAnnotationProperty(predicate)) {
                return true;
            }
            if (!this.isAnonymous(subject)) {
                if (this.isClassExpressionLax(subject)) {
                    return true;
                }
                if (this.isDataRangeLax(subject)) {
                    return true;
                }
                if (this.isObjectPropertyLax(subject)) {
                    return true;
                }
                return this.isDataPropertyLax(subject);
            }
            return true;
        }

        @Override
        public void handleTriple(@Nonnull IRI subject, IRI predicate, OWLLiteral object) {
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(predicate);
            Object annotationSubject = this.isAnonymous(subject) ? this.consumer.getOWLAnonymousIndividual(subject.toString()) : subject;
            if (this.consumer.isOntology(subject)) {
                this.anns(subject);
                Set<OWLAnnotation> anns = this.getPendingAnnotations();
                anns.forEach(this.consumer::addOntologyAnnotation);
                if (anns.isEmpty()) {
                    this.consumer.addOntologyAnnotation(this.df.getOWLAnnotation(prop, (OWLAnnotationValue)object));
                }
            } else {
                OWLAnnotationAssertionAxiom ax = this.df.getOWLAnnotationAssertionAxiom(prop, (OWLAnnotationSubject)annotationSubject, (OWLAnnotationValue)object, this.getPendingAnnotations());
                this.addAxiom((OWLAxiom)ax);
            }
            this.consumeTriple(subject, predicate, object);
        }
    }

    static abstract class AbstractBuiltInTypeHandler
    extends AbstractTriplePredicateHandler
    implements BuiltInTypeHandler {
        private final IRI typeIRI;

        protected AbstractBuiltInTypeHandler(@Nonnull OWLRDFConsumer consumer, IRI typeIRI) {
            super(consumer, OWLRDFVocabulary.RDF_TYPE.getIRI());
            this.typeIRI = typeIRI;
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return true;
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            return predicate.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI()) && object.equals((Object)this.typeIRI);
        }

        @Override
        public IRI getTypeIRI() {
            return this.typeIRI;
        }
    }

    static class AbstractTripleHandler {
        @Nonnull
        protected final OWLRDFConsumer consumer;
        @Nonnull
        private final ClassExpressionMatcher classExpressionMatcher = new ClassExpressionMatcher();
        @Nonnull
        private final DataRangeMatcher dataRangeMatcher = new DataRangeMatcher();
        @Nonnull
        private final IndividualMatcher individualMatcher = new IndividualMatcher();
        protected final OWLDataFactory df;

        protected AbstractTripleHandler(@Nonnull OWLRDFConsumer consumer) {
            this.consumer = consumer;
            this.df = consumer.getDataFactory();
        }

        @Nonnull
        protected Set<OWLAnnotation> getPendingAnnotations() {
            return this.consumer.getPendingAnnotations();
        }

        protected void anns(IRI subject) {
            this.consumer.addPendingAnnotations(this.consumer.translateAnnotations(subject));
        }

        protected void consumeTriple(IRI subject, IRI predicate, IRI object) {
            this.consumer.consumeTriple(subject, predicate, object);
        }

        protected void consumeTriple(IRI subject, IRI predicate, OWLLiteral object) {
            this.consumer.consumeTriple(subject, predicate, object);
        }

        protected boolean isStrict() {
            return this.consumer.getConfiguration().isStrict();
        }

        protected boolean isObjectPropertyOnly(IRI iri) {
            return this.consumer.isObjectPropertyOnly(iri);
        }

        protected boolean isDataPropertyOnly(IRI iri) {
            return this.consumer.isDataPropertyOnly(iri);
        }

        protected boolean isAnnotationPropertyOnly(IRI iri) {
            return this.consumer.isAnnotationPropertyOnly(iri);
        }

        protected boolean isAnnotationPropertyStrict(IRI iri) {
            return this.consumer.isAnnotationPropertyOnly(iri);
        }

        protected boolean isAnnotationPropertyLax(IRI iri) {
            return this.consumer.isAnnotationProperty(iri);
        }

        protected void addAxiom(@Nonnull OWLAxiom axiom) {
            this.consumer.addAxiom(axiom);
        }

        @Nonnull
        protected OWLClassExpression translateClassExpression(@Nonnull IRI iri) {
            return this.consumer.translatorAccessor.translateClassExpression(iri);
        }

        @Nonnull
        protected OWLObjectPropertyExpression translateObjectProperty(@Nonnull IRI iri) {
            return this.consumer.translateObjectPropertyExpression(iri);
        }

        @Nonnull
        protected OWLDataPropertyExpression translateDataProperty(@Nonnull IRI iri) {
            return this.consumer.translateDataPropertyExpression(iri);
        }

        @Nonnull
        protected OWLDataRange translateDataRange(@Nonnull IRI iri) {
            return this.consumer.translateDataRange(iri);
        }

        @Nonnull
        protected OWLIndividual translateIndividual(@Nonnull IRI iri) {
            return this.consumer.translateIndividual(iri);
        }

        protected boolean isAnonymous(@Nonnull IRI node) {
            return this.consumer.isAnonymousNode(node);
        }

        protected boolean isResourcePresent(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            return this.consumer.getResourceObject(mainNode, predicate, false) != null;
        }

        protected boolean isLiteralPresent(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            return this.consumer.getLiteralObject(mainNode, predicate, false) != null;
        }

        protected boolean isRestrictionStrict(@Nonnull IRI node) {
            return this.consumer.isRestriction(node);
        }

        protected boolean isRestrictionLax(@Nonnull IRI node) {
            return this.consumer.isRestriction(node);
        }

        protected boolean isNonNegativeIntegerStrict(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, false);
            if (literal == null) {
                return false;
            }
            OWLDatatype datatype = literal.getDatatype();
            OWL2Datatype nni = OWL2Datatype.XSD_NON_NEGATIVE_INTEGER;
            return datatype.getIRI().equals((Object)nni.getIRI()) && nni.isInLexicalSpace(literal.getLiteral());
        }

        protected boolean isNonNegativeIntegerLax(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, false);
            if (literal == null) {
                return false;
            }
            return OWL2Datatype.XSD_INTEGER.isInLexicalSpace((String)OWLAPIPreconditions.verifyNotNull((Object)literal.getLiteral().trim()));
        }

        protected int translateInteger(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, predicate, true);
            if (literal == null) {
                return 0;
            }
            try {
                return Integer.parseInt(literal.getLiteral().trim());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        protected boolean isClassExpressionStrict(@Nonnull IRI node) {
            return this.consumer.isClassExpression(node) && !this.consumer.isDataRange(node);
        }

        protected boolean isClassExpressionStrict(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isClassExpressionStrict(object);
        }

        protected boolean isClassExpressionLax(@Nonnull IRI mainNode) {
            return this.consumer.isClassExpression(mainNode) || this.consumer.isParsedAllTriples() && !this.consumer.isDataRange(mainNode);
        }

        protected boolean isClassExpressionLax(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isClassExpressionLax(object);
        }

        protected boolean isObjectPropertyStrict(@Nonnull IRI node) {
            return this.consumer.isObjectPropertyOnly(node);
        }

        protected boolean isObjectPropertyStrict(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isObjectPropertyStrict(object);
        }

        protected boolean isObjectPropertyLax(@Nonnull IRI node) {
            return this.consumer.isObjectProperty(node);
        }

        protected boolean isObjectPropertyLax(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isObjectPropertyLax(object);
        }

        protected boolean isDataPropertyStrict(@Nonnull IRI node) {
            return this.consumer.isDataPropertyOnly(node);
        }

        protected boolean isDataPropertyStrict(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isDataPropertyStrict(object);
        }

        protected boolean isDataPropertyLax(@Nonnull IRI node) {
            return this.consumer.isDataProperty(node);
        }

        protected boolean isDataPropertyLax(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isDataPropertyLax(object);
        }

        protected boolean isDataRangeStrict(@Nonnull IRI node) {
            return this.consumer.isDataRange(node) && !this.consumer.isClassExpression(node);
        }

        protected boolean isDataRangeStrict(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            assert (object != null);
            return this.isDataRangeStrict(object);
        }

        protected boolean isDataRangeLax(@Nonnull IRI node) {
            return this.consumer.isDataRange(node);
        }

        protected boolean isDataRangeLax(@Nonnull IRI mainNode, @Nonnull OWLRDFVocabulary predicate) {
            IRI object = this.consumer.getResourceObject(mainNode, predicate, false);
            return object != null && this.isDataRangeLax(mainNode);
        }

        protected boolean isClassExpressionListStrict(@Nonnull IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.classExpressionMatcher, minSize);
        }

        protected boolean isDataRangeListStrict(@Nonnull IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.dataRangeMatcher, minSize);
        }

        protected boolean isIndividualListStrict(@Nonnull IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.individualMatcher, minSize);
        }

        protected boolean isResourceListStrict(@Nullable IRI mainNode, @Nonnull TypeMatcher typeMatcher, int minSize) {
            if (mainNode == null) {
                return false;
            }
            IRI currentListNode = mainNode;
            HashSet<IRI> visitedListNodes = new HashSet<IRI>();
            int size = 0;
            IRI firstObject;
            while ((firstObject = this.consumer.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_FIRST, false)) != null) {
                if (!typeMatcher.isTypeStrict(firstObject)) {
                    return false;
                }
                ++size;
                IRI restObject = this.consumer.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_REST, false);
                if (visitedListNodes.contains(restObject)) {
                    return false;
                }
                if (restObject == null) {
                    return false;
                }
                if (restObject.equals((Object)OWLRDFVocabulary.RDF_NIL.getIRI())) {
                    return size >= minSize;
                }
                visitedListNodes.add(restObject);
                currentListNode = restObject;
            }
            return false;
        }

        class IndividualMatcher
        implements TypeMatcher {
            IndividualMatcher() {
            }

            @Override
            public boolean isTypeStrict(@Nonnull IRI node) {
                return true;
            }
        }

        class DataRangeMatcher
        implements TypeMatcher {
            DataRangeMatcher() {
            }

            @Override
            public boolean isTypeStrict(@Nonnull IRI node) {
                return AbstractTripleHandler.this.isDataRangeStrict(node);
            }
        }

        class ClassExpressionMatcher
        implements TypeMatcher {
            ClassExpressionMatcher() {
            }

            @Override
            public boolean isTypeStrict(@Nonnull IRI node) {
                return AbstractTripleHandler.this.isClassExpressionStrict(node);
            }
        }
    }

    static abstract class AbstractResourceTripleHandler
    extends AbstractTripleHandler
    implements ResourceTripleHandler {
        protected AbstractResourceTripleHandler(@Nonnull OWLRDFConsumer consumer) {
            super(consumer);
        }

        protected boolean isSubjectOrObjectAnonymous(@Nonnull IRI subject, @Nonnull IRI object) {
            return this.isAnonymous(subject) || this.isAnonymous(object);
        }

        protected boolean isSubjectAndObjectMatchingClassExpressionOrMatchingDataRange(IRI subject, IRI object) {
            return this.isSubjectAndObjectClassExpression(subject, object) || this.isSubjectAndObjectDataRange(subject, object);
        }

        protected boolean isSubjectAndObjectDataRange(IRI subject, IRI object) {
            return this.consumer.isDataRange(subject) && this.consumer.isDataRange(object);
        }

        protected boolean isSubjectAndObjectClassExpression(IRI subject, IRI object) {
            return this.consumer.isClassExpression(subject) && this.consumer.isClassExpression(object);
        }

        protected void inferTypes(IRI subject, IRI object) {
            if (this.consumer.isClassExpression(object)) {
                this.consumer.addClassExpression(subject, false);
            } else if (this.consumer.isDataRange(object)) {
                this.consumer.addDataRange(subject, false);
            } else if (this.consumer.isClassExpression(subject)) {
                this.consumer.addClassExpression(object, false);
            } else if (this.consumer.isDataRange(subject)) {
                this.consumer.addDataRange(object, false);
            }
        }
    }

    static abstract class AbstractNamedEquivalentClassAxiomHandler
    extends AbstractTriplePredicateHandler {
        AbstractNamedEquivalentClassAxiomHandler(@Nonnull OWLRDFConsumer consumer, IRI predicateIRI) {
            super(consumer, predicateIRI);
        }

        @Override
        public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
            return false;
        }

        @Override
        public boolean canHandle(IRI subject, @Nonnull IRI predicate, IRI object) {
            return super.canHandle(subject, predicate, object) && !this.isAnonymous(subject);
        }

        @Override
        public void handleTriple(IRI subject, IRI predicate, IRI object) {
            this.consumeTriple(subject, predicate, object);
            HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
            operands.add(this.translateClassExpression(subject));
            operands.add(this.translateEquivalentClass(object));
            this.addAxiom((OWLAxiom)this.df.getOWLEquivalentClassesAxiom(operands));
        }

        protected abstract OWLClassExpression translateEquivalentClass(@Nonnull IRI var1);
    }

    static class HandlerAccessor {
        @Nonnull
        private final Map<IRI, BuiltInTypeHandler> builtInTypes;
        @Nonnull
        protected final Map<IRI, BuiltInTypeHandler> axiomTypes;
        @Nonnull
        protected final Map<IRI, TriplePredicateHandler> predicates;
        protected final List<LiteralTripleHandler> literals;
        protected final List<ResourceTripleHandler> resources;
        @Nonnull
        protected final TPInverseOfHandler inverseOf;
        @Nonnull
        private final TPTypeHandler nonBuiltInTypes;
        @Nonnull
        protected final OWLRDFConsumer consumer;

        HandlerAccessor(@Nonnull OWLRDFConsumer r) {
            this.consumer = r;
            this.builtInTypes = HandlerAccessor.getBasicTypeHandlers(r, r.getConfiguration());
            this.axiomTypes = HandlerAccessor.getAxiomTypeHandlers(r);
            this.inverseOf = new TPInverseOfHandler(r);
            this.nonBuiltInTypes = new TPTypeHandler(r);
            this.predicates = this.getPredicateHandlers(r);
            this.literals = HandlerAccessor.getLiteralTripleHandlers(r);
            this.resources = HandlerAccessor.getResourceTripleHandlers(r);
        }

        void apply(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull OWLLiteral object) {
            if (OWLRDFConsumer.isGeneralPredicate(predicate)) {
                for (LiteralTripleHandler lhandler : this.literals) {
                    if (!lhandler.canHandle(subject, predicate, object)) continue;
                    lhandler.handleTriple(subject, predicate, object);
                    return;
                }
            }
        }

        void apply(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            if (OWLRDFConsumer.isGeneralPredicate(predicate)) {
                for (ResourceTripleHandler handler : this.resources) {
                    if (!handler.canHandle(subject, predicate, object)) continue;
                    handler.handleTriple(subject, predicate, object);
                    return;
                }
            }
        }

        void applyAnnotations(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            BuiltInTypeHandler builtInTypeHandler = this.axiomTypes.get(object);
            if (builtInTypeHandler != null && builtInTypeHandler.canHandle(subject, predicate, object)) {
                builtInTypeHandler.handleTriple(subject, predicate, object);
            }
        }

        public void consumeNonReservedPredicateTriples() {
            this.consumer.iterateResourceTriples((subject, predicate, object) -> this.apply(subject, predicate, object));
            this.consumer.iterateLiteralTriples((subject, predicate, object) -> this.apply(subject, predicate, object));
        }

        public void consumeAnnotatedAxioms() {
            this.consumer.iterateResourceTriples((subject, predicate, object) -> this.applyAnnotations(subject, predicate, object));
        }

        public void handleStreaming(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            boolean consumed;
            block4: {
                block6: {
                    block2: {
                        block5: {
                            block3: {
                                consumed = false;
                                if (!predicate.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI())) break block2;
                                BuiltInTypeHandler handler = this.builtInTypes.get(object);
                                if (handler == null) break block3;
                                if (!handler.canHandleStreaming(subject, predicate, object)) break block4;
                                handler.handleTriple(subject, predicate, object);
                                consumed = true;
                                break block4;
                            }
                            if (this.axiomTypes.get(object) != null) break block5;
                            this.consumer.addOWLNamedIndividual(subject, false);
                            if (!this.nonBuiltInTypes.canHandleStreaming(subject, predicate, object)) break block4;
                            this.nonBuiltInTypes.handleTriple(subject, predicate, object);
                            consumed = true;
                            break block4;
                        }
                        this.consumer.addAxiom(subject);
                        break block4;
                    }
                    ResourceTripleHandler handler = this.predicates.get(predicate);
                    if (handler == null) break block6;
                    if (!handler.canHandleStreaming(subject, predicate, object)) break block4;
                    handler.handleTriple(subject, predicate, object);
                    consumed = true;
                    break block4;
                }
                for (ResourceTripleHandler resHandler : this.resources) {
                    if (!resHandler.canHandleStreaming(subject, predicate, object)) continue;
                    resHandler.handleTriple(subject, predicate, object);
                    consumed = true;
                    break;
                }
            }
            if (!consumed) {
                this.consumer.addTriple(subject, predicate, object);
            }
        }

        public void handleStreaming(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull String literal, IRI datatype, String lang) {
            OWLLiteral con = this.consumer.getOWLLiteral(literal, datatype, lang);
            this.handleStreaming(subject, predicate, con);
        }

        private void handleStreaming(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull OWLLiteral con) {
            for (LiteralTripleHandler handler : this.literals) {
                if (!handler.canHandleStreaming(subject, predicate, con)) continue;
                handler.handleTriple(subject, predicate, con);
                return;
            }
            this.consumer.addTriple(subject, predicate, con);
        }

        protected void handle(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
            block5: {
                block3: {
                    block4: {
                        if (!predicate.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI())) break block3;
                        BuiltInTypeHandler typeHandler = this.builtInTypes.get(object);
                        if (typeHandler == null) break block4;
                        typeHandler.handleTriple(subject, predicate, object);
                        break block5;
                    }
                    if (this.axiomTypes.get(object) != null) break block5;
                    OWLIndividual ind = this.consumer.translateIndividual(subject);
                    OWLClassExpression ce = this.consumer.translatorAccessor.translateClassExpression(object);
                    this.consumer.addAxiom((OWLAxiom)this.consumer.getDataFactory().getOWLClassAssertionAxiom(ce, ind, this.consumer.getPendingAnnotations()));
                    break block5;
                }
                TriplePredicateHandler handler = this.predicates.get(predicate);
                if (handler != null && handler.canHandle(subject, predicate, object)) {
                    handler.handleTriple(subject, predicate, object);
                } else {
                    for (ResourceTripleHandler resHandler : this.resources) {
                        if (!resHandler.canHandle(subject, predicate, object)) continue;
                        resHandler.handleTriple(subject, predicate, object);
                        break;
                    }
                }
            }
        }

        protected void handle(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull OWLLiteral object) {
            for (LiteralTripleHandler handler : this.literals) {
                if (!handler.canHandle(subject, predicate, object)) continue;
                handler.handleTriple(subject, predicate, object);
                break;
            }
        }

        @Nonnull
        public Set<RDFTriple> mopUp() {
            this.consumer.iterateResourceTriples((subject, predicate, object) -> {
                TriplePredicateHandler propertyRangeHandler = this.predicates.get(OWLRDFVocabulary.RDFS_RANGE.getIRI());
                if (propertyRangeHandler.canHandle(subject, predicate, object)) {
                    propertyRangeHandler.handleTriple(subject, predicate, object);
                }
            });
            this.consumeNonReservedPredicateTriples();
            this.consumeAnnotatedAxioms();
            this.consumer.iterateResourceTriples((subject, predicate, object) -> this.handle(subject, predicate, object));
            this.consumer.iterateLiteralTriples((subject, predicate, object) -> this.handle(subject, predicate, object));
            this.inverseOf.setAxiomParsingMode(true);
            this.consumer.iterateResourceTriples((subject, predicate, object) -> {
                if (this.inverseOf.canHandle(subject, predicate, object)) {
                    this.inverseOf.handleTriple(subject, predicate, object);
                }
            });
            return this.getRemainingTriples();
        }

        @Nonnull
        private Set<RDFTriple> getRemainingTriples() {
            HashSet<RDFTriple> remainingTriples = new HashSet<RDFTriple>();
            this.consumer.iterateResourceTriples((subject, predicate, object) -> remainingTriples.add(new RDFTriple(subject, this.consumer.isAnonymousNode(subject), this.consumer.isAxiomIRI(subject), predicate, object, this.consumer.isAnonymousNode(object), this.consumer.isAxiomIRI(object))));
            this.consumer.iterateLiteralTriples((subject, predicate, object) -> remainingTriples.add(new RDFTriple(subject, this.consumer.isAnonymousNode(subject), this.consumer.isAxiomIRI(subject), predicate, object)));
            return remainingTriples;
        }

        @Nonnull
        private static List<ResourceTripleHandler> getResourceTripleHandlers(@Nonnull OWLRDFConsumer r) {
            return CollectionFactory.list((Object[])new ResourceTripleHandler[]{new GTPObjectPropertyAssertionHandler(r), new GTPAnnotationResourceTripleHandler(r)});
        }

        @Nonnull
        protected Map<IRI, TriplePredicateHandler> getPredicateHandlers(@Nonnull OWLRDFConsumer r) {
            ConcurrentHashMap<IRI, TriplePredicateHandler> predicateHandlers = new ConcurrentHashMap<IRI, TriplePredicateHandler>();
            HandlerAccessor.add(predicateHandlers, new TPDifferentFromHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDisjointUnionHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDisjointWithHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPEquivalentClassHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPEquivalentPropertyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyDomainHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyRangeHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSameAsHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSubClassOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSubPropertyOfHandler(r));
            HandlerAccessor.add(predicateHandlers, this.nonBuiltInTypes);
            HandlerAccessor.add(predicateHandlers, new TPImportsHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPIntersectionOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPUnionOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPComplementOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPOneOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSomeValuesFromHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAllValuesFromHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPRestHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPFirstResourceHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDeclaredAsHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPHasKeyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPVersionIRIHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyChainAxiomHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAnnotatedSourceHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAnnotatedPropertyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAnnotatedTargetHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyDisjointWithHandler(r));
            HandlerAccessor.add(predicateHandlers, this.inverseOf);
            HandlerAccessor.add(predicateHandlers, new TPOnPropertyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPOnClassHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPOnDataRangeHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPComplementOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDatatypeComplementOfHandler(r));
            return predicateHandlers;
        }

        @Nonnull
        public static Map<IRI, BuiltInTypeHandler> getAxiomTypeHandlers(@Nonnull OWLRDFConsumer r) {
            ConcurrentHashMap<IRI, BuiltInTypeHandler> map = new ConcurrentHashMap<IRI, BuiltInTypeHandler>();
            HandlerAccessor.add(map, new TypeAxiomHandler(r));
            HandlerAccessor.add(map, new TypeAllDifferentHandler(r));
            HandlerAccessor.add(map, new TypeAllDisjointClassesHandler(r));
            HandlerAccessor.add(map, new TypeAllDisjointPropertiesHandler(r));
            HandlerAccessor.add(map, new TypeNegativePropertyAssertionHandler(r));
            return map;
        }

        @Nonnull
        public static List<LiteralTripleHandler> getLiteralTripleHandlers(@Nonnull OWLRDFConsumer r) {
            return CollectionFactory.list((Object[])new LiteralTripleHandler[]{new GTPDataPropertyAssertionHandler(r), new TPFirstLiteralHandler(r), new GTPAnnotationLiteralHandler(r)});
        }

        private static void add(@Nonnull Map<IRI, BuiltInTypeHandler> m, @Nonnull BuiltInTypeHandler h) {
            m.put(h.getTypeIRI(), h);
        }

        private static void add(@Nonnull Map<IRI, TriplePredicateHandler> map, @Nonnull TriplePredicateHandler h) {
            map.put(h.getPredicateIRI(), h);
        }

        @Nonnull
        public static Map<IRI, BuiltInTypeHandler> getBasicTypeHandlers(@Nonnull OWLRDFConsumer r, @Nonnull OWLOntologyLoaderConfiguration config) {
            ConcurrentHashMap<IRI, BuiltInTypeHandler> map = new ConcurrentHashMap<IRI, BuiltInTypeHandler>();
            HandlerAccessor.add(map, new TypeOntologyPropertyHandler(r));
            HandlerAccessor.add(map, new TypeAsymmetricPropertyHandler(r));
            HandlerAccessor.add(map, new TypeClassHandler(r));
            HandlerAccessor.add(map, new TypeObjectPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDataPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDatatypeHandler(r));
            HandlerAccessor.add(map, new TypeFunctionalPropertyHandler(r));
            HandlerAccessor.add(map, new TypeInverseFunctionalPropertyHandler(r));
            HandlerAccessor.add(map, new TypeIrreflexivePropertyHandler(r));
            HandlerAccessor.add(map, new TypeReflexivePropertyHandler(r));
            HandlerAccessor.add(map, new TypeSymmetricPropertyHandler(r));
            HandlerAccessor.add(map, new TypeTransitivePropertyHandler(r));
            HandlerAccessor.add(map, new TypeRestrictionHandler(r));
            HandlerAccessor.add(map, new TypeListHandler(r));
            HandlerAccessor.add(map, new TypeAnnotationPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDeprecatedClassHandler(r));
            HandlerAccessor.add(map, new TypeDeprecatedPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDataRangeHandler(r));
            HandlerAccessor.add(map, new TypeOntologyHandler(r));
            HandlerAccessor.add(map, new TypeNegativeDataPropertyAssertionHandler(r));
            HandlerAccessor.add(map, new TypeRDFSClassHandler(r));
            HandlerAccessor.add(map, new TypeSelfRestrictionHandler(r));
            HandlerAccessor.add(map, new TypePropertyHandler(r));
            HandlerAccessor.add(map, new TypeNamedIndividualHandler(r));
            HandlerAccessor.add(map, new TypeAnnotationHandler(r));
            if (!config.isStrict()) {
                HandlerAccessor.add(map, new TypeSWRLAtomListHandler(r));
                HandlerAccessor.add(map, new TypeSWRLBuiltInAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLBuiltInHandler(r));
                HandlerAccessor.add(map, new TypeSWRLClassAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLDataRangeAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLDataValuedPropertyAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLDifferentIndividualsAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLImpHandler(r));
                HandlerAccessor.add(map, new TypeSWRLIndividualPropertyAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLSameIndividualAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLVariableHandler(r));
            }
            return map;
        }
    }
}

