/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.latex.renderer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.latex.renderer.LatexBracketChecker;
import org.semanticweb.owlapi.latex.renderer.LatexWriter;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class LatexObjectVisitor
implements OWLObjectVisitor {
    @Nonnull
    private static final String AND = "\\ensuremath{\\sqcap}";
    @Nonnull
    public static final String OR = "\\ensuremath{\\sqcup}";
    @Nonnull
    public static final String NOT = "\\ensuremath{\\lnot}";
    @Nonnull
    public static final String ALL = "\\ensuremath{\\forall}";
    @Nonnull
    public static final String SOME = "\\ensuremath{\\exists}";
    @Nonnull
    public static final String HASVALUE = "\\ensuremath{hasValue}";
    @Nonnull
    public static final String MIN = "\\ensuremath{\\geq}";
    @Nonnull
    public static final String MAX = "\\ensuremath{\\leq}";
    @Nonnull
    public static final String MINEX = "\\ensuremath{>}";
    @Nonnull
    public static final String MAXEX = "\\ensuremath{<}";
    @Nonnull
    public static final String EQUAL = "\\ensuremath{=}";
    @Nonnull
    public static final String SUBCLASS = "\\ensuremath{\\sqsubseteq}";
    @Nonnull
    public static final String EQUIV = "\\ensuremath{\\equiv}";
    @Nonnull
    public static final String NOT_EQUIV = "\\ensuremath{\\not\\equiv}";
    @Nonnull
    public static final String TOP = "\\ensuremath{\\top}";
    @Nonnull
    public static final String BOTTOM = "\\ensuremath{\\bot}";
    @Nonnull
    public static final String SELF = "\\ensuremath{\\Self}";
    @Nonnull
    public static final String CIRC = "\\ensuremath{\\circ}";
    @Nonnull
    public static final String INVERSE = "\\ensuremath{^-}";
    private OWLObject subject;
    private final LatexWriter writer;
    private boolean prettyPrint = true;
    private final OWLDataFactory df;
    private ShortFormProvider shortFormProvider;

    public LatexObjectVisitor(LatexWriter writer, @Nonnull OWLDataFactory df) {
        this.writer = writer;
        this.df = df;
        this.shortFormProvider = new SimpleShortFormProvider();
        this.subject = df.getOWLThing();
    }

    public void setSubject(OWLObject subject) {
        this.subject = subject;
    }

    public void setShortFormProvider(ShortFormProvider shortFormProvder) {
        this.shortFormProvider = shortFormProvder;
    }

    private void writeSpace() {
        this.writer.writeSpace();
    }

    private void write(@Nonnull Object o) {
        this.writer.write(o);
    }

    private void write(int i) {
        this.writer.write(Integer.toString(i));
    }

    private void writeOpenBrace() {
        this.writer.writeOpenBrace();
    }

    private void writeCloseBrace() {
        this.writer.writeCloseBrace();
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void visit(OWLObjectIntersectionOf ce) {
        Iterator it = ce.getOperands().iterator();
        while (it.hasNext()) {
            ((OWLClassExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(AND);
            this.writeSpace();
        }
    }

    public void visit(OWLDataAllValuesFrom ce) {
        this.write(ALL);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataExactCardinality ce) {
        this.write(EQUAL);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataMaxCardinality ce) {
        this.write(MAX);
        this.writeSpace();
        this.write(ce.getCardinality());
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataMinCardinality ce) {
        this.write(MIN);
        this.writeSpace();
        this.write(ce.getCardinality());
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataSomeValuesFrom ce) {
        this.write(SOME);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataHasValue ce) {
        this.write(HASVALUE);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)ce.getFiller()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        this.write(ALL);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)ce.getFiller());
    }

    public void visit(OWLObjectExactCardinality ce) {
        this.write(EQUAL);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)ce.getFiller());
    }

    public void visit(OWLObjectMaxCardinality ce) {
        this.write(MAX);
        this.writeSpace();
        this.write(ce.getCardinality());
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)ce.getFiller());
    }

    public void visit(OWLObjectMinCardinality ce) {
        this.write(MIN);
        this.writeSpace();
        this.write(ce.getCardinality());
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)ce.getFiller());
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        this.write(SOME);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)ce.getFiller());
    }

    public void visit(OWLObjectHasValue ce) {
        this.write(SOME);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.writeOpenBrace();
        ((OWLIndividual)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.writeCloseBrace();
    }

    public void visit(OWLObjectComplementOf ce) {
        this.write(NOT);
        this.writeNested(ce.getOperand());
    }

    public void visit(OWLObjectUnionOf ce) {
        Iterator it = ce.getOperands().iterator();
        while (it.hasNext()) {
            ((OWLClassExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    public void visit(OWLClass ce) {
        this.write(LatexObjectVisitor.escapeName(this.shortFormProvider.getShortForm((OWLEntity)ce)));
    }

    public void visit(OWLObjectOneOf ce) {
        Iterator it = ce.getIndividuals().iterator();
        while (it.hasNext()) {
            this.writeOpenBrace();
            ((OWLIndividual)it.next()).accept((OWLObjectVisitor)this);
            this.writeCloseBrace();
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    public void visit(OWLDataProperty property) {
        this.write(LatexObjectVisitor.escapeName(this.shortFormProvider.getShortForm((OWLEntity)property)));
    }

    public void visit(OWLObjectProperty property) {
        this.write(LatexObjectVisitor.escapeName(this.shortFormProvider.getShortForm((OWLEntity)property)));
    }

    public void visit(OWLNamedIndividual individual) {
        this.write(LatexObjectVisitor.escapeName(this.shortFormProvider.getShortForm((OWLEntity)individual)));
    }

    public void visit(OWLObjectHasSelf ce) {
        this.write(SOME);
        this.writeSpace();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(SELF);
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() != 2) {
            for (OWLClassExpression left : axiom.getClassExpressions()) {
                for (OWLClassExpression right : axiom.getClassExpressions()) {
                    if (left == right) continue;
                    if (left.equals(this.subject)) {
                        left.accept((OWLObjectVisitor)this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        right.accept((OWLObjectVisitor)this);
                    } else {
                        right.accept((OWLObjectVisitor)this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        left.accept((OWLObjectVisitor)this);
                    }
                    this.writer.writeNewLine();
                }
            }
        } else {
            OWLClassExpression rhs;
            OWLClassExpression lhs;
            Iterator it = axiom.getClassExpressions().iterator();
            OWLClassExpression descA = (OWLClassExpression)it.next();
            OWLClassExpression descB = (OWLClassExpression)it.next();
            if (descA.equals(this.subject)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept((OWLObjectVisitor)this);
            this.writeSpace();
            this.write(SUBCLASS);
            this.writeSpace();
            this.write(NOT);
            this.writeSpace();
            rhs.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() > 2) {
            HashSet<Set> rendered = new HashSet<Set>();
            for (OWLClassExpression left : axiom.getClassExpressions()) {
                for (OWLClassExpression right : axiom.getClassExpressions()) {
                    Set cur;
                    if (left == right || rendered.contains(cur = CollectionFactory.createSet((Object[])new OWLClassExpression[]{left, right}))) continue;
                    rendered.add(cur);
                    left.accept((OWLObjectVisitor)this);
                    this.writeSpace();
                    this.write(EQUIV);
                    this.writeSpace();
                    right.accept((OWLObjectVisitor)this);
                }
            }
        } else if (axiom.getClassExpressions().size() == 2) {
            OWLClassExpression rhs;
            OWLClassExpression lhs;
            Iterator it = axiom.getClassExpressions().iterator();
            OWLClassExpression descA = (OWLClassExpression)it.next();
            OWLClassExpression descB = (OWLClassExpression)it.next();
            if (this.subject.equals(descA)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept((OWLObjectVisitor)this);
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
            rhs.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.setPrettyPrint(false);
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.setPrettyPrint(true);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(":");
        this.writeSpace();
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.write("AsymmetricProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write("(");
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)this.df.getTopDatatype()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        axiom.getSubProperty();
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.write("Declaration");
        axiom.getEntity().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        Iterator it = axiom.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("\\{");
            ((OWLIndividual)it.next()).accept((OWLObjectVisitor)this);
            this.write("\\}");
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLDataPropertyExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.write("DisjointObjectProperties");
        this.writeSpace();
        for (OWLObjectPropertyExpression p : axiom.getProperties()) {
            p.accept((OWLObjectVisitor)this);
            this.writeSpace();
        }
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.write("DisjointUnion");
        this.writeSpace();
        for (OWLClassExpression p : axiom.getClassExpressions()) {
            p.accept((OWLObjectVisitor)this);
            this.writeSpace();
        }
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.write("Annotation");
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getValue().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLDataPropertyExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLObjectPropertyExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLImportsDeclaration axiom) {
        this.write("ImportsDeclaration");
        axiom.getIRI().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        OWLObjectInverseOf prop = this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)axiom.getProperty());
        this.df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)prop).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.write(INVERSE);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.write("IrreflexiveObjectProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write("(");
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.write(", ");
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write("(");
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write("(");
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        Iterator it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            ((OWLObjectPropertyExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(CIRC);
            this.writeSpace();
        }
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.df.getOWLThing()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        axiom.getSubProperty();
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.write("ReflexiveProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        Iterator it = axiom.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("\\{");
            ((OWLIndividual)it.next()).accept((OWLObjectVisitor)this);
            this.write("\\}");
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write(INVERSE);
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.write("Datatype");
        axiom.getDatatype().accept((OWLObjectVisitor)this);
        this.write(EQUIV);
        axiom.getDataRange().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.write("TransitiveProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLRule rule) {
        this.write("SWRLRule");
        for (SWRLAtom a : rule.getHead()) {
            a.accept((OWLObjectVisitor)this);
        }
        this.write("\\rightarrow");
        for (SWRLAtom a : rule.getBody()) {
            a.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(SWRLVariable node) {
        this.write(node.getIRI());
    }

    private void writeNested(@Nonnull OWLClassExpression classExpression) {
        this.openBracket(classExpression);
        classExpression.accept((OWLObjectVisitor)this);
        this.closeBracket(classExpression);
    }

    private void writeNested(OWLObject expression) {
        expression.accept((OWLObjectVisitor)this);
    }

    private void openBracket(@Nonnull OWLClassExpression classExpression) {
        if (LatexBracketChecker.requiresBracket(classExpression)) {
            this.write("(");
        }
    }

    private void closeBracket(@Nonnull OWLClassExpression classExpression) {
        if (LatexBracketChecker.requiresBracket(classExpression)) {
            this.write(")");
        }
    }

    @Nonnull
    private static String escapeName(String name) {
        return name.replace("_", "\\_");
    }

    public void visit(OWLOntology ontology) {
    }

    public void visit(OWLObjectInverseOf property) {
        property.getInverse().accept((OWLObjectVisitor)this);
        this.write(INVERSE);
    }

    public void visit(OWLDataComplementOf node) {
        this.write(NOT);
        this.writeNested((OWLObject)node.getDataRange());
    }

    public void visit(OWLDataOneOf node) {
        Iterator it = node.getValues().iterator();
        while (it.hasNext()) {
            this.writeOpenBrace();
            ((OWLLiteral)it.next()).accept((OWLObjectVisitor)this);
            this.writeCloseBrace();
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    public void visit(OWLFacetRestriction node) {
        this.write("Facet");
        this.write(node.getFacet());
        node.getFacetValue().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDatatypeRestriction node) {
        this.write("DatatypeRestriction");
        node.getDatatype().accept((OWLObjectVisitor)this);
        for (OWLFacetRestriction r : node.getFacetRestrictions()) {
            this.writeSpace();
            r.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLDatatype node) {
        this.write("Datatype");
        this.write(node.getIRI());
    }

    public void visit(OWLLiteral node) {
        this.write("\"");
        this.write(node.getLiteral());
        this.write("\"\\^\\^");
        this.write(node.getDatatype().getIRI());
    }

    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLBuiltInAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
        for (SWRLDArgument d : node.getArguments()) {
            this.writeSpace();
            d.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(SWRLClassAtom node) {
        ((SWRLIArgument)node.getArgument()).accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLDataRangeAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        for (SWRLArgument a : node.getAllArguments()) {
            this.writeSpace();
            a.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLSameIndividualAtom node) {
        for (SWRLArgument a : node.getAllArguments()) {
            this.writeSpace();
            a.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLAnnotationProperty property) {
        this.write("AnnotationProperty");
        property.getIRI().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLAnnotation node) {
        this.write("Annotation");
        node.getProperty().getIRI().accept((OWLObjectVisitor)this);
        node.getValue().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.write("Domain");
        axiom.getProperty().getIRI().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.write("Range");
        axiom.getProperty().getIRI().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getRange().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        axiom.getSubProperty();
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLAnnotationValue value) {
        value.accept(new OWLAnnotationValueVisitor(){

            public void visit(IRI iri) {
                iri.accept((OWLObjectVisitor)LatexObjectVisitor.this);
            }

            public void visit(OWLAnonymousIndividual individual) {
                individual.accept((OWLObjectVisitor)LatexObjectVisitor.this);
            }

            public void visit(OWLLiteral literal) {
                literal.accept((OWLObjectVisitor)LatexObjectVisitor.this);
            }
        });
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this.write("HasKey");
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        for (OWLPropertyExpression p : axiom.getPropertyExpressions()) {
            this.writeSpace();
            p.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLDataIntersectionOf node) {
        Iterator it = node.getOperands().iterator();
        while (it.hasNext()) {
            ((OWLDataRange)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(AND);
            this.writeSpace();
        }
    }

    public void visit(OWLDataUnionOf node) {
        Iterator it = node.getOperands().iterator();
        while (it.hasNext()) {
            ((OWLDataRange)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.write(individual.getID().toString());
    }

    public void visit(IRI iri) {
        this.write(iri.getShortForm());
    }
}

