/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.rdf.model.RDFGraph;
import org.semanticweb.owlapi.rdf.model.RDFTranslator;
import org.semanticweb.owlapi.util.AxiomAppearance;
import org.semanticweb.owlapi.util.AxiomSubjectProviderEx;
import org.semanticweb.owlapi.util.IndividualAppearance;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAnonymousIndividualsWithMultipleOccurrences;
import org.semanticweb.owlapi.util.OWLObjectDesharer;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public abstract class RDFRendererBase {
    private static final String ANNOTATION_PROPERTIES_BANNER_TEXT = "Annotation properties";
    private static final String DATATYPES_BANNER_TEXT = "Datatypes";
    private static final String OBJECT_PROPERTIES_BANNER_TEXT = "Object Properties";
    private static final String DATA_PROPERTIES_BANNER_TEXT = "Data properties";
    private static final String CLASSES_BANNER_TEXT = "Classes";
    private static final String INDIVIDUALS_BANNER_TEXT = "Individuals";
    private static final String ANNOTATED_IRIS_BANNER_TEXT = "Annotations";
    private static final String GENERAL_AXIOMS_BANNER_TEXT = "General axioms";
    private static final String RULES_BANNER_TEXT = "Rules";
    protected final OWLOntology ontology;
    protected final OWLDataFactory df;
    protected final Set<IRI> prettyPrintedTypes = OWLAPIStreamUtils.asUnorderedSet(Stream.of(OWLRDFVocabulary.OWL_CLASS, OWLRDFVocabulary.OWL_OBJECT_PROPERTY, OWLRDFVocabulary.OWL_DATA_PROPERTY, OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY, OWLRDFVocabulary.OWL_RESTRICTION, OWLRDFVocabulary.OWL_THING, OWLRDFVocabulary.OWL_NOTHING, OWLRDFVocabulary.OWL_ONTOLOGY, OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY, OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL, OWLRDFVocabulary.RDFS_DATATYPE, OWLRDFVocabulary.OWL_AXIOM, OWLRDFVocabulary.OWL_ANNOTATION).map(a -> a.getIRI()));
    protected final IndividualAppearance occurrences;
    protected final AxiomAppearance axiomOccurrences;
    protected final OWLOntologyWriterConfiguration config;
    protected final Set<RDFResource> pending = new HashSet<RDFResource>();
    @Nullable
    private final OWLDocumentFormat format;
    private final Set<IRI> punned;
    @Nullable
    protected RDFGraph graph;
    @Nullable
    protected Map<RDFTriple, RDFResourceBlankNode> triplesWithRemappedNodes;
    private AtomicInteger nextBlankNodeId = new AtomicInteger(1);
    private final Map<Object, Integer> blankNodeMap = new IdentityHashMap<Object, Integer>();

    public RDFRendererBase(OWLOntology ontology) {
        this(ontology, ontology.getFormat(), ontology.getOWLOntologyManager().getOntologyWriterConfiguration());
    }

    protected RDFRendererBase(OWLOntology ontology, @Nullable OWLDocumentFormat format, OWLOntologyWriterConfiguration config) {
        this.ontology = ontology;
        this.config = config;
        OWLOntologyManager m = this.ontology.getOWLOntologyManager();
        this.df = m.getOWLDataFactory();
        this.format = format;
        if (m.getOntologyWriterConfiguration().shouldSaveIdsForAllAnonymousIndividuals()) {
            this.occurrences = x -> true;
            this.axiomOccurrences = x -> true;
        } else {
            OWLAnonymousIndividualsWithMultipleOccurrences visitor = new OWLAnonymousIndividualsWithMultipleOccurrences();
            this.occurrences = visitor;
            ontology.accept((OWLObjectVisitor)visitor);
            this.axiomOccurrences = x -> x.annotations().anyMatch(a -> a.annotations().count() > 0L);
        }
        this.punned = ontology.getPunnedIRIs(Imports.EXCLUDED);
    }

    protected abstract void beginDocument();

    protected abstract void endDocument();

    protected void beginObject() {
    }

    protected void endObject() {
    }

    protected abstract void writeAnnotationPropertyComment(OWLAnnotationProperty var1);

    protected abstract void writeDataPropertyComment(OWLDataProperty var1);

    protected abstract void writeObjectPropertyComment(OWLObjectProperty var1);

    protected abstract void writeClassComment(OWLClass var1);

    protected abstract void writeDatatypeComment(OWLDatatype var1);

    protected abstract void writeIndividualComments(OWLNamedIndividual var1);

    public void render() {
        this.graph = new RDFGraph();
        this.triplesWithRemappedNodes = this.getRDFGraph().computeRemappingForSharedNodes();
        this.beginDocument();
        this.renderOntologyHeader();
        this.renderOntologyComponents();
        this.endDocument();
    }

    private void renderOntologyComponents() {
        this.renderInOntologySignatureEntities(OWLDocumentFormat.determineIllegalPunnings((boolean)this.shouldInsertDeclarations(), (Stream)this.ontology.signature(), (Collection)this.ontology.getPunnedIRIs(Imports.INCLUDED)));
        this.renderAnonymousIndividuals();
        this.renderUntypedIRIAnnotationAssertions();
        this.renderGeneralAxioms();
        this.renderSWRLRules();
    }

    private void renderInOntologySignatureEntities(Collection<IRI> illegalPuns) {
        this.renderEntities(this.ontology.annotationPropertiesInSignature(), ANNOTATION_PROPERTIES_BANNER_TEXT, illegalPuns);
        this.renderEntities(this.ontology.datatypesInSignature(), DATATYPES_BANNER_TEXT, illegalPuns);
        this.renderEntities(this.ontology.objectPropertiesInSignature(), OBJECT_PROPERTIES_BANNER_TEXT, illegalPuns);
        this.renderEntities(this.ontology.dataPropertiesInSignature(), DATA_PROPERTIES_BANNER_TEXT, illegalPuns);
        this.renderEntities(this.ontology.classesInSignature(), CLASSES_BANNER_TEXT, illegalPuns);
        this.renderEntities(this.ontology.individualsInSignature(), INDIVIDUALS_BANNER_TEXT, illegalPuns);
    }

    private void renderEntities(Stream<? extends OWLEntity> entities, String bannerText, Collection<IRI> illegalPuns) {
        AtomicBoolean firstRendering = new AtomicBoolean(true);
        entities.sorted().filter(e -> this.createGraph((OWLEntity)e, illegalPuns)).forEach(e -> this.render((OWLEntity)e, firstRendering, bannerText));
    }

    private void render(OWLEntity entity, AtomicBoolean firstRendering, String bannerText) {
        if (this.config.shouldUseBanners() && firstRendering.getAndSet(false) && !bannerText.isEmpty()) {
            this.writeBanner(bannerText);
        }
        this.renderEntity(entity);
    }

    private void renderEntity(OWLEntity entity) {
        this.beginObject();
        this.writeEntityComment(entity);
        this.render((RDFResource)new RDFResourceIRI(entity.getIRI()), true);
        this.renderAnonRoots();
        this.endObject();
    }

    private void writeEntityComment(OWLEntity entity) {
        if (entity.isOWLClass()) {
            this.writeClassComment(entity.asOWLClass());
        } else if (entity.isOWLDatatype()) {
            this.writeDatatypeComment(entity.asOWLDatatype());
        } else if (entity.isOWLObjectProperty()) {
            this.writeObjectPropertyComment(entity.asOWLObjectProperty());
        } else if (entity.isOWLDataProperty()) {
            this.writeDataPropertyComment(entity.asOWLDataProperty());
        } else if (entity.isOWLAnnotationProperty()) {
            this.writeAnnotationPropertyComment(entity.asOWLAnnotationProperty());
        } else if (entity.isOWLNamedIndividual()) {
            this.writeIndividualComments(entity.asOWLNamedIndividual());
        }
    }

    private void addIfUntyped(OWLAnnotationSubject o, Collection<IRI> set) {
        IRI iri = (IRI)o;
        if (this.punned.contains(iri) || !this.ontology.containsEntityInSignature(iri)) {
            set.add(iri);
        }
    }

    private void renderUntypedIRIAnnotationAssertions() {
        HashSet annotatedIRIs = new HashSet();
        this.ontology.axioms(AxiomType.ANNOTATION_ASSERTION).filter(ax -> ((OWLAnnotationSubject)ax.getSubject()).isIRI()).forEach(ax -> this.addIfUntyped((OWLAnnotationSubject)ax.getSubject(), annotatedIRIs));
        if (!annotatedIRIs.isEmpty()) {
            this.writeBanner(ANNOTATED_IRIS_BANNER_TEXT);
            annotatedIRIs.stream().sorted().forEach(this::renderIRI);
        }
    }

    protected void renderIRI(IRI iri) {
        this.beginObject();
        this.createGraph(this.ontology.annotationAssertionAxioms((OWLAnnotationSubject)iri));
        this.render((RDFResource)new RDFResourceIRI(iri), true);
        this.renderAnonRoots();
        this.endObject();
    }

    private void renderAnonymousIndividuals() {
        this.ontology.referencedAnonymousIndividuals().forEach(this::renderAnon);
    }

    protected void renderAnon(OWLAnonymousIndividual anonInd) {
        ArrayList axioms = new ArrayList();
        if (this.ontology.referencingAxioms((OWLPrimitive)anonInd).filter(ax -> !(ax instanceof OWLDifferentIndividualsAxiom)).noneMatch(ax -> this.shouldNotRender(anonInd, axioms, (OWLAxiom)ax))) {
            this.createGraph(axioms.stream());
            this.renderAnonRoots();
        }
    }

    protected boolean shouldNotRender(OWLAnonymousIndividual anonInd, List<OWLAxiom> axioms, OWLAxiom ax) {
        if (!AxiomSubjectProviderEx.getSubject((OWLAxiom)ax).equals(anonInd)) {
            return true;
        }
        axioms.add(ax);
        return false;
    }

    private void renderSWRLRules() {
        List ruleAxioms = OWLAPIStreamUtils.asList(this.ontology.axioms(AxiomType.SWRL_RULE).sorted());
        this.createGraph(ruleAxioms.stream());
        if (!ruleAxioms.isEmpty()) {
            this.writeBanner(RULES_BANNER_TEXT);
            SWRLVariableExtractor variableExtractor = new SWRLVariableExtractor();
            ruleAxioms.forEach(rule -> {
                Collection cfr_ignored_0 = (Collection)rule.accept((SWRLObjectVisitorEx)variableExtractor);
            });
            variableExtractor.getVariables().forEach(var -> this.render((RDFResource)new RDFResourceIRI(var.getIRI()), true));
            this.renderAnonRoots();
        }
    }

    private void renderGeneralAxioms() {
        AtomicBoolean bannerWritten = new AtomicBoolean(false);
        this.getGeneralAxioms().forEach(ax -> this.renderGeneral(bannerWritten, (OWLAxiom)ax));
    }

    protected void renderGeneral(AtomicBoolean bannerWritten, OWLAxiom axiom) {
        this.createGraph((OWLObject)axiom);
        Set<RDFResourceBlankNode> rootNodes = this.getRDFGraph().getRootAnonymousNodes();
        if (!rootNodes.isEmpty()) {
            if (!bannerWritten.getAndSet(true)) {
                this.writeBanner(GENERAL_AXIOMS_BANNER_TEXT);
            }
            this.beginObject();
            this.renderAnonRoots();
            this.endObject();
        }
    }

    protected RDFGraph getRDFGraph() {
        return (RDFGraph)OWLAPIPreconditions.verifyNotNull((Object)this.graph, (String)"rdfGraph not initialised yet");
    }

    private List<OWLAxiom> getGeneralAxioms() {
        ArrayList<OWLAxiom> generalAxioms = new ArrayList<OWLAxiom>();
        OWLAPIStreamUtils.add(generalAxioms, (Stream)this.ontology.generalClassAxioms());
        OWLAPIStreamUtils.add(generalAxioms, (Stream)this.ontology.axioms(AxiomType.DIFFERENT_INDIVIDUALS));
        OWLAPIStreamUtils.add(generalAxioms, this.ontology.axioms(AxiomType.DISJOINT_CLASSES).filter(ax -> ax.classExpressions().count() > 2L));
        OWLAPIStreamUtils.add(generalAxioms, this.ontology.axioms(AxiomType.DISJOINT_OBJECT_PROPERTIES).filter(ax -> ax.properties().count() > 2L));
        OWLAPIStreamUtils.add(generalAxioms, this.ontology.axioms(AxiomType.DISJOINT_DATA_PROPERTIES).filter(ax -> ax.properties().count() > 2L));
        OWLAPIStreamUtils.add(generalAxioms, this.ontology.axioms(AxiomType.HAS_KEY).filter(ax -> ax.getClassExpression().isAnonymous()));
        generalAxioms.sort(null);
        return generalAxioms;
    }

    protected void renderOntologyHeader() {
        RDFResource node;
        RDFTranslator translator = new RDFTranslator(this.ontology.getOWLOntologyManager(), this.ontology, this.shouldInsertDeclarations(), this.occurrences, this.axiomOccurrences, this.nextBlankNodeId, this.blankNodeMap);
        this.graph = translator.getGraph();
        this.ontology.accept((OWLObjectVisitor)translator);
        if (!this.getRDFGraph().isEmpty() && (node = (RDFResource)translator.getMappedNode((OWLObject)this.ontology)) != null) {
            this.render(node);
        }
        this.triplesWithRemappedNodes = this.getRDFGraph().computeRemappingForSharedNodes();
    }

    protected void render(RDFResource node) {
        this.render(node, true);
        this.getRDFGraph().getSubjectsForObject(node).forEach(n -> this.render((RDFResource)n, true));
    }

    private boolean createGraph(OWLEntity entity, Collection<IRI> illegalPuns) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        OWLAPIStreamUtils.add(axioms, (Stream)this.ontology.declarationAxioms(entity));
        entity.accept((OWLEntityVisitor)new GraphVisitor(this.ontology, axioms, this::createGraph));
        if (axioms.isEmpty() && this.shouldInsertDeclarations() && !illegalPuns.contains(entity.getIRI()) && OWLDocumentFormat.isMissingType((OWLEntity)entity, (OWLOntology)this.ontology)) {
            axioms.add((OWLAxiom)this.df.getOWLDeclarationAxiom(entity));
        }
        if (!this.punned.contains(entity.getIRI())) {
            OWLAPIStreamUtils.add(axioms, (Stream)this.ontology.annotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI(), Imports.EXCLUDED));
        }
        this.createGraph(axioms.stream());
        return !axioms.isEmpty();
    }

    protected boolean shouldInsertDeclarations() {
        return this.format == null || ((OWLDocumentFormat)OWLAPIPreconditions.verifyNotNull((Object)this.format)).isAddMissingTypes();
    }

    protected void createGraph(Stream<? extends OWLObject> objects) {
        RDFTranslator translator = new RDFTranslator(this.ontology.getOWLOntologyManager(), this.ontology, this.shouldInsertDeclarations(), this.occurrences, this.axiomOccurrences, this.nextBlankNodeId, this.blankNodeMap);
        objects.sorted().forEach(obj -> this.deshare((OWLObject)obj).accept((OWLObjectVisitor)translator));
        this.graph = translator.getGraph();
        this.triplesWithRemappedNodes = this.getRDFGraph().computeRemappingForSharedNodes();
    }

    protected void createGraph(OWLObject o) {
        RDFTranslator translator = new RDFTranslator(this.ontology.getOWLOntologyManager(), this.ontology, this.shouldInsertDeclarations(), this.occurrences, this.axiomOccurrences, this.nextBlankNodeId, this.blankNodeMap);
        this.deshare(o).accept((OWLObjectVisitor)translator);
        this.graph = translator.getGraph();
        this.triplesWithRemappedNodes = this.getRDFGraph().computeRemappingForSharedNodes();
    }

    protected OWLObject deshare(OWLObject o) {
        if (o.hasSharedStructure()) {
            return (OWLObject)o.accept((OWLObjectVisitorEx)new OWLObjectDesharer(this.ontology.getOWLOntologyManager()));
        }
        return o;
    }

    protected abstract void writeBanner(String var1);

    public void renderAnonRoots() {
        this.getRDFGraph().getRootAnonymousNodes().stream().sorted().forEach(x -> this.render((RDFResource)x, true));
    }

    protected abstract void render(RDFResource var1, boolean var2);

    protected boolean isObjectList(RDFResource node) {
        for (RDFTriple triple : this.getRDFGraph().getTriplesForSubject((RDFNode)node)) {
            if (!triple.getPredicate().getIRI().equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !triple.getObject().getIRI().equals((Object)OWLRDFVocabulary.RDF_LIST.getIRI())) continue;
            ArrayList<RDFNode> items = new ArrayList<RDFNode>();
            this.toJavaList((RDFNode)node, items);
            return items.stream().noneMatch(RDFNode::isLiteral);
        }
        return false;
    }

    protected void toJavaList(RDFNode n, List<RDFNode> list) {
        RDFNode currentNode = n;
        while (currentNode != null) {
            for (RDFTriple triple : this.getRDFGraph().getTriplesForSubject(currentNode)) {
                if (!triple.getPredicate().getIRI().equals((Object)OWLRDFVocabulary.RDF_FIRST.getIRI())) continue;
                list.add(triple.getObject());
            }
            for (RDFTriple triple : this.getRDFGraph().getTriplesForSubject(currentNode)) {
                if (!triple.getPredicate().getIRI().equals((Object)OWLRDFVocabulary.RDF_REST.getIRI())) continue;
                if (!triple.getObject().isAnonymous()) {
                    if (!triple.getObject().getIRI().equals((Object)OWLRDFVocabulary.RDF_NIL.getIRI())) continue;
                    currentNode = null;
                    continue;
                }
                if (!(triple.getObject() instanceof RDFResource)) continue;
                currentNode = triple.getObject();
            }
        }
    }

    protected RDFTriple remapNodesIfNecessary(RDFResource node, RDFTriple triple) {
        RDFTriple tripleToRender = triple;
        RDFResourceBlankNode remappedNode = (RDFResourceBlankNode)((Map)OWLAPIPreconditions.verifyNotNull(this.triplesWithRemappedNodes, (String)"triplesWithRemappedNodes not initialised yet")).get(tripleToRender);
        if (remappedNode != null) {
            tripleToRender = new RDFTriple(tripleToRender.getSubject(), tripleToRender.getPredicate(), (RDFNode)remappedNode);
        }
        if (!node.equals(tripleToRender.getSubject())) {
            tripleToRender = new RDFTriple(node, tripleToRender.getPredicate(), tripleToRender.getObject());
        }
        return tripleToRender;
    }

    static final class GraphVisitor
    implements OWLEntityVisitor {
        private final List<OWLAxiom> axioms;
        private OWLOntology ontology;
        private Consumer<Stream<OWLAxiom>> graphCreation;

        GraphVisitor(OWLOntology ontology, List<OWLAxiom> axioms, Consumer<Stream<OWLAxiom>> graphCreation) {
            this.axioms = axioms;
            this.ontology = ontology;
            this.graphCreation = graphCreation;
        }

        static boolean inverse(OWLAxiom ax, OWLNamedIndividual i) {
            OWLObjectPropertyAssertionAxiom candidate;
            return ax instanceof OWLObjectPropertyAssertionAxiom && ((OWLObjectPropertyExpression)(candidate = (OWLObjectPropertyAssertionAxiom)ax).getProperty()).isAnonymous() && ((OWLIndividual)candidate.getObject()).equals(i);
        }

        public void visit(OWLClass cls) {
            OWLAPIStreamUtils.add(this.axioms, this.ontology.axioms(cls).filter(this::threewayDisjoint));
            OWLAPIStreamUtils.add(this.axioms, this.ontology.axioms(AxiomType.HAS_KEY).filter(ax -> ax.getClassExpression().equals(cls)));
        }

        public void visit(OWLDatatype datatype) {
            OWLAPIStreamUtils.add(this.axioms, (Stream)this.ontology.datatypeDefinitions(datatype));
            this.graphCreation.accept(this.axioms.stream());
        }

        public void visit(OWLNamedIndividual individual) {
            OWLAPIStreamUtils.add(this.axioms, this.ontology.axioms((OWLIndividual)individual).filter(ax -> !(ax instanceof OWLDifferentIndividualsAxiom)));
            OWLAPIStreamUtils.add(this.axioms, this.ontology.referencingAxioms((OWLPrimitive)individual).filter(ax -> GraphVisitor.inverse(ax, individual)));
        }

        public void visit(OWLDataProperty property) {
            OWLAPIStreamUtils.add(this.axioms, this.ontology.axioms(property).filter(this::threewayDisjointData));
        }

        public void visit(OWLObjectProperty property) {
            OWLAPIStreamUtils.add(this.axioms, this.ontology.axioms((OWLObjectPropertyExpression)property).filter(this::threewayDisjointObject));
            OWLAPIStreamUtils.add(this.axioms, this.ontology.axioms(AxiomType.SUB_PROPERTY_CHAIN_OF).filter(ax -> ax.getSuperProperty().equals(property)));
            OWLObjectInverseOf inverse = this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLObjectInverseOf(property);
            OWLAPIStreamUtils.add(this.axioms, (Stream)this.ontology.axioms((OWLObjectPropertyExpression)inverse));
        }

        public void visit(OWLAnnotationProperty property) {
            OWLAPIStreamUtils.add(this.axioms, (Stream)this.ontology.axioms(property));
        }

        boolean threewayDisjoint(OWLAxiom ax) {
            OWLDisjointClassesAxiom disjAx;
            return !(ax instanceof OWLDisjointClassesAxiom) || (disjAx = (OWLDisjointClassesAxiom)ax).classExpressions().count() <= 2L;
        }

        boolean threewayDisjointData(OWLAxiom ax) {
            return !(ax instanceof OWLDisjointDataPropertiesAxiom) || ((OWLDisjointDataPropertiesAxiom)ax).properties().count() <= 2L;
        }

        boolean threewayDisjointObject(OWLAxiom ax) {
            return !(ax instanceof OWLDisjointObjectPropertiesAxiom) || ((OWLDisjointObjectPropertiesAxiom)ax).properties().count() <= 2L;
        }
    }
}

