/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLNamespaceManager;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLWriter;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterImpl;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFXMLRenderer
extends RDFRendererBase {
    private final RDFXMLWriter writer;
    private final RDFXMLNamespaceManager qnameManager;
    private final OWLDocumentFormat format;
    private final ShortFormProvider labelMaker;
    private boolean explicitXsdString;

    public RDFXMLRenderer(OWLOntology ontology, PrintWriter w) {
        this(ontology, w, (OWLDocumentFormat)OWLAPIPreconditions.verifyNotNull((Object)ontology.getFormat()));
    }

    public RDFXMLRenderer(OWLOntology ontology, PrintWriter w, OWLDocumentFormat format) {
        super((OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null"), (OWLDocumentFormat)OWLAPIPreconditions.checkNotNull((Object)format, (String)"format cannot be null"), ontology.getOWLOntologyManager().getOntologyWriterConfiguration());
        this.format = (OWLDocumentFormat)OWLAPIPreconditions.checkNotNull((Object)format, (String)"format cannot be null");
        this.explicitXsdString = Boolean.parseBoolean(((Boolean)format.getParameter((Serializable)((Object)"force xsd:string on literals"), (Object)Boolean.FALSE)).toString());
        this.qnameManager = new RDFXMLNamespaceManager(ontology, format);
        String defaultNamespace = this.qnameManager.getDefaultNamespace();
        String base = RDFXMLRenderer.base(defaultNamespace);
        this.writer = new RDFXMLWriter(new XMLWriterImpl((PrintWriter)OWLAPIPreconditions.checkNotNull((Object)w, (String)"w cannot be null"), this.qnameManager, base, ontology.getOWLOntologyManager().getOntologyWriterConfiguration()));
        HashMap prefLangMap = new HashMap();
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLAnnotationProperty labelProp = manager.getOWLDataFactory().getRDFSLabel();
        this.labelMaker = new AnnotationValueShortFormProvider(Collections.singletonList(labelProp), prefLangMap, (OWLOntologySetProvider)manager);
    }

    private static String base(String defaultNamespace) {
        String base = defaultNamespace.endsWith("#") ? defaultNamespace.substring(0, defaultNamespace.length() - 1) : defaultNamespace;
        return base;
    }

    @Override
    protected void beginDocument() {
        this.pending.clear();
        this.writer.startDocument();
    }

    @Override
    protected void endDocument() {
        this.writer.endDocument();
        this.writer.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        if (!this.format.isAddMissingTypes()) {
            this.writer.writeComment("Warning: type declarations were not added automatically.");
        }
        this.pending.clear();
    }

    @Override
    protected void writeIndividualComments(OWLNamedIndividual ind) {
        this.writeCommentForEntity("ind cannot be null", (OWLEntity)ind);
    }

    @Override
    protected void writeAnnotationPropertyComment(OWLAnnotationProperty prop) {
        this.writeCommentForEntity("prop cannot be null", (OWLEntity)prop);
    }

    @Override
    protected void writeClassComment(OWLClass cls) {
        this.writeCommentForEntity("cls cannot be null", (OWLEntity)cls);
    }

    @Override
    protected void writeDataPropertyComment(OWLDataProperty prop) {
        this.writeCommentForEntity("prop cannot be null", (OWLEntity)prop);
    }

    @Override
    protected void writeDatatypeComment(OWLDatatype datatype) {
        this.writeCommentForEntity("datatype cannot be null", (OWLEntity)datatype);
    }

    @Override
    protected void writeObjectPropertyComment(OWLObjectProperty prop) {
        this.writeCommentForEntity("prop cannot be null", (OWLEntity)prop);
    }

    @Override
    protected void writeBanner(String name) {
        this.writer.writeComment("\n///////////////////////////////////////////////////////////////////////////////////////\n//\n// " + (String)OWLAPIPreconditions.checkNotNull((Object)name, (String)"name cannot be null") + "\n//\n///////////////////////////////////////////////////////////////////////////////////////\n");
    }

    private void writeCommentForEntity(String msg, OWLEntity entity) {
        if (this.config.shouldUseBanners()) {
            OWLAPIPreconditions.checkNotNull((Object)entity, (String)msg);
            String iriString = entity.getIRI().toString();
            if (this.config.isLabelsAsBanner()) {
                String labelString = this.labelMaker.getShortForm(entity);
                String commentString = !iriString.equals(labelString) ? labelString : iriString;
                this.writer.writeComment(XMLUtils.escapeXML((CharSequence)commentString));
            } else {
                this.writer.writeComment(XMLUtils.escapeXML((CharSequence)iriString));
            }
        }
    }

    @Override
    protected void render(RDFResource node, boolean root) {
        OWLAPIPreconditions.checkNotNull((Object)node, (String)"node cannot be null");
        if (this.pending.contains(node)) {
            return;
        }
        this.pending.add(node);
        RDFTriple candidatePrettyPrintTypeTriple = null;
        Collection<RDFTriple> triples = this.getRDFGraph().getTriplesForSubject((RDFNode)node);
        for (RDFTriple triple : triples) {
            IRI propertyIRI = triple.getPredicate().getIRI();
            if (!propertyIRI.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(triple.getObject().getIRI()) || !this.prettyPrintedTypes.contains(triple.getObject().getIRI())) continue;
            candidatePrettyPrintTypeTriple = triple;
        }
        if (candidatePrettyPrintTypeTriple == null) {
            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
        } else {
            this.writer.writeStartElement(candidatePrettyPrintTypeTriple.getObject().getIRI());
        }
        if (!node.isAnonymous()) {
            this.writer.writeAboutAttribute(node.getIRI());
        } else if (node.idRequired()) {
            this.writer.writeNodeIDAttribute(node);
        }
        for (RDFTriple triple : triples) {
            if (candidatePrettyPrintTypeTriple != null && candidatePrettyPrintTypeTriple.equals((Object)triple)) continue;
            this.writer.writeStartElement(triple.getPredicate().getIRI());
            RDFNode objectNode = triple.getObject();
            if (!objectNode.isLiteral()) {
                RDFResource objectRes = (RDFResource)objectNode;
                if (objectRes.isAnonymous()) {
                    if (this.isObjectList(objectRes)) {
                        this.writer.writeParseTypeAttribute();
                        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                        this.toJavaList((RDFNode)objectRes, list);
                        list.forEach(this::renderList);
                    } else if (objectRes.equals(node)) {
                        this.writer.writeNodeIDAttribute(objectRes);
                    } else {
                        this.renderObject(objectRes);
                    }
                } else {
                    this.writer.writeResourceAttribute(objectRes.getIRI());
                }
            } else {
                this.writew((RDFLiteral)objectNode);
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        if (root) {
            this.deferredRendering();
        }
        this.pending.remove(node);
    }

    protected void renderList(RDFNode n) {
        if (n.isAnonymous()) {
            this.render((RDFResource)((RDFResourceBlankNode)n), false);
        } else if (n.isLiteral()) {
            this.write((RDFLiteral)n);
        } else {
            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
            this.writer.writeAboutAttribute(n.getIRI());
            this.writer.writeEndElement();
        }
    }

    protected void renderObject(RDFResource object) {
        if (object.idRequired()) {
            if (!this.pending.contains(object)) {
                this.defer((RDFNode)object);
            }
            this.writer.writeNodeIDAttribute(object);
        } else {
            this.render(object, false);
        }
    }

    protected void writew(RDFLiteral rdfLiteralNode) {
        if (rdfLiteralNode.hasLang()) {
            this.writer.writeLangAttribute(rdfLiteralNode.getLang());
        } else if (!(rdfLiteralNode.isPlainLiteral() || !this.explicitXsdString && OWL2Datatype.XSD_STRING.getIRI().equals((Object)rdfLiteralNode.getDatatype()))) {
            this.writer.writeDatatypeAttribute(rdfLiteralNode.getDatatype());
        }
        this.writer.writeTextContent(rdfLiteralNode.getLexicalValue());
    }

    protected void write(RDFLiteral litNode) {
        this.writer.writeStartElement(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        this.writew(litNode);
        this.writer.writeEndElement();
    }

    public Set<OWLEntity> getUnserialisableEntities() {
        return this.qnameManager.getEntitiesWithInvalidQNames();
    }
}

