/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.renderer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.owlxml.renderer.OWLXMLWriter;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class OWLXMLObjectRenderer
implements OWLObjectVisitor {
    private final OWLXMLWriter writer;
    private OWLDocumentFormat format;
    private boolean explicitXsdString = false;

    public OWLXMLObjectRenderer(OWLXMLWriter writer) {
        this(writer, null);
    }

    public OWLXMLObjectRenderer(OWLXMLWriter writer, OWLDocumentFormat format) {
        this.writer = (OWLXMLWriter)OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null");
        this.format = format;
    }

    private void writeAnnotations(OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null");
        this.render(axiom.annotations());
    }

    public void visit(OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        ontology.importsDeclarations().sorted().forEach(decl -> {
            this.writer.writeStartElement(OWLXMLVocabulary.IMPORT);
            this.writer.writeTextContent(decl.getIRI().toString());
            this.writer.writeEndElement();
        });
        this.render(ontology.annotations());
        Set declared = OWLAPIStreamUtils.asUnorderedSet((Stream)ontology.unsortedSignature());
        ontology.axioms(AxiomType.DECLARATION).sorted().forEach(ax -> {
            ax.accept((OWLObjectVisitor)this);
            declared.remove(ax.getEntity());
        });
        if (!declared.isEmpty()) {
            boolean addMissing = true;
            if (this.format == null) {
                this.format = ontology.getOWLOntologyManager().getOntologyFormat(ontology);
            }
            if (this.format != null) {
                addMissing = this.format.isAddMissingTypes();
                this.explicitXsdString = (Boolean)this.format.getParameter((Serializable)((Object)"force xsd:string on literals"), (Object)Boolean.FALSE);
            }
            if (addMissing) {
                Collection illegalPunnings = OWLDocumentFormat.determineIllegalPunnings((boolean)addMissing, (Stream)ontology.signature(), (Collection)ontology.getPunnedIRIs(Imports.INCLUDED));
                for (OWLEntity e : declared) {
                    if (e.isBuiltIn() || illegalPunnings.contains(e.getIRI()) || ontology.isDeclared(e, Imports.INCLUDED)) continue;
                    ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(e).accept((OWLObjectVisitor)this);
                }
            }
        }
        Stream<AxiomType> skipDeclarations = AxiomType.AXIOM_TYPES.stream().filter(t -> !t.equals((Object)AxiomType.DECLARATION));
        this.render(skipDeclarations.flatMap(arg_0 -> ((OWLOntology)ontology).axioms(arg_0)).distinct().sorted());
    }

    public void visit(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        this.writer.writeIRIElement(iri);
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANONYMOUS_INDIVIDUAL);
        this.writer.writeNodeIDAttribute(individual.getID());
        this.writer.writeEndElement();
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS_ASSERTION);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_RANGE);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DECLARATION);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getEntity().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.individuals());
        this.writer.writeEndElement();
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_CLASSES);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.classExpressions());
        this.writer.writeEndElement();
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.properties());
        this.writer.writeEndElement();
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.properties());
        this.writer.writeEndElement();
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_UNION);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        this.render(axiom.classExpressions());
        this.writer.writeEndElement();
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_ASSERTION);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLAnnotationProperty)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ((OWLAnnotationSubject)axiom.getSubject()).accept((OWLObjectVisitor)this);
        axiom.getValue().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_CLASSES);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.classExpressions());
        this.writer.writeEndElement();
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.properties());
        this.writer.writeEndElement();
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.properties());
        this.writer.writeEndElement();
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF);
        this.writeAnnotations((OWLAxiom)axiom);
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN);
        this.render(axiom.getPropertyChain().stream());
        this.writer.writeEndElement();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SAME_INDIVIDUAL);
        this.writeAnnotations((OWLAxiom)axiom);
        this.render(axiom.individuals());
        this.writer.writeEndElement();
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_CLASS_OF);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLClass ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS);
        this.writer.writeIRIAttribute(ce.getIRI());
        this.writer.writeEndElement();
    }

    public void visit(OWLDataAllValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_ALL_VALUES_FROM);
        ce.getProperty().accept((OWLObjectVisitor)this);
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDataExactCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_EXACT_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept((OWLObjectVisitor)this);
        if (ce.isQualified()) {
            ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        }
        this.writer.writeEndElement();
    }

    public void visit(OWLDataMaxCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_MAX_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept((OWLObjectVisitor)this);
        if (ce.isQualified()) {
            ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        }
        this.writer.writeEndElement();
    }

    public void visit(OWLDataMinCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_MIN_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept((OWLObjectVisitor)this);
        if (ce.isQualified()) {
            ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        }
        this.writer.writeEndElement();
    }

    public void visit(OWLDataSomeValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_SOME_VALUES_FROM);
        ce.getProperty().accept((OWLObjectVisitor)this);
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDataHasValue ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_HAS_VALUE);
        ce.getProperty().accept((OWLObjectVisitor)this);
        ((OWLLiteral)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM);
        ce.getProperty().accept((OWLObjectVisitor)this);
        ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectComplementOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF);
        ce.getOperand().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectExactCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept((OWLObjectVisitor)this);
        if (ce.isQualified()) {
            ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        }
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectIntersectionOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.render(ce.operands());
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectMaxCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept((OWLObjectVisitor)this);
        if (ce.isQualified()) {
            ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        }
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectMinCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept((OWLObjectVisitor)this);
        if (ce.isQualified()) {
            ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        }
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectOneOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.render(ce.individuals());
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectHasSelf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_HAS_SELF);
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM);
        ce.getProperty().accept((OWLObjectVisitor)this);
        ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectUnionOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.render(ce.operands());
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectHasValue ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_HAS_VALUE);
        ce.getProperty().accept((OWLObjectVisitor)this);
        ((OWLIndividual)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDataComplementOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_COMPLEMENT_OF);
        node.getDataRange().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDataOneOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_ONE_OF);
        this.render(node.values());
        this.writer.writeEndElement();
    }

    public void visit(OWLDatatype node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE);
        this.writer.writeIRIAttribute(node.getIRI());
        this.writer.writeEndElement();
    }

    public void visit(OWLDatatypeRestriction node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        node.getDatatype().accept((OWLObjectVisitor)this);
        this.render(node.facetRestrictions());
        this.writer.writeEndElement();
    }

    public void visit(OWLFacetRestriction node) {
        this.writer.writeStartElement(OWLXMLVocabulary.FACET_RESTRICTION);
        this.writer.writeFacetAttribute(node.getFacet());
        node.getFacetValue().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLLiteral node) {
        this.writer.writeStartElement(OWLXMLVocabulary.LITERAL);
        if (node.hasLang()) {
            this.writer.writeLangAttribute(node.getLang());
        } else if (!(node.isRDFPlainLiteral() || !this.explicitXsdString && OWL2Datatype.XSD_STRING.matches((OWLEntity)node.getDatatype()))) {
            this.writer.writeDatatypeAttribute(node.getDatatype());
        }
        this.writer.writeTextContent(node.getLiteral());
        this.writer.writeEndElement();
    }

    public void visit(OWLDataProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY);
        this.writer.writeIRIAttribute(property.getIRI());
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY);
        this.writer.writeIRIAttribute(property.getIRI());
        this.writer.writeEndElement();
    }

    public void visit(OWLObjectInverseOf property) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_INVERSE_OF);
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLNamedIndividual individual) {
        this.writer.writeStartElement(OWLXMLVocabulary.NAMED_INDIVIDUAL);
        this.writer.writeIRIAttribute(individual.getIRI());
        this.writer.writeEndElement();
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.HAS_KEY);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        this.render(axiom.objectPropertyExpressions());
        this.render(axiom.dataPropertyExpressions());
        this.writer.writeEndElement();
    }

    public void visit(OWLDataIntersectionOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_INTERSECTION_OF);
        this.render(node.operands());
        this.writer.writeEndElement();
    }

    public void visit(OWLDataUnionOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_UNION_OF);
        this.render(node.operands());
        this.writer.writeEndElement();
    }

    public void visit(OWLAnnotationProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_PROPERTY);
        this.writer.writeIRIAttribute(property.getIRI());
        this.writer.writeEndElement();
    }

    public void visit(OWLAnnotation node) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION);
        this.render(node.annotations());
        node.getProperty().accept((OWLObjectVisitor)this);
        node.getValue().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLAnnotationProperty)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ((IRI)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE);
        this.writeAnnotations((OWLAxiom)axiom);
        ((OWLAnnotationProperty)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ((IRI)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE_DEFINITION);
        this.writeAnnotations((OWLAxiom)axiom);
        axiom.getDatatype().accept((OWLObjectVisitor)this);
        axiom.getDataRange().accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(SWRLRule rule) {
        this.writer.writeStartElement(OWLXMLVocabulary.DL_SAFE_RULE);
        this.writeAnnotations((OWLAxiom)rule);
        this.writer.writeStartElement(OWLXMLVocabulary.BODY);
        this.render(rule.body());
        this.writer.writeEndElement();
        this.writer.writeStartElement(OWLXMLVocabulary.HEAD);
        this.render(rule.head());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public void visit(SWRLClassAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS_ATOM);
        node.getPredicate().accept((OWLObjectVisitor)this);
        ((SWRLIArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(SWRLDataRangeAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_RANGE_ATOM);
        node.getPredicate().accept((OWLObjectVisitor)this);
        ((SWRLDArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM);
        node.getPredicate().accept((OWLObjectVisitor)this);
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(SWRLDataPropertyAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_ATOM);
        node.getPredicate().accept((OWLObjectVisitor)this);
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        ((SWRLDArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(SWRLBuiltInAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.BUILT_IN_ATOM);
        this.writer.writeIRIAttribute(node.getPredicate());
        this.render(node.arguments());
        this.writer.writeEndElement();
    }

    public void visit(SWRLVariable node) {
        this.writer.writeStartElement(OWLXMLVocabulary.VARIABLE);
        if ("urn:swrl:var#".equals(node.getIRI().getNamespace()) || "urn:swrl#".equals(node.getIRI().getNamespace())) {
            this.writer.writeIRIAttribute(IRI.create((String)"urn:swrl:var#", (String)node.getIRI().getFragment()));
        } else {
            this.writer.writeIRIAttribute(node.getIRI());
        }
        this.writer.writeEndElement();
    }

    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM);
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM);
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writer.writeEndElement();
    }

    private void render(Stream<? extends OWLObject> objects) {
        objects.forEach(a -> a.accept((OWLObjectVisitor)this));
    }
}

