/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLReasonerBase
implements OWLReasoner {
    private final OWLOntologyManager manager;
    private final OWLOntology rootOntology;
    private final BufferingMode bufferingMode;
    private final List<OWLOntologyChange> rawChanges = new ArrayList<OWLOntologyChange>();
    private final Set<OWLAxiom> reasonerAxioms;
    private final long timeOut;
    private final OWLReasonerConfiguration configuration;
    private OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            OWLReasonerBase.this.handleRawOntologyChanges(changes);
        }
    };
    private final boolean log = false;

    protected OWLReasonerBase(OWLOntology rootOntology, OWLReasonerConfiguration configuration, BufferingMode bufferingMode) {
        this.rootOntology = rootOntology;
        this.bufferingMode = bufferingMode;
        this.configuration = configuration;
        this.timeOut = configuration.getTimeOut();
        this.manager = rootOntology.getOWLOntologyManager();
        this.manager.addOntologyChangeListener(this.ontologyChangeListener);
        this.reasonerAxioms = new HashSet<OWLAxiom>();
        for (OWLOntology ont : rootOntology.getImportsClosure()) {
            for (OWLLogicalAxiom ax : ont.getLogicalAxioms()) {
                this.reasonerAxioms.add(ax.getAxiomWithoutAnnotations());
            }
            for (OWLLogicalAxiom ax : ont.getAxioms(AxiomType.DECLARATION)) {
                this.reasonerAxioms.add(ax.getAxiomWithoutAnnotations());
            }
        }
    }

    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.configuration;
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology;
    }

    private synchronized void handleRawOntologyChanges(List<? extends OWLOntologyChange> changes) {
        this.rawChanges.addAll(changes);
        if (this.bufferingMode.equals((Object)BufferingMode.NON_BUFFERING)) {
            this.flush();
        }
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return new ArrayList<OWLOntologyChange>(this.rawChanges);
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        this.computeDiff(added, new HashSet<OWLAxiom>());
        return added;
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        this.computeDiff(new HashSet<OWLAxiom>(), removed);
        return removed;
    }

    public void flush() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        this.computeDiff(added, removed);
        this.reasonerAxioms.removeAll(removed);
        this.reasonerAxioms.addAll(added);
        this.rawChanges.clear();
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.handleChanges(added, removed);
        }
    }

    private void computeDiff(Set<OWLAxiom> added, Set<OWLAxiom> removed) {
        if (this.rawChanges.isEmpty()) {
            return;
        }
        for (OWLOntology ont : this.rootOntology.getImportsClosure()) {
            for (OWLLogicalAxiom ax : ont.getLogicalAxioms()) {
                if (this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
                added.add((OWLAxiom)ax);
            }
            for (OWLLogicalAxiom ax : ont.getAxioms(AxiomType.DECLARATION)) {
                if (this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
                added.add((OWLAxiom)ax);
            }
        }
        for (OWLAxiom ax : this.reasonerAxioms) {
            if (this.rootOntology.containsAxiomIgnoreAnnotations(ax, true)) continue;
            removed.add(ax);
        }
    }

    public Collection<OWLAxiom> getReasonerAxioms() {
        return new ArrayList<OWLAxiom>(this.reasonerAxioms);
    }

    protected abstract void handleChanges(Set<OWLAxiom> var1, Set<OWLAxiom> var2);

    public void dispose() {
        this.manager.removeOntologyChangeListener(this.ontologyChangeListener);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.configuration.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.configuration.getIndividualNodeSetPolicy();
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.rootOntology.getOWLOntologyManager().getOWLDataFactory();
    }
}

