/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.semanticweb.owlapi.annotations.HasPriority;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.rio.RioMemoryTripleSource;
import org.semanticweb.owlapi.rio.RioOWLRDFConsumerAdapter;
import org.semanticweb.owlapi.rio.RioParser;
import org.semanticweb.owlapi.util.AnonymousNodeChecker;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HasPriority(value=7.0)
public class RioParserImpl
extends AbstractOWLParser
implements RioParser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RioParserImpl.class);
    private static final RIOAnonymousNodeChecker CHECKER = new RIOAnonymousNodeChecker();
    private final RioRDFDocumentFormatFactory owlFormatFactory;

    public RioParserImpl(RioRDFDocumentFormatFactory nextFormat) {
        this.owlFormatFactory = (RioRDFDocumentFormatFactory)OWLAPIPreconditions.checkNotNull((Object)nextFormat, (String)"nextFormat cannot be null");
    }

    public RioRDFDocumentFormatFactory getSupportedFormat() {
        return this.owlFormatFactory;
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        try {
            RioOWLRDFConsumerAdapter consumer = new RioOWLRDFConsumerAdapter(ontology, CHECKER, configuration);
            consumer.setOntologyFormat(this.owlFormatFactory.createFormat());
            String baseUri = "urn:default:baseUri:";
            baseUri = !ontology.getOntologyID().isAnonymous() && ontology.getOntologyID().getDefaultDocumentIRI().isPresent() ? ((IRI)ontology.getOntologyID().getDefaultDocumentIRI().get()).toString() : documentSource.getDocumentIRI().toString();
            RioParserRDFHandler handler = new RioParserRDFHandler(consumer);
            if (documentSource instanceof RioMemoryTripleSource) {
                RioMemoryTripleSource tripleSource = (RioMemoryTripleSource)documentSource;
                Map<String, String> namespaces = tripleSource.getNamespaces();
                Iterator<Statement> statementsIterator = tripleSource.getStatementIterator();
                handler.startRDF();
                namespaces.forEach(handler::handleNamespace);
                while (statementsIterator.hasNext()) {
                    handler.handleStatement(statementsIterator.next());
                }
                handler.endRDF();
            } else {
                this.parseDocumentSource(documentSource, baseUri, handler, configuration);
            }
            return consumer.getOntologyFormat();
        }
        catch (RDFHandlerException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof UnloadableImportException) {
                throw (UnloadableImportException)e.getCause().getCause();
            }
            throw new OWLParserException((Throwable)e);
        }
        catch (IOException | RDFParseException | UnsupportedRDFormatException | OWLOntologyInputSourceException e) {
            throw new OWLParserException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDocumentSource(OWLOntologyDocumentSource source, String baseUri, RDFHandler handler, OWLOntologyLoaderConfiguration config) throws OWLOntologyInputSourceException, IOException {
        RDFParser createParser = Rio.createParser((RDFFormat)this.owlFormatFactory.getRioFormat());
        createParser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        createParser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        createParser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_URI_SYNTAX);
        createParser.setRDFHandler(handler);
        long rioParseStart = System.currentTimeMillis();
        try {
            if (this.owlFormatFactory.isTextual()) {
                createParser.parse(DocumentSources.wrapInputAsReader((OWLOntologyDocumentSource)source, (OWLOntologyLoaderConfiguration)config), baseUri);
                return;
            }
            try {
                createParser.parse(DocumentSources.wrapInput((OWLOntologyDocumentSource)source, (OWLOntologyLoaderConfiguration)config), baseUri);
            }
            catch (OWLOntologyInputSourceException e) {
                throw new OWLParserException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("rioParse: timing={}", (Object)(System.currentTimeMillis() - rioParseStart));
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + " : " + this.owlFormatFactory;
    }

    private static class RioParserRDFHandler
    implements RDFHandler {
        private static final Logger LOG = LoggerFactory.getLogger(RioParserRDFHandler.class);
        private final RDFHandler consumer;
        private final Set<Resource> typedLists = new HashSet<Resource>();
        private final ValueFactory vf = SimpleValueFactory.getInstance();
        private long owlParseStart;

        RioParserRDFHandler(RDFHandler consumer) {
            this.consumer = consumer;
        }

        public void startRDF() {
            this.owlParseStart = System.currentTimeMillis();
            try {
                this.consumer.startRDF();
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException((Throwable)e);
            }
        }

        public void endRDF() {
            try {
                this.consumer.endRDF();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("owlParse: timing={}", (Object)(System.currentTimeMillis() - this.owlParseStart));
                }
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException((Throwable)e);
            }
        }

        public void handleNamespace(@Nullable String prefix, @Nullable String uri) {
            try {
                this.consumer.handleNamespace(prefix, uri);
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException((Throwable)e);
            }
        }

        public void handleStatement(@Nullable Statement nextStatement) {
            OWLAPIPreconditions.checkNotNull((Object)nextStatement);
            assert (nextStatement != null);
            if (nextStatement.getPredicate().equals((Object)RDF.FIRST) || nextStatement.getPredicate().equals((Object)RDF.REST)) {
                if (!this.typedLists.contains(nextStatement.getSubject())) {
                    this.typedLists.add(nextStatement.getSubject());
                    try {
                        this.consumer.handleStatement(this.vf.createStatement(nextStatement.getSubject(), RDF.TYPE, (Value)RDF.LIST));
                    }
                    catch (RDFHandlerException e) {
                        throw new OWLParserException((Throwable)e);
                    }
                    LOG.debug("Implicitly typing list={}", (Object)nextStatement);
                }
            } else if (nextStatement.getPredicate().equals((Object)RDF.TYPE) && nextStatement.getObject().equals(RDF.LIST)) {
                if (!this.typedLists.contains(nextStatement.getSubject())) {
                    LOG.debug("Explicit list type found={}", (Object)nextStatement);
                    this.typedLists.add(nextStatement.getSubject());
                } else {
                    LOG.debug("duplicate rdf:type rdf:List statements found={}", (Object)nextStatement);
                }
            }
            try {
                this.consumer.handleStatement(nextStatement);
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException((Throwable)e);
            }
        }

        public void handleComment(@Nullable String comment) {
        }
    }

    private static class RIOAnonymousNodeChecker
    implements AnonymousNodeChecker {
        RIOAnonymousNodeChecker() {
        }

        public boolean isAnonymousNode(IRI iri) {
            if (this.anon(iri.toString())) {
                LOGGER.trace("isAnonymousNode(IRI {})", (Object)iri);
                return true;
            }
            LOGGER.trace("NOT isAnonymousNode(IRI {})", (Object)iri);
            return false;
        }

        public boolean isAnonymousNode(String iri) {
            if (this.anon(iri)) {
                LOGGER.trace("isAnonymousNode(String {})", (Object)iri);
                return true;
            }
            LOGGER.trace("NOT isAnonymousNode(String {})", (Object)iri);
            return false;
        }

        public boolean isAnonymousSharedNode(String iri) {
            if (this.anon(iri)) {
                LOGGER.trace("isAnonymousSharedNode(String {})", (Object)iri);
                return true;
            }
            LOGGER.trace("NOT isAnonymousSharedNode(String {})", (Object)iri);
            return false;
        }

        boolean anon(String iri) {
            return iri.startsWith("_:") || iri.contains("genid");
        }
    }
}

