/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public interface ModuleExtractor {
    @Nonnull
    public Stream<OWLAxiom> axiomBase();

    default public boolean containsAxiom(OWLAxiom axiom) {
        return this.axiomBase().anyMatch(axiom::equals);
    }

    default public boolean everyModuleContains(OWLAxiom axiom) {
        return this.globals().anyMatch(axiom::equals);
    }

    @Nonnull
    default public Stream<OWLAxiom> extract(Stream<OWLEntity> signature) {
        return this.extract(signature, Optional.empty());
    }

    @Nonnull
    public Stream<OWLAxiom> extract(Stream<OWLEntity> var1, Optional<Predicate<OWLAxiom>> var2);

    @Nonnull
    default public Stream<OWLAxiom> extract(Stream<OWLEntity> signature, Predicate<OWLAxiom> axiomFilter) {
        return this.extract(signature, Optional.ofNullable(axiomFilter));
    }

    @Nonnull
    default public OWLOntology extractAsOntology(Stream<OWLEntity> signature, OWLOntologyManager ontologyManager, IRI ontologyIRI) throws OWLOntologyCreationException {
        OWLOntology ontology = Objects.requireNonNull(ontologyManager, "The given ontology manager may not be null").createOntology(Objects.requireNonNull(ontologyIRI, "The given iri may not be null"));
        ontology.addAxioms(this.extract(Objects.requireNonNull(signature, "The given signature may not be null")));
        return ontology;
    }

    @Nonnull
    default public Stream<OWLAxiom> globals() {
        return this.extract(Stream.empty());
    }

    default public boolean noModuleContains(OWLAxiom axiom) {
        return this.extract((Stream<OWLEntity>)axiom.signature(), axiom::equals).count() == 0L;
    }

    @Nonnull
    default public Stream<OWLAxiom> tautologies() {
        return ((Stream)this.axiomBase().parallel()).filter(this::noModuleContains);
    }
}

