/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.atomicdecomposition;

import com.carrotsearch.hppcrt.maps.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapitools.decomposition.AtomList;
import org.semanticweb.owlapitools.decomposition.AxiomSelector;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.Decomposer;
import org.semanticweb.owlapitools.decomposition.IdentityMultiMap;
import org.semanticweb.owlapitools.decomposition.OntologyAtom;
import org.semanticweb.owlapitools.decomposition.SyntacticLocalityChecker;
import uk.ac.manchester.cs.atomicdecomposition.Atom;
import uk.ac.manchester.cs.atomicdecomposition.AtomicDecomposition;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class AtomicDecompositionImpl
implements AtomicDecomposition {
    final Map<OWLEntity, Set<Atom>> termBasedIndex = new LinkedHashMap<OWLEntity, Set<Atom>>();
    private final ModuleType type;
    Set<OWLAxiom> globalAxioms;
    Set<OWLAxiom> tautologies;
    List<Atom> atoms;
    ObjectIntHashMap<Atom> atomIndex = new ObjectIntHashMap();
    IdentityMultiMap<Atom, Atom> dependents = new IdentityMultiMap();
    IdentityMultiMap<Atom, Atom> dependencies = new IdentityMultiMap();
    Decomposer decomposer;

    public AtomicDecompositionImpl(OWLOntology o) {
        this(AxiomSelector.selectAxioms(o), ModuleType.BOT);
    }

    public AtomicDecompositionImpl(OWLOntology o, ModuleType type) {
        this(AxiomSelector.selectAxioms(o), type);
    }

    public AtomicDecompositionImpl(OWLOntology o, ModuleType type, boolean excludeAssertions) {
        this(AxiomSelector.selectAxioms(o, excludeAssertions), type);
    }

    public AtomicDecompositionImpl(List<OWLAxiom> axioms, ModuleType type) {
        int i;
        this.type = type;
        this.decomposer = new Decomposer(AxiomSelector.wrap(axioms), new SyntacticLocalityChecker());
        int size = this.decomposer.getAOS(this.type).size();
        this.atoms = new ArrayList<Atom>();
        for (i = 0; i < size; ++i) {
            Atom atom = new Atom(this.asSet(this.decomposer.getAOS().get(i).getAtomAxioms()));
            this.atoms.add(atom);
            this.atomIndex.put((Object)atom, i);
            for (OWLEntity e : atom.getSignature()) {
                this.termBasedIndex.computeIfAbsent(e, x -> new HashSet()).add(atom);
            }
        }
        for (i = 0; i < size; ++i) {
            Set<OntologyAtom> dependentIndexes = this.decomposer.getAOS().get(i).getDependencies();
            for (OntologyAtom j : dependentIndexes) {
                this.dependencies.put(this.atoms.get(i), this.atoms.get(j.getId()));
                this.dependents.put(this.atoms.get(j.getId()), this.atoms.get(i));
            }
        }
    }

    Set<OWLAxiom> asSet(Collection<AxiomWrapper> c) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomWrapper p : c) {
            toReturn.add(p.getAxiom());
        }
        return toReturn;
    }

    int getModuleType() {
        return this.type.ordinal();
    }

    @Override
    public Set<Atom> getAtoms() {
        return new HashSet<Atom>(this.atoms);
    }

    @Override
    @Nullable
    public Atom getAtomForAxiom(OWLAxiom axiom) {
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (!this.atoms.get(i).contains(axiom)) continue;
            return this.atoms.get(i);
        }
        return null;
    }

    @Override
    public boolean isTopAtom(Atom atom) {
        return !this.dependents.containsKey(atom);
    }

    @Override
    public boolean isBottomAtom(Atom atom) {
        return !this.dependencies.containsKey(atom);
    }

    @Override
    public Set<OWLAxiom> getPrincipalIdeal(Atom atom) {
        return this.asSet(this.getAtomModule(this.atomIndex.get((Object)atom)));
    }

    @Override
    public Set<OWLEntity> getPrincipalIdealSignature(Atom atom) {
        return Collections.emptySet();
    }

    @Override
    public Set<Atom> getDependencies(Atom atom) {
        return this.getDependencies(atom, false);
    }

    @Override
    public Set<Atom> getDependencies(Atom atom, boolean direct) {
        return this.explore(atom, direct, this.dependencies);
    }

    @Override
    public Set<Atom> getDependents(Atom atom) {
        return this.getDependents(atom, false);
    }

    @Override
    public Set<Atom> getDependents(Atom atom, boolean direct) {
        return this.explore(atom, direct, this.dependents);
    }

    Set<Atom> explore(Atom atom, boolean direct, IdentityMultiMap<Atom, Atom> multimap) {
        if (direct) {
            HashSet<Atom> hashSet = new HashSet<Atom>(multimap.get(atom));
            for (Atom a : multimap.get(atom)) {
                hashSet.removeAll(multimap.get(a));
            }
            return hashSet;
        }
        HashMap<Atom, Atom> toReturn = new HashMap<Atom, Atom>();
        toReturn.put(atom, atom);
        ArrayList<Atom> toDo = new ArrayList<Atom>();
        toDo.add(atom);
        for (int i = 0; i < toDo.size(); ++i) {
            Atom key = (Atom)toDo.get(i);
            if (key == null) continue;
            Collection<Atom> c = multimap.get(key);
            for (Atom a : c) {
                if (toReturn.put(a, a) != null) continue;
                toDo.add(a);
            }
        }
        return toReturn.keySet();
    }

    @Override
    public Set<Atom> getRelatedAtoms(Atom atom) {
        Set<Atom> s = this.getDependencies(atom);
        s.addAll(this.getDependents(atom));
        return s;
    }

    @Override
    public Set<Atom> getTopAtoms() {
        Set<Atom> keys = this.getAtoms();
        keys.removeAll(this.dependencies.getAllValues());
        return keys;
    }

    @Override
    public Set<Atom> getBottomAtoms() {
        Set<Atom> keys = this.getAtoms();
        keys.removeAll(this.dependents.getAllValues());
        return keys;
    }

    Set<OWLAxiom> getGlobalAxioms() {
        return this.globalAxioms;
    }

    void setGlobalAxioms(Set<OWLAxiom> globalAxioms) {
        this.globalAxioms = globalAxioms;
    }

    @Override
    public Set<OWLAxiom> getTautologies() {
        return this.asSet(this.decomposer.getTautologies());
    }

    @Override
    public Map<OWLEntity, Set<Atom>> getTermBasedIndex() {
        HashMap<OWLEntity, Set<Atom>> toReturn = new HashMap<OWLEntity, Set<Atom>>();
        for (OWLEntity e : this.termBasedIndex.keySet()) {
            toReturn.put(e, new HashSet(this.termBasedIndex.get(e)));
        }
        return toReturn;
    }

    Collection<AxiomWrapper> getAtomModule(int index) {
        return this.decomposer.getAOS().get(index).getModule();
    }

    @Override
    public AtomList getAtomList() {
        return this.decomposer.getAOS();
    }

    @Override
    public Stream<OWLAxiom> getModule(Stream<OWLEntity> signature, boolean useSemantics, ModuleType moduletype) {
        return this.decomposer.getModule(signature, useSemantics, moduletype).stream().map(AxiomWrapper::getAxiom).filter(ax -> ax != null);
    }
}

