/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.DivideAndConquerContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.blackbox.ExpansionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.StructuralTypePriorityExpansionStrategy;

public class Configuration<E> {
    private EntailmentCheckerFactory<E> checkerFactory;
    private ExpansionStrategy expansionStrategy;
    private ContractionStrategy contractionStrategy;

    public Configuration(EntailmentCheckerFactory<E> checkerFactory, ExpansionStrategy expansionStrategy, ContractionStrategy contractionStrategy) {
        this(checkerFactory, expansionStrategy, contractionStrategy, null);
    }

    public Configuration(EntailmentCheckerFactory<E> checkerFactory, ExpansionStrategy expansionStrategy, ContractionStrategy contractionStrategy, ExplanationProgressMonitor<E> progressMonitor) {
        this.checkerFactory = checkerFactory;
        this.contractionStrategy = contractionStrategy;
        this.expansionStrategy = expansionStrategy;
    }

    public Configuration(EntailmentCheckerFactory<E> checkerFactory) {
        this(checkerFactory, new StructuralTypePriorityExpansionStrategy(), new DivideAndConquerContractionStrategy());
    }

    public Configuration(EntailmentCheckerFactory<E> checkerFactory, ExplanationProgressMonitor<E> progressMonitor) {
        this(checkerFactory, new StructuralTypePriorityExpansionStrategy(), new DivideAndConquerContractionStrategy(), progressMonitor);
    }

    public EntailmentCheckerFactory<E> getCheckerFactory() {
        return this.checkerFactory;
    }

    public ContractionStrategy getContractionStrategy() {
        return this.contractionStrategy;
    }

    public ExpansionStrategy getExpansionStrategy() {
        return this.expansionStrategy;
    }
}

