/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

public class ModularityContractionStrategy
implements ContractionStrategy {
    private int count = 0;
    private int windowSize;
    private int counter = 0;

    private static void toList(Tree<OWLAxiom> tree, List<OWLAxiom> axioms, EntailmentChecker checker) {
        OWLAxiom axiom = (OWLAxiom)tree.getUserObject();
        if (!axiom.equals(checker.getEntailment())) {
            axioms.add(axiom);
        }
        for (Tree t : tree.getChildren()) {
            ModularityContractionStrategy.toList((Tree<OWLAxiom>)t, axioms, checker);
        }
    }

    @Override
    public Set<OWLAxiom> doPruning(Set<OWLAxiom> axioms, EntailmentChecker checker, ExplanationProgressMonitor<?> progressMonitor) {
        this.count = 0;
        this.windowSize = axioms.size() / 20;
        if (this.windowSize == 0) {
            this.windowSize = 1;
        }
        ArrayList<OWLAxiom> axiomList = new ArrayList<OWLAxiom>(axioms);
        HashSet<OWLAxiom> contraction = new HashSet<OWLAxiom>(axioms);
        int cursor = 0;
        while (cursor < axiomList.size()) {
            ArrayList<OWLAxiom> picked = new ArrayList<OWLAxiom>(12);
            cursor = this.pickAxioms(axiomList, cursor, picked) + 1;
            if (!contraction.removeAll(picked)) continue;
            ++this.count;
            if (!checker.isEntailed(contraction)) {
                contraction.addAll(picked);
                continue;
            }
            Set<OWLAxiom> module = this.computeModule(contraction, checker);
            if (module.size() == contraction.size()) continue;
            contraction.clear();
            contraction.addAll(module);
            for (int i = 0; i < axiomList.size(); ++i) {
                if (module.contains(axiomList.get(i))) continue;
                axiomList.set(i, null);
            }
        }
        ++this.counter;
        HashSet<OWLAxiom> contractionCopy = new HashSet<OWLAxiom>(contraction);
        for (OWLAxiom ax : contractionCopy) {
            ++this.count;
            contraction.remove(ax);
            if (checker.isEntailed(contraction)) continue;
            contraction.add(ax);
        }
        return contraction;
    }

    @Override
    public int getNumberOfSteps() {
        return this.count;
    }

    private Set<OWLAxiom> computeModule(Set<OWLAxiom> contraction, EntailmentChecker checker) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.createOntology(contraction);
            SyntacticLocalityModuleExtractor extractor = new SyntacticLocalityModuleExtractor(man, ont, ModuleType.BOT);
            return extractor.extract(checker.getEntailmentSignature());
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private int pickAxioms(List<OWLAxiom> axs, int start, Collection<OWLAxiom> picked) {
        int finished = 0;
        int added = 0;
        int i = start;
        while (i < axs.size()) {
            OWLAxiom curAx = axs.get(i);
            if (curAx != null) {
                picked.add(curAx);
                axs.set(i, null);
                if (++added == this.windowSize) break;
            }
            finished = i++;
        }
        return finished;
    }
}

