/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.checker;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.BlackBoxExplanationGenerator2;
import org.semanticweb.owl.explanation.impl.blackbox.Configuration;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class BlackBoxExplanationGeneratorFactory<E>
implements ExplanationGeneratorFactory<E> {
    private Configuration<E> configuration;

    public BlackBoxExplanationGeneratorFactory(Configuration<E> configuration) {
        this.configuration = configuration;
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(OWLOntology ontology) {
        return this.createExplanationGenerator(ontology, null);
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(OWLOntology ontology, ExplanationProgressMonitor<E> progressMonitor) {
        HashSet axioms = new HashSet(ontology.getLogicalAxiomCount());
        for (OWLOntology ont : ontology.getImportsClosure()) {
            axioms.addAll(ont.getLogicalAxioms());
        }
        return new BlackBoxExplanationGenerator2<E>(axioms, this.configuration.getCheckerFactory(), this.configuration.getExpansionStrategy(), this.configuration.getContractionStrategy(), progressMonitor);
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(Set<? extends OWLAxiom> axioms) {
        return this.createExplanationGenerator(axioms, null);
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(Set<? extends OWLAxiom> axioms, ExplanationProgressMonitor<E> progressMonitor) {
        return new BlackBoxExplanationGenerator2<E>(axioms, this.configuration.getCheckerFactory(), this.configuration.getExpansionStrategy(), this.configuration.getContractionStrategy(), progressMonitor);
    }
}

