/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.checker;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class ConsistencyEntailmentChecker
implements EntailmentChecker<OWLAxiom> {
    private OWLAxiom entailment;
    private OWLReasonerFactory reasonerFactory;
    private int counter;
    private boolean consistent = false;
    private long timeout = Long.MAX_VALUE;

    public ConsistencyEntailmentChecker(OWLReasonerFactory reasonerFactory, long timeout) {
        this.timeout = timeout;
        this.reasonerFactory = reasonerFactory;
        OWLDataFactoryImpl df = new OWLDataFactoryImpl();
        this.entailment = df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLThing(), (OWLClassExpression)df.getOWLNothing());
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void resetCounter() {
        this.counter = 0;
    }

    @Override
    public OWLAxiom getEntailment() {
        return this.entailment;
    }

    @Override
    public Set<OWLAxiom> getModule(Set<OWLAxiom> axioms) {
        return axioms;
    }

    @Override
    public Set<OWLEntity> getEntailmentSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLEntity> getSeedSignature() {
        return Collections.emptySet();
    }

    @Override
    public boolean isEntailed(Set<OWLAxiom> axiom) {
        TelemetryTimer timer = new TelemetryTimer();
        TelemetryTimer loadTimer = new TelemetryTimer();
        TelemetryTimer checkTimer = new TelemetryTimer();
        DefaultTelemetryInfo info = new DefaultTelemetryInfo("entailmentcheck", new TelemetryTimer[]{timer, loadTimer, checkTimer});
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        transmitter.beginTransmission((TelemetryInfo)info);
        try {
            transmitter.recordMeasurement((TelemetryInfo)info, "input size", (Number)axiom.size());
            ++this.counter;
            timer.start();
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.createOntology(axiom);
            SimpleConfiguration config = new SimpleConfiguration(this.timeout);
            timer.start();
            loadTimer.start();
            OWLReasoner r = this.reasonerFactory.createReasoner(ont, (OWLReasonerConfiguration)config);
            loadTimer.stop();
            transmitter.recordTiming((TelemetryInfo)info, "load time", timer);
            checkTimer.start();
            this.consistent = r.isConsistent();
            checkTimer.stop();
            timer.stop();
            transmitter.recordTiming((TelemetryInfo)info, "check time", checkTimer);
            transmitter.recordTiming((TelemetryInfo)info, "time", timer);
            r.dispose();
            boolean bl = !this.consistent;
            return bl;
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        finally {
            transmitter.endTransmission((TelemetryInfo)info);
        }
    }

    @Override
    public String getModularisationTypeDescription() {
        return "none";
    }

    @Override
    public boolean isUseModularisation() {
        return false;
    }

    @Override
    public Set<OWLAxiom> getEntailingAxioms(Set<OWLAxiom> axioms) {
        return null;
    }
}

