/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.checker;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.checker.ConsistencyEntailmentChecker;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PatternBasedConsistencyEntailmentChecker
implements EntailmentChecker<OWLAxiom> {
    private ConsistencyEntailmentChecker delegate;
    private OWLDataFactory df;
    private int counter = 0;

    public PatternBasedConsistencyEntailmentChecker(OWLReasonerFactory rf, long timeout) {
        this.delegate = new ConsistencyEntailmentChecker(rf, timeout);
        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
        this.df = man.getOWLDataFactory();
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void resetCounter() {
        this.counter = 0;
    }

    @Override
    public OWLAxiom getEntailment() {
        return this.delegate.getEntailment();
    }

    @Override
    public Set<OWLEntity> getEntailmentSignature() {
        return this.delegate.getEntailmentSignature();
    }

    @Override
    public Set<OWLEntity> getSeedSignature() {
        return Collections.emptySet();
    }

    @Override
    public boolean isEntailed(Set<OWLAxiom> axioms) {
        HashMap subjPredObjectMap = new HashMap();
        for (OWLAxiom ax : axioms) {
            HashSet<OWLLiteral> objects;
            OWLDataPropertyExpression prop;
            OWLFunctionalDataPropertyAxiom funcAx;
            if (!(ax instanceof OWLDataPropertyAssertionAxiom) || !axioms.contains(funcAx = this.df.getOWLFunctionalDataPropertyAxiom(prop = (OWLDataPropertyExpression)((OWLDataPropertyAssertionAxiom)ax).getProperty()))) continue;
            OWLIndividual subject = ((OWLDataPropertyAssertionAxiom)ax).getSubject();
            HashMap propObjectMap = (HashMap)subjPredObjectMap.get(subject);
            if (propObjectMap == null) {
                propObjectMap = new HashMap();
                subjPredObjectMap.put(subject, propObjectMap);
            }
            if ((objects = (HashSet<OWLLiteral>)propObjectMap.get(prop)) == null) {
                objects = new HashSet<OWLLiteral>();
                propObjectMap.put(prop, objects);
            }
            OWLLiteral object = (OWLLiteral)((OWLDataPropertyAssertionAxiom)ax).getObject();
            objects.add(object);
            if (objects.size() <= 1) continue;
            HashSet<OWLAxiom> candidateJustification = new HashSet<OWLAxiom>(3);
            candidateJustification.add((OWLAxiom)funcAx);
            for (OWLLiteral lit : objects) {
                candidateJustification.add((OWLAxiom)this.df.getOWLDataPropertyAssertionAxiom(prop, subject, lit));
            }
            if (!this.delegate.isEntailed(candidateJustification)) continue;
            return true;
        }
        return this.delegate.isEntailed(axioms);
    }

    @Override
    public Set<OWLAxiom> getModule(Set<OWLAxiom> axioms) {
        return this.delegate.getModule(axioms);
    }

    @Override
    public String getModularisationTypeDescription() {
        return this.delegate.getModularisationTypeDescription();
    }

    @Override
    public boolean isUseModularisation() {
        return this.delegate.isUseModularisation();
    }

    @Override
    public Set<OWLAxiom> getEntailingAxioms(Set<OWLAxiom> axioms) {
        return this.delegate.getEntailingAxioms(axioms);
    }
}

