/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.hst;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.impl.blackbox.hst.ExplanationGeneratorMediator;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTree;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTreeConstructionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTreeNode;
import org.semanticweb.owlapi.model.OWLAxiom;

public class DepthFirstStrategy<E>
implements HittingSetTreeConstructionStrategy<E> {
    public void start(HittingSetTree<E> hittingSetTree) {
    }

    @Override
    public void constructTree(HittingSetTree<E> hittingSetTree, int limit, ExplanationGeneratorMediator<E> handler) {
        this.buildHittingSetTree(hittingSetTree, limit, handler, hittingSetTree.getRoot());
    }

    public void buildHittingSetTree(HittingSetTree<E> hittingSetTree, int limit, ExplanationGeneratorMediator<E> handler, HittingSetTreeNode<E> currentNode) {
        for (OWLAxiom ax : currentNode.getExplanation().getAxioms()) {
            handler.removeAxiom(ax);
            HashSet<OWLAxiom> pathContents = new HashSet<OWLAxiom>(currentNode.getPathToRoot());
            pathContents.add(ax);
            if (hittingSetTree.addExploredPath(pathContents)) {
                Explanation<E> expl = this.getNonIntersectingExplanation(hittingSetTree, pathContents);
                boolean reuse = true;
                if (expl == null) {
                    reuse = false;
                    expl = handler.generateExplanation(currentNode.getExplanation().getEntailment());
                    hittingSetTree.addExplanation(expl);
                    if (hittingSetTree.getExplanations().size() == limit) {
                        return;
                    }
                }
                if (!expl.isEmpty()) {
                    HittingSetTreeNode<E> hittingSetTreeNode = new HittingSetTreeNode<E>(hittingSetTree, ax, currentNode, expl, reuse);
                    currentNode.addChild(ax, hittingSetTreeNode);
                    this.buildHittingSetTree(hittingSetTree, limit, handler, hittingSetTreeNode);
                } else {
                    hittingSetTree.addClosedPath(new HashSet<OWLAxiom>(pathContents));
                }
            }
            handler.addAxiom(ax);
        }
    }

    private Explanation<E> getNonIntersectingExplanation(HittingSetTree<E> hittingSetTree, Set<OWLAxiom> pathContents) {
        for (Explanation<E> existingExpl : hittingSetTree.getExplanations()) {
            boolean overlaps = false;
            for (OWLAxiom pathAx : pathContents) {
                if (!existingExpl.contains(pathAx)) continue;
                overlaps = true;
                break;
            }
            if (overlaps) continue;
            return existingExpl;
        }
        return null;
    }

    public void finish(HittingSetTree<E> hittingSetTree) {
    }
}

