/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.hst;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.hst.ExplanationComparator;
import org.semanticweb.owl.explanation.impl.blackbox.hst.ExplanationGeneratorMediator;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTreeConstructionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTreeNode;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryObject;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.reasoner.TimeOutException;

public class HittingSetTree<E>
implements TelemetryObject {
    private HittingSetTreeNode<E> root;
    private Set<Set<OWLAxiom>> closedPaths = new HashSet<Set<OWLAxiom>>();
    private Set<OWLAxiom> justificationsUnion = new HashSet<OWLAxiom>();
    private List<Explanation<E>> explanations = new ArrayList<Explanation<E>>();
    private ExplanationProgressMonitor<E> progressMonitor;
    private Set<Set<OWLAxiom>> exploredPaths = new HashSet<Set<OWLAxiom>>();
    private ExplanationComparator<E> explanationComparator = new ExplanationComparator(this);
    private int treeSize = 0;
    private HashSet<Explanation<E>> allFoundExplanations = new HashSet();
    private HittingSetTreeConstructionStrategy<E> strategy;
    private int numberOfNodesWithCallsToFindOne = 0;
    private int numberOfNodesWithReusedJustifications = 0;
    private int numberOfEarlyTerminatedPaths = 0;
    private int numberOfEarlyTerminatedClosedPaths = 0;
    private int closedPathMaxLength = 0;
    private int closedPathMinLength = Integer.MAX_VALUE;
    private int exploredPathMaxLength = 0;
    private int summedPathSize;
    private TelemetryInfo info;

    public HittingSetTree(HittingSetTreeConstructionStrategy<E> strategy, ExplanationProgressMonitor<E> progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.strategy = strategy;
    }

    public void incrementNumberOfNodesWithCallsToFindOne() {
        ++this.numberOfNodesWithCallsToFindOne;
    }

    public void incrementNumberOfNodesWithReusedJustifications() {
        ++this.numberOfNodesWithReusedJustifications;
    }

    public void buildHittingSetTree(E entailment, int limit, ExplanationGeneratorMediator<E> generatorMediator) {
        TelemetryTimer hstTimer = new TelemetryTimer();
        this.info = new DefaultTelemetryInfo("hittingsettree", new TelemetryTimer[]{hstTimer});
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        transmitter.beginTransmission(this.info);
        boolean foundAll = false;
        try {
            transmitter.recordMeasurement(this.info, "construction strategy", this.strategy.getClass().getName());
            hstTimer.start();
            this.numberOfNodesWithCallsToFindOne = 1;
            Explanation<E> firstExplanation = generatorMediator.generateExplanation(entailment);
            this.root = new HittingSetTreeNode<E>(this, firstExplanation);
            this.treeSize = 1;
            this.addExplanation(firstExplanation);
            if (this.explanations.size() >= limit) {
                return;
            }
            this.strategy.constructTree(this, limit, generatorMediator);
            foundAll = true;
        }
        catch (TimeOutException e) {
            transmitter.recordMeasurement(this.info, "reasoner time out", true);
            throw e;
        }
        catch (ExplanationGeneratorInterruptedException e) {
            transmitter.recordMeasurement(this.info, "hst interrupted", true);
            throw e;
        }
        catch (RuntimeException e) {
            transmitter.recordMeasurement(this.info, "hst exception", true);
            transmitter.recordMeasurement(this.info, "hst exception message", e.getMessage());
            transmitter.recordMeasurement(this.info, "hst exception class", e.getClass().getName());
            throw e;
        }
        finally {
            hstTimer.stop();
            transmitter.recordMeasurement(this.info, "number of nodes", (Number)this.treeSize);
            transmitter.recordMeasurement(this.info, "number of nodes with calls to findone", (Number)this.numberOfNodesWithCallsToFindOne);
            transmitter.recordMeasurement(this.info, "number of nodes with reused justifications", (Number)this.numberOfNodesWithReusedJustifications);
            transmitter.recordMeasurement(this.info, "number of closed paths", (Number)this.closedPaths.size());
            transmitter.recordMeasurement(this.info, "number of early terminated paths", (Number)this.numberOfEarlyTerminatedPaths);
            transmitter.recordMeasurement(this.info, "number of early terminated closed paths", (Number)this.numberOfEarlyTerminatedClosedPaths);
            transmitter.recordMeasurement(this.info, "closed path min length", (Number)this.closedPathMinLength);
            transmitter.recordMeasurement(this.info, "closed path max length", (Number)this.closedPathMaxLength);
            transmitter.recordMeasurement(this.info, "closed path average length", (Number)((double)this.summedPathSize * 1.0 / (double)this.closedPaths.size()));
            transmitter.recordTiming(this.info, "construction time", hstTimer);
            transmitter.recordMeasurement(this.info, "found all", foundAll);
            transmitter.endTransmission(this.info);
        }
    }

    public Set<Set<OWLAxiom>> getExploredPaths() {
        return this.exploredPaths;
    }

    public ExplanationProgressMonitor<E> getProgressMonitor() {
        return this.progressMonitor;
    }

    public void addExplanation(Explanation<E> explanation) {
        if (!explanation.isEmpty() && this.allFoundExplanations.add(explanation)) {
            this.explanations.add(explanation);
            Collections.sort(this.explanations, this.explanationComparator);
            this.progressMonitor.foundExplanation(null, explanation, this.allFoundExplanations);
        }
    }

    public List<Explanation<E>> getSortedExplanations() {
        return this.explanations;
    }

    public Set<Explanation<E>> getExplanations() {
        return this.allFoundExplanations;
    }

    public HittingSetTreeNode<E> getRoot() {
        return this.root;
    }

    public boolean containsClosedPath(Set<OWLAxiom> path) {
        for (Set<OWLAxiom> closedPath : this.closedPaths) {
            if (closedPath.size() > path.size() || !path.containsAll(closedPath)) continue;
            ++this.numberOfEarlyTerminatedPaths;
            return true;
        }
        return false;
    }

    public boolean addExploredPath(Set<OWLAxiom> currentPath) {
        ++this.treeSize;
        boolean added = this.exploredPaths.add(currentPath);
        if (added) {
            this.summedPathSize += currentPath.size();
        } else {
            ++this.numberOfEarlyTerminatedPaths;
        }
        if (currentPath.size() > this.exploredPathMaxLength) {
            this.exploredPathMaxLength = currentPath.size();
        }
        return added;
    }

    public void removeCurrentPath(Set<OWLAxiom> currentPath) {
        this.exploredPaths.remove(currentPath);
    }

    public void addClosedPath(Set<OWLAxiom> pathContents) {
        if (this.closedPaths.add(pathContents)) {
            if (pathContents.size() < this.closedPathMinLength) {
                this.closedPathMinLength = pathContents.size();
            }
            if (pathContents.size() > this.closedPathMaxLength) {
                this.closedPathMaxLength = pathContents.size();
            }
        }
    }

    public String getPreferredSerialisedName() {
        return "hst";
    }

    public boolean isSerialisedAsXML() {
        return false;
    }

    public void serialise(OutputStream outputStream) {
    }
}

