/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.laconic.BetaGenerator;
import org.semanticweb.owl.explanation.impl.laconic.OPlusSplitting;
import org.semanticweb.owl.explanation.impl.laconic.TauGenerator;
import org.semanticweb.owl.explanation.impl.laconic.TriviallyBottomChecker;
import org.semanticweb.owl.explanation.impl.laconic.TriviallyTopChecker;
import org.semanticweb.owl.explanation.impl.util.AxiomTransformation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class OPlusGenerator
implements OWLAxiomVisitorEx<Set<? extends OWLAxiom>>,
AxiomTransformation {
    private OWLDataFactory dataFactory;
    private BetaGenerator betaGenerator;
    private TauGenerator tauGenerator;
    private TriviallyBottomChecker bottomChecker;
    private TriviallyTopChecker topChecker;
    private Map<OWLAxiom, Set<OWLAxiom>> axiom2SourceMap = new HashMap<OWLAxiom, Set<OWLAxiom>>();
    private OPlusSplitting splitting;
    private OWLAxiom currentSourceAxiom;

    public OPlusGenerator(OWLDataFactory dataFactory, OPlusSplitting splitting) {
        this.dataFactory = dataFactory;
        this.splitting = splitting;
        this.betaGenerator = new BetaGenerator(dataFactory);
        this.tauGenerator = new TauGenerator(dataFactory);
        this.bottomChecker = new TriviallyBottomChecker();
        this.topChecker = new TriviallyTopChecker();
    }

    @Override
    public Set<OWLAxiom> transform(Set<OWLAxiom> axioms) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        int count = 0;
        for (OWLAxiom ax : axioms) {
            ++count;
            this.currentSourceAxiom = ax;
            Set axiomResult = (Set)ax.accept((OWLAxiomVisitorEx)this);
            result.addAll(axiomResult);
        }
        return result;
    }

    public boolean isNothing(OWLClassExpression desc) {
        return (Boolean)desc.accept((OWLClassExpressionVisitorEx)this.bottomChecker);
    }

    public boolean isThing(OWLClassExpression desc) {
        return (Boolean)desc.accept((OWLClassExpressionVisitorEx)this.topChecker);
    }

    public void reset() {
        this.axiom2SourceMap.clear();
    }

    public Map<OWLAxiom, Set<OWLAxiom>> getAxiom2SourceMap() {
        return this.axiom2SourceMap;
    }

    public boolean hasSameSource(OWLAxiom ax1, OWLAxiom ax2) {
        Set<OWLAxiom> source1 = this.axiom2SourceMap.get(ax1);
        Set<OWLAxiom> source2 = this.axiom2SourceMap.get(ax2);
        if (source1 == null || source2 == null) {
            return false;
        }
        for (OWLAxiom source1Ax : source1) {
            if (!source2.contains(source1Ax)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMultipleSources(OWLAxiom axiom) {
        Set<OWLAxiom> sources = this.axiom2SourceMap.get(axiom);
        return sources != null && sources.size() > 1;
    }

    public Set<OWLAxiom> getSameSourceAxioms(OWLAxiom axiom, Set<OWLAxiom> toSearch) {
        Set<OWLAxiom> axiomSources = this.axiom2SourceMap.get(axiom);
        if (axiomSources == null) {
            return Collections.emptySet();
        }
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        block0: for (OWLAxiom ax : toSearch) {
            Set<OWLAxiom> sources = this.axiom2SourceMap.get(ax);
            if (sources == null) continue;
            for (OWLAxiom axiomSourceAxiom : axiomSources) {
                if (!sources.contains(axiomSourceAxiom)) continue;
                result.add(ax);
                continue block0;
            }
        }
        return result;
    }

    public void addSources(OWLAxiom ax, Set<OWLAxiom> sources) {
        Set<OWLAxiom> existingSources = this.axiom2SourceMap.get(ax);
        if (existingSources == null) {
            existingSources = new HashSet<OWLAxiom>();
            this.axiom2SourceMap.put(ax, existingSources);
        }
        existingSources.addAll(sources);
    }

    public Set<OWLAxiom> getSources(OWLAxiom axiom) {
        Set<Object> sources = this.axiom2SourceMap.get(axiom);
        if (sources == null) {
            sources = Collections.emptySet();
        }
        return sources;
    }

    public Set<OWLAxiom> log(OWLAxiom source, Set<OWLAxiom> axioms) {
        for (OWLAxiom ax : axioms) {
            Set<OWLAxiom> sourceAxioms = this.axiom2SourceMap.get(ax);
            if (sourceAxioms == null) {
                sourceAxioms = new HashSet<OWLAxiom>(4);
                this.axiom2SourceMap.put(ax, sourceAxioms);
            }
            sourceAxioms.add(this.currentSourceAxiom);
        }
        return axioms;
    }

    private OWLAnnotation getSourceAxiomAnnotation(OWLAxiom source) {
        OWLAnnotationProperty sourceAnnotationProperty = this.dataFactory.getOWLAnnotationProperty(OPlusSplitting.SOURCE_AXIOM_IRI);
        OWLLiteral identityLiteral = this.dataFactory.getOWLLiteral(System.identityHashCode(source));
        return this.dataFactory.getOWLAnnotation(sourceAnnotationProperty, (OWLAnnotationValue)identityLiteral);
    }

    public Set<OWLAxiom> log(OWLAxiom source) {
        return this.log(source, Collections.singleton(source));
    }

    public Set<OWLAxiom> visit(OWLSubClassOfAxiom axiom) {
        Set sourceAnnotations;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        HashSet tau = new HashSet();
        HashSet beta = new HashSet();
        if (this.splitting.equals((Object)OPlusSplitting.TOP_LEVEL)) {
            Set subClassDisjuncts;
            Set superClassConjuncts = axiom.getSuperClass().asConjunctSet();
            for (OWLClassExpression superClassConjunct : superClassConjuncts) {
                tau.addAll((Collection)superClassConjunct.accept((OWLClassExpressionVisitorEx)this.tauGenerator));
            }
            OWLClassExpression subClass = axiom.getSubClass();
            if (subClass instanceof OWLObjectOneOf) {
                OWLObjectOneOf objectOneOf = (OWLObjectOneOf)subClass;
                subClassDisjuncts = objectOneOf.asObjectUnionOf().asDisjunctSet();
            } else {
                subClassDisjuncts = subClass.asDisjunctSet();
            }
            for (OWLClassExpression subClassDisjunct : subClassDisjuncts) {
                beta.addAll((Collection)subClassDisjunct.accept((OWLClassExpressionVisitorEx)this.betaGenerator));
            }
            sourceAnnotations = Collections.emptySet();
        } else {
            tau.addAll((Collection)axiom.getSuperClass().accept((OWLClassExpressionVisitorEx)this.tauGenerator));
            beta.addAll((Collection)axiom.getSubClass().accept((OWLClassExpressionVisitorEx)this.betaGenerator));
            sourceAnnotations = Collections.emptySet();
        }
        for (OWLClassExpression tauDesc : tau) {
            if (this.isThing(tauDesc)) continue;
            for (OWLClassExpression betaDesc : beta) {
                if (this.isNothing(betaDesc) || this.isThing(tauDesc)) continue;
                OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(betaDesc, tauDesc, sourceAnnotations);
                axioms.add((OWLAxiom)ax);
            }
        }
        return this.log((OWLAxiom)axiom, axioms);
    }

    public Set<? extends OWLAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLDisjointClassesAxiom axiom) {
        boolean containAnonDescriptions = false;
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            if (!desc.isAnonymous()) continue;
            containAnonDescriptions = true;
            break;
        }
        if (!containAnonDescriptions) {
            return this.log((OWLAxiom)axiom);
        }
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        ArrayList descs = new ArrayList(axiom.getClassExpressions());
        for (int i = 0; i < descs.size(); ++i) {
            for (int j = i + 1; j < descs.size(); ++j) {
                Set weakendAxioms = (Set)this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)descs.get(i), (OWLClassExpression)this.dataFactory.getOWLObjectComplementOf((OWLClassExpression)descs.get(j))).accept((OWLAxiomVisitorEx)this);
                for (OWLAxiom ax : weakendAxioms) {
                    if (ax.isOfType(new AxiomType[]{AxiomType.SUBCLASS_OF})) {
                        OWLClassExpression clsB;
                        OWLClassExpression clsA;
                        OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                        if (sca.getSubClass() instanceof OWLObjectComplementOf) {
                            clsA = ((OWLObjectComplementOf)sca.getSubClass()).getOperand();
                            clsB = sca.getSuperClass();
                            axioms.add((OWLAxiom)this.dataFactory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{clsA, clsB}));
                            continue;
                        }
                        if (sca.getSuperClass() instanceof OWLObjectComplementOf) {
                            clsA = sca.getSubClass();
                            clsB = ((OWLObjectComplementOf)sca.getSuperClass()).getOperand();
                            axioms.add((OWLAxiom)this.dataFactory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{clsA, clsB}));
                            continue;
                        }
                        axioms.add(ax);
                        continue;
                    }
                    axioms.add(ax);
                }
            }
        }
        return this.log((OWLAxiom)axiom, axioms);
    }

    public Set<? extends OWLAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLObjectPropertyDomainAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLClassExpression dom : (Set)axiom.getDomain().accept((OWLClassExpressionVisitorEx)this.tauGenerator)) {
            if (this.isThing(dom)) continue;
            result.add((OWLAxiom)this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), dom));
        }
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLObjectPropertyExpression propA : axiom.getProperties()) {
            for (OWLObjectPropertyExpression propB : axiom.getProperties()) {
                if (propA.equals(propB)) continue;
                result.add((OWLAxiom)this.dataFactory.getOWLSubObjectPropertyOfAxiom(propA, propB));
            }
        }
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLIndividual indA : axiom.getIndividuals()) {
            for (OWLIndividual indB : axiom.getIndividuals()) {
                if (indA.equals(indB)) continue;
                result.add((OWLAxiom)this.dataFactory.getOWLDifferentIndividualsAxiom(new OWLIndividual[]{indA, indB}));
            }
        }
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLHasKeyAxiom owlHasKeyAxiom) {
        return this.log((OWLAxiom)owlHasKeyAxiom);
    }

    public Set<? extends OWLAxiom> visit(OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
        return this.log((OWLAxiom)owlSubAnnotationPropertyOfAxiom);
    }

    public Set<? extends OWLAxiom> visit(OWLAnnotationPropertyDomainAxiom owlAnnotationPropertyDomainAxiom) {
        return this.log((OWLAxiom)owlAnnotationPropertyDomainAxiom);
    }

    public Set<? extends OWLAxiom> visit(OWLAnnotationPropertyRangeAxiom owlAnnotationPropertyRangeAxiom) {
        return this.log((OWLAxiom)owlAnnotationPropertyRangeAxiom);
    }

    public Set<? extends OWLAxiom> visit(OWLObjectPropertyRangeAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLClassExpression rng : (Set)((OWLClassExpression)axiom.getRange()).accept((OWLClassExpressionVisitorEx)this.tauGenerator)) {
            if (this.isThing(rng)) continue;
            result.add((OWLAxiom)this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), rng));
        }
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLObjectPropertyAssertionAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>(2);
        result.add((OWLAxiom)axiom);
        OWLObjectSomeValuesFrom type = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.dataFactory.getOWLThing());
        result.add((OWLAxiom)this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)type, axiom.getSubject()));
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLDisjointUnionAxiom axiom) {
        System.err.println("WARNING: Not weakening disjoint union");
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLDeclarationAxiom axiom) {
        return Collections.singleton(axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLAnnotationAssertionAxiom axiom) {
        return Collections.singleton(axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLClassAssertionAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLClassExpression cls : (Set)axiom.getClassExpression().accept((OWLClassExpressionVisitorEx)this.tauGenerator)) {
            if (this.isThing(cls)) continue;
            result.add((OWLAxiom)this.dataFactory.getOWLClassAssertionAxiom(cls, axiom.getIndividual()));
        }
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLClassExpression descA : axiom.getClassExpressions()) {
            for (OWLClassExpression descB : axiom.getClassExpressions()) {
                if (descA.equals(descB)) continue;
                axioms.addAll((Collection)this.dataFactory.getOWLSubClassOfAxiom(descA, descB).accept((OWLAxiomVisitorEx)this));
            }
        }
        return this.log((OWLAxiom)axiom, axioms);
    }

    public Set<? extends OWLAxiom> visit(OWLDataPropertyAssertionAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>(2);
        result.add((OWLAxiom)axiom);
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLSameIndividualAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLSubPropertyChainOfAxiom axiom) {
        return this.log((OWLAxiom)axiom);
    }

    public Set<? extends OWLAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        result.add((OWLAxiom)this.dataFactory.getOWLSubObjectPropertyOfAxiom(axiom.getFirstProperty(), (OWLObjectPropertyExpression)this.dataFactory.getOWLObjectInverseOf(axiom.getSecondProperty())));
        result.add((OWLAxiom)this.dataFactory.getOWLSubObjectPropertyOfAxiom(axiom.getSecondProperty(), (OWLObjectPropertyExpression)this.dataFactory.getOWLObjectInverseOf(axiom.getFirstProperty())));
        return this.log((OWLAxiom)axiom, result);
    }

    public Set<? extends OWLAxiom> visit(OWLDatatypeDefinitionAxiom axiom) {
        return null;
    }

    public Set<? extends OWLAxiom> visit(SWRLRule rule) {
        return this.log((OWLAxiom)rule);
    }
}

