/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.rootderived;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationManager;
import org.semanticweb.owl.explanation.api.RootDerivedReasoner;
import org.semanticweb.owl.explanation.impl.rootderived.StructuralRootDerivedReasoner;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class CompleteRootDerivedReasoner
implements RootDerivedReasoner {
    private OWLOntologyManager manager;
    private OWLReasoner baseReasoner;
    private OWLReasonerFactory reasonerFactory;
    private Map<OWLClass, Set<Explanation<OWLAxiom>>> cls2JustificationMap;
    private Set<OWLClass> roots = new HashSet<OWLClass>();

    public CompleteRootDerivedReasoner(OWLOntologyManager manager, OWLReasoner baseReasoner, OWLReasonerFactory reasonerFactory) {
        this.manager = manager;
        this.baseReasoner = baseReasoner;
        this.reasonerFactory = reasonerFactory;
    }

    @Override
    public Set<OWLClass> getRootUnsatisfiableClasses() throws ExplanationException {
        StructuralRootDerivedReasoner srd = new StructuralRootDerivedReasoner(this.manager, this.baseReasoner, this.reasonerFactory);
        Set<OWLClass> estimatedRoots = srd.getRootUnsatisfiableClasses();
        this.cls2JustificationMap = new HashMap<OWLClass, Set<Explanation<OWLAxiom>>>();
        HashSet allAxioms = new HashSet();
        for (OWLOntology ont : this.baseReasoner.getRootOntology().getImportsClosure()) {
            allAxioms.addAll(ont.getLogicalAxioms());
        }
        for (OWLClass cls : estimatedRoots) {
            this.cls2JustificationMap.put(cls, new HashSet());
            System.out.println("POTENTIAL ROOT: " + cls);
        }
        System.out.println("Finding real roots from " + estimatedRoots.size() + " estimated roots");
        int done = 0;
        this.roots.addAll(estimatedRoots);
        for (OWLClass estimatedRoot : estimatedRoots) {
            ExplanationGeneratorFactory<OWLAxiom> genFac = ExplanationManager.createExplanationGeneratorFactory(this.reasonerFactory);
            ExplanationGenerator<OWLAxiom> gen = genFac.createExplanationGenerator(allAxioms);
            OWLDataFactory df = this.manager.getOWLDataFactory();
            Set<Explanation<OWLAxiom>> expls = gen.getExplanations((OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)estimatedRoot, (OWLClassExpression)df.getOWLNothing()));
            this.cls2JustificationMap.get(estimatedRoot).addAll(expls);
            System.out.println("Done " + ++done);
        }
        for (OWLClass clsA : estimatedRoots) {
            for (OWLClass clsB : estimatedRoots) {
                if (clsA.equals(clsB)) continue;
                Set<Explanation<OWLAxiom>> clsAExpls = this.cls2JustificationMap.get(clsA);
                Set<Explanation<OWLAxiom>> clsBExpls = this.cls2JustificationMap.get(clsB);
                boolean clsARootForClsB = false;
                boolean clsBRootForClsA = false;
                for (Explanation<OWLAxiom> clsAExpl : clsAExpls) {
                    for (Explanation<OWLAxiom> clsBExpl : clsBExpls) {
                        if (CompleteRootDerivedReasoner.isRootFor(clsAExpl, clsBExpl)) {
                            clsARootForClsB = true;
                            continue;
                        }
                        if (!CompleteRootDerivedReasoner.isRootFor(clsBExpl, clsAExpl)) continue;
                        clsBRootForClsA = true;
                    }
                }
                if (clsARootForClsB && clsBRootForClsA) continue;
                if (clsARootForClsB) {
                    this.roots.remove(clsB);
                    continue;
                }
                if (!clsBRootForClsA) continue;
                this.roots.remove(clsA);
            }
        }
        return this.roots;
    }

    private static boolean isRootFor(Explanation<OWLAxiom> explA, Explanation<OWLAxiom> explB) {
        return explB.getAxioms().containsAll(explA.getAxioms()) && !explA.getAxioms().equals(explB.getAxioms());
    }

    @Override
    public Set<OWLClass> getDependentChildClasses(OWLClass cls) {
        return null;
    }

    @Override
    public Set<OWLClass> getDependentDescendantClasses(OWLClass cls) {
        return null;
    }

    public static void main(String[] args) {
    }
}

