/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.util.AxiomTransformation;
import org.semanticweb.owl.explanation.impl.util.DeltaTransformation;
import org.semanticweb.owl.explanation.impl.util.ModularityStrategy;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class DeltaPlusTransformation
implements AxiomTransformation {
    private OWLDataFactory dataFactory;
    private int cardinalityBound;
    private ModularityStrategy modularityStrategy = ModularityStrategy.DONT_USE_MODULARITY;

    public DeltaPlusTransformation(OWLDataFactory dataFactory, int cardinalityBound, ModularityStrategy modularityStrategy) {
        this.dataFactory = dataFactory;
        this.modularityStrategy = modularityStrategy;
    }

    public DeltaPlusTransformation(OWLDataFactory dataFactory) {
        this(dataFactory, 0, ModularityStrategy.DONT_USE_MODULARITY);
    }

    @Override
    public Set<OWLAxiom> transform(Set<OWLAxiom> axioms) {
        DeltaTransformation transformation = new DeltaTransformation(this.dataFactory);
        Set<OWLAxiom> deltaAxioms = transformation.transform(axioms);
        HashSet<OWLAxiom> deltaPlusAxioms = new HashSet<OWLAxiom>(deltaAxioms);
        DeltaAxiomVisitor axiomVisitor = new DeltaAxiomVisitor();
        for (OWLAxiom deltaAxiom : deltaAxioms) {
            deltaPlusAxioms.addAll((Collection)deltaAxiom.accept((OWLAxiomVisitorEx)axiomVisitor));
        }
        return deltaPlusAxioms;
    }

    private class NegativeClassExpressionWeakener
    implements OWLClassExpressionVisitorEx<Set<OWLClassExpression>> {
        private NegativeClassExpressionWeakener() {
        }

        public Set<OWLClassExpression> visit(OWLClass ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectIntersectionOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectUnionOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectComplementOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectSomeValuesFrom ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectAllValuesFrom ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            result.add((OWLClassExpression)ce);
            result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectAllValuesFrom(ce.getProperty(), (OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLNothing()));
            return result;
        }

        public Set<OWLClassExpression> visit(OWLObjectHasValue ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectMinCardinality ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            for (int n = ce.getCardinality(); n < DeltaPlusTransformation.this.cardinalityBound; ++n) {
                result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectMinCardinality(n, ce.getProperty(), (OWLClassExpression)ce.getFiller()));
            }
            return result;
        }

        public Set<OWLClassExpression> visit(OWLObjectExactCardinality ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectMaxCardinality ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            result.add((OWLClassExpression)ce);
            for (int n = ce.getCardinality(); n > 0; --n) {
                result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectMaxCardinality(n, ce.getProperty(), (OWLClassExpression)ce.getFiller()));
            }
            return result;
        }

        public Set<OWLClassExpression> visit(OWLObjectHasSelf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectOneOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataSomeValuesFrom ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataAllValuesFrom ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataHasValue ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataMinCardinality ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataExactCardinality ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataMaxCardinality ce) {
            return Collections.singleton(ce);
        }
    }

    private class PositiveClassExpressionWeakener
    implements OWLClassExpressionVisitorEx<Set<OWLClassExpression>> {
        private PositiveClassExpressionWeakener() {
        }

        public Set<OWLClassExpression> visit(OWLClass ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectIntersectionOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectUnionOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectComplementOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectSomeValuesFrom ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            result.add((OWLClassExpression)ce);
            result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectSomeValuesFrom(ce.getProperty(), (OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLThing()));
            return result;
        }

        public Set<OWLClassExpression> visit(OWLObjectAllValuesFrom ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectHasValue ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectMinCardinality ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            for (int n = ce.getCardinality(); n > 0; --n) {
                result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectMinCardinality(n, ce.getProperty(), (OWLClassExpression)ce.getFiller()));
                result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectMinCardinality(n, ce.getProperty(), (OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLThing()));
            }
            return result;
        }

        public Set<OWLClassExpression> visit(OWLObjectExactCardinality ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectMaxCardinality ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            for (int n = ce.getCardinality(); n < DeltaPlusTransformation.this.cardinalityBound; ++n) {
                result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectMaxCardinality(n, ce.getProperty(), (OWLClassExpression)ce.getFiller()));
                result.add((OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLObjectMaxCardinality(n, ce.getProperty(), (OWLClassExpression)DeltaPlusTransformation.this.dataFactory.getOWLThing()));
            }
            return result;
        }

        public Set<OWLClassExpression> visit(OWLObjectHasSelf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectOneOf ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataSomeValuesFrom ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            result.add((OWLClassExpression)ce);
            return result;
        }

        public Set<OWLClassExpression> visit(OWLDataAllValuesFrom ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataHasValue ce) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            result.add((OWLClassExpression)ce);
            return result;
        }

        public Set<OWLClassExpression> visit(OWLDataMinCardinality ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataExactCardinality ce) {
            return Collections.singleton(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataMaxCardinality ce) {
            return Collections.singleton(ce);
        }
    }

    private class DeltaAxiomVisitor
    implements OWLAxiomVisitorEx<Set<OWLAxiom>> {
        private DeltaAxiomVisitor() {
        }

        public Set<OWLAxiom> visit(OWLSubClassOfAxiom axiom) {
            HashSet superClses = new HashSet();
            PositiveClassExpressionWeakener positiveWeakener = new PositiveClassExpressionWeakener();
            superClses.addAll((Collection)axiom.getSuperClass().accept((OWLClassExpressionVisitorEx)positiveWeakener));
            HashSet subClses = new HashSet();
            NegativeClassExpressionWeakener negativeWeakener = new NegativeClassExpressionWeakener();
            subClses.addAll((Collection)axiom.getSubClass().accept((OWLClassExpressionVisitorEx)negativeWeakener));
            HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
            for (OWLClassExpression superCls : superClses) {
                for (OWLClassExpression subCls : subClses) {
                    OWLSubClassOfAxiom ax = DeltaPlusTransformation.this.dataFactory.getOWLSubClassOfAxiom(subCls, superCls, axiom.getAnnotations());
                    result.add((OWLAxiom)ax);
                }
            }
            return result;
        }

        public Set<OWLAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDisjointClassesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLObjectPropertyDomainAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLObjectPropertyRangeAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLObjectPropertyAssertionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSubObjectPropertyOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDisjointUnionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDeclarationAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLAnnotationAssertionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLClassAssertionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLEquivalentClassesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDataPropertyAssertionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSubDataPropertyOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSameIndividualAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSubPropertyChainOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLHasKeyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDatatypeDefinitionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(SWRLRule rule) {
            return Collections.singleton(rule);
        }

        public Set<OWLAxiom> visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLAnnotationPropertyDomainAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLAnnotationPropertyRangeAxiom axiom) {
            return Collections.singleton(axiom);
        }
    }
}

