/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.AbstractABoxEngineWrapper;
import com.clarkparsia.pellet.sparqldl.engine.BindingIterator;
import com.clarkparsia.pellet.sparqldl.engine.LiteralIterator;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;

public class SimpleQueryEngine
extends AbstractABoxEngineWrapper {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());

    @Override
    public boolean supports(Query q) {
        return true;
    }

    @Override
    public QueryResult execABoxQuery(Query q) {
        QueryResultImpl results = new QueryResultImpl(q);
        KnowledgeBase kb = q.getKB();
        long satCount = kb.getABox().stats.satisfiabilityCount;
        long consCount = kb.getABox().stats.consistencyCount;
        if (q.getDistVars().isEmpty()) {
            if (QueryEngine.execBooleanABoxQuery(q)) {
                results.add(new ResultBindingImpl());
            }
        } else {
            boolean hasLiterals;
            HashMap<ATermAppl, Set<ATermAppl>> varBindings = new HashMap<ATermAppl, Set<ATermAppl>>();
            for (ATermAppl currVar : q.getDistVarsForType(Query.VarType.INDIVIDUAL)) {
                ATermAppl rolledUpClass = q.rollUpTo(currVar, Collections.EMPTY_SET, false);
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Rolled up class " + rolledUpClass);
                }
                Set inst = kb.getInstances(rolledUpClass);
                varBindings.put(currVar, inst);
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Var bindings: " + varBindings);
            }
            BindingIterator i = new BindingIterator(varBindings);
            Set<ATermAppl> literalVars = q.getDistVarsForType(Query.VarType.LITERAL);
            Set<ATermAppl> individualVars = q.getDistVarsForType(Query.VarType.INDIVIDUAL);
            boolean bl = hasLiterals = !individualVars.containsAll(literalVars);
            if (hasLiterals) {
                while (i.hasNext()) {
                    ResultBinding b = (ResultBinding)i.next();
                    LiteralIterator l = new LiteralIterator(q, b);
                    while (l.hasNext()) {
                        ResultBinding mappy = (ResultBinding)l.next();
                        boolean queryTrue = QueryEngine.execBooleanABoxQuery(q.apply(mappy));
                        if (!queryTrue) continue;
                        results.add(mappy);
                    }
                }
            } else {
                while (i.hasNext()) {
                    ResultBinding b = (ResultBinding)i.next();
                    boolean queryTrue = q.getDistVarsForType(Query.VarType.INDIVIDUAL).size() == 1 || QueryEngine.execBooleanABoxQuery(q.apply(b));
                    if (!queryTrue) continue;
                    results.add(b);
                }
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Results: " + results);
            log.fine("Total satisfiability operations: " + (kb.getABox().stats.satisfiabilityCount - satCount));
            log.fine("Total consistency operations: " + (kb.getABox().stats.consistencyCount - consCount));
        }
        return results;
    }
}

