/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.Core;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mindswap.pellet.utils.ATermUtils;

public class CoreImpl
extends QueryAtomImpl
implements Core {
    private List<ATermAppl> distVars = null;
    private List<ATermAppl> consts = null;
    private Collection<ATermAppl> undistVars = null;
    private Collection<QueryAtom> atoms;

    public CoreImpl(List<ATermAppl> arguments, Collection<ATermAppl> uv, Collection<QueryAtom> atoms) {
        super(QueryPredicate.UndistVarCore, arguments);
        this.atoms = atoms;
        this.undistVars = uv;
    }

    private void setup() {
        this.distVars = new ArrayList<ATermAppl>();
        this.consts = new ArrayList<ATermAppl>();
        for (ATermAppl a : this.arguments) {
            if (ATermUtils.isVar((ATermAppl)a)) {
                this.distVars.add(a);
                continue;
            }
            this.consts.add(a);
        }
    }

    @Override
    public Collection<ATermAppl> getConstants() {
        if (this.consts == null) {
            this.setup();
        }
        return this.consts;
    }

    @Override
    public Collection<ATermAppl> getDistVars() {
        if (this.distVars == null) {
            this.setup();
        }
        return this.distVars;
    }

    @Override
    public Collection<ATermAppl> getUndistVars() {
        if (this.undistVars == null) {
            this.setup();
        }
        return this.undistVars;
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        if (this.isGround()) {
            return this;
        }
        ArrayList<ATermAppl> newArguments = new ArrayList<ATermAppl>();
        for (ATermAppl a : this.arguments) {
            if (binding.isBound(a)) {
                newArguments.add(binding.getValue(a));
                continue;
            }
            newArguments.add(a);
        }
        ArrayList<QueryAtom> newAtoms = new ArrayList<QueryAtom>();
        for (QueryAtom a : this.atoms) {
            newAtoms.add(a.apply(binding));
        }
        return new CoreImpl(newArguments, this.undistVars, newAtoms);
    }

    @Override
    public int hashCode() {
        return this.arguments.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoreImpl other = (CoreImpl)obj;
        return this.arguments.equals(other.arguments);
    }
}

