/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.telemetry;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryObject;
import org.semanticweb.owl.explanation.telemetry.TelemetryReceiver;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryXMLWriter;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.owlxml.renderer.OWLXMLObjectRenderer;
import org.semanticweb.owlapi.owlxml.renderer.OWLXMLWriter;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterNamespaceManager;

public class XMLTelemetryReceiver
implements TelemetryReceiver {
    private TelemetryXMLWriter xmlWriter;
    private Stack<TelemetryInfo> telemetryNodeStack = new Stack();
    private Stack<Boolean> ignoreNodeStack = new Stack();
    private Set<String> ignoredNodeNames = new HashSet<String>();
    private int depth = 0;
    private Writer baseWriter;

    public XMLTelemetryReceiver() {
        this(XMLTelemetryReceiver.getNextFile("telemetry-", ".xml"));
    }

    private static File getNextFile(String prefix, String suffix) {
        File outputFile;
        int i = 0;
        while ((outputFile = new File(prefix + i + suffix)).exists()) {
            ++i;
        }
        return outputFile;
    }

    public XMLTelemetryReceiver(File outputFile) {
        this(XMLTelemetryReceiver.getWriterForFile(outputFile));
    }

    private static BufferedWriter getWriterForFile(File outputFile) {
        try {
            return new BufferedWriter(new FileWriter(outputFile), 0xA00000);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XMLTelemetryReceiver(Writer writer) {
        XMLWriterNamespaceManager nsm = new XMLWriterNamespaceManager("");
        this.baseWriter = writer;
        this.xmlWriter = new TelemetryXMLWriter(this.baseWriter, nsm, "");
        this.xmlWriter.startDocument(IRI.create((String)"experiments"));
        ++this.depth;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    XMLTelemetryReceiver.this.xmlWriter.endDocument();
                    XMLTelemetryReceiver.this.baseWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void addIgnoreName(String name) {
        this.ignoredNodeNames.add(name);
    }

    public void closeOpenTransmissions() {
        while (!this.telemetryNodeStack.isEmpty()) {
            TelemetryInfo info = this.telemetryNodeStack.peek();
            this.endTransmission(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransmission(TelemetryInfo info) {
        List<TelemetryTimer> timers = this.pauseRunningTimers();
        try {
            this.telemetryNodeStack.push(info);
            boolean ignore = false;
            if (!this.ignoreNodeStack.isEmpty()) {
                ignore = this.ignoreNodeStack.peek();
            }
            if (!ignore) {
                ignore = this.ignoredNodeNames.contains(info.getName());
            }
            this.ignoreNodeStack.push(ignore);
            if (!ignore) {
                this.xmlWriter.writeStartElement(IRI.create((String)info.getName()));
            }
            ++this.depth;
        }
        finally {
            this.unpauseTimers(timers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordMeasurement(TelemetryInfo info, String propertyName, String value) {
        if (propertyName != null && value != null && !this.isIgnoredTransmission()) {
            List<TelemetryTimer> timers = this.pauseRunningTimers();
            try {
                this.xmlWriter.writeStartElement(IRI.create((String)"measurement"));
                this.xmlWriter.writeAttribute("name", propertyName);
                this.xmlWriter.writeAttribute("value", value);
                this.xmlWriter.writeEndElement();
            }
            finally {
                this.unpauseTimers(timers);
            }
        }
    }

    private boolean isIgnoredTransmission() {
        return !this.ignoreNodeStack.isEmpty() && this.ignoreNodeStack.peek() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordException(TelemetryInfo info, Throwable exception) {
        List<TelemetryTimer> pausedTimers = this.pauseRunningTimers();
        try {
            this.xmlWriter.writeStartElement(IRI.create((String)"exception"));
            this.xmlWriter.writeStartElement(IRI.create((String)"class"));
            this.xmlWriter.writeTextContent(exception.getClass().getName());
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeStartElement(IRI.create((String)"message"));
            this.xmlWriter.writeTextContent(exception.getMessage());
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeStartElement(IRI.create((String)"stacktrace"));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            pw.flush();
            this.xmlWriter.writeTextContent(sw.getBuffer().toString());
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndElement();
        }
        finally {
            this.unpauseTimers(pausedTimers);
        }
    }

    @Override
    public void recordObject(TelemetryInfo info, String namePrefix, String nameSuffix, Object object) {
        if (!this.isIgnoredTransmission()) {
            List<TelemetryTimer> timers = this.pauseRunningTimers();
            this.serialiseObject(info, namePrefix, object);
            this.unpauseTimers(timers);
        }
    }

    private void serialiseObject(TelemetryInfo info, String namePrefix, Object object) {
        if (!this.isIgnoredTransmission()) {
            try {
                boolean writeAsXML = false;
                this.xmlWriter.writeStartElement(IRI.create((String)"object"));
                this.xmlWriter.writeAttribute("name", namePrefix);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                boolean wrapInCDataSection = true;
                if (object instanceof TelemetryObject) {
                    TelemetryObject telemetryObject = (TelemetryObject)object;
                    telemetryObject.serialise(bos);
                    if (!telemetryObject.isSerialisedAsXML()) {
                        wrapInCDataSection = false;
                    } else {
                        wrapInCDataSection = false;
                        writeAsXML = true;
                    }
                } else if (object instanceof OWLAxiom) {
                    OWLAxiom ax = (OWLAxiom)object;
                    OutputStreamWriter osw = new OutputStreamWriter(bos);
                    PrintWriter printWriter = new PrintWriter(osw);
                    OWLXMLWriter writer = new OWLXMLWriter(printWriter, null);
                    OWLXMLObjectRenderer renderer = new OWLXMLObjectRenderer(writer);
                    ax.accept((OWLObjectVisitor)renderer);
                    osw.flush();
                    wrapInCDataSection = false;
                    writeAsXML = true;
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter(bos);
                    String string = object.toString();
                    writer.write(string);
                    writer.flush();
                }
                if (wrapInCDataSection) {
                    this.xmlWriter.writeCData(bos.toString());
                } else if (writeAsXML) {
                    this.xmlWriter.writeXMLContent(bos.toString());
                } else {
                    this.xmlWriter.writeTextContent(bos.toString());
                }
                this.xmlWriter.writeEndElement();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void recordTiming(TelemetryInfo info, String name, TelemetryTimer telemetryTimer) {
        if (!this.isIgnoredTransmission()) {
            this.recordMeasurement(info, name, Long.toString(telemetryTimer.getEllapsedTime()));
        }
    }

    @Override
    public void endTransmission(TelemetryInfo info) {
        List<TelemetryTimer> timers = this.pauseRunningTimers();
        try {
            if (!this.isIgnoredTransmission()) {
                this.xmlWriter.writeEndElement();
            }
            if (!this.telemetryNodeStack.isEmpty()) {
                this.telemetryNodeStack.pop();
            }
            if (!this.ignoreNodeStack.isEmpty()) {
                this.ignoreNodeStack.pop();
            }
            --this.depth;
            if (this.depth == 0) {
                this.xmlWriter.endDocument();
            }
        }
        finally {
            this.unpauseTimers(timers);
        }
    }

    private void unpauseTimers(List<TelemetryTimer> paused) {
        for (TelemetryTimer timer : paused) {
            timer.start();
        }
    }

    private List<TelemetryTimer> pauseRunningTimers() {
        ArrayList<TelemetryTimer> paused = new ArrayList<TelemetryTimer>();
        for (TelemetryInfo i : this.telemetryNodeStack) {
            for (TelemetryTimer timer : i.getTimers()) {
                if (timer == null || !timer.isRunning()) continue;
                timer.stop();
                paused.add(timer);
            }
        }
        return paused;
    }
}

