/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.telemetry;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryObject;
import org.semanticweb.owl.explanation.telemetry.TelemetryReceiver;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;

public class ZipTelemetryReceiver
implements TelemetryReceiver {
    private static final String ROOT_NAME = "telemetry/";
    private Map<TelemetryInfo, Properties> info2PropertiesMap = new WeakHashMap<TelemetryInfo, Properties>();
    private Map<TelemetryInfo, String> info2EntryMap = new WeakHashMap<TelemetryInfo, String>();
    private Stack<TelemetryInfo> telemetryInfoStack = new Stack();
    private Set<String> zipEntryNames = new HashSet<String>();
    private File zip;
    private ZipOutputStream zipOutputStream;

    public ZipTelemetryReceiver(File zipFile) {
        try {
            this.zip = zipFile;
            this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            this.zipOutputStream.putNextEntry(new ZipEntry(ROOT_NAME));
            this.zipOutputStream.closeEntry();
            this.zipOutputStream.setLevel(9);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    ZipTelemetryReceiver.this.zipOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void close() {
        try {
            this.zipOutputStream.flush();
            this.zipOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beginTransmission(TelemetryInfo info) {
        this.createTelemetryInfoEntry(info);
    }

    @Override
    public void recordMeasurement(TelemetryInfo info, String propertyName, String value) {
        this.writeProperty(info, propertyName, value);
    }

    @Override
    public void recordException(TelemetryInfo info, Throwable exception) {
    }

    @Override
    public void recordObject(TelemetryInfo info, String namePrefix, String nameSuffix, Object object) {
        this.writeObject(info, namePrefix + nameSuffix, object);
    }

    @Override
    public void recordTiming(TelemetryInfo info, String name, TelemetryTimer telemetryTimer) {
        long ellapsedTime = telemetryTimer.getEllapsedTime();
        this.recordMeasurement(info, name, Long.toString(ellapsedTime));
    }

    @Override
    public void endTransmission(TelemetryInfo info) {
        TelemetryInfo popped = this.telemetryInfoStack.pop();
        this.writeTelemetryInfoProperties(info);
        try {
            this.zipOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!popped.equals(info)) {
            System.err.println("ERROR: TelemetryInfo mismatch: " + info + " " + popped);
        }
    }

    private void createTelemetryInfoEntry(TelemetryInfo info) {
        String infoEntry = this.createNumberedZipEntry(info);
        ZipEntry ze = new ZipEntry(infoEntry);
        try {
            this.zipOutputStream.putNextEntry(ze);
            this.zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.telemetryInfoStack.push(info);
        this.info2EntryMap.put(info, infoEntry);
        this.info2PropertiesMap.put(info, new Properties());
    }

    private String createNumberedZipEntry(TelemetryInfo info) {
        String parentEntry;
        if (!this.telemetryInfoStack.isEmpty()) {
            TelemetryInfo parentInfo = this.telemetryInfoStack.peek();
            parentEntry = this.getTelemetryInfoZipEntryName(parentInfo);
        } else {
            parentEntry = ROOT_NAME;
        }
        int count = 0;
        while (true) {
            StringBuilder sb = new StringBuilder();
            sb.append(parentEntry);
            sb.append(info.getName());
            sb.append(".");
            sb.append(count);
            sb.append("/");
            String candidate = sb.toString();
            if (!this.zipEntryNames.contains(candidate)) {
                this.zipEntryNames.add(candidate);
                return candidate;
            }
            ++count;
        }
    }

    private String getTelemetryInfoZipEntryName(TelemetryInfo info) {
        return this.info2EntryMap.get(info);
    }

    private String getTelemetryInfoArtefactZipEntryName(TelemetryInfo info, String artefactName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTelemetryInfoZipEntryName(info));
        sb.append(artefactName);
        return sb.toString();
    }

    public ZipEntry getPropertiesZipEntryName(TelemetryInfo info) {
        String zipEntryName = this.getTelemetryInfoArtefactZipEntryName(info, info.getName() + ".properties");
        return new ZipEntry(zipEntryName);
    }

    private void writeProperty(TelemetryInfo info, String propertyName, String value) {
        List<TelemetryTimer> paused = this.pauseRunningTimers();
        Properties properties = this.info2PropertiesMap.get(info);
        if (properties != null) {
            properties.setProperty(propertyName, value);
        }
        this.unpauseTimers(paused);
    }

    private void writeTelemetryInfoProperties(TelemetryInfo info) {
        Properties properties = this.info2PropertiesMap.get(info);
        try {
            ZipEntry propertiesZipEntry = this.getPropertiesZipEntryName(info);
            this.zipOutputStream.putNextEntry(propertiesZipEntry);
            BufferedOutputStream bos = new BufferedOutputStream(this.zipOutputStream);
            properties.store(bos, null);
            bos.flush();
            this.zipOutputStream.closeEntry();
            this.zipOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void unpauseTimers(List<TelemetryTimer> paused) {
        for (TelemetryTimer timer : paused) {
            timer.start();
        }
    }

    private List<TelemetryTimer> pauseRunningTimers() {
        ArrayList<TelemetryTimer> paused = new ArrayList<TelemetryTimer>();
        for (TelemetryInfo i : this.telemetryInfoStack) {
            for (TelemetryTimer timer : i.getTimers()) {
                if (timer == null || !timer.isRunning()) continue;
                timer.stop();
                paused.add(timer);
            }
        }
        return paused;
    }

    private void writeObject(TelemetryInfo info, String name, Object object) {
        List<TelemetryTimer> paused = this.pauseRunningTimers();
        String zipEntryName = this.getTelemetryInfoArtefactZipEntryName(info, name);
        try {
            this.zipOutputStream.putNextEntry(new ZipEntry(zipEntryName));
            if (object instanceof TelemetryObject) {
                TelemetryObject telemetryObject = (TelemetryObject)object;
                telemetryObject.serialise(this.zipOutputStream);
            } else {
                PrintWriter pw = new PrintWriter(this.zipOutputStream);
                pw.print(object);
                pw.flush();
            }
            this.zipOutputStream.closeEntry();
            this.zipOutputStream.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.unpauseTimers(paused);
    }
}

